-- ============================================================================
--   Table : TRAEXPORT_SAP
-- ============================================================================
-- 	NUM_CR = Compteur des différentes erreurs sur un même fichier

-- ============================================================================
--	TYPE_CR = 0 - Pas d'anomalie
--	TYPE_CR = 1 - Fichier rejeté
--	TYPE_CR = 2 - Pb référentiel ( un des fam/four/réf non remplis )
--	TYPE_CR = 3 - Pb référentiel ( un des fam/four/réf pas la bonne taille )
-- ============================================================================
--	BAS_IDENT 	= IDENT du fichier BASSTO créé
--	BAS_CODE 	= CODE du fichier BASSTO créé
--	BAS_LIBELLE 	= LIBELLE du fichier BASSTO créé
-- ============================================================================
--	WEB_IDENT	= IDENT du fichier INFOWEB créé
--	WEB_LIBELLE	= LIBELLE du fichier INFOWEB créé
-- ============================================================================
CREATE TABLE TRAEXPORT_SAP
(
NUMEXPORT	NUMBER(10,0)	NOT NULL,
NUM_CR		NUMBER(10,0)	NOT NULL,
TYPE_CR		NUMBER(2,0),	
NOM_FICHIER	CHAR(100),
CFAMILLE		CHAR(3),
CFOURNISS	CHAR(4),
REFFOUR		CHAR(15),
BAS_IDENT           	CHAR(2),
BAS_CODE	CHAR(10),
BAS_LIBELLE	CHAR(30),
WEB_IDENT	CHAR(2),
WEB_LIBELLE	CHAR(100),
LIB_CR		CHAR(100),
DATESYSTEME	DATE,
HEURESYSTEME	CHAR(8),
CONSTRAINT TRAEXPORT_SAP_UNIQ PRIMARY KEY (NUMEXPORT,NUM_CR) USING INDEX TABLESPACE INDX
)
/
EXIT
/