create or replace 
PROCEDURE PS_REASSORT_DET  (

Pn_NBJOUR         in number,  -- Slection : nombre de jours maxi slectionn
Pc_Operateur        in char,    -- Code oprateur faisant le rassort
Pc_ListeMag          in char,    -- Slection : liste des magasins  rassortir
Pc_Cfourniss         in char,    -- Slection : code fournisseur
Pd_DateDeb          in char,    -- Slection : dbut priode rassort
Pd_DateFin           in char,    -- Slection : fin priode rassort
Pc_FamDeb           in char,    -- Slection : famille mini
Pc_FamFin            in char,    -- Slection : famille maxi
Pn_PxVDeb          in number,  -- Slection : prix de vente mini
Pn_PxVFin            in number,  -- Slection : prix de vente maxi
Pn_SAUFCCOL                in number,  -- 0/1 : Sauf des codes collection
Pn_SAUFCSTY                in number,  -- 0/1 : Sauf des codes style
Pn_SAUFCSUI                 in number,  -- 0/1 : Sauf des codes suivi
Pn_SAUFCCOM               in number,  -- 0/1 : Sauf des couleurs mtaux
Pc_LCOL                          in char,    -- Liste des codes collection
Pc_LSTY                          in char,    -- Liste des codes style
Pc_LSUI                           in char,    -- Liste des codes suivi
Pc_LCOM                         in char,    -- Liste des codes couleurs mtaux
Pc_Centrale           in char,    -- Code magasin de la centrale
Pn_RELIQ             in number,  -- 0/1 : Tenir cpte des qts en reliquat de cde
Pn_STNONINT                 in number,  -- 0/1 : Tenir cpte des qts en stock non intgr
Pn_STMAG           in number,  -- 0/1 : Tenir cpte des qts en stock magasin
Pd_DateDepNbJour      in char,    -- Date pour calcul nb jour des articles vendus sur x derniers mois
Pd_DateVente       in char,    -- Date  partir de laquelle la qt vendue orig. sera calcule
Pd_DateHistomou       in char,    -- Date  partir de laquelle on slectionne les BL centrale pour le stock non intgr
Pd_DateJour           in char,        -- Date du dossier
Pc_TITREMET                 in char,  -- Titre mtal
Pn_InfoCatalogue      in number) AS   -- 0/1 : Paramtre fonctionnement "Ne pas mettre  jour le catalogue" 

-- ------------------------------------------------------------------------------
-- Dclaration des variables utilises
-- ------------------------------------------------------------------------------
  TYPE Curseur_c       IS REF CURSOR;
  Cur_Mag                   Curseur_c;
  Cur_Ref                    Curseur_c;
  Cur_Ref2                  Curseur_c;
  Cur_Ref3                  Curseur_c;
  
  Req_c                     varchar(20000);
  ReqMag_c                  varchar(1000);
  Mag_c                     varchar(3);
  Fam_c                     varchar(4);
  Fam_3_c                        varchar(3);
  Four_c                           varchar(4);
  Reffour_c                   varchar(30);
  Reffour_15_c             varchar(15);
  CInterne_c                varchar(15);
  LibArt_c                      varchar(500);
  ListeMag_c               varchar(10000);
  ListeCollec_c            varchar(10000);
  ListeSuivi_c             varchar(10000);
  ListeStyle_c              varchar(10000);
  ListeCoulm_c                       varchar(10000);
  SelTitreMet_c                       varchar(50);
  SelLienSto_c             varchar(100);
  FromSto_c                    varchar(50);
  Code10_c                  varchar(10);
  Code2_c                        varchar(2);
  NMag_c                    varchar(3);
  DateFac_d                   date;
  DateCre_d                   date;
  NbJoursRefMag_n    number(10);
  NbJours_n                   number(10,2);
  NbJourVend_n    number(10,2);
  NbJourSto_n     number(10,2);
  QtVendNbJour_n number(10,2);
  QtStoNbJour_n  number(10,2);
  QteVteRefMag_n      number(10,2);
  QteCdeRefMag_n     number(10,2);
  QteVteDebut_n                    number(10,2);
  QteStRefMag_n                   number(10,2);
  QteStNonInt_n                     number(10,2);
  QteStoCent_n                       number(10,2);
  QteDejaCde_n            number(10,2);
  QteVendue_n                        number(10,2);
  PxAch_n                   number(10,2);
  PxAchB_n                   number(10,2);
  PxVte_n                        number(10,2);
  RemFour_n                 number(10,2);
  Tail_n                            number(10);
  Ind_n                            number(10);
  NumEtiq_n                  number(10);
  Trouve_n                  number(1); -- Booleen
  RefMagOk_n              number(1); -- Booleen
  NMagasin_c               varchar(3);
  Catalo_PxAchB_n   number(10,2);
  Catalo_PxAch_n    number(10,2);
  Catalo_RemFour_n  number(10,2);
  Catalo_PxVte_n    number(10,2);
  Catalo_LibArt_c   varchar(500);
  
BEGIN
-- ------------------------------------------------------------------------------
-- Supression des enregistrements des tables REASREF et MAGREF pour le code
-- oprateur en cours
-- ------------------------------------------------------------------------------
DELETE FROM MAGREF  WHERE OPERATEUR = Pc_Operateur;
DELETE FROM REASREF WHERE OPERATEUR = Pc_Operateur;
-- ------------------------------------------------------------------------------
-- Formatage liste des magasins
-- ------------------------------------------------------------------------------
Tail_n := LENGTH(Pc_ListeMag);
Ind_n  := 1;
LOOP
  EXIT WHEN Ind_n > Tail_n;
  Mag_c                := SUBSTR(Pc_ListeMag,Ind_n,3);
  ListeMag_c := ListeMag_c||','''||Mag_c||'''';
  Ind_n      := Ind_n + 4;
END LOOP;
Tail_n                 := LENGTH(ListeMag_c);
ListeMag_c   := SUBSTR(ListeMag_c,2,Tail_n);
Mag_c                := NULL;
-- ------------------------------------------------------------------------------
-- Curseur liste des magasins slectionns
-- ------------------------------------------------------------------------------
ReqMag_c := '              SELECT   AD.CONTRMARQ
                           FROM            ADHERENT AD
                           WHERE         AD.CONTRMARQ IN ('||ListeMag_c||')';

-- ------------------------------------------------------------------------------
-- Prparation slection sur titre mtal
-- ------------------------------------------------------------------------------
IF Pc_TITREMET IS NOT NULL THEN
  SelTitreMet_c := ' ST.TITREMETAL = '''||Pc_TITREMET||''' AND ';
  SelLienSto_c := ' ST.NMAGASIN = HC.NMAGASIN AND ST.NUMETIQ = HC.NUMETIQ AND ST.CONTRMARQ = HC.CONTRMARQ AND ';
  FromSto_c     := ', STOCKC ST';
END IF;

-- ------------------------------------------------------------------------------
-- Prparation de la requte
-- ------------------------------------------------------------------------------
Req_c :=' SELECT  HC.CFAMILLE,HC.CFOURNISS,HC.REFFOUR,CA.CINTERNE,HC.CONTRMARQ,SUM(HC.QTEVENDUE)
                    FROM       HISTOVENC HC, CATALO CA '||FromSto_c||'
                    WHERE    CA.CFAMILLE         = HC.CFAMILLE                                                                                                AND
                            CA.CFOURNISS     = HC.CFOURNISS                                                                                            AND
                            CA.REFFOUR        = HC.REFFOUR                                                                                                 AND
                                      '||SelLienSto_c||'
                                      (HC.CANU      IS NULL OR HC.CANU <> ''A'')                                                          AND
                          HC.DATEVENT         BETWEEN   TO_DATE('''||Pd_DateDeb||''',''YYYYMMDD'')         AND
                                                                               TO_DATE('''||Pd_DateFin||''',''YYYYMMDD'')    AND
                            HC.CFOURNISS    = '''||Pc_Cfourniss||'''                                          AND
                            HC.CONTRMARQ             IN ('||ListeMag_c||')                                                                   AND
                  '||SelTitreMet_c||'
                            HC.CFAMILLE       BETWEEN  '''||Pc_FamDeb||''' AND '''||Pc_FamFin||'''  AND
                            ABS(HC.CATTC)   BETWEEN  '||to_char(Pn_PxVDeb)||' AND '||to_char(Pn_PxVFin)||'';

-- ------------------------------------------------------------------------------
-- Prparation de la requte : Slection sur les codes suivi, style ...
-- ------------------------------------------------------------------------------
IF Pc_LCOL IS NOT NULL THEN
  -- ---------------------------------------
  -- Formatage liste des codes collection
  -- ---------------------------------------
  Tail_n := 0;
  Ind_n  := 1;
  Tail_n := LENGTH(Pc_LCOL);
  LOOP
    EXIT WHEN Ind_n > Tail_n;
    Code10_c                 := SUBSTR(Pc_LCOL,Ind_n,10);
    ListeCollec_c := ListeCollec_c||','''||Code10_c||'''';
    Ind_n                            := Ind_n + 11;
  END LOOP;
  Tail_n                       := LENGTH(ListeCollec_c);
  ListeCollec_c            := SUBSTR(ListeCollec_c,2,Tail_n);
  Code10_c                  := NULL;
  -- ---------------------------------------
  -- Ajout  la requte
  -- ---------------------------------------
  Req_c := Req_c||' AND CA.CCOLLECTION  = (    SELECT  CA2.CCOLLECTION
                                                                                                       FROM    CATALO CA2
                                                                                                       WHERE   '||to_char(Pn_SAUFCCOL)||' = 0          AND
                                                                                                               CA2.CCOLLECTION IN ('||ListeCollec_c||')AND
                                                                                                               CA2.CCOLLECTION = CA.CCOLLECTION
                                                                                             UNION
                                                                                                       SELECT  CA2.CCOLLECTION
                                                                                                       FROM    CATALO CA2
                                                                                                       WHERE   '||to_char(Pn_SAUFCCOL)||' = 1              AND
                                                                                                               CA2.CCOLLECTION NOT IN ('||ListeCollec_c||')AND
                                                                                                               CA2.CCOLLECTION = CA.CCOLLECTION)';
END IF;

IF Pc_LSTY IS NOT NULL THEN
  -- ---------------------------------------
  -- Formatage liste des codes style
  -- ---------------------------------------
  Tail_n := 0;
  Ind_n  := 1;
  Tail_n := LENGTH(Pc_LSTY);
  LOOP
    EXIT WHEN Ind_n > Tail_n;
    Code10_c       := SUBSTR(Pc_LSTY,Ind_n,10);
    ListeStyle_c := ListeStyle_c||','''||Code10_c||'''';
    Ind_n                 := Ind_n + 11;
  END LOOP;
  Tail_n                  := LENGTH(ListeStyle_c);
  ListeStyle_c   := SUBSTR(ListeStyle_c,2,Tail_n);
  Code10_c          := NULL;
  -- ---------------------------------------
  -- Ajout  la requte
  -- ---------------------------------------
  Req_c := Req_c||' AND CA.CSTY = ( SELECT  CA3.CSTY
                                                                                     FROM    CATALO CA3
                                                                                     WHERE   '||to_char(Pn_SAUFCSTY)||' = 0   AND
                                                                                             CA3.CSTY IN ('||ListeStyle_c||') AND
                                                                                             CA3.CSTY = CA.CSTY
                                                                           UNION
                                                                                     SELECT CA3.CSTY
                                                                                     FROM   CATALO CA3
                                                                                     WHERE '||to_char(Pn_SAUFCSTY)||' = 1       AND
                                                                                           CA3.CSTY NOT IN ('||ListeStyle_c||') AND
                                                                                           CA3.CSTY = CA.CSTY)';
END IF;

IF Pc_LSUI IS NOT NULL THEN
  -- ---------------------------------------
  -- Formatage liste des codes suivi
  -- ---------------------------------------
  Tail_n := 0;
  Ind_n  := 1;
  Tail_n := LENGTH(Pc_LSUI);
  LOOP
    EXIT WHEN Ind_n > Tail_n;
    Code2_c          := SUBSTR(Pc_LSUI,Ind_n,2);
    ListeSuivi_c:= ListeSuivi_c||','''||Code2_c||'''';
    Ind_n       := Ind_n + 3;
  END LOOP;
  Tail_n        := LENGTH(ListeSuivi_c);
  ListeSuivi_c  := SUBSTR(ListeSuivi_c,2,Tail_n);
  Code2_c       := NULL;
  -- ---------------------------------------
  -- Ajout  la requte
  -- ---------------------------------------
  Req_c := Req_c||' AND CA.CSUI = ( SELECT  CA4.CSUI
                                                                                     FROM    CATALO CA4
                                                                                     WHERE   '||to_char(Pn_SAUFCSUI)||' = 0     AND
                                                                                             CA4.CSUI IN ('||ListeSuivi_c||')   AND
                                                                                             CA4.CSUI = CA.CSUI
                                                                           UNION
                                                                                     SELECT CA4.CSUI
                                                                                     FROM   CATALO CA4
                                                                                     WHERE  '||to_char(Pn_SAUFCSUI)||' = 1        AND
                                                                                            CA4.CSUI NOT IN ('||ListeSuivi_c||')  AND
                                                                                            CA4.CSUI = CA.CSUI)';
END IF;

IF Pc_LCOM IS NOT NULL THEN
  -- ---------------------------------------
  -- Formatage liste des codes couleur mtal
  -- ---------------------------------------
  Tail_n := 0;
  Ind_n  := 1;
  Tail_n := LENGTH(Pc_LCOM);
  LOOP
    EXIT WHEN Ind_n > Tail_n;
    Code2_c            := SUBSTR(Pc_LCOM,Ind_n,2);
    ListeCoulm_c  := ListeCoulm_c||','''||Code2_c||'''';
    Ind_n                  := Ind_n + 3;
  END LOOP;
  Tail_n        := LENGTH(ListeCoulm_c);
  Listecoulm_c := SUBSTR(ListeCoulm_c,2,Tail_n);
  Code2_c              := NULL;
  -- ---------------------------------------
  -- Ajout  la requte
  -- ---------------------------------------
  Req_c := Req_c||' AND CA.CCOUL = ( SELECT  CA5.CCOUL
                                                                                      FROM    CATALO CA5
                                                                                      WHERE   '||to_char(Pn_SAUFCCOM)||' = 0    AND
                                                                                              CA5.CCOUL IN ('||ListeCoulm_c||') AND
                                                                                              CA5.CCOUL = CA.CCOUL
                                                                        UNION
                                                                                   SELECT  CA5.CCOUL
                                                            FROM    CATALO CA5
                                                                                   WHERE   '||to_char(Pn_SAUFCCOM)||' = 1         AND
                                                                                           CA5.CCOUL NOT IN ('||ListeCoulm_c||')  AND
                                                                                           CA5.CCOUL = CA.CCOUL)';
END IF;

-- ----------------------------------------------------------------------------
-- Prparation de la requte : Regroupement par fam/four/Ref
-- ----------------------------------------------------------------------------
Req_c := Req_c||' HAVING    SUM(HC.QTEVENDUE) > 0
                  GROUP BY  HC.CFAMILLE, HC.CFOURNISS, HC.REFFOUR, CA.CINTERNE, HC.CONTRMARQ';

-- ----------------------------------------------------------------------------
-- Lecture des rf. - mags slectionnes pour recherche des infos
-- ----------------------------------------------------------------------------
OPEN Cur_Ref FOR Req_c;
LOOP
    FETCH Cur_Ref INTO Fam_c,Four_c,Reffour_c,CInterne_c,Mag_c,QteVteRefMag_n;
    EXIT WHEN Cur_Ref%NOTFOUND;
    
    -- ----------------------------------------------------------------------------
    -- Calcul du nombre de jours moyen  la rfrence
    -- ----------------------------------------------------------------------------
    -- Nombre de jours des articles vendus sur les x derniers mois
    -- ----------------------------------------------------------------------------
    NbJourVend_n    := 0;
    QtVendNbJour_n := 0;
    SELECT sUM ( CASE  WHEN       HC.DATEVENT < SC.DATEENTA
                       THEN  0
                       ELSE    (( HC.DATEVENT - SC.DATEENTA ) * HC.QTEVENDUE )
                 END ) ,
           SUM ( CASE  WHEN  HC.DATEVENT < SC.DATEENTA
                           THEN          0
                       ELSE    HC.QTEVENDUE
                 END )
    INTO    NbJourVend_n, QtVendNbJour_n
    FROM    HISTOVENC HC, STOCKC SC
    WHERE   HC.CFAMILLE   = Fam_c                                       AND
            HC.CFOURNISS  = Four_c                                      AND
            HC.REFFOUR    = Reffour_c                                   AND
            HC.CONTRMARQ  = Mag_c                                       AND
                      ( HC.CANU <> 'A' OR HC.CANU IS NULL )                       AND
            HC.DATEVENT   BETWEEN TO_DATE(Pd_DateDepNbJour,'YYYYMMDD')  AND
                                  TO_DATE(Pd_DateJour,'YYYYMMDD')       AND
            HC.NMAGASIN   = SC.NMAGASIN                                 AND
            HC.NUMETIQ    = SC.NUMETIQ                                  AND
            HC.CONTRMARQ  = SC.CONTRMARQ;

    -- ----------------------------------------------------------------------------
    -- Nombre de jours des articles en stock
    -- ----------------------------------------------------------------------------
    NbJourSto_n     := 0;
    QtStoNbJour_n  := 0;
    SELECT  SUM((TO_DATE(Pd_DateJour,'YYYYMMDD') - SC.DATEENTA) * SC.QTE_26), SUM(SC.QTE_26)
    INTO    NbJourSto_n, QtStoNbJour_n
    FROM    STOCKC SC
    WHERE   SC.CFAMILLE   = Fam_c     AND
            SC.CFOURNISS  = Four_c    AND
            SC.REFFOUR    = Reffour_c AND
            SC.CONTRMARQ  = Mag_c;

    --DBMS_OUTPUT.PUT_LINE(Fam_c||'-'||Four_c||'-'||rtrim(Reffour_c,' ')||'-'||Mag_c||'- Nb jours : Qtes Sto : '||QtStoNbJour_n);

    -- ----------------------------------------------------------------------------
    -- Calcul du nombre de jours de la rf sur mag en cours et slection suivant
    -- nb de jours saisi
    -- ----------------------------------------------------------------------------
    NbJours_n := 0;
    IF QtVendNbJour_n+QtStoNbJour_n > 0 THEN
            NbJours_n := (NbJourVend_n+NbJourSto_n)/(QtVendNbJour_n+QtStoNbJour_n);
    END IF;

    RefMagOk_n := 1;
    IF Pn_NBJOUR <> 0 THEN
      IF NbJours_n > Pn_NBJOUR THEN
                RefMagOk_n := 0;
      END IF;
    END IF;

    IF RefMagOk_n = 1 THEN

                 -- ----------------------------------------------------------------------------
                 -- Recherche quantit vendue depuis le dbut pour cette rf et ce magasin
                 -- ----------------------------------------------------------------------------
                 QteVteDebut_n := 0 ;
                 SELECT SUM(HC.QTEVENDUE)
                 INTO   QteVteDebut_n
                 FROM   HISTOVENC HC
       WHERE  HC.CONTRMARQ  = Mag_c                                     AND
                            HC.CFAMILLE   = Fam_c                                 AND
                                HC.CFOURNISS  = Four_c                                        AND
                            HC.REFFOUR    = Reffour_c                                       AND
              HC.DATEVENT       BETWEEN TO_DATE(Pd_DateVente,'YYYYMMDD')   AND
                                                                        TO_DATE(Pd_DateJour,'YYYYMMDD')       AND
                                (HC.CANU IS NULL OR HC.CANU <> 'A');
                -- ----------------------------------------------------------------------
                -- Recherche quantit de stock pour cette rf et ce magasin
                -- ----------------------------------------------------------------------------
                QteStRefMag_n := 0 ;
                SELECT SUM(SC.QTE_26)
                INTO   QteStRefMag_n
                FROM   STOCKC SC
                WHERE  SC.CONTRMARQ  = Mag_c      AND
                                 SC.CFAMILLE   = Fam_c         AND
                               SC.CFOURNISS  = Four_c          AND
                           SC.REFFOUR    = Reffour_c;
                -- ----------------------------------------------------------------------------
                -- Recherche quantit dj en commande
                -- ----------------------------------------------------------------------------
                Qtedejacde_n := 0 ;
                SELECT SUM(LF.QTEMAG - LF.QTELIVR)
                INTO   Qtedejacde_n
                FROM   LICOFDET LF, COMMFOUR CF
                WHERE  LF.NMAGASIN  = Mag_c                      AND
             LF.CINTERNE  = CInterne_c          AND
             LF.NDOCUMENT = CF.NDOCUMENT             AND
                           CF.NIVEAU    = 'VA';

                -- ----------------------------------------------------------------------------
                -- Recherche quantit en attente d'intgration (Focntion FS_STNONINT)
                -- Le stock non intgr est celui trouv dans HISTOMOU et non retrouv dans
                -- STOCKC ( => Envoy mais non intgr sur le magasin) + Les articles intgrs
                -- partielement ( => Qt envoye <> de la qt intgre (Achete) sur l'article)
                -- ----------------------------------------------------------------------------
                QteStNonInt_n := 0;
                QteStNonInt_n := FS_STNONINT(Fam_c,Four_c,Reffour_c,Mag_c,Pd_DateHistomou,Pd_DateJour);

                -- ----------------------------------------------------------------------------
                -- Calcul de la qt en cde si on tient cpte des qts reliquat de cde et stock
                -- non intgr.
                -- ----------------------------------------------------------------------------
                QteCdeRefMag_n := 0;
                QteCdeRefMag_n := NVL(QteVteRefMag_n,0);

      IF QteCdeRefMag_n > 0 THEN

        -- Enlve la qt en reliquat de commande
        IF Pn_RELIQ = 1 THEN
          QteCdeRefMag_n := QteCdeRefMag_n - NVL(Qtedejacde_n,0);
          IF QteCdeRefMag_n < 0 THEN
            QteCdeRefMag_n := 0;
          END IF;
        END IF;

        -- Enlve la qt en stock non intgr
        IF Pn_STNONINT = 1 THEN
          QteCdeRefMag_n := QteCdeRefMag_n - NVL(QteStNonInt_n,0);
          IF QteCdeRefMag_n < 0 THEN
            QteCdeRefMag_n := 0;
          END IF;
        END IF;

        -- Enlve la qt de stock du magasin
        IF Pn_STMAG = 1 THEN
          QteCdeRefMag_n := QteCdeRefMag_n - NVL(QteStRefMag_n,0);
          IF QteCdeRefMag_n < 0 THEN
            QteCdeRefMag_n := 0;
          END IF;
        END IF;

      END IF;

                -- ----------------------------------------------------------------------------
                -- Gestion des qts vendues ngatives (Reprises)
                -- ----------------------------------------------------------------------------
                IF QteCdeRefMag_n < 0 THEN
                        QteCdeRefMag_n := 0;
                END IF;

                -- ----------------------------------------------------------------------------
                -- Insertion de la rf. par magasin
                -- ----------------------------------------------------------------------------
                INSERT INTO MAGREF    (         OPERATEUR, CMAG, CFOURNISS, REFFOUR, CFAMILLE,
                                                        CINTERNE, STGENCODE, QTECDE,
                                                                                     QTEVEN,
                                                          QTEVENDEB, QTEDEJACDE, QTESTOCK,
                                                                      QTE_ATTENTE_MAG, LIBPROD, TAIL, LONGUEUR, PXACHATU,
                                                    PXACHATOT, DUREE_VIE, DATELIV)
                                                                 ( SELECT  Pc_Operateur, Mag_c, Four_c, Reffour_c, Fam_c,
                                                                         CInterne_c, CA.STGENCODE, QteCdeRefMag_n,QteVteRefMag_n,
                                                                         QteVteDebut_n, Qtedejacde_n, QteStRefMag_n,
                                                                         QteStNonInt_n, CA.LIBART, 0, 0, 0,
                                                                         0, NbJours_n,''
                                                             FROM           CATALO CA
                                                      WHERE    CA.CINTERNE = CInterne_c);
    END IF; -- FIN du SI Nombre de jours OK
END LOOP; -- FIN Boucle des rf. slectionnes
CLOSE Cur_Ref;

-- ----------------------------------------------------------------------------
-- Recherche des rfrences slectionnes pour complter la table MAGREF avec
-- les magasins slectionns mais non trouvs dans HISTOVENC
-- ----------------------------------------------------------------------------

--DBMS_OUTPUT.PUT_LINE('Boucle Cur_Ref2 ');

Req_c := ' SELECT  DISTINCT CFAMILLE,CFOURNISS,REFFOUR,CINTERNE
                     FROM       MAGREF
                     WHERE   OPERATEUR = '''||Pc_Operateur||'''';
OPEN Cur_Ref2 FOR Req_c;
LOOP
  FETCH Cur_Ref2 into Fam_c,Four_c,Reffour_c,CInterne_c;
  EXIT WHEN Cur_Ref2%NOTFOUND;

  -- ------------------------------------------
  -- Parcours des magasins slectionns
  -- ------------------------------------------
  OPEN Cur_Mag FOR ReqMag_c;
  LOOP
    FETCH Cur_Mag into Mag_c;
    EXIT WHEN Cur_Mag%NOTFOUND;

      -- ----------------------------------------
      -- Recherche si mag trait
      -- ----------------------------------------
      BEGIN
        SELECT 1
        INTO   Trouve_n
        FROM   MAGREF
        WHERE  OPERATEUR  = Pc_Operateur                       AND
                       CFAMILLE        = RPad(Fam_c,4,' ')                    AND
                       CFOURNISS    = Four_c                            AND
                       REFFOUR          = RPad(Reffour_c,30,' ')         AND
                       CMAG                 = Mag_c;
              EXCEPTION
                 WHEN NO_DATA_FOUND THEN Trouve_n := 0;
              END;

      -- ----------------------------------------
      -- Pas trouv => cration enreg MAGREF
      -- ----------------------------------------
      IF Trouve_n = 0 THEN

          -- ----------------------------------------------------------------------------
          -- Calcul du nombre de jours moyen  la rfrence
          -- ----------------------------------------------------------------------------
          -- Nombre de jours des articles vendus sur les x derniers mois
          -- ----------------------------------------------------------------------------
          NbJourVend_n    := 0;
          QtVendNbJour_n := 0;     
          SELECT sUM (  CASE  WHEN HC.DATEVENT < SC.DATEENTA
                                        THEN 0
                             ELSE (( HC.DATEVENT - SC.DATEENTA ) * HC.QTEVENDUE )
                            END ) ,
               SUM (   CASE  WHEN HC.DATEVENT < SC.DATEENTA
                                          THEN 0
                             ELSE HC.QTEVENDUE
                              END )
          INTO    NbJourVend_n, QtVendNbJour_n
          FROM    HISTOVENC HC, STOCKC SC
          WHERE   HC.CFAMILLE   = Fam_c                                       AND
                  HC.CFOURNISS  = Four_c                                      AND
                  HC.REFFOUR    = Reffour_c                                   AND
                 HC.CONTRMARQ  = Mag_c                                       AND
                                      ( HC.CANU <> 'A' OR HC.CANU IS NULL )                       AND
                  HC.DATEVENT   BETWEEN TO_DATE(Pd_DateDepNbJour,'YYYYMMDD')  AND
                                        TO_DATE(Pd_DateJour,'YYYYMMDD')       AND
                  HC.NMAGASIN   = SC.NMAGASIN                                 AND
                  HC.NUMETIQ    = SC.NUMETIQ                                  AND
                  HC.CONTRMARQ  = SC.CONTRMARQ;

          -- ----------------------------------------------------------------------------
          -- Nombre de jours des articles en stock
          -- ----------------------------------------------------------------------------
          NbJourSto_n     := 0;
          QtStoNbJour_n  := 0;
          SELECT  SUM((TO_DATE(Pd_DateJour,'YYYYMMDD') - SC.DATEENTA) * SC.QTE_26), SUM(SC.QTE_26)
          INTO    NbJourSto_n, QtStoNbJour_n
          FROM    STOCKC SC
          WHERE   SC.CFAMILLE   = Fam_c     AND
                  SC.CFOURNISS  = Four_c    AND
                  SC.REFFOUR    = Reffour_c AND
                  SC.CONTRMARQ  = Mag_c;
                          
          -- ----------------------------------------------------------------------------
          -- Calcul du nombre de jours de la rf sur mag en cours et slection suivant
          -- nb de jours saisi
          -- ----------------------------------------------------------------------------
              NbJours_n := 0;
              IF QtVendNbJour_n  IS NULL THEN QtVendNbJour_n  := 0; END IF;
              IF QtStoNbJour_n   IS NULL THEN QtStoNbJour_n   := 0; END IF;
              IF NbJourSto_n      IS NULL THEN NbJourSto_n      := 0; END IF;
              IF NbJourVend_n     IS NULL THEN NbJourVend_n     := 0; END IF;
              
              IF ( QtVendNbJour_n + QtStoNbJour_n ) > 0 THEN
                       NbJours_n := (NbJourVend_n+NbJourSto_n)/(QtVendNbJour_n+QtStoNbJour_n);
              END IF;
              
                   -- ----------------------------------------------------------------------
                   -- Recherche quantit de stock pour cette rf et ce magasin
                   -- ----------------------------------------------------------------------------
                   QteStRefMag_n := 0 ;
                   SELECT SUM(SC.QTE_26)
                   INTO   QteStRefMag_n
                   FROM   STOCKC SC
                   WHERE  SC.CONTRMARQ  = Mag_c      AND
                                    SC.CFAMILLE   = Fam_c       AND
                                  SC.CFOURNISS  = Four_c        AND
                              SC.REFFOUR    = Reffour_c;

                   -- ----------------------------------------------------------------------
                   -- Recherche quantit vendue depuis le dbut pour cette rf et ce magasin
                   -- ----------------------------------------------------------------------------
                   QteVteDebut_n := 0 ;
                   SELECT SUM(HC.QTEVENDUE)
                   INTO   QteVteDebut_n
                   FROM   HISTOVENC HC
                   WHERE  HC.CONTRMARQ  = Mag_c                                     AND
                    HC.CFAMILLE   = Fam_c                                          AND
                                  HC.CFOURNISS  = Four_c                                      AND
                              HC.REFFOUR    = Reffour_c                                     AND
                              HC.DATEVENT   BETWEEN TO_DATE(Pd_DateVente,'YYYYMMDD')   AND
                                                                        TO_DATE(Pd_DateJour,'YYYYMMDD')       AND
                                    (HC.CANU IS NULL OR HC.CANU <> 'A');

                   -- ----------------------------------------------------------------------------
                     -- Recherche quantit dj en commande
                     -- ----------------------------------------------------------------------------
                   Qtedejacde_n := 0 ;
                   SELECT SUM(LF.QTEMAG - LF.QTELIVR)
                   INTO   Qtedejacde_n
                   FROM   LICOFDET LF, COMMFOUR CF
                   WHERE  LF.NMAGASIN  = Mag_c                   AND
                  LF.CINTERNE  = CInterne_c         AND
                  LF.NDOCUMENT = CF.NDOCUMENT        AND
                                CF.NIVEAU    = 'VA';


                   -- ----------------------------------------------------------------------------
                   -- Recherche quantit en attente d'intgration (Fonction FS_STNONINT)
                   -- Le stock non intgr est celui trouv dans HISTOMOU et non retrouv dans
                   -- STOCKC ( => Envoy mais non intgr sur le magasin) + Les articles intgrs
                   -- partielement ( => Qt envoye <> de la qt intgre (Achete) sur l'article)
                   -- ----------------------------------------------------------------------------
                   QteStNonInt_n := 0 ;
                     QteStNonInt_n := FS_STNONINT(Fam_c,Four_c,Reffour_c,Mag_c,Pd_DateHistomou,Pd_DateJour);

                   -- ----------------------------------------------------------------------------
                     -- Insertion de la rf. par magasin
                   -- ----------------------------------------------------------------------------
                   INSERT INTO MAGREF (           OPERATEUR, CMAG, CFOURNISS, REFFOUR, CFAMILLE,
                                                    CINTERNE, STGENCODE, QTECDE, QTEVEN,
                                                    QTEVENDEB, QTEDEJACDE, QTESTOCK,
                                                                QTE_ATTENTE_MAG, LIBPROD, TAIL, LONGUEUR, PXACHATU,
                                              PXACHATOT, DUREE_VIE, DATELIV)
                                                                   ( SELECT Pc_Operateur, Mag_c, Four_c, Reffour_c, Fam_c,
                                                                CInterne_c, CA.STGENCODE, 0, 0,
                                                                          QteVteDebut_n, Qtedejacde_n, QteStRefMag_n,
                                                                          QteStNonInt_n, CA.LIBART, 0, 0, 0, 0, NbJours_n,''
                                                                 FROM  CATALO CA
                                                         WHERE CA.CINTERNE = CInterne_c);
      END IF;
  END LOOP; -- FIN Boucle des magasins slectionns
  CLOSE Cur_Mag;
END LOOP; -- FIN Boucle des rfrences slectionnes
CLOSE Cur_Ref2;

-- ----------------------------------------------------------------------------
-- Cration du fichier REASREF qui sont le cumul des enregs de MAGREF  la
-- rfrence fournisseur
-- ----------------------------------------------------------------------------
Req_c := '  SELECT    MR.CFAMILLE,MR.CFOURNISS,MR.REFFOUR,MR.CINTERNE,
                      CA.DATECRE,CA.PXACHATU,CA.PXACHATN,CA.REMFOUR,CA.PXVENTTC_1,CA.LIBART,
                      SUM(MR.QTECDE)
            FROM      MAGREF MR , CATALO CA
            WHERE     MR.CINTERNE = CA.CINTERNE AND MR.OPERATEUR = '''||Pc_Operateur||'''
            GROUP BY  MR.CFAMILLE,MR.CFOURNISS,MR.REFFOUR,MR.CINTERNE,
                      CA.DATECRE,CA.PXACHATU,CA.PXACHATN,CA.REMFOUR,CA.PXVENTTC_1,CA.LIBART';                      

OPEN Cur_Ref3 FOR Req_c;
LOOP
  FETCH Cur_Ref3 INTO Fam_c,Four_c,Reffour_c,CInterne_c,
                      DateCre_d,Catalo_PxAchB_n,Catalo_PxAch_n,Catalo_RemFour_n,Catalo_PxVte_n,Catalo_LibArt_c,
                      QteVendue_n;
  EXIT WHEN Cur_Ref3%NOTFOUND;

  -- ----------------------------------------------------------------------------
  -- Rcup des valeurs sans espaces pour requte sur tables centrale
  -- ----------------------------------------------------------------------------
  Fam_3_c       := rtrim(Fam_c,' ');
  Reffour_15_c  := rtrim(Reffour_c,' ');
  Reffour_15_c  := rpad(Reffour_15_c,15,' ');

  -- ----------------------------------------------------------------------------
  -- Si qt vendue globales ngative => Passe  zro : ne devrait pas arriver
  -- ----------------------------------------------------------------------------
  IF QteVendue_n < 0 THEN
   QteVendue_n := 0;
  END IF;

  -- ----------------------------------------------------------------------------
  -- Recherche de la dernire entre de stock ( CENTRALE ) sur la rfrence et 
  -- de ses infos ( Prix achat / Prix vente / Libell )
  -- ----------------------------------------------------------------------------
  DateFac_d := '';
  PxAch_n   := 0;
  PxAchB_n  := 0;
  PxVte_n   := 0;
  RemFour_n := 0;
  LibArt_c  := '';
  
  Numetiq_n:=0;
  SELECT  MAX(NUMETIQ)
  INTO    Numetiq_n
  FROM    STOCK
  WHERE   CFOURNISS = Four_c  AND
          CFAMILLE  = Fam_3_c AND
          REFFOUR   = Reffour_15_c;
   
  
  IF Numetiq_n <> 0 THEN
    NMagasin_c:='';
    SELECT  NMAGASIN
    INTO    NMagasin_c
    FROM    STOCK
    WHERE   NUMETIQ   = Numetiq_n AND
            CFOURNISS = Four_c  AND
            CFAMILLE  = Fam_3_c AND
            REFFOUR   = Reffour_15_c;
  END IF;
    
  IF Numetiq_n <> 0 AND NMagasin_c <> ' ' THEN
    SELECT  DATEFAC, PXACHATN, PXACHATB, PXVENTTC_1, REMFOUR, LIBART
    INTO    DateFac_d, PxAch_n, PxAchB_n, PxVte_n, RemFour_n, LibArt_c
    FROM    STOCK
    WHERE   NUMETIQ  = Numetiq_n AND
            NMAGASIN = NMagasin_c;
  END IF;
  
  -- ----------------------------------------------------------------------------
  -- Suivant le paramtre, on reprend les infos de la dernire entre de stock
  -- ou du catalogue article
  -- ----------------------------------------------------------------------------  
  IF Pn_InfoCatalogue = 1 THEN  
    PxAch_n   := Catalo_PxAch_n ;
    PxAchB_n  := Catalo_PxAchB_n ;
    PxVte_n   := Catalo_PxVte_n ; 
    RemFour_n := Catalo_RemFour_n ;
    LibArt_c  := Catalo_LibArt_c ;
  END IF;  
   
  -- ----------------------------------------------------------------------------
  -- Recherche du stock centrale de la rfrence
  -- ----------------------------------------------------------------------------
  QteStoCent_n := 0 ;
  SELECT SUM(QTE_26)
  INTO   QteStoCent_n
  FROM   STOCK
  WHERE  CFAMILLE  = Fam_3_c      AND
                   CFOURNISS = Four_c         AND
         REFFOUR   = Reffour_15_c;

  -- ----------------------------------------------------------------------------
  -- Insertion de la rf. tous mags confondus
  -- ----------------------------------------------------------------------------
  INSERT INTO REASREF     ( OPERATEUR,MACFOURNISS,MAREFFOUR,CFAMILLE,CINTERNE,DERNCDE,
                        MAQTECOM,MATAILLE,MAPOIDS,LONGUEUR,MAPA,MAPAB,MAREMISE,
                                     MAPV,MAEXIST,MACOMMENT,QTESTO_CENT,DATECRE)
  VALUES
                                ( Pc_Operateur, Four_c, Reffour_c, Fam_c, CInterne_c, DateFac_d,
                                             QteVendue_n, 0, 0, 0, PxAch_n, PxAchB_n, RemFour_n,
                                             PxVte_n, 0, LibArt_c, QteStoCent_n,DateCre_d);
END LOOP; -- FIN Boucle des rfrences slectionnes
CLOSE Cur_Ref3;
END PS_REASSORT_DET;