/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util;

import java.util.Hashtable;
import java.util.ResourceBundle;
import javax.naming.CommunicationException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import oracle.ldap.util.CommunicationErrorException;
import oracle.ldap.util.GeneralErrorException;
import oracle.ldap.util.LDAPGroup;
import oracle.ldap.util.NoSuchGroupException;
import oracle.ldap.util.ParameterException;
import oracle.ldap.util.PropertySet;
import oracle.ldap.util.PropertySetCollection;
import oracle.ldap.util.User;
import oracle.ldap.util.Util;
import oracle.ldap.util.UtilException;

public class Group
extends LDAPGroup {
    private int groupIdType = -1;
    private static String commonDN = "cn=Common,cn=Products,cn=OracleContext";
    private static ResourceBundle resBundle = ResourceBundle.getBundle("oracle.ldap.util.nls.UtilityResource");
    private String grpGuid = null;

    public Group(int n, String string) throws UtilException {
        super(null, string);
        if (string == null) {
            throw new ParameterException(resBundle.getString("PARAMETER_NULL") + ":  inGroupIdName");
        }
        if (n != Util.IDTYPE_GUID && n != Util.IDTYPE_DN) {
            throw new ParameterException(resBundle.getString("PARAMETER_INVALID") + ":  inGroupIdType");
        }
        this.entryDN = string;
        this.groupIdType = n;
        if (n == Util.IDTYPE_GUID) {
            this.grpGuid = string;
        }
        this.validated = false;
    }

    protected Group(DirContext dirContext, String string) {
        super(dirContext, string);
        this.validated = true;
    }

    protected Group(DirContext dirContext, String string, PropertySet propertySet) {
        super(dirContext, string, propertySet);
        this.validated = true;
    }

    public void resolve(DirContext dirContext) throws UtilException {
        try {
            if (!this.validated) {
                PropertySetCollection propertySetCollection = null;
                if (this.groupIdType == Util.IDTYPE_DN) {
                    propertySetCollection = Util.getEntryDetails(dirContext, this.entryDN, "(objectclass=*)", 0, new String[]{"orclguid"});
                    if (!propertySetCollection.isEmpty()) {
                        this.grpGuid = (String)propertySetCollection.getPropertySet(0).getProperty("orclguid").getValue(0);
                    }
                } else if (this.groupIdType == Util.IDTYPE_GUID && !(propertySetCollection = Util.getEntryDetails(dirContext, "", "orclguid=" + this.grpGuid, 2, new String[0])).isEmpty()) {
                    this.entryDN = propertySetCollection.getPropertySet(0).getDN();
                }
                if (propertySetCollection.isEmpty()) {
                    throw new NoSuchGroupException();
                }
                this.validated = true;
            }
        }
        catch (NamingException namingException) {
            if (namingException instanceof CommunicationException) {
                throw new CommunicationErrorException(resBundle.getString("UNABLE_TO_CONNECT_TO_DIR"), namingException);
            }
            throw new GeneralErrorException(resBundle.getString("GENERAL_ERROR_SEARCH") + this.entryDN, namingException);
        }
    }

    public boolean isMember(DirContext dirContext, User user, boolean bl) throws UtilException {
        this.resolve(dirContext);
        String[] stringArray = new String[]{"orclguid"};
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        searchControls.setReturningAttributes(stringArray);
        Hashtable hashtable = null;
        if (bl) {
            hashtable = new Hashtable(100);
        }
        return this.isGroupMember(dirContext, bl, user.getDN(dirContext), Util.normalizeDN(this.getDN(dirContext)), hashtable, searchControls);
    }

    private boolean isGroupMember(DirContext dirContext, boolean bl, String string, String string2, Hashtable hashtable, SearchControls searchControls) throws UtilException {
        try {
            NamingEnumeration<SearchResult> namingEnumeration = dirContext.search("", "uniquemember=" + string, searchControls);
            while (namingEnumeration.hasMore()) {
                SearchResult searchResult = namingEnumeration.next();
                String string3 = null;
                try {
                    string3 = (String)searchResult.getAttributes().get("orclguid").get(0);
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                if (string3 != null && this.grpGuid.equalsIgnoreCase(string3)) {
                    return true;
                }
                if (string3 == null && (string3 = Util.normalizeDN(searchResult.getName())).equals(string2)) {
                    return true;
                }
                if (!bl || hashtable.containsKey(string3)) continue;
                hashtable.put(string3, searchResult);
                if (!this.isGroupMember(dirContext, bl, searchResult.getName(), string2, hashtable, searchControls)) continue;
                return true;
            }
        }
        catch (NamingException namingException) {
            Util.grpErrHandler(namingException, new UtilException("isMember", namingException));
        }
        return false;
    }

    public String getDn(DirContext dirContext) throws UtilException {
        return this.getDN(dirContext);
    }

    public PropertySetCollection getProperties(DirContext dirContext, String[] stringArray) throws UtilException {
        return this.getProperties(dirContext, stringArray, false);
    }
}

