/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util;

import java.util.ResourceBundle;
import javax.naming.CommunicationException;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import oracle.ldap.util.CommunicationErrorException;
import oracle.ldap.util.GeneralErrorException;
import oracle.ldap.util.ModPropertySet;
import oracle.ldap.util.PropertySet;
import oracle.ldap.util.PropertySetCollection;
import oracle.ldap.util.Util;
import oracle.ldap.util.UtilException;

public abstract class LDAPEntry {
    protected static ResourceBundle resBundle = ResourceBundle.getBundle("oracle.ldap.util.nls.UtilityResource");
    protected String entryDN = null;
    protected String inEntryId = null;
    protected int entryIdType = -1;
    protected PropertySetCollection entryPsc = null;
    protected boolean validated = false;

    protected LDAPEntry(DirContext dirContext, String string) {
        this.entryDN = string;
        this.entryPsc = new PropertySetCollection();
    }

    protected LDAPEntry(DirContext dirContext, String string, PropertySet propertySet) {
        this.entryDN = string;
        this.entryPsc = new PropertySetCollection();
        this.entryPsc.add(propertySet);
    }

    public PropertySetCollection getProperties(DirContext dirContext, String[] stringArray, boolean bl) throws UtilException {
        if (!this.validated) {
            this.resolve(dirContext);
        }
        try {
            if (bl && stringArray != null && !this.entryPsc.isEmpty()) {
                this.entryPsc.getPropertySet(0).doSearch(dirContext, stringArray);
                PropertySetCollection propertySetCollection = new PropertySetCollection();
                propertySetCollection.add(this.entryPsc.getPropertySet(0).returnPropertySet(stringArray));
                return propertySetCollection;
            }
            this.entryPsc = Util.getEntryDetails(dirContext, this.entryDN, "(objectclass=*)", 0, stringArray);
            return this.entryPsc;
        }
        catch (NamingException namingException) {
            if (namingException instanceof CommunicationException) {
                throw new CommunicationErrorException(resBundle.getString("UNABLE_TO_CONNECT_TO_DIR"), namingException);
            }
            throw new GeneralErrorException(resBundle.getString("NAMINGEXCEPTION_SEARCH") + ":  " + this.entryDN, namingException);
        }
    }

    public void setProperties(DirContext dirContext, ModPropertySet modPropertySet) throws UtilException {
        this.resolve(dirContext);
        Util.ldapModify(dirContext, this.entryDN, modPropertySet);
    }

    public String getDN(DirContext dirContext) throws UtilException {
        this.resolve(dirContext);
        return this.entryDN;
    }

    public abstract void resolve(DirContext var1) throws UtilException;
}

