/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.naming.CommunicationException;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NamingException;
import javax.naming.directory.AttributeInUseException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.NoSuchAttributeException;
import oracle.ldap.util.CommunicationErrorException;
import oracle.ldap.util.LDAPEntry;
import oracle.ldap.util.LDIFReader;
import oracle.ldap.util.LDIFRecord;
import oracle.ldap.util.LDIFSubstitute;
import oracle.ldap.util.LDIFWriter;
import oracle.ldap.util.UtilException;

public class LDIFLoader {
    private static String fileName = null;
    private static Vector subVector = null;
    private boolean debug = true;
    private DirContext ctx = null;
    private boolean ignoreError = false;
    private NamingException[] ignoredExceptionList = null;
    private PrintStream pStream = null;
    private String listFileExt = ".lst";
    private String sbsFileExt = ".sbs";
    private static ResourceBundle resBundle = LDAPEntry.resBundle;

    public LDIFLoader(DirContext dirContext, String string, Vector vector) {
        fileName = string;
        subVector = vector;
        if (dirContext == null || string == null) {
            // empty if block
        }
        this.ctx = dirContext;
        this.debug = true;
        this.pStream = System.out;
    }

    public void load() throws UtilException {
        if (fileName.endsWith(this.listFileExt)) {
            this.recursiveLoad(fileName, "");
        } else {
            this.loadOneLdifFile(fileName, "");
        }
    }

    public void load(boolean bl, PrintStream printStream) throws UtilException {
        this.pStream = printStream == null ? System.out : printStream;
        this.ignoreError = bl;
        this.load();
    }

    private void recursiveLoad(String string, String string2) throws UtilException {
        if (this.debug) {
            this.pStream.println(string2 + "->> " + string + " *");
        }
        try {
            File file = new File(string);
            if (!file.exists()) {
                // empty if block
            }
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            String string3 = file.getParent();
            while (bufferedReader.ready()) {
                String string4 = bufferedReader.readLine().trim();
                if (string4.length() <= 0 || string4.startsWith("#")) continue;
                String string5 = string3 + File.separator + string4;
                if (string5.endsWith(this.listFileExt)) {
                    this.recursiveLoad(string5, string2 + "   ");
                    continue;
                }
                this.loadOneLdifFile(string5, string2 + "   ");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.pStream.println("exception in recursive load");
        }
    }

    private void loadOneLdifFile(String string, String string2) throws UtilException {
        try {
            if (this.debug) {
                this.pStream.println(string2 + "-> LOADING:  " + string);
            }
            LDIFReader lDIFReader = new LDIFReader(string);
            LDIFWriter lDIFWriter = null;
            ByteArrayOutputStream byteArrayOutputStream = null;
            byteArrayOutputStream = new ByteArrayOutputStream();
            lDIFWriter = new LDIFWriter(byteArrayOutputStream);
            Vector vector = null;
            Vector vector2 = null;
            while ((vector = lDIFReader.nextEntry()) != null) {
                vector2 = LDIFSubstitute.substitute(vector, subVector);
                lDIFWriter.writeEntry(vector2);
            }
            lDIFWriter.close();
            lDIFReader.close();
            lDIFReader = new LDIFReader(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()), "UTF-8");
            LDIFRecord lDIFRecord = null;
            while ((lDIFRecord = lDIFReader.nextRecord()) != null) {
                try {
                    switch (lDIFRecord.getChangeType()) {
                        case 1: {
                            Attributes attributes = lDIFRecord.getJNDIAttributes();
                            this.ctx.createSubcontext(lDIFRecord.getDN(), attributes);
                            break;
                        }
                        case 3: {
                            ModificationItem[] modificationItemArray = lDIFRecord.getJNDIModificationItems();
                            this.ctx.modifyAttributes(lDIFRecord.getDN(), modificationItemArray);
                            break;
                        }
                        case 2: {
                            this.ctx.destroySubcontext(lDIFRecord.getDN());
                        }
                    }
                }
                catch (NamingException namingException) {
                    if (namingException instanceof CommunicationException) {
                        throw new CommunicationErrorException(resBundle.getString("UNABLE_TO_CONNECT_TO_DIR"), namingException);
                    }
                    if (this.ignoreError) {
                        this.pStream.println("Error:  " + string);
                        this.pStream.println(lDIFRecord.toString());
                        if (!this.isIgnoredException(namingException)) {
                            this.pStream.println(namingException.toString());
                            throw new UtilException("NamingException encountered during loading of file:  " + string, namingException);
                        }
                    } else {
                        throw new UtilException("NamingException encountered during loading of file:  " + string + lDIFRecord.toString(), namingException);
                    }
                    this.pStream.println("Ignoring Error:  " + namingException.toString());
                    this.pStream.println();
                    this.pStream.println();
                }
            }
            lDIFReader.close();
        }
        catch (IOException iOException) {
            throw new UtilException("IOException encountered when loading file:  " + string, iOException);
        }
    }

    private boolean isIgnoredException(NamingException namingException) {
        if (this.ignoredExceptionList == null) {
            return true;
        }
        return namingException instanceof AttributeInUseException || namingException instanceof NameAlreadyBoundException || namingException instanceof NoSuchAttributeException;
    }
}

