/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util;

import java.util.Enumeration;
import java.util.Vector;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.ModificationItem;
import oracle.ldap.util.LDIFAttribute;

public class LDIFRecord
implements Cloneable {
    private String dn = null;
    private Vector attrs = null;
    private int changeType = 1;
    private String newRdn = null;
    private boolean deleteOldRdn = false;
    private String newSuperior = null;
    private boolean expChgType = false;

    public LDIFRecord() {
        this(null);
    }

    public LDIFRecord(String string) {
        this.dn = string;
        this.attrs = new Vector();
    }

    public String getNewRdn() {
        return this.newRdn;
    }

    public String getNewSuperior() {
        return this.newSuperior;
    }

    public boolean getDeleteOldRdn() {
        return this.deleteOldRdn;
    }

    public void addAttribute(LDIFAttribute lDIFAttribute) {
        if (lDIFAttribute != null) {
            int n = this.attrs.lastIndexOf(lDIFAttribute);
            if (n == -1) {
                this.attrs.addElement(lDIFAttribute);
            } else {
                LDIFAttribute lDIFAttribute2 = (LDIFAttribute)this.attrs.elementAt(n);
                if (lDIFAttribute2.getChangeType() == lDIFAttribute.getChangeType()) {
                    lDIFAttribute2.addValue(lDIFAttribute.getStringValueArray());
                } else {
                    this.attrs.addElement(lDIFAttribute);
                }
            }
        }
    }

    public void add(String string, String string2, int n) {
        LDIFAttribute lDIFAttribute = null;
        if (null != string) {
            lDIFAttribute = new LDIFAttribute(string, string2);
            lDIFAttribute.setChangeType(n);
            this.addAttribute(lDIFAttribute);
        }
    }

    public String getDN() {
        return this.dn;
    }

    public void setDN(String string) {
        this.dn = string;
    }

    void setExpChgType(boolean bl) {
        this.expChgType = bl;
    }

    boolean getExpChgType() {
        return this.expChgType;
    }

    public synchronized LDIFAttribute getAttribute(String string) {
        LDIFAttribute lDIFAttribute = null;
        int n = 0;
        while (n < this.attrs.size()) {
            lDIFAttribute = (LDIFAttribute)this.attrs.elementAt(n);
            if (string.equalsIgnoreCase(lDIFAttribute.getName())) break;
            lDIFAttribute = null;
            ++n;
        }
        return lDIFAttribute;
    }

    public synchronized void removeAttribute(String string) {
        this.removeAttribute(string, false);
    }

    public synchronized void removeAttribute(String string, boolean bl) {
        LDIFAttribute lDIFAttribute = null;
        int n = this.attrs.size();
        int n2 = 0;
        String string2 = null;
        while (n2 < n) {
            lDIFAttribute = (LDIFAttribute)this.attrs.elementAt(n2);
            String string3 = string2 = bl ? lDIFAttribute.getBaseName() : lDIFAttribute.getName();
            if (string.equalsIgnoreCase(string2)) {
                this.attrs.removeElement(lDIFAttribute);
                if (!bl) break;
                --n;
                continue;
            }
            ++n2;
        }
    }

    public synchronized LDIFAttribute getAttribute(int n) {
        if (n < 0 || n >= this.size()) {
            throw new IndexOutOfBoundsException("Invalid Index : " + n);
        }
        return (LDIFAttribute)this.attrs.elementAt(n);
    }

    public Enumeration getAll() {
        return this.attrs.elements();
    }

    public boolean contains(String string) {
        LDIFAttribute lDIFAttribute = this.getAttribute(string);
        return lDIFAttribute != null;
    }

    public synchronized Enumeration getIDs() {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < this.attrs.size()) {
            LDIFAttribute lDIFAttribute = (LDIFAttribute)this.attrs.elementAt(n);
            vector.addElement(lDIFAttribute.getName());
            ++n;
        }
        return vector.elements();
    }

    public int getChangeType() {
        return this.changeType;
    }

    public void setChangeType(int n) {
        this.changeType = n;
    }

    public int size() {
        return this.attrs.size();
    }

    public Object clone() {
        return null;
    }

    synchronized void setNewRdn(String string, boolean bl, String string2) {
        if (this.changeType == 4) {
            this.newRdn = string;
            this.deleteOldRdn = bl;
            this.newSuperior = string2;
        }
    }

    public synchronized Attributes getJNDIAttributes() {
        BasicAttributes basicAttributes = null;
        LDIFAttribute lDIFAttribute = null;
        int n = this.attrs.size();
        if (n != 0) {
            basicAttributes = new BasicAttributes();
            int n2 = 0;
            while (n2 < n) {
                lDIFAttribute = (LDIFAttribute)this.attrs.elementAt(n2);
                basicAttributes.put(lDIFAttribute.getJNDIAttribute());
                ++n2;
            }
        }
        return basicAttributes;
    }

    public synchronized ModificationItem[] getJNDIModificationItems() {
        ModificationItem[] modificationItemArray = null;
        LDIFAttribute lDIFAttribute = null;
        int n = this.attrs.size();
        if (n != 0) {
            modificationItemArray = new ModificationItem[n];
            int n2 = 0;
            while (n2 < n) {
                lDIFAttribute = (LDIFAttribute)this.attrs.elementAt(n2);
                modificationItemArray[n2] = lDIFAttribute.getJNDIModificationItem();
                ++n2;
            }
        }
        return modificationItemArray;
    }

    String getRecordAsString(boolean bl) {
        return this.getRecordAsString(bl, true);
    }

    /*
     * Unable to fully structure code
     */
    String getRecordAsString(boolean var1_1, boolean var2_2) {
        block15: {
            block14: {
                var3_3 = this.getAll();
                var4_4 = System.getProperty("line.separator");
                var5_5 = new StringBuffer();
                var6_6 = var1_1 != false ? "#" : "";
                var5_5.append(LDIFAttribute.getAttrAsLDIFStr("dn", this.getDN(), var1_1, var2_2)).append(var4_4);
                if (this.changeType == 2) {
                    var5_5.append(var6_6 + "changetype: delete").append(var4_4);
                } else if (this.changeType == 3) {
                    var5_5.append(var6_6 + "changetype: modify").append(var4_4);
                } else if (this.changeType == 4) {
                    var5_5.append(var6_6 + "changetype: moddn").append(var4_4);
                }
                if (this.changeType != 1) break block14;
                if (this.expChgType) {
                    var5_5.append(var6_6 + "changetype: add").append(var4_4);
                }
                while (var3_3.hasMoreElements()) {
                    var7_7 = (LDIFAttribute)var3_3.nextElement();
                    var8_8 = var7_7.getChangeType();
                    var9_9 = var7_7.getName();
                    var10_10 = var7_7.getByteValues();
                    while (var10_10.hasMoreElements()) {
                        var11_11 = (byte[])var10_10.nextElement();
                        var5_5.append(LDIFAttribute.getAttrAsLDIFStr(var9_9, var11_11, var1_1, var2_2, var7_7.isBinary())).append(var4_4);
                    }
                }
                break block15;
            }
            if (this.changeType != 4) ** GOTO lbl52
            var5_5.append(LDIFAttribute.getAttrAsLDIFStr("newrdn", this.newRdn, var1_1, var2_2)).append(var4_4).append(var6_6 + "deleteoldrdn: ");
            if (this.deleteOldRdn) {
                var5_5.append("1");
            } else {
                var5_5.append("0");
            }
            var5_5.append(var4_4);
            if (this.newSuperior == null) break block15;
            var5_5.append(LDIFAttribute.getAttrAsLDIFStr("newsuperior", this.newSuperior, var1_1, var2_2)).append(var4_4);
            break block15;
lbl-1000:
            // 1 sources

            {
                var5_5.append(((LDIFAttribute)var3_3.nextElement()).getAttributeAsString(var1_1, var2_2));
lbl52:
                // 2 sources

                ** while (var3_3.hasMoreElements())
            }
        }
        return var5_5.toString();
    }

    public String toString() {
        return this.getRecordAsString(false);
    }
}

