/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util;

import java.io.PrintStream;
import java.util.ResourceBundle;
import javax.naming.CommunicationException;
import javax.naming.directory.DirContext;
import oracle.ldap.util.CommunicationErrorException;
import oracle.ldap.util.LDAPEntry;
import oracle.ldap.util.PropertySetCollection;
import oracle.ldap.util.Util;
import oracle.ldap.util.UtilException;

public class OracleSchema {
    private static final String OracleSchemaVersionRDN = "cn=OracleSchemaVersion";
    private static final String oracleSchemaVersionObjectClass = "orclSchemaVersion";
    private static final String oracleProductVersionAttribute = "orclProductVersion";
    private static final String adConfigurationRDN = "cn=Configuration";
    private static final String adDefaultNamingContext = "defaultNamingContext";
    private static final String listFileExt = ".lst";
    private DirContext ctx = null;
    private static ResourceBundle resBundle = LDAPEntry.resBundle;
    private String orclSchemaFilePrefix = "oidSchema";
    protected String ohome = null;
    protected PrintStream pStream = null;
    protected String orclSchemaVersion = null;
    private String fileSeparator = null;

    public OracleSchema(DirContext dirContext, String string) {
        this(dirContext, string, System.out);
    }

    public OracleSchema(DirContext dirContext, String string, PrintStream printStream) {
        this.ohome = string;
        this.ctx = dirContext;
        this.pStream = printStream;
        this.fileSeparator = System.getProperty("file.separator");
    }

    public void create() throws UtilException {
        String string = this.ohome + this.fileSeparator + "ldap" + this.fileSeparator + "schema" + this.fileSeparator + "oid" + this.fileSeparator;
        String string2 = this.ohome + this.fileSeparator + "ldap" + this.fileSeparator + "admin" + this.fileSeparator + "odi.ldif";
        Util.ldapModify(this.ctx, string2, null, true, this.pStream);
        string2 = string + this.orclSchemaFilePrefix + "CreateAux.lst";
        Util.ldapModify(this.ctx, string2, null, true, this.pStream);
        string2 = string + this.orclSchemaFilePrefix + "Create.lst";
        Util.ldapModify(this.ctx, string2, null, true, this.pStream);
        if (!this.exists()) {
            throw new UtilException("Oracle Schema creation failed");
        }
    }

    public boolean isUpToDate(DirContext dirContext) {
        try {
            String string = this.getVersionFor(dirContext, "BASE");
            String string2 = this.ohome + this.fileSeparator + "ldap" + this.fileSeparator + "schema" + this.fileSeparator + "versions.txt";
            this.pStream.println(string2);
            String string3 = Util.getParameterFromFile("SchemaVersion", string2);
            this.pStream.println("version: " + string + " up_version: " + string3);
            return string3.compareTo(string) <= 0;
        }
        catch (Exception exception) {
            return true;
        }
    }

    public String getVersionFor(DirContext dirContext, String string) throws UtilException {
        try {
            String string2 = "cn=" + string + ",cn=OracleSchemaVersion";
            PropertySetCollection propertySetCollection = Util.ldapSearch(dirContext, string2, "objectclass=*", 0, new String[]{"orclproductversion"});
            return (String)propertySetCollection.getPropertySet(0).getProperty(0).getValue(0);
        }
        catch (Exception exception) {
            if (exception instanceof CommunicationException) {
                throw new CommunicationErrorException(resBundle.getString("UNABLE_TO_CONNECT_TO_DIR"), exception);
            }
            throw new UtilException(resBundle.getString("GENERAL_ERROR_SEARCH"), exception);
        }
    }

    public String[][] getVersions() {
        return null;
    }

    public void upgrade(DirContext dirContext) throws Exception {
        while (!this.isUpToDate(dirContext)) {
            String string = this.getVersionFor(dirContext, "BASE");
            this.pStream.println("curVersion: " + string);
            this.pStream.println();
            String string2 = this.ohome + this.fileSeparator + "ldap" + this.fileSeparator + "schema" + this.fileSeparator + "oid" + this.fileSeparator + this.orclSchemaFilePrefix + "UpgradeFrom" + string + listFileExt;
            this.pStream.println("Loading: " + string2);
            Util.ldapModify(dirContext, string2, null, true, this.pStream);
        }
    }

    public boolean exists() throws UtilException {
        return Util.getObjectClass(this.ctx, "orclContext") != null;
    }
}

