/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util;

import oracle.ldap.util.Guid;

public final class OrclGuid
implements Cloneable {
    private Guid _guid = null;

    public static OrclGuid newInstance() {
        return new OrclGuid();
    }

    public OrclGuid() {
        this._guid = new Guid();
    }

    public OrclGuid(String string) {
        if (string.length() == 35) {
            this._guid = new Guid(string);
        } else if (string.length() == 32) {
            this._guid = new Guid(OrclGuid.expandGuidString(string));
        }
    }

    public OrclGuid(byte[] byArray) {
        this._guid = new Guid(byArray);
    }

    public byte[] getBytes() {
        if (this._guid != null) {
            return this._guid.getBytes();
        }
        return null;
    }

    public final String toString() {
        if (this._guid != null) {
            return OrclGuid.compactGuidString(this._guid.toString());
        }
        return null;
    }

    public boolean equals(Object object) {
        if (this.getClass() == object.getClass()) {
            return this.toString().equals(object.toString());
        }
        return false;
    }

    public int hashCode() {
        if (this._guid != null) {
            return this._guid.hashCode();
        }
        return 0;
    }

    public Object clone() {
        OrclGuid orclGuid = new OrclGuid(this.getBytes());
        return orclGuid;
    }

    public static String compactGuidString(String string) {
        if (string != null && string.length() == 35) {
            return string.substring(0, 12) + string.substring(13, 17) + string.substring(18, 22) + string.substring(23, 35);
        }
        if (string != null && string.length() == 32) {
            return string;
        }
        return "oracle.ldap.util.OrclGuid: Invalid GUID String";
    }

    public static String expandGuidString(String string) {
        if (string != null && string.length() == 32) {
            return string.substring(0, 12) + "-" + string.substring(12, 16) + "-" + string.substring(16, 20) + "-" + string.substring(20, 32);
        }
        if (string != null && string.length() == 35) {
            return string;
        }
        return "oracle.ldap.util.OrclGuid: Invalid GUID String";
    }

    public static void main(String[] stringArray) {
        int n = 1;
        if (stringArray.length >= 1) {
            n = Integer.parseInt(stringArray[0]);
        }
        int n2 = 0;
        while (n2 < n) {
            OrclGuid orclGuid = new OrclGuid();
            System.out.println(orclGuid);
            ++n2;
        }
    }
}

