/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util;

import java.util.Vector;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.SearchResult;
import oracle.ldap.util.Property;
import oracle.ldap.util.PropertySet;
import oracle.ldap.util.Util;
import oracle.ldap.util.UtilException;

public class PropertySetCollection {
    private static String commonDN = "cn=Common,cn=Products,cn=OracleContext";
    private Vector resultVector = null;
    private String searchBaseDN = null;
    private Object resultSet = null;
    private boolean converted = false;

    protected PropertySetCollection() {
        this.resultVector = new Vector();
        this.converted = true;
    }

    public PropertySetCollection(int n) {
        this.resultVector = new Vector(n);
        this.converted = true;
    }

    protected PropertySetCollection(String string, Object object) {
        this(string, object, true);
    }

    protected PropertySetCollection(String string, Object object, boolean bl) {
        this.resultVector = new Vector();
        this.searchBaseDN = string;
        this.resultSet = object;
        if (bl) {
            this.convert();
        }
    }

    public final boolean isEmpty() {
        this.convert();
        return this.resultVector.isEmpty();
    }

    public final int size() {
        this.convert();
        return this.resultVector.size();
    }

    public final String[] getDns() {
        this.convert();
        String[] stringArray = new String[this.resultVector.size()];
        int n = 0;
        while (n < this.resultVector.size()) {
            stringArray[n] = ((PropertySet)this.resultVector.elementAt(n)).getDN();
            ++n;
        }
        return stringArray;
    }

    public final PropertySet getPropertySet(int n) {
        this.convert();
        return (PropertySet)this.resultVector.elementAt(n);
    }

    public final PropertySet getPropertySet(String string) {
        this.convert();
        String string2 = Util.normalizeDN(string);
        int n = 0;
        while (n < this.resultVector.size()) {
            if (string2.equals(Util.normalizeDN(((PropertySet)this.resultVector.elementAt(n)).getDN()))) {
                return this.getPropertySet(n);
            }
            ++n;
        }
        return new PropertySet();
    }

    final void add(PropertySet propertySet) {
        this.convert();
        this.resultVector.addElement(propertySet);
    }

    final PropertySet remove(int n) {
        this.convert();
        PropertySet propertySet = (PropertySet)this.resultVector.elementAt(n);
        this.resultVector.removeElementAt(n);
        return propertySet;
    }

    final Vector toVector() {
        this.convert();
        return (Vector)this.resultVector.clone();
    }

    private void convert() {
        block7: {
            if (this.converted) break block7;
            try {
                if (this.resultSet != null) {
                    if (this.resultSet instanceof NamingEnumeration) {
                        while (((NamingEnumeration)this.resultSet).hasMore()) {
                            SearchResult searchResult = (SearchResult)((NamingEnumeration)this.resultSet).next();
                            PropertySet propertySet = new PropertySet(this.searchBaseDN, searchResult);
                            this.resultVector.addElement(propertySet);
                        }
                    } else if (this.resultSet instanceof SearchResult) {
                        PropertySet propertySet = new PropertySet(this.searchBaseDN, (SearchResult)this.resultSet);
                        this.resultVector.addElement(propertySet);
                    }
                }
                this.converted = true;
            }
            catch (NamingException namingException) {}
        }
    }

    public String[] getPropertyValues(String string) throws UtilException {
        if (this.isEmpty()) {
            throw new UtilException("The PropertySetCollection is empty");
        }
        Vector<Object> vector = new Vector<Object>();
        try {
            int n = 0;
            while (n < this.size()) {
                Property property = this.getPropertySet(n).getProperty(string);
                if (property != null && property.size() >= 1) {
                    int n2 = 0;
                    while (n2 < property.size()) {
                        vector.addElement(property.getValue(n2));
                        ++n2;
                    }
                }
                ++n;
            }
        }
        catch (Exception exception) {
            throw new UtilException("Unexpected exception from getPropertyValues" + exception.toString());
        }
        if (vector.size() > 0) {
            return Util.vector2StrArray(vector);
        }
        throw new UtilException("There's no value for " + string);
    }

    public String getUniquePropertyValue(String string) throws UtilException {
        if (this.isEmpty()) {
            throw new UtilException("The PropertySetCollection is empty");
        }
        String string2 = null;
        try {
            int n = 0;
            while (n < this.size()) {
                Property property = this.getPropertySet(n).getProperty(string);
                if (property != null && property.size() > 0) {
                    if (property.size() > 1) {
                        throw new UtilException("The property has more than 1 value");
                    }
                    if (string2 != null) {
                        throw new UtilException("The property is not unique.");
                    }
                    string2 = (String)property.getValue(0);
                }
                ++n;
            }
        }
        catch (Exception exception) {
            throw new UtilException("Unexpected exception from getUniquePropertyValue" + exception.toString());
        }
        if (string2 == null) {
            throw new UtilException("There's no value for " + string);
        }
        return string2;
    }
}

