/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util;

import java.util.ResourceBundle;
import javax.naming.directory.DirContext;
import oracle.ldap.util.CommunicationErrorException;
import oracle.ldap.util.LDAPGroup;
import oracle.ldap.util.ModPropertySet;
import oracle.ldap.util.PropertySet;
import oracle.ldap.util.PropertySetCollection;
import oracle.ldap.util.Util;
import oracle.ldap.util.UtilException;

public class ServiceRecipient
extends LDAPGroup {
    private static ResourceBundle resBundle = ResourceBundle.getBundle("oracle.ldap.util.nls.UtilityResource");
    private String hostedServiceObjectClass = "orclHostedService";

    public ServiceRecipient(DirContext dirContext, String string) throws UtilException {
        super(dirContext, string);
        this.resolve(dirContext);
    }

    public ServiceRecipient(DirContext dirContext, String string, PropertySet propertySet) throws UtilException {
        super(dirContext, string, propertySet);
        this.resolve(dirContext);
    }

    public void addUniquemember(DirContext dirContext, String string) throws UtilException {
        this.resolve(dirContext);
        try {
            this.addMemberGuidEntry(dirContext, string);
        }
        catch (UtilException utilException) {
            if (utilException instanceof CommunicationErrorException) {
                throw utilException;
            }
            throw new UtilException("Error in creating member guid entry under ServiceRecipient");
        }
        super.addUniquemember(dirContext, string);
    }

    public void addUniquemember(DirContext dirContext, String[] stringArray) throws UtilException {
        this.resolve(dirContext);
        int n = 0;
        while (n < stringArray.length) {
            this.addUniquemember(dirContext, stringArray[n]);
            ++n;
        }
    }

    public void removeUniquemember(DirContext dirContext, String string) throws UtilException {
        this.resolve(dirContext);
        try {
            this.removeMemberGuidEntry(dirContext, string);
        }
        catch (UtilException utilException) {
            if (utilException instanceof CommunicationErrorException) {
                throw utilException;
            }
            throw new UtilException("Error in removing member guid entry under ServiceRecipient");
        }
        Util.removeUniquemember(dirContext, this.entryDN, string);
    }

    public void resolve(DirContext dirContext) throws UtilException {
        if (!this.validated && Util.dnExists(dirContext, this.entryDN)) {
            this.validated = true;
        }
    }

    private void addMemberGuidEntry(DirContext dirContext, String string) throws UtilException {
        String string2 = null;
        try {
            string2 = this.verifyDnAndGetGUID(dirContext, string);
        }
        catch (UtilException utilException) {
            if (utilException instanceof CommunicationErrorException) {
                throw utilException;
            }
            throw new UtilException("DN is not a valid user");
        }
        ModPropertySet modPropertySet = new ModPropertySet(1);
        String[] stringArray = new String[]{"orclServiceSubscriptionDetail", "orclReferenceObject", "top"};
        modPropertySet.addProperty(0, "objectclass", stringArray);
        modPropertySet.addProperty(0, "orclOwnerGUID", string2);
        modPropertySet.addProperty(0, "seeAlso", string);
        String string3 = "orclOwnerGUID=" + string2 + "," + this.entryDN;
        Util.ldapAdd(dirContext, string3, modPropertySet);
    }

    private void removeMemberGuidEntry(DirContext dirContext, String string) throws UtilException {
        String string2 = null;
        try {
            string2 = this.verifyDnAndGetGUID(dirContext, string);
        }
        catch (UtilException utilException) {
            if (utilException instanceof CommunicationErrorException) {
                throw utilException;
            }
            throw new UtilException("DN is not a valid user");
        }
        String string3 = "orclOwnerGUID=" + string2 + "," + this.entryDN;
        Util.ldapDelete(dirContext, string3);
    }

    private String verifyDnAndGetGUID(DirContext dirContext, String string) throws UtilException {
        String[] stringArray = new String[]{"orclguid"};
        PropertySetCollection propertySetCollection = Util.ldapSearch(dirContext, string, "objectclass=*", 0, stringArray);
        if (propertySetCollection == null) {
            throw new UtilException("Cannot find the user");
        }
        return (String)propertySetCollection.getPropertySet(0).getProperty("orclguid").getValue(0);
    }
}

