/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util;

import java.io.PrintStream;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.naming.CommunicationException;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import oracle.ldap.das.util.UILabelsNLS;
import oracle.ldap.util.CommunicationErrorException;
import oracle.ldap.util.LDAPEntry;
import oracle.ldap.util.OrclGuid;
import oracle.ldap.util.PropertySetCollection;
import oracle.ldap.util.Subscriber;
import oracle.ldap.util.Util;
import oracle.ldap.util.UtilException;

public class SubscriberCreator {
    private static String rootOracleContextDN = "cn=OracleContext";
    private String subDN = null;
    private String parentDN = null;
    private String fQHN = null;
    private String simpleName = null;
    private String ohome = null;
    private DirContext ctx = null;
    private int nameType = 0;
    private String subSearchBase = null;
    private String subNickNameAttr = null;
    private boolean defaultSub = false;
    private boolean install = false;
    private boolean genGuid = true;
    private boolean createAux = false;
    private static ResourceBundle resBundle = LDAPEntry.resBundle;
    private PrintStream pStream = null;

    public SubscriberCreator(DirContext dirContext, String string, String string2) throws UtilException {
        this(dirContext, string, string2, System.out);
    }

    public SubscriberCreator(DirContext dirContext, String string, String string2, PrintStream printStream) throws UtilException {
        this.pStream = printStream;
        if (dirContext == null) {
            throw new UtilException("Null DirContext");
        }
        this.ctx = dirContext;
        if (string == null) {
            throw new UtilException("Null Oracle Home String");
        }
        this.ohome = string;
        if (string2 == null) {
            throw new UtilException(resBundle.getString("PARAMETER_INVALID"));
        }
        this.subDN = Util.normalizeDN(string2);
    }

    protected SubscriberCreator(DirContext dirContext, String string, String string2, String string3, String string4, PrintStream printStream) throws UtilException {
        this(dirContext, string, string2, printStream);
        this.simpleName = string2;
        this.subSearchBase = string3;
        this.subNickNameAttr = string4;
    }

    public void createInstall() throws UtilException {
        this.install = true;
        this.genGuid = true;
        Util.createDN(this.ctx, this.subDN);
        this.createDefault(true);
    }

    public void createDefault(boolean bl) throws UtilException {
        this.defaultSub = true;
        this.create(bl);
    }

    public Subscriber create(boolean bl) throws UtilException {
        this.createAux = bl;
        if (this.simpleName == null) {
            try {
                PropertySetCollection propertySetCollection = Util.getEntryDetails(this.ctx, this.subDN, "(objectclass=*)", 0, new String[0]);
            }
            catch (NamingException namingException) {
                if (namingException instanceof CommunicationException) {
                    throw new CommunicationErrorException(resBundle.getString("UNABLE_TO_CONNECT_TO_DIR"), namingException);
                }
                throw new UtilException(resBundle.getString("CANNOT_FIND_SUBSCRIBER"));
            }
            this.createSubscriber();
        } else {
            this.subDN = this.getSimpleNameDN();
            this.createSubscriber();
        }
        return new Subscriber(this.ctx, Util.IDTYPE_DN, this.subDN, false);
    }

    private void createSubscriber() throws UtilException {
        StringTokenizer stringTokenizer = new StringTokenizer(this.subDN, "=", false);
        String string = null;
        String string2 = null;
        String string3 = null;
        if (stringTokenizer.countTokens() > 2) {
            string = stringTokenizer.nextToken();
            string2 = stringTokenizer.nextToken(",").substring(1);
            string3 = stringTokenizer.nextToken("?").substring(1);
        } else {
            string = stringTokenizer.nextToken();
            string2 = stringTokenizer.nextToken();
            string3 = "";
        }
        String string4 = null;
        String string5 = null;
        try {
            string5 = (String)this.ctx.getEnvironment().get("java.naming.security.principal");
        }
        catch (NamingException namingException) {
            if (namingException instanceof CommunicationException) {
                throw new CommunicationErrorException(resBundle.getString("UNABLE_TO_CONNECT_TO_DIR"), namingException);
            }
            throw new UtilException("Cannot obtain current user info from DirContext");
        }
        if (string.equals("o")) {
            string4 = new String("organization");
        } else if (string.equals("dc")) {
            string4 = new String("domain");
        } else if (string.equals("l")) {
            string4 = new String("locality");
        } else if (string.equals("c")) {
            string4 = new String("country");
        }
        Vector<String> vector = new Vector<String>(20);
        vector.insertElementAt("s_SubscriberObjectclass", 0);
        vector.insertElementAt(string4, 1);
        vector.insertElementAt("s_SubscriberNamingAttribute", 2);
        vector.insertElementAt(string, 3);
        vector.insertElementAt("s_SubscriberName", 4);
        vector.insertElementAt(string2, 5);
        vector.insertElementAt("s_SubscriberParentDN", 6);
        vector.insertElementAt(string3, 7);
        vector.insertElementAt("s_SubscriberDN", 8);
        vector.insertElementAt(this.subDN, 9);
        vector.insertElementAt("s_RootOracleContextDN", 10);
        vector.insertElementAt(rootOracleContextDN, 11);
        vector.insertElementAt("s_OracleContextDN", 12);
        vector.insertElementAt("cn=OracleContext," + this.subDN, 13);
        vector.insertElementAt("s_OracleContextParentDN", 14);
        vector.insertElementAt(this.subDN, 15);
        vector.insertElementAt("s_CurrentUserDN", 16);
        vector.insertElementAt(string5, 17);
        vector.insertElementAt("s_GroupSearchBase", 18);
        vector.insertElementAt("cn=groups," + this.subDN, 19);
        String string6 = this.ohome + System.getProperty("file.separator") + "ldap" + System.getProperty("file.separator") + "schema" + System.getProperty("file.separator") + "oid" + System.getProperty("file.separator");
        try {
            Util.ldapModify(this.ctx, string6 + "oidSubscriberCreateCommon.lst", vector, true, this.pStream);
            if (this.createAux) {
                Util.ldapModify(this.ctx, string6 + "oidSubscriberCreateAuxDIT.lst", vector, true, this.pStream);
            }
            if (this.defaultSub) {
                Util.ldapModify(this.ctx, string6 + "oidDefaultSubscriberConfig.sbs", vector, true, this.pStream);
            }
        }
        catch (Exception exception) {
            throw new UtilException("Error in Subscriber creation");
        }
        UILabelsNLS.populateNLSLabels((DirContext)this.ctx, (String)this.subDN);
        if (this.genGuid) {
            int n = 7;
            int n2 = 6;
            Vector<String> vector2 = new Vector<String>(n2 + n * 2);
            vector2.insertElementAt("s_SubscriberDN", 0);
            vector2.insertElementAt(this.subDN, 1);
            vector2.insertElementAt("s_SubscriberName", 2);
            vector2.insertElementAt(string2, 3);
            vector2.insertElementAt("s_OracleContextDN", 4);
            vector2.insertElementAt("cn=OracleContext", 5);
            OrclGuid orclGuid = null;
            int n3 = 0;
            while (n3 < n) {
                orclGuid = OrclGuid.newInstance();
                String string7 = "s_GUID" + (n3 + 1);
                vector2.insertElementAt(string7, n2 + n3);
                vector2.insertElementAt(orclGuid.toString(), ++n2 + n3);
                ++n3;
            }
            Util.ldapModify(this.ctx, string6 + "oidSubscriberCreateJAZN.sbs", vector2, true, this.pStream);
        } else {
            Vector<String> vector3 = new Vector<String>(6);
            vector3.insertElementAt("subscriberDN", 0);
            vector3.insertElementAt(this.subDN, 1);
            vector3.insertElementAt("subscriberNickname", 2);
            vector3.insertElementAt(string2, 3);
            vector3.insertElementAt("s_OracleContextDN", 4);
            vector3.insertElementAt("cn=OracleContext", 5);
            Util.ldapModify(this.ctx, this.ohome + System.getProperty("file.separator") + "j2ee" + System.getProperty("file.separator") + "home" + System.getProperty("file.separator") + "jazn" + System.getProperty("file.separator") + "install" + System.getProperty("file.separator") + "oidSubCreateJAZN.sbs", vector3, true, this.pStream);
        }
    }

    private void rCreateDN(String string) throws UtilException {
        if (string == null) {
            throw new UtilException("inDN is null in rCreateDN");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        if (Util.dnExists(this.ctx, string)) {
            return;
        }
        if (stringTokenizer.countTokens() < 2) {
            this.createDNEntries(string);
        } else {
            this.rCreateDN(Util.getParentDN(string));
            this.createDNEntries(string);
        }
    }

    private void createDNEntries(String string) throws UtilException {
        String string2 = Util.getRDN(string);
        String string3 = Util.getAttrOfRDN(string);
        String string4 = Util.getAttrValueOfRDN(string);
        BasicAttributes basicAttributes = new BasicAttributes(true);
        BasicAttribute basicAttribute = new BasicAttribute("objectclass");
        basicAttribute.add("top");
        if (string3.equalsIgnoreCase("dc")) {
            basicAttribute.add("domain");
        } else if (string3.equalsIgnoreCase("c")) {
            basicAttribute.add("country");
        } else if (string3.equalsIgnoreCase("o")) {
            basicAttribute.add("organization");
        } else if (string3.equalsIgnoreCase("l")) {
            basicAttribute.add("locality");
        } else {
            throw new UtilException("RDN not valid for subscriber creation");
        }
        basicAttributes.put(basicAttribute);
        BasicAttribute basicAttribute2 = new BasicAttribute(string3);
        basicAttribute2.add(string4);
        basicAttributes.put(basicAttribute2);
        try {
            this.ctx.createSubcontext(string, (Attributes)basicAttributes);
        }
        catch (NamingException namingException) {
            if (namingException instanceof CommunicationException) {
                throw new CommunicationErrorException(resBundle.getString("UNABLE_TO_CONNECT_TO_DIR"), namingException);
            }
            throw new UtilException("Cannot create DN during subscriber creation:  " + string, namingException);
        }
    }

    private String getSimpleNameDN() throws UtilException {
        try {
            String[] stringArray = new String[]{"orclsubscribernicknameattribute", "orclsubscribersearchbase"};
            PropertySetCollection propertySetCollection = Util.getEntryDetails(this.ctx, "cn=common,cn=products,cn=oraclecontext", "(objectclass=*)", 0, stringArray);
            String string = (String)propertySetCollection.getPropertySet(0).getProperty("orclsubscribernicknameattribute").getValue(0);
            String string2 = null;
            string2 = propertySetCollection.getPropertySet(0).getProperty("orclsubscribersearchbase") == null ? "" : "," + (String)propertySetCollection.getPropertySet(0).getProperty("orclsubscribersearchbase").getValue(0);
            String string3 = string + "=" + this.simpleName + string2;
            BasicAttributes basicAttributes = new BasicAttributes(true);
            BasicAttribute basicAttribute = new BasicAttribute("objectclass");
            basicAttribute.add("top");
            if (string.equalsIgnoreCase("dc")) {
                basicAttribute.add("domain");
            } else if (string.equalsIgnoreCase("c")) {
                basicAttribute.add("country");
            } else if (string.equalsIgnoreCase("o")) {
                basicAttribute.add("organization");
            } else if (string.equalsIgnoreCase("l")) {
                basicAttribute.add("locality");
            } else {
                throw new UtilException("RDN not valid for subscriber creation");
            }
            basicAttributes.put(basicAttribute);
            BasicAttribute basicAttribute2 = new BasicAttribute(string);
            basicAttribute2.add(this.simpleName);
            basicAttributes.put(basicAttribute2);
            this.ctx.createSubcontext(string3, (Attributes)basicAttributes);
            return string3;
        }
        catch (NamingException namingException) {
            if (namingException instanceof CommunicationException) {
                throw new CommunicationErrorException(resBundle.getString("UNABLE_TO_CONNECT_TO_DIR"), namingException);
            }
            throw new UtilException(resBundle.getString("INVALID_ROOT_CTX"), namingException);
        }
    }
}

