/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util.jndi;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Hashtable;
import javax.net.SocketFactory;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocket;
import oracle.security.ssl.OracleSSLCredential;
import oracle.security.ssl.OracleSSLSocketFactoryImpl;

public final class LDAPSSLSocketFactoryImpl
extends SocketFactory {
    public static final String WALLET_LOCATION = "oracle.ldap.wltloc";
    public static final String WALLET_PASSWORD = "oracle.ldap.wltpassword";
    private static OracleSSLSocketFactoryImpl ossl = null;

    public LDAPSSLSocketFactoryImpl() throws SSLException {
        this(System.getProperties());
    }

    public LDAPSSLSocketFactoryImpl(Hashtable hashtable) throws SSLException {
        ossl = new OracleSSLSocketFactoryImpl();
        OracleSSLCredential oracleSSLCredential = new OracleSSLCredential();
        Object v = hashtable.get(WALLET_LOCATION);
        Object v2 = hashtable.get(WALLET_PASSWORD);
        if (v != null && v instanceof String && v2 != null && v2 instanceof String) {
            try {
                this.ckWltLoc((String)v);
                oracleSSLCredential.setWallet((String)v, (String)v2);
            }
            catch (IOException iOException) {
                throw new SSLException("IOException encountered while opening Oracle Wallet.  Root exception: " + iOException.getMessage());
            }
        }
        ossl.setSSLCredentials(oracleSSLCredential);
        ossl.setSSLProtocolVersion(768);
    }

    public static SocketFactory getDefault() {
        try {
            return new LDAPSSLSocketFactoryImpl();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Socket createSocket(Socket socket) throws IOException {
        SSLSocket sSLSocket = (SSLSocket)ossl.createSocket(socket);
        return this.init(sSLSocket);
    }

    public Socket createSocket(String string, int n) throws IOException {
        SSLSocket sSLSocket = (SSLSocket)ossl.createSocket(string, n);
        return this.init(sSLSocket);
    }

    public Socket createSocket(InetAddress inetAddress, int n) throws IOException {
        SSLSocket sSLSocket = (SSLSocket)ossl.createSocket(inetAddress, n);
        return this.init(sSLSocket);
    }

    public Socket createSocket(String string, int n, InetAddress inetAddress, int n2) throws IOException {
        SSLSocket sSLSocket = (SSLSocket)ossl.createSocket(string, n, inetAddress, n2);
        return this.init(sSLSocket);
    }

    public Socket createSocket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) throws IOException {
        SSLSocket sSLSocket = (SSLSocket)ossl.createSocket(inetAddress, n, inetAddress2, n2);
        return this.init(sSLSocket);
    }

    private SSLSocket init(SSLSocket sSLSocket) throws IOException {
        sSLSocket.setUseClientMode(true);
        sSLSocket.setEnabledCipherSuites(ossl.getSupportedCipherSuites());
        sSLSocket.startHandshake();
        return sSLSocket;
    }

    private void ckWltLoc(String string) throws IOException {
        File file = new File(string);
        if (!file.exists()) {
            throw new IOException("The wallet \"" + string + "\" does not exist.");
        }
        if (!file.canRead()) {
            throw new IOException("The wallet \"" + string + "\" cannot be read.");
        }
        if (!file.isFile()) {
            throw new IOException("The wallet \"" + string + "\" is not a 'normal' file.");
        }
    }
}

