/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.verification;

import oracle.cluster.verification.AvailableSpaceInfo;
import oracle.cluster.verification.StorageSize;
import oracle.cluster.verification.StorageUnit;

public class AvailableSpaceInfoImpl
implements AvailableSpaceInfo {
    private String m_node;
    private String m_location;
    private long m_size;
    private StorageUnit m_unit;

    public AvailableSpaceInfoImpl(String node, String location, long size, StorageUnit unit) {
        this.m_node = node;
        this.m_location = location;
        this.m_size = size;
        this.m_unit = unit;
    }

    @Override
    public double getAvailableSpace(StorageUnit unit) {
        if (this.m_unit == unit) {
            return this.m_size;
        }
        return new StorageSize(this.m_size, this.m_unit).sizeIn(unit);
    }

    @Override
    public String getResolvedLocation() {
        return this.m_location;
    }

    @Override
    public String getNode() {
        return this.m_node;
    }
}

