/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.verification;

import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.util.VerificationUtil;

public class FixupException
extends Exception {
    private static MessageBundle s_gMsgBundle = VerificationUtil.getMessageBundle("Prvg");
    static final String LSEP = System.getProperty("line.separator");
    private Throwable m_cause;

    public FixupException(String msg) {
        super(msg);
    }

    public FixupException(String msg, Throwable cause) {
        super(msg, cause);
        this.m_cause = cause;
        Trace.stackTrace((Throwable)cause);
    }

    public FixupException(Throwable cause) {
        super(s_gMsgBundle.getMessage("7090", true));
        this.m_cause = cause;
        Trace.stackTrace((Throwable)cause);
    }

    @Override
    public String getMessage() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.getMessage());
        if (this.m_cause != null) {
            Throwable nextCause;
            sb.append(LSEP + this.m_cause.getMessage());
            Throwable thrw = this.m_cause;
            while ((nextCause = thrw.getCause()) != null) {
                sb.append(LSEP + nextCause.getMessage());
                thrw = nextCause;
            }
        }
        return sb.toString();
    }
}

