/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.verification.command;

import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.VerificationCommand;

public class MulticastCommand
extends VerificationCommand {
    private CmdMode m_cmdMode;

    MulticastCommand(String node, String[] args, CmdMode cmdMode) {
        super(node, args, null);
        this.m_cmdMode = cmdMode;
    }

    public static MulticastCommand getListnerMulticastCommand(String node, String ip, String mcGroup, int port) {
        String[] args = null;
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        args = nativeSystem.isUnixSystem() ? new String[]{"-multicast", "-listen", ip, mcGroup, String.valueOf(port)} : new String[]{"-multicast", "-listen", ip, mcGroup, String.valueOf(port), "-debug"};
        return new MulticastCommand(node, args, CmdMode.LISTEN);
    }

    public static MulticastCommand getListnerBroadcastCommand(String node, String ip, String bcAddr, int port) {
        String[] args = new String[]{"-broadcast", "-listen", ip, bcAddr, String.valueOf(port)};
        return new MulticastCommand(node, args, CmdMode.LISTEN);
    }

    public static MulticastCommand getGroupIpMulticastCommand(String node, String ip, String mcGroup, int port) {
        String[] args = new String[]{"-multicast", "-groupIps", ip, mcGroup, String.valueOf(port)};
        return new MulticastCommand(node, args, CmdMode.GROUP_IPS);
    }

    public static MulticastCommand getGroupIpBroadcastCommand(String node, String ip, String bcAddr, int port) {
        String[] args = new String[]{"-broadcast", "-groupIps", ip, bcAddr, String.valueOf(port)};
        return new MulticastCommand(node, args, CmdMode.GROUP_IPS);
    }

    public static MulticastCommand getKillMsgMulticastCommand(String node, String ip, String mcGroup, int port) {
        String[] args = new String[]{"-multicast", "-killMsg", mcGroup, String.valueOf(port)};
        return new MulticastCommand(node, args, CmdMode.KILL_MSG);
    }

    public static MulticastCommand getKillMulticastCommand(String node, int pid) {
        String[] args = new String[]{"-killproc", String.valueOf(pid)};
        return new MulticastCommand(node, args, CmdMode.KILL_MSG);
    }

    public String[] getGroupIps() {
        if (this.m_cmdMode == CmdMode.GROUP_IPS) {
            return this.getOutput().trim().split(",");
        }
        Trace.out((String)("WRONG mode. it should be called on getGroupIpMulticastCommand() object. m_cmdMode=" + (Object)((Object)this.m_cmdMode)));
        return new String[0];
    }

    public int getPid() {
        if (this.m_cmdMode == CmdMode.LISTEN && this.getStatus()) {
            return Integer.parseInt(this.getOutput().trim());
        }
        return -1;
    }

    private static enum CmdMode {
        LISTEN,
        GROUP_IPS,
        KILL_MSG;

    }
}

