/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.verification.constraints;

import java.util.HashMap;
import java.util.Vector;
import oracle.cluster.verification.constraints.CDMConstraintTypes;
import oracle.ops.mgmt.trace.Trace;

public class CDMShellLimitChecks {
    private Vector<HashMap<String, String>> m_fdSoftLimits = new Vector();
    private Vector<HashMap<String, String>> m_mpSoftLimits = new Vector();
    private Vector<HashMap<String, String>> m_fdHardLimits = new Vector();
    private Vector<HashMap<String, String>> m_mpHardLimits = new Vector();

    public void addFileDescriptorLimit(String shellVar, String shellSel, String limitType, String limit, String severity) {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("shellVar = " + shellVar + ", shellSel = " + shellSel + ", limitType = " + limitType + ", limit = " + limit));
        }
        HashMap<String, String> p = new HashMap<String, String>();
        p.put(CDMConstraintTypes.VAR, shellVar);
        p.put(CDMConstraintTypes.SELECTION, shellSel);
        p.put(CDMConstraintTypes.LIMIT_TYPE, limitType);
        p.put(CDMConstraintTypes.LIMIT, limit);
        p.put(CDMConstraintTypes.SEVERITY, severity);
        if (limitType.equalsIgnoreCase("SOFT")) {
            this.m_fdSoftLimits.add(p);
        } else {
            this.m_fdHardLimits.add(p);
        }
    }

    public void addMaxProcessLimits(String shellVar, String shellSel, String limitType, String limit, String severity) {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)"shellVar=%s, shellSel=%s, limitType=%s, limit=%s ", (Object[])new Object[]{shellVar, shellSel, limitType, limit});
        }
        HashMap<String, String> p = new HashMap<String, String>();
        p.put(CDMConstraintTypes.VAR, shellVar);
        p.put(CDMConstraintTypes.SELECTION, shellSel);
        p.put(CDMConstraintTypes.LIMIT_TYPE, limitType);
        p.put(CDMConstraintTypes.LIMIT, limit);
        p.put(CDMConstraintTypes.SEVERITY, severity);
        if (limitType.equalsIgnoreCase("SOFT")) {
            this.m_mpSoftLimits.add(p);
        } else {
            this.m_mpHardLimits.add(p);
        }
    }

    public Vector<HashMap<String, String>> getSoftFileDescriptorLimits() {
        return this.m_fdSoftLimits;
    }

    public Vector<HashMap<String, String>> getHardFileDescriptorLimits() {
        return this.m_fdHardLimits;
    }

    public Vector<HashMap<String, String>> getSoftMaxProcessLimits() {
        return this.m_mpSoftLimits;
    }

    public Vector<HashMap<String, String>> getHardMaxProcessLimits() {
        return this.m_mpHardLimits;
    }
}

