/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.verification.fixup;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import oracle.cluster.impl.verification.FixupResultImpl;
import oracle.cluster.impl.verification.FixupResultSetImpl;
import oracle.cluster.verification.FixupException;
import oracle.cluster.verification.FixupOverallStatus;
import oracle.cluster.verification.FixupResult;
import oracle.cluster.verification.FixupStatus;
import oracle.cluster.verification.InvalidFixupNodeException;
import oracle.cluster.verification.InvalidPathException;
import oracle.cluster.verification.NodeResultsUnavailableException;
import oracle.cluster.verification.VerificationError;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.VerificationTask;
import oracle.cluster.verification.fixup.FixupData;
import oracle.cluster.verification.fixup.FixupTaskListContainer;
import oracle.cluster.verification.fixup.FixupUtility;
import oracle.cluster.verification.fixup.FixupXMLException;
import oracle.cluster.verification.fixup.RootAutomationException;
import oracle.cluster.verification.fixup.controller.FixupController;
import oracle.cluster.verification.fixup.datagenerator.FixupDataFile;
import oracle.cluster.verification.fixup.datagenerator.FixupDataGenerator;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.Constants;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.CVUAutoUpdateManager;
import oracle.ops.verification.framework.util.RemoteExecFileList;
import oracle.ops.verification.framework.util.RootAutomationUtility;
import oracle.ops.verification.framework.util.VerificationLogData;
import oracle.ops.verification.framework.util.VerificationUtil;

public class CVUFixup {
    private static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");
    private static MessageBundle s_gMsgBundle = VerificationUtil.getMessageBundle("Prvg");
    private static boolean m_isSetUpRequired;
    private static boolean m_isExecuteCalled;
    private static CVUFixup m_fixupDriverObj;
    private static FixupController m_fixupController;
    private FixupDataFile m_fixupDataFile = null;
    private HashMap<String, List<Task>> m_fixupNodeTableWithParticipatingTasks = null;
    private List<Task> m_fixableTaskList = null;
    private List<Task> m_fixupGenerationFailedTaskList = null;

    private CVUFixup(List<VerificationTask> fixupTaskList) {
        m_isSetUpRequired = true;
        this.segregateTaskAndNodes(fixupTaskList);
    }

    public static synchronized CVUFixup getInstance(List<VerificationTask> fixupTaskList) {
        if (m_fixupDriverObj == null) {
            m_fixupDriverObj = new CVUFixup(fixupTaskList);
            m_fixupController = FixupController.getInstance(m_fixupDriverObj);
        }
        return m_fixupDriverObj;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void fixAutomatically() throws RootAutomationException, FixupException {
        Trace.out((String)("fixAutomatically called when m_isExecuteCalled = " + m_isExecuteCalled));
        if (this.m_fixableTaskList == null || this.m_fixableTaskList.size() <= 0) return;
        if (!m_isExecuteCalled) {
            m_isExecuteCalled = true;
            if (!RootAutomationUtility.isRootExecutionConfigured()) throw new RootAutomationException(s_gMsgBundle.getMessage("9018", false));
            m_fixupController.performFixup();
        } else {
            Trace.out((String)"Only wrapping up as this is a second/repeating call");
            VerificationLogData.logInfo("Only wrapping up as this is a second/repeating call");
        }
        this.wrapUpFixup();
    }

    private void wrapUpFixup() throws FixupException {
        m_fixupController.copyAndProcessFixupOutFiles(this.getFixableNodes());
        this.m_fixupDataFile.saveToFile();
        this.updateTaskFixupResultSet();
    }

    public void fixManually() throws FixupException {
        if (this.m_fixableTaskList != null && this.m_fixableTaskList.size() > 0) {
            this.wrapUpFixup();
        }
    }

    private void segregateTaskAndNodes(List<VerificationTask> listOfFailureTasks) {
        this.m_fixupNodeTableWithParticipatingTasks = new HashMap();
        this.m_fixableTaskList = new ArrayList<Task>();
        this.m_fixupGenerationFailedTaskList = new ArrayList<Task>();
        ArrayList<Task> fixupTaskList = new ArrayList<Task>();
        for (VerificationTask vTask : listOfFailureTasks) {
            fixupTaskList.add((Task)vTask);
        }
        for (Task task : fixupTaskList) {
            FixupResultSetImpl taskResSet;
            Trace.out((String)("Current Task is " + task.getDefaultTaskID()));
            if (!task.isFixable()) {
                Trace.out((String)("Skipping - Task " + task.getDefaultTaskID() + " is not fixable"));
                if (task.getResultSet().getFailureNodes().length <= 0) continue;
                FixupResultSetImpl taskResSet2 = new FixupResultSetImpl(task.getResultSet().getFailureNodes());
                taskResSet2.updateOverAllStatus(FixupOverallStatus.NOT_FIXABLE);
                task.updateFixupResultSet(taskResSet2);
                continue;
            }
            FixupData fixDataForTask = task.getFixupData();
            List<String> participatingFixupNodesForTask = fixDataForTask.getParticipatingNodes();
            if (fixDataForTask.isFixupGenerationFailed()) {
                Trace.out((String)("For Fix-up Task " + task.getDefaultTaskID() + " fix-up could node be generated on nodes " + VerificationUtil.strList2List(fixDataForTask.getFixupGenerationFailedNodes())));
                VerificationLogData.logInfo("For Fix-up Task " + task.getDefaultTaskID() + " fix-up could node be generated on nodes " + VerificationUtil.strList2List(fixDataForTask.getFixupGenerationFailedNodes()));
                if (task.getFixupResultSet() == null) {
                    taskResSet = new FixupResultSetImpl(participatingFixupNodesForTask);
                    taskResSet.updateOverAllStatus(FixupOverallStatus.FAILED);
                    task.updateFixupResultSet(taskResSet);
                }
                for (String node : fixDataForTask.getFixupGenerationFailedNodes()) {
                    FixupResultImpl fixupResult = new FixupResultImpl(node);
                    fixupResult.setStatus(FixupStatus.ERROR);
                    for (ErrorDescription error : fixDataForTask.getFixupGenerationFailedErrors(node)) {
                        fixupResult.addErrorDescription(error);
                    }
                    try {
                        ((FixupResultSetImpl)task.getFixupResultSet()).addNodeResult(node, fixupResult);
                    }
                    catch (InvalidFixupNodeException ifne) {
                        Trace.out((String)"Caught InvalidFixupNodeException - ignoring");
                    }
                    if (!participatingFixupNodesForTask.contains(node)) continue;
                    participatingFixupNodesForTask.remove(node);
                }
                this.m_fixupGenerationFailedTaskList.add(task);
                if (fixDataForTask.isFixupGenerationFailedOnAllNodes()) {
                    task.setFixupProcessed();
                    continue;
                }
            }
            Trace.out((String)("Adding - Task " + task.getDefaultTaskID() + " to fixable task list to process"));
            if (task.getFixupResultSet() == null) {
                taskResSet = new FixupResultSetImpl(participatingFixupNodesForTask);
                taskResSet.updateOverAllStatus(FixupOverallStatus.UNKNOWN);
                task.updateFixupResultSet(taskResSet);
            }
            this.m_fixableTaskList.add(task);
            for (String node : fixDataForTask.getFixableNodes()) {
                Trace.out((String)("Task " + task.getDefaultTaskID() + " is fixable on node " + node));
                if (this.m_fixupNodeTableWithParticipatingTasks.containsKey(node)) {
                    ArrayList<Task> nodeTaskList = new ArrayList<Task>();
                    nodeTaskList.addAll((Collection)this.m_fixupNodeTableWithParticipatingTasks.get(node));
                    nodeTaskList.add(task);
                    this.m_fixupNodeTableWithParticipatingTasks.remove(node);
                    this.m_fixupNodeTableWithParticipatingTasks.put(node, nodeTaskList);
                    continue;
                }
                this.m_fixupNodeTableWithParticipatingTasks.put(node, Arrays.asList(task));
            }
        }
    }

    public void setUp() throws FixupException {
        if (m_isSetUpRequired) {
            Trace.out((int)5, (String)"Fixup basic setup is required and hence performing the setup");
            m_isSetUpRequired = false;
            this.cleanUpFixupDir();
            try {
                RemoteExecFileList.createDirectory(FixupUtility.getFixupDataFileLocation());
            }
            catch (ClusterException ce) {
                throw new FixupException(ce);
            }
            catch (VerificationException ve) {
                throw new FixupException(ve);
            }
            Trace.out((int)5, (String)"Generating the Fixup data file");
            this.generateFixupDataFile();
            Trace.out((int)5, (String)"Generating the Fixup instructions file");
            this.generateFixupInstructionsFile();
            Trace.out((String)"Copying tools and dependencies");
            ResultSet remoteCopyResultSet = new ResultSet();
            try {
                this.performCopyOfFixupDeps(remoteCopyResultSet);
            }
            catch (InvalidPathException ipe) {
                throw new FixupException(ipe);
            }
            if (remoteCopyResultSet.anyFailure()) {
                if (!remoteCopyResultSet.anySuccess()) {
                    throw new FixupException(s_gMsgBundle.getMessage("9019", true, (Object[])new String[]{VerificationUtil.getCVUSubDirPath()}));
                }
                Trace.out((String)"Failed to copy the tools and dependencies on some of the participating node");
                List<String> failedCopyNodes = remoteCopyResultSet.getFailedNodes();
                for (String node : failedCopyNodes) {
                    Trace.out((String)("Updating the result for node " + node));
                    List<Task> taskListForNode = this.m_fixupNodeTableWithParticipatingTasks.get(node);
                    for (Task t : taskListForNode) {
                        try {
                            ((FixupResultSetImpl)t.getFixupResultSet()).addResult(node, remoteCopyResultSet.getResult(node));
                        }
                        catch (InvalidFixupNodeException ifne) {
                            Trace.out((String)("Caught InvalidFixupNodeException skipping node " + node));
                        }
                    }
                    Trace.out((String)("Dropping node " + node + " from fixup operations as the copy of tools and dependencies failed on this node"));
                    this.m_fixupNodeTableWithParticipatingTasks.remove(node);
                }
            }
            if (this.m_fixupNodeTableWithParticipatingTasks.size() == 0) {
                throw new FixupException(s_msgBundle.getMessage("7650", false, (Object[])new String[]{VerificationUtil.getCVUSubDirPath(), VerificationUtil.strCollection2String(this.m_fixupNodeTableWithParticipatingTasks.keySet())}));
            }
        }
    }

    private void generateFixupDataFile() throws FixupException, FixupXMLException {
        FixupDataGenerator.getInstance(m_fixupDriverObj).generate();
        this.m_fixupDataFile = FixupDataFile.getInstance();
    }

    private void cleanUpFixupDir() {
        String fixupDirPath = FixupUtility.getFixupDataFileLocation();
        for (String node : this.getFixableNodes()) {
            Trace.out((String)("Removing the existing fixup directory from node " + node));
            VerificationLogData.logInfo("Removing the existing fixup directory from node  " + node);
            try {
                RemoteExecFileList.removeDirectoryOnNode(node, fixupDirPath, false);
            }
            catch (ClusterException ce) {
                Trace.out((String)("Ignoring Caught ClusterException while deleting the fixup directory at path " + fixupDirPath + " at node " + node + " Error is " + ce.getMessage()));
            }
            catch (VerificationException ve) {
                Trace.out((String)("Ignoring Caught VerificationException while deleting the fixup directory at path " + fixupDirPath + " at node " + node + " Error is " + ve.getMessage()));
            }
        }
    }

    private void generateFixupInstructionsFile() throws FixupException {
        StringBuffer textBuffer = new StringBuffer();
        String completeFilePath = FixupUtility.getFixupInstructionsFilePath();
        File fixupInstructionFile = new File(completeFilePath);
        textBuffer.append("FIXUP_DATA_FILE=" + FixupUtility.getFixupDataFileCompletePath() + Constants.LINE_SEPARATOR);
        textBuffer.append("FIXUP_TRACE_LEVEL=" + Trace.getCurrentTraceLevel() + Constants.LINE_SEPARATOR);
        try {
            FileOutputStream stream = new FileOutputStream(fixupInstructionFile);
            stream.write(textBuffer.toString().getBytes());
        }
        catch (FileNotFoundException fne) {
            throw new FixupException(fne.getMessage());
        }
        catch (IOException ioe) {
            throw new FixupException(ioe.getMessage());
        }
    }

    public List<String> getFixableNodes() {
        return new ArrayList<String>(this.m_fixupNodeTableWithParticipatingTasks.keySet());
    }

    public List<Task> getFixableTaskList() {
        return this.m_fixableTaskList;
    }

    public List<Task> getFixupGenerationFailedTaskList() {
        return this.m_fixupGenerationFailedTaskList;
    }

    public void updateFixupTaskList(List<VerificationTask> listOfFailureTasks) {
        this.segregateTaskAndNodes(listOfFailureTasks);
    }

    public static void destroy() {
        FixupController.destroy();
        m_fixupController = null;
        FixupDataGenerator.destroy();
        FixupTaskListContainer.clear();
        m_isSetUpRequired = true;
        m_isExecuteCalled = false;
        m_fixupDriverObj = null;
    }

    private void updateTaskFixupResultSet() {
        Trace.out((String)("The number of tasks to update result is " + this.m_fixableTaskList.size()));
        for (int index = 0; index < this.m_fixableTaskList.size(); ++index) {
            Task curTask = this.m_fixableTaskList.get(index);
            if (curTask.isFixupProcessed()) {
                Trace.out((String)("Already updated the task " + curTask.getDefaultTaskID() + " at index (" + index + ") with fixup results"));
                VerificationLogData.log("Already updated the task " + curTask.getDefaultTaskID() + " at index (" + index + ") with fixup results");
                continue;
            }
            Trace.out((String)("Updating the task " + curTask.getDefaultTaskID() + " with fixup results"));
            VerificationLogData.log("Updating the task " + curTask.getDefaultTaskID() + " with fixup results");
            List<Integer> commonTaskIndexList = FixupUtility.getCommonTaskIndex(this.m_fixableTaskList, curTask.getDefaultTaskID());
            int taskIndex = 0;
            for (Integer taskNumber : commonTaskIndexList) {
                Trace.out((String)("Updating the task " + curTask.getDefaultTaskID() + " instance(" + taskNumber + ") with fixup results"));
                VerificationLogData.log("Updating the task " + curTask.getDefaultTaskID() + " instance(" + taskNumber + ") with fixup results");
                this.m_fixableTaskList.get(taskNumber).updateFixupResultSet(this.getResultSetForFixupTask(curTask.getDefaultTaskID(), taskIndex));
                ((FixupResultSetImpl)this.m_fixableTaskList.get(taskNumber).getFixupResultSet()).traceFixupResultSet("AFTER UPLOADING TO TASK");
                this.m_fixableTaskList.get(taskNumber).setFixupProcessed();
                ++taskIndex;
            }
        }
        Trace.out((String)"Updating FixupTaskListContainer to remove successfully fixed fixup tasks");
        VerificationLogData.logInfo("Updating FixupTaskListContainer to remove successfully fixed fixup tasks");
        for (Task task : this.m_fixableTaskList) {
            if (task.getFixupResultSet().getFixupOverallStatus() != FixupOverallStatus.SUCCESSFUL) continue;
            FixupTaskListContainer.removeTask(task);
        }
    }

    private FixupResultSetImpl getResultSetForFixupTask(String taskID, int taskIndex) {
        List<String> participatingNodes = this.getFixableNodes();
        FixupResultSetImpl resultSet = new FixupResultSetImpl(participatingNodes);
        for (String node : participatingNodes) {
            FixupResultImpl taskResult = (FixupResultImpl)this.m_fixupDataFile.getTaskResultForNode(node, taskID, taskIndex);
            try {
                Trace.out((String)("Adding Fixup result for Task " + taskID + " on node " + node));
                VerificationLogData.log("Setting Fixup result for Task " + taskID + " on node " + node);
                VerificationLogData.logInfo(taskResult.traceFixupResultInfo());
                resultSet.addNodeResult(node, taskResult);
            }
            catch (InvalidFixupNodeException e) {
                Trace.out((String)"Caught InvalidFixupNodeException, ignoring");
            }
        }
        if (resultSet.getFailedNodes().size() > 0) {
            resultSet.updateOverAllStatus(FixupOverallStatus.FAILED);
        }
        return resultSet;
    }

    private void performCopyOfFixupDeps(ResultSet remoteCopyResultSet) throws InvalidPathException {
        RemoteExecFileList fileList = new RemoteExecFileList(this.createListOfFilesToCopy());
        ArrayList<String> copyFailedNodes = new ArrayList<String>();
        for (String node : this.getFixableNodes()) {
            Trace.out((String)("Processsing copy of tools and dependencies required for fixup on node " + node));
            VerificationLogData.logInfo("Processsing copy of tools and dependencies required for fixup on node " + node);
            boolean fileCopied = false;
            String errMsg = null;
            Result nodeResult = new Result(node);
            try {
                fileList.copyFiles(node, VerificationUtil.getCVUSubDirPath());
                nodeResult.setStatus(1);
                fileCopied = true;
            }
            catch (ClusterException ce) {
                Trace.out((String)("Caught ClusterException : Failed to perform copy operation on node " + node));
                Trace.out((Exception)((Object)ce));
                errMsg = ce.getMessage();
            }
            catch (VerificationException ve) {
                Trace.out((String)("Caught VerificationException : Failed to perform copy operation on node " + node));
                Trace.out((Exception)ve);
                errMsg = ve.getMessage();
            }
            catch (InvalidPathException ipe) {
                Trace.out((String)("Caught InvalidPathException : Failed to perform copy operation on node " + node));
                Trace.out((Exception)ipe);
                errMsg = ipe.getMessage();
            }
            if (!fileCopied) {
                copyFailedNodes.add(node);
                if (VerificationUtil.isStringGood(errMsg)) {
                    nodeResult.addErrorDescription(new ErrorDescription(errMsg));
                }
                nodeResult.setStatus(2);
            }
            remoteCopyResultSet.addResult(node, nodeResult);
        }
        if (copyFailedNodes.size() > 0) {
            Trace.out((String)("Copying of fixup tools and dependencies failed on following nodes " + VerificationUtil.strCollection2String(copyFailedNodes)));
            VerificationLogData.logWarning("Copying of fixup tools and dependencies failed on following nodes " + VerificationUtil.strCollection2String(copyFailedNodes));
            remoteCopyResultSet.setStatus(2);
            remoteCopyResultSet.addErrorDescription(new ErrorDescription(s_msgBundle.getMessage("7650", false, (Object[])new String[]{VerificationUtil.getCVUSubDirPath(), VerificationUtil.strCollection2String(copyFailedNodes)})));
        }
    }

    private List<RemoteExecFileList.FilePath> createListOfFilesToCopy() throws InvalidPathException {
        ArrayList<RemoteExecFileList.FilePath> listOfFilesToCopy = new ArrayList<RemoteExecFileList.FilePath>();
        String[] remExecFiles = CVUAutoUpdateManager.getCmdFiles4RemExec();
        if (null != remExecFiles) {
            for (String file : remExecFiles) {
                listOfFilesToCopy.add(new RemoteExecFileList.FilePath(file, 0, false));
            }
        }
        listOfFilesToCopy.add(new RemoteExecFileList.FilePath(FixupUtility.getFixupDataFileCompletePath(), 1, false));
        listOfFilesToCopy.add(new RemoteExecFileList.FilePath(FixupUtility.getFixupInstructionsFilePath(), 1, false));
        return listOfFilesToCopy;
    }

    public void updateNodeResult(Result result) {
        String node = result.getNode();
        List<Task> participatingTasksForNode = this.m_fixupNodeTableWithParticipatingTasks.get(node);
        for (Task t : participatingTasksForNode) {
            try {
                ((FixupResultSetImpl)t.getFixupResultSet()).addResult(node, result);
            }
            catch (InvalidFixupNodeException e) {
                Trace.out((String)("Caught InvalidFixupNodeException skipping node " + node));
            }
        }
    }

    public List<String> getFixupFailedNodes() {
        ArrayList<String> failedNodes = new ArrayList<String>();
        for (Task t : this.m_fixableTaskList) {
            List<String> failedNodesForTask = ((FixupResultSetImpl)t.getFixupResultSet()).getFailedNodes();
            for (String node : failedNodesForTask) {
                if (failedNodes.contains(node)) continue;
                failedNodes.add(node);
            }
        }
        return failedNodes;
    }

    public void displayFixupSummary() {
        boolean bSucc = true;
        for (Task task : this.m_fixableTaskList) {
            this.displayFixupTaskResult(task);
            if (task.getFixupResultSet().getFixupOverallStatus() == FixupOverallStatus.SUCCESSFUL) continue;
            bSucc = false;
        }
        String summary = null;
        summary = bSucc ? s_gMsgBundle.getMessage("9010", false) : s_gMsgBundle.getMessage("9011", false, (Object[])new String[]{VerificationUtil.strList2List(this.getFixupFailedNodes())});
        ReportUtil.println(summary);
    }

    private void displayFixupTaskResult(Task task) {
        if (task.isFixable() && task.isFixupProcessed()) {
            FixupResultSetImpl fixupTaskResultSet = (FixupResultSetImpl)task.getFixupResultSet();
            FixupData taskFixupData = task.getFixupData();
            fixupTaskResultSet.traceFixupResultSet("<== Before Summary ==>");
            List<String> participatingNodeForTask = taskFixupData.getFixableNodes();
            if (participatingNodeForTask.size() > 0) {
                ReportUtil.blankln();
                ReportUtil.sureprintln(s_gMsgBundle.getMessage("9014", false, (Object[])new String[]{task.getDefaultElementName()}));
            }
            if (fixupTaskResultSet.hasNodeResults()) {
                ReportUtil.writeColHeaders(ReportUtil.NODENAME, ReportUtil.STATUS);
                String nodeErrors = null;
                String nodeWarnings = null;
                for (String node : participatingNodeForTask) {
                    try {
                        FixupResult taskResult = fixupTaskResultSet.getResult(node);
                        String status = null;
                        String nodewiseError = null;
                        String nodewiseWarning = null;
                        if (taskResult.getStatus() == FixupStatus.SUCCESSFUL) {
                            status = ReportUtil.SUCCESSFUL;
                        } else if (taskResult.getStatus() == FixupStatus.WARNING) {
                            status = ReportUtil.PARTIALLY_SUCCESSFUL;
                            nodewiseWarning = FixupUtility.getCompleteErrorMessageFromErrorList(taskResult.getErrors());
                            nodeWarnings = VerificationUtil.isStringGood(nodeWarnings) && VerificationUtil.isStringGood(nodewiseWarning) ? nodeWarnings + VerificationConstants.LINE_SEPARATOR + nodewiseWarning : nodewiseWarning;
                        } else if (taskResult.getStatus() == FixupStatus.FAILED) {
                            status = ReportUtil.FAILED;
                            nodewiseError = FixupUtility.getCompleteErrorMessageFromErrorList(taskResult.getErrors());
                            nodeErrors = VerificationUtil.isStringGood(nodeErrors) && VerificationUtil.isStringGood(nodewiseError) ? nodeErrors + VerificationConstants.LINE_SEPARATOR + nodewiseError : nodewiseError;
                        } else if (taskResult.getStatus() == FixupStatus.ERROR) {
                            status = taskFixupData.isFixupGenerationFailedForNode(node) ? ReportUtil.FAILED_GENERATE_FIXUP : ReportUtil.FAILED;
                            nodewiseError = FixupUtility.getCompleteErrorMessageFromErrorList(taskResult.getErrors());
                            nodeErrors = VerificationUtil.isStringGood(nodeErrors) && VerificationUtil.isStringGood(nodewiseError) ? nodeErrors + VerificationConstants.LINE_SEPARATOR + nodewiseError : nodewiseError;
                        } else {
                            status = ReportUtil.UNKNOWN;
                        }
                        ReportUtil.writeRecord(taskResult.getNode(), status);
                    }
                    catch (InvalidFixupNodeException e) {
                    }
                    catch (NodeResultsUnavailableException e) {
                        break;
                    }
                }
                if (VerificationUtil.isStringGood(nodeWarnings)) {
                    ReportUtil.printWarning(nodeWarnings);
                }
                if (VerificationUtil.isStringGood(nodeErrors)) {
                    ReportUtil.printError(nodeErrors);
                }
            }
            if (fixupTaskResultSet.getGlobalErrors().size() > 0) {
                List<VerificationError> errorList = fixupTaskResultSet.getGlobalErrors();
                for (VerificationError error : errorList) {
                    ReportUtil.printError(error.getErrorMessage());
                }
            }
            String taskSummary = null;
            taskSummary = fixupTaskResultSet.getFailedNodes().size() > 0 ? s_gMsgBundle.getMessage("9009", false, (Object[])new String[]{task.getDefaultElementName(), VerificationUtil.strList2List(fixupTaskResultSet.getFailedNodes())}) : s_gMsgBundle.getMessage("9008", false, (Object[])new String[]{task.getDefaultElementName()});
            ReportUtil.printResult(taskSummary);
        }
    }

    static {
        m_isExecuteCalled = false;
        m_fixupDriverObj = null;
        m_fixupController = null;
    }
}

