/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.verification.fixup;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Vector;
import oracle.cluster.util.ConsoleUtilException;
import oracle.cluster.verification.FixupException;
import oracle.cluster.verification.FixupManualInstruction;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.VerificationTask;
import oracle.cluster.verification.fixup.CVUFixup;
import oracle.cluster.verification.fixup.FixupUtility;
import oracle.cluster.verification.fixup.RootAutomationException;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.RootAutomationUtility;
import oracle.ops.verification.framework.util.VerificationLogData;
import oracle.ops.verification.framework.util.VerificationUtil;

public class FixupCommandline {
    List<VerificationTask> m_taskListToProcess = FixupUtility.getFixupTaskList();
    private static MessageBundle s_gMsgBundle = VerificationUtil.getMessageBundle("Prvg");
    private static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");
    private static FixupCommandline m_instance = null;

    private FixupCommandline() {
    }

    public static synchronized FixupCommandline getInstance() {
        if (m_instance == null) {
            m_instance = new FixupCommandline();
        }
        return m_instance;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void performFixups(boolean onlyGenerateFixups) throws ConsoleUtilException, FixupException {
        if (this.m_taskListToProcess.size() <= 0) {
            ReportUtil.sureblankln();
            ReportUtil.printNote(s_gMsgBundle.getMessage("9000", false));
            return;
        }
        CVUFixup driver = CVUFixup.getInstance(this.m_taskListToProcess);
        this.displaySelectedTasks(driver);
        if (driver.getFixableTaskList().size() <= 0) {
            ReportUtil.sureblankln();
            ReportUtil.printNote(s_gMsgBundle.getMessage("9000", false));
            return;
        }
        driver.setUp();
        if (onlyGenerateFixups) {
            if (onlyGenerateFixups) {
                Trace.out((String)"The Fixup command line option '-fixupnoexec' was specifiedhence skipping the execution of fix-ups generated ");
            }
            ReportUtil.blankln();
            FixupManualInstruction manualInstruction = FixupUtility.getManualFixupInstruction(driver);
            ReportUtil.sureprintln(s_gMsgBundle.getMessage("9006", false, (Object[])new String[]{manualInstruction.getFixupInstruction(), VerificationUtil.strList2List(manualInstruction.getParticipatingNodes())}));
            ReportUtil.blankln();
        } else {
            try {
                if (RootAutomationUtility.getRootExecutionInfo() != null) {
                    try {
                        driver.fixAutomatically();
                        driver.displayFixupSummary();
                    }
                    catch (RootAutomationException rae) {
                        VerificationLogData.logError("RootAutomationException : " + rae.getMessage());
                        Trace.out((String)("Caught RootAutomationException - Root Automation is not established, failed with error " + rae.getMessage()));
                        ReportUtil.printWarning(rae.getMessage());
                        this.processFixupManualExecution();
                    }
                }
            }
            catch (VerificationException e) {
                VerificationLogData.logError("Root Automation not available, performing fix-ups manually");
                Trace.out((String)"Root Automation not available, performing fix-ups manually");
                this.processFixupManualExecution();
            }
        }
        CVUFixup.destroy();
    }

    private void processFixupManualExecution() throws ConsoleUtilException, FixupException {
        CVUFixup driver = CVUFixup.getInstance(this.m_taskListToProcess);
        ReportUtil.blankln();
        FixupManualInstruction manualInstruction = FixupUtility.getManualFixupInstruction(driver);
        ReportUtil.sureprintln(s_gMsgBundle.getMessage("9006", false, (Object[])new String[]{manualInstruction.getFixupInstruction(), VerificationUtil.strList2List(manualInstruction.getParticipatingNodes())}));
        ReportUtil.blankln();
        ReportUtil.sureprintln(s_gMsgBundle.getMessage("9007", false, (Object[])new String[]{FixupUtility.getDriverScriptCompletePath(), VerificationUtil.strList2List(driver.getFixableNodes())}));
        if (this.readEnterKeyStroke()) {
            driver.fixManually();
            driver.displayFixupSummary();
        }
    }

    private void displaySelectedTasks(CVUFixup driver) throws ConsoleUtilException {
        String highLight;
        if (driver.getFixupGenerationFailedTaskList().size() > 0) {
            ReportUtil.blankln();
            highLight = this.createNewFormattedTextLine("*", 90);
            ReportUtil.sureprintln(highLight);
            ReportUtil.sureprintln(s_gMsgBundle.getMessage("9022", false));
            ReportUtil.sureprintln(highLight);
            this.printFixupGenFailedTaskList(driver.getFixupGenerationFailedTaskList());
        }
        if (driver.getFixableTaskList().size() > 0) {
            ReportUtil.blankln();
            highLight = this.createNewFormattedTextLine("*", 90);
            ReportUtil.sureprintln(highLight);
            ReportUtil.sureprintln(s_gMsgBundle.getMessage("9017", false));
            ReportUtil.sureprintln(highLight);
            this.printFixableTaskList(driver.getFixableTaskList());
            ReportUtil.blankln();
        }
    }

    private void printFixableTaskList(List<Task> fixableTaskList) {
        ReportUtil.sureblankln();
        int[] spaceBtwnColmns = new int[]{30, 20, 20};
        String checkName = s_msgBundle.getMessage("9402", false);
        this.printFormattedLine(new String[]{this.createNewFormattedTextLine("-", checkName.length()), this.createNewFormattedTextLine("-", ReportUtil.FAILED_ON_NODES.length()), this.createNewFormattedTextLine("-", ReportUtil.REBOOT_REQUIRED.length())}, spaceBtwnColmns);
        this.printFormattedLine(new String[]{checkName, ReportUtil.FAILED_ON_NODES, ReportUtil.REBOOT_REQUIRED}, spaceBtwnColmns);
        this.printFormattedLine(new String[]{this.createNewFormattedTextLine("-", checkName.length()), this.createNewFormattedTextLine("-", ReportUtil.FAILED_ON_NODES.length()), this.createNewFormattedTextLine("-", ReportUtil.REBOOT_REQUIRED.length())}, spaceBtwnColmns);
        for (Task task : fixableTaskList) {
            if (!task.isFixable()) continue;
            String[] nodeList = null;
            nodeList = task.getFixupData() != null ? task.getFixupData().getFixableNodes().toArray(new String[0]) : new String[]{""};
            String taskDesc = task.getDefaultElementName();
            String isRebootRequired = task.isRebootRequiredForFixup() ? ReportUtil.YES : ReportUtil.NO;
            this.printFormattedLine(new String[]{taskDesc, VerificationUtil.strArr2List(nodeList, ","), isRebootRequired}, spaceBtwnColmns);
        }
        ReportUtil.sureblankln();
    }

    private void printFixupGenFailedTaskList(List<Task> fixGenFailedTaskList) {
        ReportUtil.sureblankln();
        for (Task task : fixGenFailedTaskList) {
            ReportUtil.sureprintln(s_msgBundle.getMessage("1000", false, (Object[])new String[]{task.getDefaultElementName()}));
            if (!task.isFixable()) continue;
            String[] failedNodeList = null;
            failedNodeList = task.getFixupData() != null ? task.getFixupData().getFixupGenerationFailedNodes().toArray(new String[0]) : new String[]{""};
            ReportUtil.sureprintln(ReportUtil.FAILED_ON_NODES + ": " + VerificationUtil.strArr2List(failedNodeList, ","));
            ReportUtil.sureprintln(ReportUtil.ERROR);
            String error = FixupUtility.getCompleteErrorMessageFromErrorList(task.getFixupResultSet().getErrors());
            ReportUtil.sureprintln(error);
            ReportUtil.sureblankln();
        }
        ReportUtil.sureblankln();
    }

    private Vector<String> formatTextLine(String[] columns, int[] space, String delim) {
        Vector<String> lines = new Vector<String>();
        if (columns == null || space == null || columns.length != space.length) {
            return null;
        }
        boolean oneMoreLine = false;
        String[] newArray = new String[columns.length];
        StringBuffer buffer = new StringBuffer();
        for (int cnt = 0; cnt < columns.length; ++cnt) {
            int allowedSpan = space[cnt] - 2;
            String col = columns[cnt].trim();
            if (col.length() > allowedSpan) {
                String colForThisLine = col.substring(0, allowedSpan);
                if (colForThisLine.contains("\n")) {
                    int newLineIndx = colForThisLine.indexOf("\n");
                    buffer.append(colForThisLine.substring(0, newLineIndx));
                    newArray[cnt] = col.substring(newLineIndx, col.length());
                    oneMoreLine = true;
                } else {
                    int lastBreakIndx = colForThisLine.lastIndexOf(" ");
                    if (lastBreakIndx == -1) {
                        lastBreakIndx = colForThisLine.lastIndexOf(",");
                    }
                    int additionalSpaces = 0;
                    if (lastBreakIndx != -1) {
                        colForThisLine = col.substring(0, lastBreakIndx);
                        additionalSpaces = col.substring(0, allowedSpan).substring(lastBreakIndx).length();
                        for (int i = 0; i < additionalSpaces; ++i) {
                            colForThisLine = colForThisLine + " ";
                        }
                    } else {
                        lastBreakIndx = allowedSpan;
                    }
                    buffer.append(colForThisLine);
                    newArray[cnt] = col.substring(lastBreakIndx, col.length());
                    oneMoreLine = true;
                }
            } else if (col.length() < allowedSpan) {
                int i;
                buffer.append(col);
                if (cnt == 0 && VerificationUtil.isStringGood(delim)) {
                    for (i = 0; i < allowedSpan - col.length() - 1; ++i) {
                        buffer.append(" ");
                    }
                    buffer.append(delim.charAt(0));
                } else {
                    for (i = 0; i < allowedSpan - col.length(); ++i) {
                        buffer.append(" ");
                    }
                }
                newArray[cnt] = "";
            } else {
                buffer.append(col);
                newArray[cnt] = "";
            }
            buffer.append("  ");
        }
        lines.add(buffer.toString());
        if (oneMoreLine) {
            Vector<String> moreLines = this.formatTextLine(newArray, space, null);
            for (String str : moreLines) {
                lines.add(str);
            }
        }
        return lines;
    }

    private void printFormattedLine(String[] columns, int[] columnSizes) {
        Vector<String> linesToPrint = this.formatTextLine(columns, columnSizes, null);
        for (String line : linesToPrint) {
            ReportUtil.sureprintln(line);
        }
    }

    private String createNewFormattedTextLine(String lineChar, int length) {
        StringBuffer txtBuffer = new StringBuffer();
        if (length <= 0) {
            length = 90;
        }
        for (int i = 0; i < length; ++i) {
            txtBuffer.append(lineChar);
        }
        return txtBuffer.toString();
    }

    private boolean readEnterKeyStroke() throws ConsoleUtilException {
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        try {
            in.readLine();
        }
        catch (IOException ioe) {
            Trace.out((String)("Failed to read response from console, Error is - " + ioe.getMessage()));
            throw new ConsoleUtilException((Throwable)ioe);
        }
        return true;
    }
}

