/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.verification.fixup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import oracle.cluster.verification.VerificationTask;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.util.VerificationLogData;

public class FixupTaskListContainer {
    private static List<VerificationTask> m_performedTaskList = new ArrayList<VerificationTask>();
    private static List<Task> m_generatedTaskListToReturn = new ArrayList<Task>();

    public static void addPerformedTask(VerificationTask task) {
        if (!m_performedTaskList.contains(task)) {
            m_performedTaskList.add(task);
        }
    }

    public static List<Task> getGeneratedFixupTaskList() {
        if (m_performedTaskList.size() > 0) {
            m_generatedTaskListToReturn = GeneratedFixupTaskContainer.getAllTasks();
            m_performedTaskList.clear();
            Trace.out((String)("Returning the Fix-up Task List as following \n Returned task list size(" + m_generatedTaskListToReturn.size() + ")" + "\nContainer status is as following \nPerformed TaskList contains (" + m_performedTaskList.size() + ") items"));
            VerificationLogData.logInfo("Returning the Fix-up Task List as following \n Returned task list size(" + m_generatedTaskListToReturn.size() + ")" + "\nContainer status is as following \nPerformed TaskList contains (" + m_performedTaskList.size() + ") items");
            GeneratedFixupTaskContainer.clearTaskList();
        }
        return m_generatedTaskListToReturn;
    }

    public static void clear() {
        GeneratedFixupTaskContainer.clearTaskList();
        m_performedTaskList.clear();
        m_generatedTaskListToReturn.clear();
        Trace.out((String)("Cleared the Fix-up Task List Containers as following \nm_performedTaskList size(" + m_performedTaskList.size() + ")" + "\nm_generatedTaskListToReturn size(" + m_generatedTaskListToReturn.size() + ")"));
        VerificationLogData.logInfo("Cleared the Fix-up Task List Containers as following \nPerformed TaskList size(" + m_performedTaskList.size() + ")" + "\nGenerated TaskListToReturn size(" + m_generatedTaskListToReturn.size() + ")");
    }

    public static void addFixupTask(Task fixableTask) {
        Trace.out((String)("Adding fix-up Task " + fixableTask.getDefaultTaskID() + " in the fixable task container"));
        VerificationLogData.logInfo("Adding fix-up Task " + fixableTask.getDefaultTaskID() + " in the fixable task container");
        GeneratedFixupTaskContainer.addTask(fixableTask);
    }

    public static void removeTask(Task task) {
        GeneratedFixupTaskContainer.removeTask(task);
    }

    private static class GeneratedFixupTaskContainer {
        private static HashMap<String, List<Task>> s_cvuFixupGeneratedTaskMap = new HashMap();

        private GeneratedFixupTaskContainer() {
        }

        public static boolean containsTask(Task task) {
            return s_cvuFixupGeneratedTaskMap.containsKey(task.getDefaultTaskID());
        }

        public static void addTask(Task task) {
            if (task == null) {
                return;
            }
            if (GeneratedFixupTaskContainer.containsTask(task)) {
                Trace.out((String)("Fixup Task Container already contains task of type " + task.getDefaultTaskID()));
                VerificationLogData.logInfo("Fixup Task Container already contains task of type " + task.getDefaultTaskID());
                if (task.getFixupData() != null) {
                    boolean duplicate = false;
                    for (Task currTask : s_cvuFixupGeneratedTaskMap.get(task.getDefaultTaskID())) {
                        if (!currTask.getFixupData().isSameFixupData(task.getFixupData(), true)) continue;
                        currTask.getFixupData().addParticipatingNodes(task.getFixupData().getParticipatingNodes());
                        for (String node : task.getFixupData().getParticipatingNodes()) {
                            currTask.getFixupData().setActualValue(node, task.getFixupData().getActualVal(node));
                            currTask.getFixupData().setExpectedValue(node, task.getFixupData().getExpectedVal(node));
                        }
                        duplicate = true;
                        break;
                    }
                    if (!duplicate) {
                        s_cvuFixupGeneratedTaskMap.get(task.getDefaultTaskID()).add(task);
                    } else {
                        Trace.out((String)("Similar FixupData for task " + task.getDefaultTaskID() + " is already added," + " ignored this duplicate FixupData and updated the nodewise additional data if any"));
                    }
                }
            } else {
                Trace.out((String)("Adding fix-up task " + task.getDefaultTaskID() + " in Fixup Task Container"));
                VerificationLogData.logInfo("Adding fix-up task " + task.getDefaultTaskID() + " in Fixup Task Container");
                ArrayList<Task> taskIdentifierTable = new ArrayList<Task>();
                taskIdentifierTable.add(task);
                s_cvuFixupGeneratedTaskMap.put(task.getDefaultTaskID(), taskIdentifierTable);
            }
        }

        public static List<Task> getAllTasks() {
            ArrayList<Task> taskList = new ArrayList<Task>();
            for (String taskID : s_cvuFixupGeneratedTaskMap.keySet()) {
                taskList.addAll((Collection)s_cvuFixupGeneratedTaskMap.get(taskID));
            }
            Trace.out((String)("Returning total " + taskList.size() + " generated fix-up tasks from Task Container"));
            return taskList;
        }

        public static void clearTaskList() {
            s_cvuFixupGeneratedTaskMap.clear();
            Trace.out((String)("Cleared the Generated Task List Containers \n Now Generated task list contains (" + s_cvuFixupGeneratedTaskMap.size() + ") items"));
            VerificationLogData.logInfo("Cleared the Generated Task List Containers \n Now Generated task list contains (" + s_cvuFixupGeneratedTaskMap.size() + ") items");
        }

        public static void removeTask(Task task) {
            if (task == null) {
                return;
            }
            if (GeneratedFixupTaskContainer.containsTask(task)) {
                Trace.out((String)("Removing Task " + task.getDefaultTaskID() + " from fixable task list."));
                VerificationLogData.logInfo("Removing Task " + task.getDefaultTaskID() + " from fixable task list.");
                List<Task> matchingTaskList = s_cvuFixupGeneratedTaskMap.get(task.getDefaultTaskID());
                for (Task t : matchingTaskList) {
                    if (!task.equals(t)) continue;
                    s_cvuFixupGeneratedTaskMap.get(task.getDefaultTaskID()).remove(t);
                    if (s_cvuFixupGeneratedTaskMap.get(task.getDefaultTaskID()).size() == 0) {
                        Trace.out((String)("Successfully Removed all Tasks with ID " + task.getDefaultTaskID() + " from fixable task list."));
                        VerificationLogData.logInfo("Successfully Removed all Tasks with ID " + task.getDefaultTaskID() + " from fixable task list.");
                        s_cvuFixupGeneratedTaskMap.remove(task.getDefaultTaskID());
                    }
                    Trace.out((String)("Successfully Removed Task " + task.getDefaultTaskID() + " from fixable task list."));
                    VerificationLogData.logInfo("Successfully Removed Task " + task.getDefaultTaskID() + " from fixable task list.");
                    break;
                }
            } else {
                Trace.out((String)("Not removing - Task " + task.getDefaultTaskID() + " not found in fixable task list."));
                VerificationLogData.logInfo("Not removing - Task " + task.getDefaultTaskID() + " not found in fixable task list.");
            }
        }
    }
}

