/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.verification.nodemgr;

import oracle.cluster.verification.nodemgr.NodeManager;
import oracle.cluster.verification.nodemgr.NodeManagerException;
import oracle.cluster.verification.nodemgr.NodeManagerFactoryException;
import oracle.ops.mgmt.trace.Trace;

public class NodeManagerFactory {
    private static NodeManagerFactory m_instance = null;
    private NodeManager m_nodeManager = null;

    private NodeManagerFactory() {
    }

    public static synchronized NodeManagerFactory getInstance() throws NodeManagerFactoryException {
        if (null == m_instance) {
            m_instance = new NodeManagerFactory();
        }
        return m_instance;
    }

    public synchronized NodeManager getNodeManager(String[] hubNodes, String[] leafNodes, String[] autoNodes, int hubSize) {
        if (this.m_nodeManager != null && this.m_nodeManager.equals(hubNodes, leafNodes, autoNodes, hubSize)) {
            Trace.out((String)"returning existing NodeManager");
            return this.m_nodeManager;
        }
        Trace.out((String)"creating new NodeManager");
        this.m_nodeManager = new NodeManager(hubNodes, leafNodes, autoNodes, hubSize);
        return this.m_nodeManager;
    }

    public synchronized NodeManager getNodeManager(String[] nodeList) {
        if (this.m_nodeManager != null && this.m_nodeManager.equals(nodeList, null, null, nodeList == null ? 0 : nodeList.length)) {
            Trace.out((String)"returning existing NodeManager");
            return this.m_nodeManager;
        }
        Trace.out((String)"creating new NodeManager");
        this.m_nodeManager = new NodeManager(nodeList);
        return this.m_nodeManager;
    }

    public synchronized NodeManager getNodeManager(boolean isSIDB) throws NodeManagerFactoryException {
        try {
            if (this.m_nodeManager != null && this.m_nodeManager.isSIDB() == isSIDB) {
                Trace.out((String)"returning existing NodeManager");
                return this.m_nodeManager;
            }
            Trace.out((String)"creating new NodeManager");
            this.m_nodeManager = new NodeManager(isSIDB);
        }
        catch (NodeManagerException nmEx) {
            throw new NodeManagerFactoryException(nmEx);
        }
        return this.m_nodeManager;
    }

    public synchronized NodeManager getNodeManager() throws NodeManagerFactoryException {
        try {
            if (this.m_nodeManager == null) {
                Trace.out((String)"creating new NodeManager");
                this.m_nodeManager = new NodeManager();
            }
        }
        catch (NodeManagerException nmEx) {
            throw new NodeManagerFactoryException(nmEx);
        }
        return this.m_nodeManager;
    }

    public synchronized NodeManager createNodeManager() throws NodeManagerFactoryException {
        try {
            this.m_nodeManager = new NodeManager(false);
        }
        catch (NodeManagerException nmEx) {
            throw new NodeManagerFactoryException(nmEx);
        }
        return this.m_nodeManager;
    }

    public synchronized boolean isNodeManagerExists() {
        return this.m_nodeManager != null;
    }
}

