/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.verification.pluggable;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.sql.rowset.CachedRowSet;
import oracle.cluster.verification.pluggable.ArgType;
import oracle.cluster.verification.pluggable.DataComparator;
import oracle.cluster.verification.pluggable.DataType;
import oracle.cluster.verification.pluggable.ExecutableArgument;
import oracle.cluster.verification.pluggable.ExecutableInfo;
import oracle.cluster.verification.pluggable.PluggableTaskUtil;
import oracle.cluster.verification.pluggable.ResultAnalyzerException;
import oracle.cluster.verification.pluggable.VerificationExecutableException;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.util.VerificationUtil;

public class ExternalDataComparator
extends DataComparator {
    private ExecutableInfo m_comparatorExecutable = null;

    public ExternalDataComparator(ExecutableInfo compExec) {
        this.m_comparatorExecutable = compExec;
    }

    @Override
    public ResultSet analyzeResult(ResultSet vfnResult) throws ResultAnalyzerException {
        ResultSet rsltSet;
        block17: {
            Hashtable ht = vfnResult.getResultTable();
            Enumeration e = ht.keys();
            rsltSet = new ResultSet();
            boolean isGlobal = this.m_comparatorExecutable.getLocalNodeCheck();
            Trace.out((String)"Attempting to execute an external analyzer");
            String fileName = new String();
            String executableArg = new String();
            String destLoc = VerificationUtil.getCVUSubDirPath();
            String path = new String();
            if (destLoc != null) {
                ClusterCmd cmd = new ClusterCmd();
                path = destLoc + "tempdir";
                try {
                    String localHost = VerificationUtil.getLocalHost();
                    if (!cmd.createDirWithPermissionsOnNodes(new String[]{localHost}, path, "0700")) {
                        Trace.out((String)("Failed to create directory:" + path));
                        throw new ResultAnalyzerException(s_msgBundle.getMessage("0006", false, (Object[])new String[]{path}));
                    }
                }
                catch (UnknownHostException uhe) {
                    Trace.out((String)"Unable to get local host.");
                    rsltSet = vfnResult;
                    String errMsg = s_msgBundle.getMessage("0014", false);
                    ErrorDescription errDesc = new ErrorDescription(errMsg, "", "");
                    rsltSet.addErrorDescription(errDesc);
                    rsltSet.setStatus(2);
                    return rsltSet;
                }
                catch (ClusterException ce) {
                    Trace.out((String)"Unable to create directory with the given permissions.");
                    rsltSet = vfnResult;
                    String errMsg = s_msgBundle.getMessage("0006", false, (Object[])new String[]{path});
                    ErrorDescription errDesc = new ErrorDescription(errMsg, "", "");
                    rsltSet.addErrorDescription(errDesc);
                    rsltSet.setStatus(2);
                    return rsltSet;
                }
            }
            Trace.out((String)"Fetching fileList");
            String fileList = ExternalDataComparator.getFileName(path, "filelist");
            Trace.out((String)("fileList=" + fileList));
            this.writeToFile(fileList, "PATH=" + path + VerificationUtil.LSEP, false);
            Trace.out((String)("isGlobal=" + isGlobal));
            if (isGlobal) {
                String node;
                Result result;
                fileName = "DATA_GLOBAL_" + ExternalDataComparator.getProcessId() + "_" + ExternalDataComparator.getTimeStamp();
                executableArg = ExternalDataComparator.getFileName(path, fileName);
                boolean toAppend = false;
                if (e.hasMoreElements() && (result = (Result)ht.get(node = (String)e.nextElement())).getStatus() == 1) {
                    try {
                        Object collectedValue = result.getResultInfoSet().firstElement();
                        String collectedValueStr = this.getValueString(collectedValue);
                        this.writeToFile(executableArg, collectedValueStr + VerificationUtil.LSEP, toAppend);
                        if (!toAppend) {
                            toAppend = true;
                        }
                    }
                    catch (SQLException e1) {
                        throw new ResultAnalyzerException(e1.getMessage(), e1);
                    }
                    String contents = "<GLOBAL>=" + fileName + VerificationUtil.LSEP;
                    this.writeToFile(fileList, contents, true);
                }
            } else {
                while (e.hasMoreElements()) {
                    String node = (String)e.nextElement();
                    Result result = (Result)ht.get(node);
                    if (result.getStatus() != 1) continue;
                    fileName = "DATA_" + node + "_" + ExternalDataComparator.getProcessId() + "_" + ExternalDataComparator.getTimeStamp();
                    executableArg = ExternalDataComparator.getFileName(path, fileName);
                    boolean toAppend = false;
                    try {
                        Object collectedValue = result.getResultInfoSet().firstElement();
                        String collectedValueStr = this.getValueString(collectedValue);
                        this.writeToFile(executableArg, collectedValueStr + VerificationUtil.LSEP, toAppend);
                        if (!toAppend) {
                            toAppend = true;
                        }
                    }
                    catch (SQLException e1) {
                        throw new ResultAnalyzerException(e1.getMessage(), e1);
                    }
                    String contents = node + "=" + fileName + VerificationUtil.LSEP;
                    this.writeToFile(fileList, contents, true);
                }
            }
            ExecutableInfo holder = this.m_comparatorExecutable;
            ExecutableArgument eArg = new ExecutableArgument("arg0", ArgType.DEFINED, DataType.STRING, fileList);
            holder.addExecArgument(eArg);
            try {
                rsltSet = this.execVerificationExecutableAnalyzer(holder);
            }
            catch (ResultAnalyzerException rae) {
                rsltSet.setStatus(2);
                if (!Trace.isLevelEnabled((int)5)) break block17;
                Trace.out((String)("ResultAnalyzerException: " + rae.getMessage()));
                Trace.stackTrace((Throwable)rae);
            }
        }
        return rsltSet;
    }

    private String getValueString(Object collectedValue) throws SQLException {
        String collectedValueStr = "";
        if (collectedValue instanceof CachedRowSet) {
            CachedRowSet collectedRowSet = (CachedRowSet)collectedValue;
            int columnCount = collectedRowSet.getMetaData().getColumnCount();
            while (collectedRowSet.next()) {
                for (int i = 0; i < columnCount; ++i) {
                    if (i != 0) {
                        collectedValueStr = collectedValueStr + "\t";
                    }
                    collectedValueStr = collectedValueStr + collectedRowSet.getString(i + 1);
                }
                collectedValueStr = collectedValueStr + VerificationUtil.LSEP;
            }
        } else {
            collectedValueStr = String.valueOf(collectedValue);
        }
        return collectedValueStr;
    }

    private ResultSet execVerificationExecutableAnalyzer(ExecutableInfo info) throws ResultAnalyzerException {
        Trace.out((String)"Starting execVerificationExecutableAnalyzer...");
        ResultSet resultSet = new ResultSet();
        try {
            String localNode = VerificationUtil.getLocalHost();
            resultSet = PluggableTaskUtil.mapResultSet(PluggableTaskUtil.execExecutable(new String[]{localNode}, info));
        }
        catch (UnknownHostException uhe) {
            throw new ResultAnalyzerException(s_msgBundle.getMessage("0014", false));
        }
        catch (VerificationExecutableException vee) {
            throw new ResultAnalyzerException(vee.getMessage());
        }
        return resultSet;
    }

    boolean writeToFile(String fileName, String resStr, boolean append) {
        boolean ret = false;
        try {
            FileWriter fstream = new FileWriter(fileName, append);
            BufferedWriter out = new BufferedWriter(fstream);
            out.append(resStr);
            out.close();
            ret = true;
        }
        catch (IOException e) {
            Trace.out((String)e.getMessage());
        }
        return ret;
    }

    static String getProcessId() {
        long id = Thread.currentThread().getId();
        return Long.toString(id);
    }

    static String getFileName(String path, String prefix) {
        return path + VerificationUtil.FSEP + prefix;
    }

    static String getTimeStamp() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("ddMMyyyyHHmmss");
        return dateFormat.format(new Date());
    }
}

