/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.verification.pluggable.task;

import oracle.cluster.verification.common.CVUException;
import oracle.cluster.verification.pluggable.ExecutableArgument;
import oracle.cluster.verification.pluggable.task.PluggableJavaTask;
import oracle.cluster.verification.pluggable.task.PluggableTaskContext;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.util.CVUHelperUtil;
import oracle.ops.verification.framework.util.VerificationLogData;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskUpgradePrivilegedGroupsCheck
extends PluggableJavaTask {
    private static String OSASM_GROUP = "OSASM";
    private static String OSDBA_GROUP = "OSDBA";

    public TaskUpgradePrivilegedGroupsCheck(PluggableTaskContext ctx) {
        super(ctx);
    }

    @Override
    protected boolean performJavaTask() {
        Trace.out((int)2, (String)"Entry");
        this.m_resultSet.setStatus(1);
        this.m_resultSet.setHasNodeResults(false);
        String selectedOSASMGrp = null;
        String selectedOSDBAGrp = null;
        boolean usingCRSHome = false;
        for (ExecutableArgument arg : this.getExecutableInfo().getExecutableArgs()) {
            String argName = arg.getArgName();
            String argVal = arg.getArgVal();
            if ("ASM_GROUP".equals(argName)) {
                selectedOSASMGrp = argVal;
                continue;
            }
            if ("DBA_GROUP".equals(argName)) {
                selectedOSDBAGrp = argVal;
                continue;
            }
            Trace.out((String)("unknown argument. name=" + argName + ". value=" + argVal));
        }
        Trace.out((String)("Current selection of privileged groups is\nselectedOSASMGrp=" + selectedOSASMGrp + "\nselectedOSDBAGrp=" + selectedOSDBAGrp));
        String configuredOSASMGrp = null;
        String configuredOSDBAGrp = null;
        String osdbaHome = null;
        try {
            Version curVer = VerificationUtil.getCRSActiveVersionObj();
            Result result = new Result(m_localHost);
            if (curVer != null && Version.isPre112((Version)curVer)) {
                osdbaHome = CVUHelperUtil.getASMhome(result);
            } else {
                osdbaHome = VerificationUtil.getCRSHome(m_localHost, result);
                usingCRSHome = true;
            }
            if (!VerificationUtil.isStringGood(osdbaHome)) {
                Trace.out((String)"Could not locate the CRS or Oracle/database home to run the osdbagrp utility from.");
                VerificationLogData.log("Could not locate the CRS or Oracle/database home to run the osdbagrp utility from.");
                this.m_resultSet.addResult(m_localHost, result);
                throw new CVUException(s_msgBundle.getMessage(usingCRSHome ? "5301" : "7556", true));
            }
            Trace.out((String)("Getting privileged groups from home location " + osdbaHome));
            VerificationLogData.log("Getting privileged groups from home location " + osdbaHome);
            configuredOSASMGrp = VerificationUtil.getOSAsmGroup(osdbaHome);
            configuredOSDBAGrp = VerificationUtil.getOSDBAGroup(osdbaHome);
        }
        catch (CVUException ce) {
            Trace.out((String)("Caught CVUException " + ce.getMessage()));
            this.m_resultSet.addErrorDescription(new ErrorDescription(s_plgMsgBundle.getMessage("10125", true, (Object[])new String[]{ce.getMessage()})));
            this.m_resultSet.setStatus(2);
            return false;
        }
        Trace.out((String)("Configured privileged groups are\nconfiguredOSASMGrp=" + configuredOSASMGrp + "\nconfiguredOSDBAGrp=" + configuredOSDBAGrp));
        if (!VerificationUtil.isStringGood(selectedOSASMGrp) && m_isCLImode) {
            selectedOSASMGrp = configuredOSASMGrp;
        }
        if (!VerificationUtil.isStringGood(selectedOSDBAGrp) && m_isCLImode) {
            selectedOSDBAGrp = configuredOSDBAGrp;
        }
        if (VerificationUtil.isStringGood(selectedOSASMGrp)) {
            if (VerificationUtil.isStringGood(configuredOSASMGrp)) {
                if (!configuredOSASMGrp.equals(selectedOSASMGrp)) {
                    this.m_resultSet.addErrorDescription(new ErrorDescription(s_plgMsgBundle.getMessage(usingCRSHome ? "10123" : "10128", true, (Object[])new String[]{OSASM_GROUP, selectedOSASMGrp, configuredOSASMGrp, osdbaHome})));
                    this.m_resultSet.setStatus(3);
                } else {
                    Trace.out((String)"The OS ASM group selection matches with the configured value");
                }
            } else {
                this.m_resultSet.addErrorDescription(new ErrorDescription(s_plgMsgBundle.getMessage(usingCRSHome ? "10126" : "10129", true, (Object[])new String[]{OSASM_GROUP, osdbaHome})));
                this.m_resultSet.setStatus(4);
            }
        } else {
            Trace.out((String)"The current selection of OS ASM group could not be retrieved");
            this.m_resultSet.addErrorDescription(new ErrorDescription(s_plgMsgBundle.getMessage("10124", true, (Object[])new String[]{OSASM_GROUP})));
            this.m_resultSet.setStatus(3);
        }
        if (VerificationUtil.isStringGood(selectedOSDBAGrp)) {
            if (VerificationUtil.isStringGood(configuredOSDBAGrp)) {
                if (!configuredOSDBAGrp.equals(selectedOSDBAGrp)) {
                    this.m_resultSet.addErrorDescription(new ErrorDescription(s_plgMsgBundle.getMessage(usingCRSHome ? "10123" : "10128", true, (Object[])new String[]{OSDBA_GROUP, selectedOSDBAGrp, configuredOSDBAGrp, osdbaHome})));
                    this.m_resultSet.setStatus(3);
                } else {
                    Trace.out((String)"The OS DBA group selection matches with the configured value");
                }
            } else {
                this.m_resultSet.addErrorDescription(new ErrorDescription(s_plgMsgBundle.getMessage(usingCRSHome ? "10126" : "10129", true, (Object[])new String[]{OSDBA_GROUP, osdbaHome})));
                this.m_resultSet.setStatus(4);
            }
        } else {
            Trace.out((String)"The current selection of OS DBA group could not be retrieved");
            this.m_resultSet.addErrorDescription(new ErrorDescription(s_plgMsgBundle.getMessage("10124", true, (Object[])new String[]{OSDBA_GROUP})));
            this.m_resultSet.setStatus(3);
        }
        Trace.out((int)2, (String)"Exit");
        return this.m_resultSet.allSuccess();
    }

    @Override
    public String getDefaultDescription() {
        return s_plgMsgBundle.getMessage("10121", false);
    }

    @Override
    public String getDefaultElementName() {
        return s_plgMsgBundle.getMessage("10120", false);
    }
}

