/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.verification.pluggable.xml;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import oracle.cluster.verification.SeverityType;
import oracle.cluster.verification.VerificationAPIConstants;
import oracle.cluster.verification.constraints.CDMConstraintTypes;
import oracle.cluster.verification.constraints.XmlParserException;
import oracle.cluster.verification.constraints.parser.NodeVisitorCB;
import oracle.cluster.verification.database.DatabaseConnectInfo;
import oracle.cluster.verification.database.DatabaseConnectInfoException;
import oracle.cluster.verification.pluggable.ArgType;
import oracle.cluster.verification.pluggable.DarwinSQLDataComparator;
import oracle.cluster.verification.pluggable.DataComparator;
import oracle.cluster.verification.pluggable.DataComparatorType;
import oracle.cluster.verification.pluggable.DataType;
import oracle.cluster.verification.pluggable.ExecutableArgument;
import oracle.cluster.verification.pluggable.ExecutableInfo;
import oracle.cluster.verification.pluggable.ExecutableResultType;
import oracle.cluster.verification.pluggable.ExecutableType;
import oracle.cluster.verification.pluggable.ExternalDataComparator;
import oracle.cluster.verification.pluggable.InitialValidation;
import oracle.cluster.verification.pluggable.PluggableConstants;
import oracle.cluster.verification.pluggable.ReferenceInfo;
import oracle.cluster.verification.pluggable.SQLDataComparator;
import oracle.cluster.verification.pluggable.StdDataComparator;
import oracle.cluster.verification.pluggable.task.PluggableJavaTask;
import oracle.cluster.verification.pluggable.task.PluggableTaskContext;
import oracle.cluster.verification.util.DBUtils;
import oracle.cluster.verification.util.DBUtilsException;
import oracle.cluster.verification.util.XmlFilePathException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.security.NullSecurityManager;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.task.PluggableTask;
import oracle.ops.verification.framework.param.InvalidCommandlineException;
import oracle.ops.verification.framework.param.ParamManager;
import oracle.ops.verification.framework.param.UninitializedParamManagerException;
import oracle.ops.verification.framework.util.InvalidRangeManipulationException;
import oracle.ops.verification.framework.util.NodelistNotFoundException;
import oracle.ops.verification.framework.util.RangeOfValue;
import oracle.ops.verification.framework.util.RangeOperator;
import oracle.ops.verification.framework.util.RangeType;
import oracle.ops.verification.framework.util.VerificationLogData;
import oracle.ops.verification.framework.util.VerificationUtil;
import oracle.ops.verification.resources.PrveMsgID;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class PluggableConfigXmlParser
implements VerificationAPIConstants {
    private static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");
    private static MessageBundle s_prveMsgBundle = VerificationUtil.getMessageBundle("Prve");
    private ParamManager.OperationMode m_currentOperationMode;
    Element m_rootElement;
    String m_dbConnDescr;
    boolean m_darwinChecks;

    public PluggableConfigXmlParser() {
        block2: {
            this.m_currentOperationMode = null;
            this.m_rootElement = null;
            this.m_dbConnDescr = null;
            this.m_darwinChecks = false;
            Trace.out((String)"Method Entry.");
            try {
                ParamManager pm = ParamManager.getInstance();
                this.m_currentOperationMode = pm.getMode();
            }
            catch (UninitializedParamManagerException e) {
                if (!Trace.isLevelEnabled((int)1)) break block2;
                Trace.out((Exception)e);
            }
        }
    }

    public List<PluggableTask> getTasks(String release, String distID, String targetID, String[] nodeList) throws XmlParserException {
        Trace.out((int)5, (String)"Method release=%s, distID=%s, targetID=%s, nodeList", (Object[])new Object[]{release, distID, targetID, nodeList});
        try {
            String xml = VerificationUtil.getPluggableTaskXmlURI();
            this.m_darwinChecks = false;
            List<PluggableTask> cvuTasks = this.parse(xml, release, distID, targetID, nodeList);
            xml = VerificationUtil.getPluggableTaskDarwinXmlURI();
            Trace.out((String)("getting darwin checks from " + xml));
            this.m_darwinChecks = true;
            List<PluggableTask> darwinTasks = this.parse(xml, release, distID, targetID, nodeList);
            if (cvuTasks != null) {
                if (darwinTasks != null) {
                    cvuTasks.addAll(darwinTasks);
                }
            } else {
                cvuTasks = darwinTasks;
            }
            return cvuTasks;
        }
        catch (XmlFilePathException e) {
            throw new XmlParserException(e.getMessage(), e);
        }
        catch (ParserConfigurationException e) {
            throw new XmlParserException(e.getMessage(), e);
        }
        catch (SAXException e) {
            throw new XmlParserException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new XmlParserException(e.getMessage(), e);
        }
    }

    public List<PluggableTask> parse(String xmlFile, String release, String distID, String targetID, String[] nodeList) throws XmlParserException, ParserConfigurationException, SAXException, IOException, XmlFilePathException {
        Trace.out((int)5, (String)"Method release=%s, distID=%s, targetID=%s, nodeList", (Object[])new Object[]{release, distID, targetID, nodeList});
        DocumentBuilderFactory m_xmlFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder m_xmlParser = null;
        Document m_xmlDocument = null;
        String version = null;
        String m_xsdURI = VerificationUtil.getPluggableTaskXmlSchemaURI();
        File file_xsdURI = null;
        File file_xmlFile = null;
        try {
            file_xsdURI = new File(new URI(m_xsdURI));
            if (xmlFile != null) {
                file_xmlFile = new File(new URI(xmlFile));
            }
            Trace.out((String)("==== URIs obtained :xsd URI = " + m_xsdURI));
            Trace.out((String)("==== URIs obtained :xml URI = " + xmlFile));
            if (file_xmlFile == null || !file_xmlFile.exists()) {
                Trace.out((String)("xmlFile: " + xmlFile + " does not exists. returning null"));
                return null;
            }
            m_xmlFactory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
            m_xmlFactory.setNamespaceAware(true);
            m_xmlFactory.setValidating(true);
            m_xmlFactory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaSource", m_xsdURI);
            m_xmlParser = m_xmlFactory.newDocumentBuilder();
            ErrorHandler handler = new ErrorHandler(){

                @Override
                public void error(SAXParseException arg0) throws SAXException {
                    throw arg0;
                }

                @Override
                public void fatalError(SAXParseException arg0) throws SAXException {
                    throw arg0;
                }

                @Override
                public void warning(SAXParseException arg0) throws SAXException {
                    Trace.out((String)("Igonred waring while parsing: " + arg0));
                }
            };
            m_xmlParser.setErrorHandler(handler);
            m_xmlDocument = m_xmlParser.parse(xmlFile);
            this.m_rootElement = m_xmlDocument.getDocumentElement();
            NodeList softwareReleaseList = this.m_rootElement.getElementsByTagName("SOFTWARE");
            Element releaseElem = null;
            for (int i = 0; i < softwareReleaseList.getLength(); ++i) {
                Element elem = (Element)softwareReleaseList.item(i);
                version = this.getRequiredAttributeValue(elem, "VERSION");
                if (!version.equalsIgnoreCase(release)) continue;
                releaseElem = elem;
            }
            if (releaseElem == null) {
                return null;
            }
            Trace.out((String)("The releaseElem selected for the input release :" + version));
            return this.parseTargetList(releaseElem, distID, targetID, nodeList);
        }
        catch (SAXException se) {
            throw new XmlParserException(se.getMessage(), se);
        }
        catch (IOException ioe) {
            throw new XmlParserException(ioe.getMessage(), ioe);
        }
        catch (FactoryConfigurationError fce) {
            throw new XmlParserException(fce.getMessage(), fce);
        }
        catch (ParserConfigurationException pce) {
            throw new XmlParserException(pce.getMessage(), pce);
        }
        catch (Exception e) {
            Trace.out((String)("Exception " + e.getClass().getName() + " occured. Msg " + e.getMessage()));
            throw new XmlParserException(e.getMessage(), e);
        }
    }

    private List<PluggableTask> parseTargetList(Element releaseElem, String distID, String targetID, String[] nodeList) throws XmlParserException {
        Trace.out((int)5, (String)"Method releaseElem=%s, distID=%s, targetID=%s", (Object[])new Object[]{releaseElem.getTagName(), distID, targetID});
        NodeList targetList = releaseElem.getElementsByTagName("TARGET");
        Element targetElem = null;
        for (int i = 0; i < targetList.getLength(); ++i) {
            Element elem = (Element)targetList.item(i);
            String id = this.getRequiredAttributeValue(elem, "ID");
            if (!targetID.equalsIgnoreCase(id)) continue;
            targetElem = elem;
        }
        if (targetElem == null) {
            Trace.out((int)5, (String)"No prereq tasks found! For distID=%s, targetID=%s", (Object[])new Object[]{distID, targetID});
            return new ArrayList<PluggableTask>();
        }
        return this.parseTarget(targetElem, distID, nodeList);
    }

    private List<PluggableTask> parseTarget(Element targetListElem, String distID, String[] nodeList) throws XmlParserException {
        Trace.out((String)("Method Entry. TargetListElem=>" + targetListElem.getNodeName() + "Dist ID =>" + distID));
        Element taskListElem = this.getFirstChildByTagName(targetListElem, "TASK_LIST");
        return this.parseTaskList(taskListElem, distID, nodeList);
    }

    private void parseChildrenConditionally(NodeVisitorCB visitorCallback, Element xmlElem, String distID, String[] nodeList) throws XmlParserException {
        Trace.out((String)("Method Entry. xmlElem=" + xmlElem.getNodeName()));
        NodeList childNodeList = xmlElem.getChildNodes();
        for (int i = 0; i < childNodeList.getLength(); ++i) {
            Node childNode = childNodeList.item(i);
            if (childNode.getNodeType() != 1) continue;
            Trace.out((String)("Processing pCC , current Node Visited is =>" + childNode.getNodeName()));
            Element elem = (Element)childNodeList.item(i);
            if (elem.getNodeName().equals("CONDITION")) {
                boolean conditionEvaluationResult = false;
                String mConditionVar = this.getOptionalAttributeValue(elem, "VAR");
                PluggableTask varTask = null;
                if (mConditionVar == null) {
                    NodeList varTaskNL = this.getChildrenByTagName(elem, "VAR_TASK");
                    if (varTaskNL.getLength() > 0) {
                        varTask = this.parsePlacementTask((Element)varTaskNL.item(0), distID, nodeList);
                    } else {
                        throw new XmlParserException("VAR or VAR_TASK must be specified");
                    }
                }
                if (mConditionVar != null) {
                    String eq = this.getOptionalAttributeValue(elem, CDMConstraintTypes.EQUAL);
                    String eqNoCase = this.getOptionalAttributeValue(elem, "EQ_NO_CASE");
                    String ge = this.getOptionalAttributeValue(elem, CDMConstraintTypes.ATLEAST);
                    String le = this.getOptionalAttributeValue(elem, CDMConstraintTypes.ATMOST);
                    String gt = this.getOptionalAttributeValue(elem, CDMConstraintTypes.GREATER_THAN);
                    String lt = this.getOptionalAttributeValue(elem, CDMConstraintTypes.LESS_THAN);
                    String ne = this.getOptionalAttributeValue(elem, "NE");
                    String re = this.getOptionalAttributeValue(elem, "RE");
                    String type = this.getOptionalAttributeValue(elem, CDMConstraintTypes.TYPE);
                    if (eq != null || ge != null || le != null || gt != null || lt != null || eqNoCase != null || ne != null || re != null) {
                        RangeOfValue r = new RangeOfValue(this.getRangeType(type));
                        try {
                            this.manipulateRange(r, eq, eqNoCase, ge, le, gt, lt, ne, re);
                            String value = VerificationUtil.getVariableValue(mConditionVar);
                            conditionEvaluationResult = r.contains(value);
                        }
                        catch (InvalidRangeManipulationException e) {
                            throw new XmlParserException(e.getMessage(), e);
                        }
                    } else {
                        conditionEvaluationResult = VerificationUtil.evaluateCondition(mConditionVar);
                    }
                } else {
                    Trace.out((String)"Performing var task!!");
                    boolean perform = false;
                    if (varTask != null) {
                        varTask.setSilent(true);
                        perform = varTask.perform();
                    } else {
                        conditionEvaluationResult = false;
                    }
                    if (perform) {
                        conditionEvaluationResult = varTask.getResultSet().allSuccess();
                    }
                }
                if (conditionEvaluationResult) {
                    this.parseChildrenConditionally(visitorCallback, elem, distID, nodeList);
                    continue;
                }
                NodeList elseNodeList = this.getChildrenByTagName(elem, "ELSE");
                if (elseNodeList.getLength() != 1) continue;
                this.parseChildrenConditionally(visitorCallback, (Element)elseNodeList.item(0), distID, nodeList);
                continue;
            }
            Trace.out((String)("Non-condition node encountered =>" + elem.getNodeName()));
            visitorCallback.handle(elem, null, null, null);
        }
    }

    private RangeType getRangeType(String type) {
        if ("VERSION".equalsIgnoreCase(type)) {
            return RangeType.VERSION;
        }
        if ("NUMBER".equalsIgnoreCase(type)) {
            return RangeType.FLOAT;
        }
        return RangeType.STRING;
    }

    private void manipulateRange(RangeOfValue r, String eq, String eqNoCase, String ge, String le, String gt, String lt, String ne, String re) throws XmlParserException {
        RangeOperator ro = null;
        String expected = null;
        expected = eq;
        if (expected != null) {
            ro = RangeOperator.EQ;
        } else {
            expected = eqNoCase;
            if (expected != null) {
                ro = RangeOperator.EQ_NO_CASE;
            } else {
                expected = ge;
                if (expected != null) {
                    ro = RangeOperator.GE;
                } else {
                    expected = le;
                    if (expected != null) {
                        ro = RangeOperator.LE;
                    } else {
                        expected = gt;
                        if (expected != null) {
                            ro = RangeOperator.GT;
                        } else {
                            expected = lt;
                            if (expected != null) {
                                ro = RangeOperator.LT;
                            } else {
                                expected = ne;
                                if (expected != null) {
                                    ro = RangeOperator.NE;
                                } else {
                                    expected = re;
                                    if (expected != null) {
                                        ro = RangeOperator.RE;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        if (ro == null) {
            Trace.out((String)"Unable to get appropriate Operator");
            throw new XmlParserException(s_msgBundle.getMessage("0004", false));
        }
        try {
            r.include(ro, expected);
        }
        catch (InvalidRangeManipulationException e) {
            throw new XmlParserException(e.getMessage(), e);
        }
    }

    private NodeList getChildrenByTagName(Element elem, String tagName) {
        Trace.out((String)"Method Entry. elem=%s, tagName=%s", (Object[])new Object[]{elem.getTagName(), tagName});
        NodeList allChildren = elem.getChildNodes();
        final ArrayList<Node> _items = new ArrayList<Node>();
        NodeList immediateChildren = new NodeList(){

            @Override
            public int getLength() {
                return _items.size();
            }

            @Override
            public Node item(int paramInt) {
                return (Node)_items.get(paramInt);
            }
        };
        boolean j = false;
        for (int i = 0; i < allChildren.getLength(); ++i) {
            Node toddler = allChildren.item(i);
            if (toddler == null || !toddler.getNodeName().equals(tagName)) continue;
            _items.add(toddler);
            Trace.out((String)("Adding the node " + toddler.getNodeName()));
        }
        return immediateChildren;
    }

    private List<PluggableTask> parseTaskList(Element tlElem, final String distID, final String[] nodeList) throws XmlParserException {
        Trace.out((String)"Method Entry. tlElem=%s, distID=%s", (Object[])new Object[]{tlElem.getTagName(), distID});
        final ArrayList<PluggableTask> pluggableTaskList = new ArrayList<PluggableTask>();
        Trace.out((String)("(init)pluggableTaskList.size(): '" + pluggableTaskList.size() + "'"));
        this.parseChildrenConditionally(new NodeVisitorCB(){

            @Override
            public void handle(Element elem, String conditionVar, String choiceVar, String selection) throws XmlParserException {
                if (elem.getNodeName().equals("TASK")) {
                    Trace.out((String)"NodeVisitorCB handle called , adding Task list");
                    PluggableTask task = PluggableConfigXmlParser.this.parsePlacementTask(elem, distID, nodeList);
                    if (task != null) {
                        pluggableTaskList.add(task);
                    }
                }
            }
        }, tlElem, distID, nodeList);
        Trace.out((String)("(return)pluggableTaskList.size(): '" + pluggableTaskList.size() + "'"));
        return pluggableTaskList;
    }

    private String getConnectDescriptor(DatabaseConnectInfo dbConInfo) throws XmlParserException {
        if (this.m_dbConnDescr != null) {
            return this.m_dbConnDescr;
        }
        try {
            Version crsVer = VerificationUtil.getCRSActiveVersionObj();
            DBUtils dbUtils = new DBUtils(crsVer);
            String dbName = dbConInfo.dbUniqueName();
            this.m_dbConnDescr = dbUtils.isPortRequiredForConnect(dbName) ? dbUtils.getConnectDescriptor(dbName, dbConInfo.listenerPort()) : dbUtils.getConnectDescriptor(dbName);
        }
        catch (DBUtilsException dbuEx) {
            Trace.out((String)("DBUtilsException. message " + dbuEx.getMessage()));
            Trace.out((Exception)dbuEx);
            throw new XmlParserException(dbuEx.getMessage());
        }
        return this.m_dbConnDescr;
    }

    private void sqlPluggableTask(PluggableTask task) throws XmlParserException {
        try {
            DatabaseConnectInfo dbConInfo = null;
            dbConInfo = DatabaseConnectInfo.getDatabaseConnectInfos().toArray(new DatabaseConnectInfo[0])[0];
            String dbName = dbConInfo.dbUniqueName();
            String user = dbConInfo.userName();
            String passwd = dbConInfo.userPassword();
            String conDescr = this.getConnectDescriptor(dbConInfo);
            ArrayList<ExecutableArgument> execArgs = new ArrayList<ExecutableArgument>();
            execArgs.add(new ExecutableArgument("DB_NAME", ArgType.DEFINED, DataType.STRING, dbName));
            execArgs.add(new ExecutableArgument("DB_PWD", ArgType.DEFINED, DataType.STRING, passwd));
            execArgs.add(new ExecutableArgument("DB_DESCR", ArgType.DEFINED, DataType.STRING, conDescr));
            execArgs.add(new ExecutableArgument("DB_USER", ArgType.DEFINED, DataType.STRING, user));
            ExecutableInfo ei = task.getExecutableInfo();
            ei.setExecutableArgs(execArgs);
        }
        catch (DatabaseConnectInfoException dcEx) {
            Trace.out((String)("DatabaseConnectInfoException occured while getting databases conect info. message " + dcEx.getMessage()));
            Trace.out((Exception)dcEx);
        }
        catch (Exception ex) {
            Trace.out((String)("Exception: class" + ex.getClass()));
            Trace.out((String)("Exception: message" + ex.getMessage()));
        }
    }

    private PluggableTask parsePlacementTask(Element elTask, String distID, String[] nodeList) throws XmlParserException {
        String moreDetailsId;
        Trace.out((int)5, (String)"Method Entry.elTask.getElementName=%s, distID=%s", (Object[])new Object[]{elTask.getTagName(), distID});
        String taskID = this.getRequiredAttributeValue(elTask, "ID");
        PluggableTask pluggableTask = this.parseTask(taskID, nodeList, distID);
        if (pluggableTask == null) {
            Trace.out((String)"Returning NULL");
            return null;
        }
        String severityStr = this.getOptionalAttributeValue(elTask, "SEVERITY");
        if (severityStr != null) {
            SeverityType severity = this.getSeverityAttributeValue(severityStr);
            pluggableTask.setSeverity(severity);
        }
        String idMsgParamsStr = this.getOptionalAttributeValue(elTask, "ID_MSG_PARAMS");
        String[] idMsgParams = null;
        if (VerificationUtil.isStringGood(idMsgParamsStr)) {
            idMsgParams = idMsgParamsStr.split(",");
            pluggableTask.setIdMsgParams(idMsgParams);
        }
        if ((moreDetailsId = this.getOptionalAttributeValue(elTask, "MORE_DETAILS_ID")) != null) {
            String moreDetails = this.getMoreDetailsMsg(moreDetailsId);
            pluggableTask.setMoreDetails(moreDetails);
        }
        String bestPracticeStr = this.getOptionalAttributeValue(elTask, "BEST_PRACTICE");
        boolean bestPractice = "true".equalsIgnoreCase(bestPracticeStr);
        pluggableTask.setBestPractice(bestPractice);
        NodeList referenceNodeList = elTask.getElementsByTagName("REFERENCE");
        if (referenceNodeList.getLength() > 0) {
            ArrayList<String> referenceList = new ArrayList<String>();
            for (int i = 0; i < referenceNodeList.getLength(); ++i) {
                Element referenceElement = (Element)referenceNodeList.item(i);
                String reference = referenceElement.getFirstChild().getNodeValue();
                if (reference == null) continue;
                referenceList.add(reference.trim());
            }
            pluggableTask.setReferences(referenceList);
        }
        ExecutableInfo ei = pluggableTask.getExecutableInfo();
        if (this.getFirstChildByTagName(elTask, "EXECUTABLE_ARGUMENTS") != null) {
            NodeList externalExecArgsList = elTask.getElementsByTagName("ARG");
            for (int i = 0; i < externalExecArgsList.getLength(); ++i) {
                Element argElement = (Element)externalExecArgsList.item(i);
                String argName = this.getRequiredAttributeValue(this.getFirstChildByTagName(argElement, "NAME"), "VALUE");
                String argType = this.getRequiredAttributeValue(this.getFirstChildByTagName(argElement, "TYPE"), "VALUE");
                String argValue = null;
                ArgType execArgType = null;
                Element valElem = this.getFirstChildByTagName(argElement, "VAL");
                Element varElem = this.getFirstChildByTagName(argElement, "VAR");
                if (valElem != null) {
                    argValue = this.getRequiredAttributeValue(valElem, "VALUE");
                    execArgType = ArgType.DEFINED;
                } else if (varElem != null) {
                    argValue = this.getRequiredAttributeValue(varElem, "VALUE");
                    execArgType = ArgType.DERIVED;
                } else {
                    throw new XmlParserException("Argument VAL or VAR not specified");
                }
                DataType execArgDataType = this.mapDataType(argType);
                ExecutableArgument execArg = new ExecutableArgument(argName, execArgType, execArgDataType, argValue);
                ei.replaceExecArgument(execArg);
            }
        }
        if (this.getFirstChildByTagName(elTask, "ANALYZER") != null) {
            this.parseAnalyzer(taskID, elTask, ei);
        }
        if (pluggableTask.getExecutableInfo().getExecutableType() == ExecutableType.SQL) {
            this.sqlPluggableTask(pluggableTask);
        }
        return pluggableTask;
    }

    private PluggableTask parseTask(String taskID, String[] nodeList, String distID) throws XmlParserException {
        String moreDetails;
        String moreDetailsId;
        Trace.out((String)("Method Entry. taskID=" + taskID));
        NodeList taskDefList = this.m_rootElement.getElementsByTagName("TASK_DEFINITION");
        Element taskElem = null;
        for (int i = 0; i < taskDefList.getLength(); ++i) {
            Element e = (Element)taskDefList.item(i);
            if (!this.getRequiredAttributeValue(e, "ID").equals(taskID)) continue;
            taskElem = e;
            break;
        }
        if (taskElem == null) {
            Trace.out((String)"Returning NULL");
            return null;
        }
        PluggableConstants.ModeType applicableMode = PluggableConstants.ModeType.ALL;
        String modeTypeStr = this.getOptionalAttributeValue(taskElem, "MODE_APPLICABLE");
        if (VerificationUtil.isStringGood(modeTypeStr)) {
            applicableMode = this.getModeTypeAttributeValue(modeTypeStr);
        }
        if (!this.isApplicableForCurrentOperationMode(applicableMode)) {
            Trace.out((String)("Pluggable Task " + taskID + " with applicable mode " + applicableMode.toString() + " is not applicable to this operation mode " + (Object)((Object)this.m_currentOperationMode)));
            VerificationLogData.log("Pluggable Task " + taskID + " with applicable mode " + applicableMode.toString() + " is not applicable to this operation mode " + (Object)((Object)this.m_currentOperationMode));
            return null;
        }
        if (!this.isApplicableToCurrentOS(taskElem, distID)) {
            Trace.out((String)"Not applicable, returning NULL");
            return null;
        }
        String rootPrivilegeRequiredStr = this.getOptionalAttributeValue(taskElem, "ROOT_PRIVILEGE_REQUIRED");
        boolean rootPrivilegeRequired = "true".equalsIgnoreCase(rootPrivilegeRequiredStr);
        String severityStr = this.getOptionalAttributeValue(taskElem, "SEVERITY");
        String idMsgParamsStr = this.getOptionalAttributeValue(taskElem, "ID_MSG_PARAMS");
        String[] idMsgParams = null;
        if (VerificationUtil.isStringGood(idMsgParamsStr)) {
            idMsgParams = idMsgParamsStr.split(",");
        }
        ExecutableInfo ei = this.parseExecutableInfo(taskID, taskElem);
        List<InitialValidation> initValList = this.parseInitialValidationList(taskElem);
        PluggableTask plTask = null;
        plTask = ei.getExecutableType().equals((Object)ExecutableType.JAVA) ? this.createPluggableJavaTask(taskID, idMsgParams, nodeList, ei) : new PluggableTask(new PluggableTaskContext(taskID, nodeList, ei, idMsgParams, this.m_darwinChecks));
        plTask.setInitialValidation(initValList);
        if (severityStr != null) {
            SeverityType severity = this.getSeverityAttributeValue(severityStr);
            plTask.setSeverity(severity);
        }
        if ((moreDetailsId = this.getOptionalAttributeValue(taskElem, "MORE_DETAILS_ID")) != null && (moreDetails = this.getMoreDetailsMsg(moreDetailsId)) != null) {
            plTask.setMoreDetails(moreDetails);
        }
        String bestPracticeStr = this.getOptionalAttributeValue(taskElem, "BEST_PRACTICE");
        boolean bestPractice = "true".equalsIgnoreCase(bestPracticeStr);
        plTask.setBestPractice(bestPractice);
        NodeList referenceNodeList = taskElem.getElementsByTagName("REFERENCE");
        if (referenceNodeList.getLength() > 0) {
            ArrayList<String> referenceList = new ArrayList<String>();
            for (int i = 0; i < referenceNodeList.getLength(); ++i) {
                Element referenceElement = (Element)referenceNodeList.item(i);
                String reference = referenceElement.getFirstChild().getNodeValue();
                if (reference == null) continue;
                referenceList.add(reference.trim());
            }
            plTask.setReferences(referenceList);
        }
        return plTask;
    }

    private PluggableJavaTask createPluggableJavaTask(String taskID, String[] idMsgParams, String[] nodeList, ExecutableInfo execInfo) throws XmlParserException {
        String className = "oracle.cluster.verification.pluggable.task." + execInfo.getExecutableName();
        Trace.out((String)("Creating Pluggable java task object for \nClass: " + className));
        List<ExecutableArgument> argList = execInfo.getExecutableArgs();
        for (ExecutableArgument eArg : argList) {
            String argVal = eArg.getArgVal();
            if (eArg.getArgType() == ArgType.DERIVED && VerificationUtil.isStringGood(argVal)) {
                argVal = VerificationUtil.getVariableValue(argVal);
            }
            if (VerificationUtil.isStringGood(argVal)) {
                eArg.setArgVal(argVal);
                continue;
            }
            eArg.setArgVal("");
        }
        PluggableTaskContext taskData = new PluggableTaskContext(taskID, nodeList, execInfo, idMsgParams, this.m_darwinChecks);
        try {
            Class<?> pluggableJavaTaskClass = Class.forName(className);
            Class[] clsArr = new Class[]{PluggableTaskContext.class};
            Constructor<?> object = pluggableJavaTaskClass.getConstructor(clsArr);
            Trace.out((String)("Successfully Created object of \nClass: " + object.getName() + "\nConstructor Details: " + object.toGenericString()));
            Object[] params = new Object[]{taskData};
            return (PluggableJavaTask)object.newInstance(params);
        }
        catch (NoSuchMethodException e) {
            Trace.out((String)("Constructor " + execInfo.getExecutableName() + " not found in class " + className + " Error: " + e.getMessage()));
            VerificationLogData.logError("Constructor " + execInfo.getExecutableName() + " not found in class " + className + " Error: " + e.getMessage());
            throw new XmlParserException(e.getMessage());
        }
        catch (InstantiationException e) {
            Trace.out((String)("error while constructing " + execInfo.getExecutableName() + " from class " + className + " Error: " + e.getMessage()));
            VerificationLogData.logError("error while constructing " + execInfo.getExecutableName() + " from class " + className + " Error: " + e.getMessage());
            throw new XmlParserException(e.getMessage());
        }
        catch (ClassNotFoundException e) {
            Trace.out((String)("Class " + className + " not found: " + e.getMessage()));
            VerificationLogData.logError("Class " + className + " not found: " + e.getMessage());
            throw new XmlParserException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            Trace.out((String)("Illegal Access while constructing object of class " + className + " Error is :\n" + e.getMessage()));
            VerificationLogData.logError("Illegal Access while constructing object of class " + className + " Error is :\n" + e.getMessage());
            throw new XmlParserException(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            Trace.out((String)("IllegalArgumentException while constructing object of class " + className + " Error is :\n" + e.getMessage()));
            VerificationLogData.logError("IllegalArgumentException while constructing object of class " + className + " Error is :\n" + e.getMessage());
            throw new XmlParserException(e.getMessage());
        }
        catch (InvocationTargetException e) {
            Trace.out((String)("InvocationTargetException while constructing object of class " + className + " Error is :\n" + e.getMessage()));
            VerificationLogData.logError("InvocationTargetException while constructing object of class " + className + " Error is :\n" + e.getMessage());
            throw new XmlParserException(e.getMessage());
        }
        catch (ClassCastException e) {
            Trace.out((String)("ClassCastException while casting the object of class " + className + " to PluggableJavaTask, Error is :\n" + e.getMessage()));
            VerificationLogData.logError("ClassCastException while constructing object of class " + className + " to PluggableJavaTask, Error is :\n" + e.getMessage());
            throw new XmlParserException(e.getMessage());
        }
    }

    private String getMoreDetailsMsg(String msgId) {
        String message = null;
        try {
            Class<PrveMsgID> c = PrveMsgID.class;
            Field f = c.getField(msgId);
            String msgID = null;
            if (f != null) {
                msgID = f.get(null).toString();
            }
            message = msgID != null ? s_prveMsgBundle.getMessage(msgID, false) : null;
        }
        catch (IllegalArgumentException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (SecurityException e) {
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return message;
    }

    private List<InitialValidation> parseInitialValidationList(Element taskElem) {
        NodeList dbInstalled;
        ArrayList<InitialValidation> initValList = new ArrayList<InitialValidation>();
        NodeList crsInstalled = taskElem.getElementsByTagName("CRS_INSTALLED");
        if (crsInstalled.getLength() > 0) {
            initValList.add(InitialValidation.CRS_INSTALL);
        }
        if ((dbInstalled = taskElem.getElementsByTagName("DB_INSTALLED")).getLength() > 0) {
            initValList.add(InitialValidation.DB_INSTALL);
        }
        return initValList;
    }

    private boolean isApplicableToCurrentOS(Element taskElem, String distID) throws DOMException, XmlParserException {
        NodeList osNL = taskElem.getElementsByTagName("OPERATING_SYSTEM");
        if (osNL.getLength() == 0) {
            return true;
        }
        for (int i = 0; i < osNL.getLength(); ++i) {
            Element osElem = (Element)osNL.item(i);
            String osType = this.getFirstChildByTagName(osElem, "TYPE").getFirstChild().getNodeValue();
            String osVersion = this.getFirstChildByTagName(osElem, "VERSION").getFirstChild().getNodeValue();
            String osArchitecture = this.getFirstChildByTagName(osElem, "ARCHITECTURE").getFirstChild().getNodeValue();
            if (!this.matchOSType(osType) || !this.matchOSVersion(osVersion, distID) || !this.matchOSArchitecture(osArchitecture)) continue;
            return true;
        }
        return false;
    }

    private boolean matchOSType(String osType) {
        boolean osTypeMatches = false;
        if (osType.equalsIgnoreCase("all")) {
            osTypeMatches = true;
        } else if (osType.equalsIgnoreCase("unix")) {
            osTypeMatches = new SystemFactory().CreateSystem().isUnixSystem();
        } else if (osType.equalsIgnoreCase("windows")) {
            osTypeMatches = !new SystemFactory().CreateSystem().isUnixSystem();
        } else if (osType.equalsIgnoreCase(VerificationUtil.getCurrentOS())) {
            osTypeMatches = true;
        }
        return osTypeMatches;
    }

    private boolean matchOSVersion(String osVersion, String distID) {
        boolean matches = false;
        if (osVersion.equalsIgnoreCase("all")) {
            matches = true;
        } else if (this.m_darwinChecks) {
            String osV;
            String[] osVersions;
            String[] arr$ = osVersions = osVersion.split("/");
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && !(matches = (osV = arr$[i$]).equalsIgnoreCase(distID)); ++i$) {
            }
        } else {
            matches = osVersion.equalsIgnoreCase(distID);
        }
        return matches;
    }

    private boolean matchOSArchitecture(String string) {
        boolean matches = false;
        if (string.equalsIgnoreCase("all")) {
            matches = true;
        } else {
            String archRegEx = string.replaceAll("\\*", ".*");
            Pattern archPtn = Pattern.compile(archRegEx, 2);
            String osArch = VerificationUtil.getCurrentArch();
            if (osArch != null) {
                matches = archPtn.matcher(osArch).matches();
            }
        }
        return matches;
    }

    private ExecutableInfo parseExecutableInfo(String taskID, Element taskElem) throws XmlParserException {
        Trace.out((String)"Method Entry.");
        ExecutableInfo ei = null;
        Element execInfoElem = this.getFirstChildByTagName(taskElem, "EXECUTABLE_INFO");
        String type = this.getRequiredAttributeValue(execInfoElem, "TYPE");
        ExecutableType execType = this.mapExecutableType(type);
        Element execResultTypeElem = this.getFirstChildByTagName(execInfoElem, "RESULT_TYPE");
        ExecutableResultType execResultType = ExecutableResultType.ANALYZED;
        if (this.getRequiredAttributeValue(execResultTypeElem, "VALUE").equals("TO_BE_ANALYZED")) {
            execResultType = ExecutableResultType.TO_BE_ANALYZED;
        }
        NodeList inlineElemNL = execInfoElem.getElementsByTagName("INLINE");
        NodeList javaTaskElemNL = execInfoElem.getElementsByTagName("JAVATASK");
        if (inlineElemNL.getLength() > 0) {
            Element inlineElem = (Element)inlineElemNL.item(0);
            String execName = this.getRequiredAttributeValue(inlineElem, "VALUE");
            ei = new ExecutableInfo(execName, execType, execResultType);
            NodeList externalExecArgsList = inlineElem.getElementsByTagName("ARG");
            for (int i = 0; i < externalExecArgsList.getLength(); ++i) {
                Element argElement = (Element)externalExecArgsList.item(i);
                String argName = this.getRequiredAttributeValue(this.getFirstChildByTagName(argElement, "NAME"), "VALUE");
                String argType = this.getRequiredAttributeValue(this.getFirstChildByTagName(argElement, "TYPE"), "VALUE");
                String argValue = null;
                ArgType execArgType = null;
                Element valElem = this.getFirstChildByTagName(argElement, "VAL");
                Element varElem = this.getFirstChildByTagName(argElement, "VAR");
                if (valElem != null) {
                    argValue = this.getRequiredAttributeValue(valElem, "VALUE");
                    execArgType = ArgType.DEFINED;
                } else if (varElem != null) {
                    argValue = this.getRequiredAttributeValue(varElem, "VALUE");
                    execArgType = ArgType.DERIVED;
                } else {
                    throw new XmlParserException("Argument VAL or VAR not specified");
                }
                DataType execArgDataType = this.mapDataType(argType);
                ExecutableArgument execArg = new ExecutableArgument(argName, execArgType, execArgDataType, argValue);
                ei.addExecArgument(execArg);
            }
        } else if (javaTaskElemNL.getLength() > 0) {
            Element javaTaskElem = (Element)javaTaskElemNL.item(0);
            String javaTaskName = this.getRequiredAttributeValue(javaTaskElem, "NAME");
            ei = new ExecutableInfo(javaTaskName, execType, execResultType);
            NodeList methodArgsList = javaTaskElem.getElementsByTagName("ARG");
            for (int i = 0; i < methodArgsList.getLength(); ++i) {
                Element argElement = (Element)methodArgsList.item(i);
                String argName = this.getRequiredAttributeValue(this.getFirstChildByTagName(argElement, "NAME"), "VALUE");
                String argType = this.getRequiredAttributeValue(this.getFirstChildByTagName(argElement, "TYPE"), "VALUE");
                String argValue = null;
                ArgType methodArgType = null;
                Element valElem = this.getFirstChildByTagName(argElement, "VAL");
                Element varElem = this.getFirstChildByTagName(argElement, "VAR");
                if (valElem != null) {
                    argValue = this.getRequiredAttributeValue(valElem, "VALUE");
                    methodArgType = ArgType.DEFINED;
                } else if (varElem != null) {
                    argValue = this.getRequiredAttributeValue(varElem, "VALUE");
                    methodArgType = ArgType.DERIVED;
                } else {
                    throw new XmlParserException("Argument VAL or VAR not specified");
                }
                DataType methodArgDataType = this.mapDataType(argType);
                ExecutableArgument methodArg = new ExecutableArgument(argName, methodArgType, methodArgDataType, argValue);
                ei.addExecArgument(methodArg);
            }
        } else {
            Element externalExecElement = this.getFirstChildByTagName(execInfoElem, "EXTERNAL");
            Element externalExecNameElem = this.getFirstChildByTagName(externalExecElement, "NAME");
            String execName = this.getRequiredAttributeValue(externalExecNameElem, "VALUE");
            ei = new ExecutableInfo(execName, execType, execResultType);
            NodeList externalExecArgsList = externalExecElement.getElementsByTagName("ARG");
            for (int i = 0; i < externalExecArgsList.getLength(); ++i) {
                Element argElement = (Element)externalExecArgsList.item(i);
                String argName = this.getRequiredAttributeValue(this.getFirstChildByTagName(argElement, "NAME"), "VALUE");
                String argType = this.getRequiredAttributeValue(this.getFirstChildByTagName(argElement, "TYPE"), "VALUE");
                String argValue = null;
                ArgType execArgType = null;
                Element valElem = this.getFirstChildByTagName(argElement, "VAL");
                Element varElem = this.getFirstChildByTagName(argElement, "VAR");
                if (valElem != null) {
                    argValue = this.getRequiredAttributeValue(valElem, "VALUE");
                    execArgType = ArgType.DEFINED;
                } else if (varElem != null) {
                    argValue = this.getRequiredAttributeValue(varElem, "VALUE");
                    execArgType = ArgType.DERIVED;
                } else {
                    throw new XmlParserException("Argument VAL or VAR not specified");
                }
                DataType execArgDataType = this.mapDataType(argType);
                ExecutableArgument execArg = new ExecutableArgument(argName, execArgType, execArgDataType, argValue);
                ei.addExecArgument(execArg);
            }
        }
        if (execResultType.equals((Object)ExecutableResultType.TO_BE_ANALYZED)) {
            this.parseAnalyzer(taskID, taskElem, ei);
        }
        return ei;
    }

    private void parseAnalyzer(String taskID, Element taskElem, ExecutableInfo ei) throws XmlParserException {
        Trace.out((String)"Method Entry.");
        Element analyzerElem = this.getFirstChildByTagName(taskElem, "ANALYZER");
        Element standardAnalyzerElem = this.getFirstChildByTagName(analyzerElem, "STANDARD_ANALYZER");
        Element sqlAnalyzerElem = this.getFirstChildByTagName(analyzerElem, "SQL_ANALYZER");
        DataComparator dc = null;
        if (standardAnalyzerElem != null) {
            Element comparatorElem = this.getFirstChildByTagName(standardAnalyzerElem, "COMPARATOR");
            dc = new StdDataComparator(this.parseReferenceInfo(comparatorElem));
        } else if (sqlAnalyzerElem != null) {
            String refColumn = null;
            boolean emptyResultSetImpliesSuccess = "true".equalsIgnoreCase(this.getOptionalAttributeValue(sqlAnalyzerElem, "EMPTY_RESULTSET_IMPLIES_SUCCESS"));
            ArrayList<ReferenceInfo> columnReferenceList = new ArrayList<ReferenceInfo>();
            Element referenceColumnElem = this.getFirstChildByTagName(analyzerElem, "REFERENCE_COLUMN");
            if (referenceColumnElem != null) {
                refColumn = this.getRequiredAttributeValue(referenceColumnElem, "NAME");
            }
            NodeList refColumnNodeList = analyzerElem.getElementsByTagName("COLUMN");
            ArrayList<String> columnNameList = new ArrayList<String>();
            for (int i = 0; i < refColumnNodeList.getLength(); ++i) {
                Element columnElem = (Element)refColumnNodeList.item(i);
                columnNameList.add(this.getRequiredAttributeValue(columnElem, "NAME"));
                Element comparatorElem = this.getFirstChildByTagName(columnElem, "COMPARATOR");
                columnReferenceList.add(this.parseReferenceInfo(comparatorElem));
            }
            dc = this.m_darwinChecks ? new DarwinSQLDataComparator(taskID, refColumn, columnNameList, columnReferenceList, emptyResultSetImpliesSuccess) : new SQLDataComparator(taskID, refColumn, columnNameList, columnReferenceList, emptyResultSetImpliesSuccess);
        } else {
            Element externalAnalyzerElem = this.getFirstChildByTagName(analyzerElem, "EXTERNAL_ANALYZER");
            String globalAnalyzerStr = this.getOptionalAttributeValue(externalAnalyzerElem, "GLOBAL_ANALYZER");
            boolean globalAnalyzer = "TRUE".equalsIgnoreCase(globalAnalyzerStr);
            ExecutableInfo analyzerExecInfo = this.parseExecutableInfo(taskID, externalAnalyzerElem);
            analyzerExecInfo.setLocalNodeCheck(globalAnalyzer);
            dc = new ExternalDataComparator(analyzerExecInfo);
        }
        ei.setDataComparator(dc);
    }

    private ReferenceInfo parseReferenceInfo(Element comparatorElem) throws XmlParserException {
        String type = this.getRequiredAttributeValue(comparatorElem, "TYPE");
        DataType referenceDataType = this.mapDataType(type);
        DataComparatorType referenceDCT = null;
        Object referenceDataValue = null;
        String eq = this.getOptionalAttributeValue(comparatorElem, "EQ");
        String eq_no_case = this.getOptionalAttributeValue(comparatorElem, "EQ_NO_CASE");
        String ge = this.getOptionalAttributeValue(comparatorElem, "GE");
        String gt = this.getOptionalAttributeValue(comparatorElem, "GT");
        String le = this.getOptionalAttributeValue(comparatorElem, "LE");
        String lt = this.getOptionalAttributeValue(comparatorElem, "LT");
        String re = this.getOptionalAttributeValue(comparatorElem, "RE");
        String ne = this.getOptionalAttributeValue(comparatorElem, "NE");
        if (eq_no_case != null) {
            if (type.equalsIgnoreCase("STRING")) {
                referenceDataValue = eq_no_case;
                referenceDCT = DataComparatorType.EQ_NO_CASE;
            } else {
                eq = eq_no_case;
            }
        }
        if (eq != null) {
            referenceDataValue = eq;
            referenceDCT = DataComparatorType.EQ;
        } else if (ne != null) {
            referenceDataValue = ne;
            referenceDCT = DataComparatorType.NE;
        } else if (re != null) {
            referenceDataValue = re;
            referenceDCT = DataComparatorType.RE;
        } else if (ge != null) {
            if (le != null) {
                referenceDCT = DataComparatorType.RANGE;
                RangeOfValue rov = new RangeOfValue(this.mapRangeType(type));
                try {
                    rov.include(RangeOperator.GE, ge, RangeOperator.LE, le);
                }
                catch (InvalidRangeManipulationException e) {
                    throw new XmlParserException(e.getMessage(), e);
                }
                referenceDataValue = rov;
            } else if (lt != null) {
                referenceDCT = DataComparatorType.RANGE;
                RangeOfValue rov = new RangeOfValue(this.mapRangeType(type));
                try {
                    rov.include(RangeOperator.GE, ge, RangeOperator.LT, le);
                }
                catch (InvalidRangeManipulationException e) {
                    throw new XmlParserException(e.getMessage(), e);
                }
                referenceDataValue = rov;
            } else {
                referenceDCT = DataComparatorType.GE;
                referenceDataValue = ge;
            }
        } else if (gt != null) {
            if (le != null) {
                referenceDCT = DataComparatorType.RANGE;
                RangeOfValue rov = new RangeOfValue(this.mapRangeType(type));
                try {
                    rov.include(RangeOperator.GT, gt, RangeOperator.LE, le);
                }
                catch (InvalidRangeManipulationException e) {
                    throw new XmlParserException(e.getMessage(), e);
                }
                referenceDataValue = rov;
            } else if (lt != null) {
                referenceDCT = DataComparatorType.RANGE;
                RangeOfValue rov = new RangeOfValue(this.mapRangeType(type));
                try {
                    rov.include(RangeOperator.GT, gt, RangeOperator.LT, le);
                }
                catch (InvalidRangeManipulationException e) {
                    throw new XmlParserException(e.getMessage(), e);
                }
                referenceDataValue = rov;
            } else {
                referenceDCT = DataComparatorType.GT;
                referenceDataValue = gt;
            }
        } else if (le != null) {
            referenceDCT = DataComparatorType.LE;
            referenceDataValue = le;
        } else if (lt != null) {
            referenceDCT = DataComparatorType.LT;
            referenceDataValue = lt;
        }
        return new ReferenceInfo(referenceDataType, referenceDataValue, referenceDCT);
    }

    private ExecutableType mapExecutableType(String executableType) {
        Trace.out((int)5, (String)"Method Entry. executableType=%s", (Object[])new Object[]{executableType});
        ExecutableType et = ExecutableType.SHELL;
        if ("PERL".equalsIgnoreCase(executableType)) {
            et = ExecutableType.PERL;
        } else if ("SQL".equalsIgnoreCase(executableType)) {
            et = ExecutableType.SQL;
        } else if ("PLSQL".equalsIgnoreCase(executableType)) {
            et = ExecutableType.PLSQL;
        } else if ("NATIVE".equalsIgnoreCase(executableType)) {
            et = ExecutableType.NATIVE_EXEC;
        } else if ("JAVA".equalsIgnoreCase(executableType)) {
            et = ExecutableType.JAVA;
        }
        return et;
    }

    private DataType mapDataType(String dataType) {
        Trace.out((int)5, (String)"Method Entry. dataType=%s", (Object[])new Object[]{dataType});
        DataType dt = DataType.STRING;
        if ("NUMERIC".equalsIgnoreCase(dataType)) {
            dt = DataType.NUMERIC;
        } else if ("VERSION".equalsIgnoreCase(dataType)) {
            dt = DataType.VERSION;
        } else if ("LIST".equalsIgnoreCase(dataType)) {
            dt = DataType.LIST;
        } else if ("EXECUTABLE".equalsIgnoreCase(dataType)) {
            dt = DataType.EXECUTABLE;
        }
        return dt;
    }

    private RangeType mapRangeType(String dataType) {
        Trace.out((int)5, (String)"Method Entry. dataType=%s", (Object[])new Object[]{dataType});
        RangeType rt = RangeType.STRING;
        if ("NUMERIC".equals(dataType)) {
            rt = RangeType.FLOAT;
        } else if ("VERSION".equals(dataType)) {
            rt = RangeType.VERSION;
        }
        return rt;
    }

    private String getRequiredAttributeValue(Element elem, String key) throws XmlParserException {
        if (!elem.hasAttribute(key)) {
            String[] msgParams = new String[]{elem.getTagName(), key};
            String msg = "A required attribute is missing";
            Trace.out((String)msg);
            throw new XmlParserException(msg);
        }
        String value = elem.getAttribute(key);
        return value;
    }

    private String getOptionalAttributeValue(Element elem, String key) {
        String attributeValue = null;
        if (elem.hasAttribute(key)) {
            attributeValue = elem.getAttribute(key);
        }
        return attributeValue;
    }

    private Element getFirstChildByTagName(Element osElem, String elemName) throws XmlParserException {
        if (osElem == null || elemName == null) {
            return null;
        }
        NodeList nl = osElem.getElementsByTagName(elemName);
        if (nl.getLength() >= 1) {
            return (Element)nl.item(0);
        }
        return null;
    }

    private SeverityType getSeverityAttributeValue(String severityStr) throws XmlParserException {
        SeverityType severity = SeverityType.CRITICAL;
        if ("IGNORABLE".equalsIgnoreCase(severityStr)) {
            severity = SeverityType.IGNORABLE;
        }
        return severity;
    }

    private PluggableConstants.ModeType getModeTypeAttributeValue(String modeTypeStr) throws XmlParserException {
        PluggableConstants.ModeType mode = PluggableConstants.ModeType.ALL;
        if (!VerificationUtil.isStringGood(modeTypeStr)) {
            mode = PluggableConstants.ModeType.ALL;
        } else if ("API".equalsIgnoreCase(modeTypeStr)) {
            mode = PluggableConstants.ModeType.API;
        } else if ("COMMANDLINE".equalsIgnoreCase(modeTypeStr)) {
            mode = PluggableConstants.ModeType.COMMANDLINE;
        } else if ("BESTPRACTICE".equalsIgnoreCase(modeTypeStr)) {
            mode = PluggableConstants.ModeType.BESTPRACTICE;
        }
        return mode;
    }

    private boolean isApplicableForCurrentOperationMode(PluggableConstants.ModeType taskMode) {
        if (this.m_currentOperationMode == null) {
            return false;
        }
        if (taskMode == PluggableConstants.ModeType.ALL) {
            return true;
        }
        if (this.m_currentOperationMode == ParamManager.OperationMode.MODE_CLI && taskMode == PluggableConstants.ModeType.COMMANDLINE) {
            return true;
        }
        if (this.m_currentOperationMode == ParamManager.OperationMode.MODE_API && taskMode == PluggableConstants.ModeType.API) {
            return true;
        }
        return this.m_currentOperationMode == ParamManager.OperationMode.MODE_BEST_PRACTICE && taskMode == PluggableConstants.ModeType.BESTPRACTICE;
    }

    public static void main(String[] args) {
        String tracePackages = new String("oracle.cluster.verification.constraints,oracle.cluster.verification.constraints.parser");
        if (System.getSecurityManager() == null) {
            System.setSecurityManager((SecurityManager)new NullSecurityManager());
        }
        System.setProperty("TRACING.ENABLED", "true");
        System.setProperty("TRACING.LEVEL", "5");
        System.setProperty("TRACING.PACKAGE", tracePackages);
        String logDir = VerificationUtil.getTraceLoc();
        if (logDir == null) {
            logDir = VerificationUtil.getCVHome();
        }
        if (logDir == null) {
            logDir = "./";
        }
        Trace.out((String)("logDir = " + logDir));
        Trace.out((String)("log file = " + logDir + "trace.log"));
        Trace.configure((boolean)true, (boolean)true, (boolean)true, (boolean)true, (String)(logDir + "trace.log"), (boolean)true);
        ParamManager paramMgr = null;
        try {
            paramMgr = ParamManager.getInstance(ParamManager.OperationMode.MODE_API, args);
        }
        catch (InvalidCommandlineException e) {
            e.printStackTrace();
        }
        String[] nodelist = null;
        try {
            nodelist = VerificationUtil.getNodelist();
        }
        catch (NodelistNotFoundException e) {
            e.printStackTrace();
        }
        String classpath = System.getProperty("CLASSPATH");
        Trace.out((String)("System property CLASSPATH: " + classpath));
        String cp = System.getenv("CLASSPATH");
        Trace.out((String)("Env CLASSPATH: " + cp));
        PluggableConfigXmlParser parser = new PluggableConfigXmlParser();
        try {
            List<PluggableTask> taskList = parser.getTasks("11gR2", "OEL5", "STAGE_PRE_CRSINST", null);
            if (taskList != null) {
                for (PluggableTask task : taskList) {
                    System.out.println(task);
                }
            }
        }
        catch (XmlParserException e) {
            e.printStackTrace(System.out);
        }
        catch (Exception xe) {
            xe.printStackTrace(System.out);
        }
    }
}

