/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.verification.util;

import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.trace.Trace;

public class DatabaseInfo {
    private String m_dbUniqueName;
    private String m_dbDomain;
    private String m_dbHome;
    private Version m_dbVersion;

    public DatabaseInfo(String dbUniqueName, String domain, Version v, String dbHome) {
        this.m_dbUniqueName = dbUniqueName;
        this.m_dbDomain = domain;
        this.m_dbHome = dbHome;
        this.m_dbVersion = v;
    }

    public String getUniqueName() {
        return this.m_dbUniqueName;
    }

    public String getDomainName() {
        return this.m_dbDomain;
    }

    public String getDefaultServiceName() {
        if (this.m_dbDomain == null) {
            Trace.out((String)("DB domain of '" + this.m_dbUniqueName + "' is null. returning database unique name"));
            return this.m_dbUniqueName;
        }
        return this.m_dbUniqueName + "." + this.m_dbDomain;
    }

    public Version getVersion() {
        return this.m_dbVersion;
    }

    public String getHome() {
        return this.m_dbHome;
    }
}

