/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.command;

import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.nativesystem.ExecutionAnalyzer;
import oracle.ops.verification.framework.nativesystem.ExecutionAnalyzerFactory;
import oracle.ops.verification.framework.network.NetworkConstants;
import oracle.ops.verification.framework.util.VerificationUtil;

public class CheckPortCommand
extends VerificationCommand {
    private static String m_arg1 = "-chkport";
    private String m_port;
    private String m_protocol;
    private String m_IPAddress;

    public CheckPortCommand(String nodeName, String port, NetworkConstants.NetworkProtocol protocol, String IPAddress) {
        super(nodeName, null, null);
        this.m_port = port;
        this.m_protocol = null != protocol ? protocol.toString() : "TCP";
        this.m_IPAddress = IPAddress;
        String[] args = null;
        if (VerificationUtil.isStringGood(this.m_IPAddress)) {
            args = new String[4];
            args[3] = this.m_IPAddress;
        } else {
            args = new String[]{m_arg1, this.m_protocol, this.m_port};
        }
        super.setArgs(args);
    }

    @Override
    public boolean execute() {
        Trace.out((String)("CheckPortCommand::Inside execute() " + Thread.currentThread().getName()));
        boolean bResult = super.execute();
        Result result = this.getResult();
        if (!bResult) {
            String trcTxt = "super.execute() failed for " + this.m_protocol + " port number " + this.m_port;
            Trace.out((String)trcTxt);
            result.addTraceInfo(trcTxt);
            result.addErrorInfo("checking port availability failed");
            result.setStatus(2);
            return false;
        }
        String[] resultString = this.getCommandResult().getResultString();
        String reoutput = VerificationUtil.strArr2String(resultString);
        ExecutionAnalyzer analyzer = ExecutionAnalyzerFactory.getExecutionAnalyzer();
        analyzer.verifyPortAvail(reoutput, result);
        return true;
    }
}

