/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.command;

import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.util.CommandsUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

public class CheckRootGidConsistencyCommand
extends VerificationCommand {
    private boolean m_usegroupscmd;
    String[] s_args = new String[]{"-chkuser", "root", ""};
    String[] s_args_groups = new String[]{"-rungencmd", new CommandsUtil().getGroups(), "root"};

    public CheckRootGidConsistencyCommand(String nodeName) {
        super(nodeName, null, null);
    }

    public void setUseGroupsCmd(boolean val) {
        this.m_usegroupscmd = val;
    }

    public boolean getUseGroupsCmd() {
        return this.m_usegroupscmd;
    }

    @Override
    public boolean execute() {
        boolean bResult = false;
        Trace.out((String)("CheckRootGidConsistencyCommand::execute() entry" + Thread.currentThread().getName()));
        if (this.m_usegroupscmd) {
            this.setArgs(this.s_args_groups);
        } else {
            this.setArgs(this.s_args);
        }
        bResult = super.execute();
        Result result = this.getResult();
        String rsltString = VerificationUtil.strArr2String(this.getCommandResult().getResultString());
        if (!bResult) {
            String trcTxt = "super.execute() failed for CheckRootGidConsistency...";
            Trace.out((String)trcTxt);
            result.addTraceInfo(trcTxt);
            result.addErrorInfo("Command Execution failed for Root GID Consistency check");
            result.setStatus(2);
            return false;
        }
        if (!VerificationUtil.fetchVerificationStatus(rsltString)) {
            String trcTxt = "system command could not be executed successfully";
            Trace.out((String)trcTxt);
            result.addTraceInfo(trcTxt);
            result.addErrorInfo("command Execution could not fetch anything for Root GID Consistency check");
            result.setStatus(3);
            return false;
        }
        result.setStatus(1);
        result.addResultInfo(rsltString);
        Trace.out((String)"CheckRootGidConsistencyCommand.execute successful");
        return true;
    }
}

