/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.command;

import oracle.ops.mgmt.cluster.RemoteShellException;
import oracle.ops.mgmt.command.CommandResult;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.RuntimeExec;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.config.VDMUtil;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.util.VerificationLogData;
import oracle.ops.verification.framework.util.VerificationUtil;

public class CheckUserEquivCommand
extends VerificationCommand {
    static final String CONFIG_XCHK_FOR_SSH_ENABLED = "CV_XCHK_FOR_SSH_ENABLED";
    private boolean m_bCheckX;

    public CheckUserEquivCommand(String nodeName) {
        this(nodeName, VerificationUtil.getConfiguredValue(CONFIG_XCHK_FOR_SSH_ENABLED, true) != null && VerificationUtil.getConfiguredValue(CONFIG_XCHK_FOR_SSH_ENABLED, true).equalsIgnoreCase("TRUE"));
    }

    public CheckUserEquivCommand(String nodeName, boolean checkX) {
        super(nodeName);
        this.m_bCheckX = checkX;
    }

    @Override
    public boolean execute() {
        Result result = this.getResult();
        String retval = null;
        Trace.out((String)("CheckUserEquivCommand:: Inside execute() [Thread:" + Thread.currentThread().getName() + "]"));
        result.addTraceInfo("CheckUserEquivCommand::Inside execute() " + Thread.currentThread().getName());
        try {
            retval = this.nativeSystem.isNodeAccessible(this.m_node);
        }
        catch (Exception e) {
            result.addTraceInfo("CheckUserEquivCommand::execute() Exception calling native system");
            Trace.out((String)"CheckUserEquivCommand::execute() Exception calling native system");
            result.addErrorInfo(e.getMessage());
            result.setStatus(2);
            return false;
        }
        CommandResult commandResult = new CommandResult(retval);
        if (commandResult == null) {
            Trace.out((String)"CheckUserEquivCommand::execute() Command failed!");
            result.addTraceInfo("CheckUserEquivCommand::execute() Command failed!");
            result.addErrorInfo("CheckUserEquivCommand::execute() Command failed!");
            result.setStatus(2);
            return false;
        }
        if (commandResult.getStatus()) {
            Trace.out((String)("The user equivalence on node " + this.m_node + " is TRUE"));
            boolean bXonSshPassed = true;
            if (this.nativeSystem.isUnixSystem()) {
                if (this.m_bCheckX) {
                    Trace.out((String)"==== Simple SSH check passed. Now checking user equivalence for X-Windows...");
                    bXonSshPassed = this.check4XWindows();
                } else {
                    Trace.out((String)"==== XCHK for SSH disabled.");
                }
            }
            result.addTraceInfo("The user equivalence on node " + this.m_node + " is " + bXonSshPassed);
            result.addResultInfo(new Boolean(bXonSshPassed));
            if (bXonSshPassed) {
                result.setStatus(1);
            } else {
                result.setStatus(2);
            }
            return bXonSshPassed;
        }
        Trace.out((String)("The user equivalence on node " + this.m_node + " is FALSE"));
        result.addTraceInfo("ERROR:CheckUserEquivCommand:: " + commandResult.getResultString());
        if (VerificationUtil.isStringGood(commandResult.getErrorString())) {
            Trace.out((String)("commandResult.getErrorString()=" + commandResult.getErrorString()));
            VerificationLogData.logError(commandResult.getErrorString());
            result.addErrorInfo(commandResult.getErrorString());
        }
        result.setStatus(2);
        return false;
    }

    private boolean check4XWindows() {
        boolean isSshOk4X = true;
        try {
            String remShellCmd = this.nativeSystem.getRemoteShellCmd();
            Trace.out((String)("==== Remote shell cmd is: " + remShellCmd));
            int lastSlash = remShellCmd.lastIndexOf(47);
            lastSlash = lastSlash == -1 ? 0 : lastSlash;
            int endIdx = remShellCmd.indexOf(32);
            if (endIdx == -1) {
                endIdx = remShellCmd.length();
            }
            String curRemShell = remShellCmd.substring(lastSlash + 1, endIdx);
            boolean isSSH = curRemShell.equalsIgnoreCase("ssh");
            Trace.out((String)("==== Is SSH used for remote shell? A:" + isSSH));
            if (!isSSH) {
                Trace.out((String)("==== Not using ssh for node " + this.m_node));
                return true;
            }
            Trace.out((String)"==== SSH is used. Let's do X-Windows check...");
            String xCheckAppLoc = VDMUtil.getXCheckAppLoc();
            if (xCheckAppLoc == null) {
                Trace.out((String)("==== No XCheck loc found. Aborting this check for " + this.m_node));
                return true;
            }
            String dispVar = VerificationUtil.getEnv("DISPLAY");
            String xCmd = xCheckAppLoc + "xdpyinfo -display " + dispVar + " > /dev/null";
            String unixcmd = remShellCmd + this.m_node + " " + xCmd;
            Trace.out((String)("==== Checking XWindows with the command: " + unixcmd));
            RuntimeExec runtime = new RuntimeExec(NativeSystem.getCmdArr((String)unixcmd), null, null);
            int retVal = runtime.runCommand();
            if (runtime.getExitValue() != 0) {
                int j;
                String[] output = null;
                String[] error = runtime.getError();
                output = runtime.getOutput();
                Trace.out((int)5, (String)("Non-zero exit for cmd: " + unixcmd));
                if (output != null && output.length != 0) {
                    for (j = 0; j < output.length; ++j) {
                        VerificationLogData.logError(output[j]);
                        Trace.out((int)5, (String)output[j]);
                    }
                } else {
                    Trace.out((int)5, (String)"output is NULL/EMPTY");
                }
                if (error != null && error.length != 0) {
                    for (j = 0; j < error.length; ++j) {
                        VerificationLogData.logError(error[j]);
                        Trace.out((int)5, (String)error[j]);
                    }
                }
            }
            String[] cmdError = runtime.getError();
            if (retVal != 0 || cmdError != null && cmdError.length != 0 && !NativeSystem.isCmdScv((String)unixcmd)) {
                Trace.out((String)("==== SSH run for X failed on node " + this.m_node));
                isSshOk4X = false;
            }
        }
        catch (RemoteShellException rse) {
            Trace.out((Exception)((Object)rse));
            isSshOk4X = false;
        }
        Trace.out((String)("==== Is SSH configured for X-Windows on node " + this.m_node + "? A:" + isSshOk4X));
        return isSshOk4X;
    }
}

