/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.command;

import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.util.VerificationUtil;

public class GetLoginShellCommand
extends VerificationCommand {
    private static String m_arg1 = "-getLoginShell";

    public GetLoginShellCommand(String nodeName) {
        super(nodeName, null, null);
        String[] args = new String[]{m_arg1};
        super.setArgs(args);
    }

    @Override
    public boolean execute() {
        Trace.out((String)("GetLoginShellCommand::Inside execute() " + Thread.currentThread().getName()));
        boolean bResult = super.execute();
        Result result = this.getResult();
        if (!bResult) {
            String trcTxt = "super.execute() failed for GetLoginShellCommand...";
            Trace.out((String)trcTxt);
            result.addTraceInfo(trcTxt);
            Trace.out((String)"getting login shell failed");
            result.addErrorInfo("getting login shell failed");
            result.setStatus(2);
            return false;
        }
        Trace.out((String)"super.execute() was succcessful for GetLoginShellCommand...");
        String[] resultString = this.getCommandResult().getResultString();
        String exectaskFmtdStr = VerificationUtil.strArr2List(resultString, "\n");
        if (!VerificationUtil.fetchExecResult(exectaskFmtdStr)) {
            String trcTxt = "Exectask result shows failure for -getLoginShell...";
            Trace.out((String)trcTxt);
            result.addTraceInfo(trcTxt);
            Trace.out((String)"getting login shell failed");
            result.addErrorInfo("getting login shell failed");
            result.setStatus(2);
            return false;
        }
        String loginShell = VerificationUtil.fetchVerificationValue(exectaskFmtdStr);
        Trace.out((String)"after calling fetchVerificationValue() ");
        Trace.out((String)("The login shell at node '" + this.getNodeName() + "' is '" + loginShell + "'"));
        result.addTraceInfo("The login shell at node '" + this.getNodeName() + "' is '" + loginShell + "'");
        result.addResultInfo(loginShell);
        result.setStatus(1);
        return true;
    }
}

