/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.command;

import oracle.cluster.verification.StorageUnit;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.storage.CommandHandler;
import oracle.ops.verification.framework.storage.CommandHandlerFactory;
import oracle.ops.verification.framework.storage.StorageException;
import oracle.ops.verification.framework.storage.StorageInfo;
import oracle.ops.verification.framework.util.VerificationLogData;
import oracle.ops.verification.framework.util.VerificationUtil;

public class GetSpaceCommand
extends VerificationCommand {
    protected static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");
    private String m_location;
    private int m_type;
    private VerificationCommand remCmd = null;
    private static CommandHandler s_commandHandler;
    private String m_realpath;
    private String m_signature;
    private StorageInfo m_stInfo;

    public GetSpaceCommand(String nodeName, String location, String realpath, int stType, StorageInfo stInfo) {
        super(nodeName);
        this.m_location = location;
        this.m_type = stType;
        this.m_realpath = realpath;
        this.m_stInfo = stInfo;
        s_commandHandler = CommandHandlerFactory.createCommandHandler();
    }

    public GetSpaceCommand(String nodeName, String signature, int stType, StorageInfo stInfo) {
        super(nodeName);
        this.m_type = stType;
        this.m_signature = signature;
        this.m_stInfo = stInfo;
        s_commandHandler = CommandHandlerFactory.createCommandHandler();
    }

    @Override
    public boolean execute() {
        Result result = super.getResult();
        StorageInfo st = null;
        String errString = new String("ERROR:GetSpaceCommand:: UNKNOWN ERROR");
        Trace.out((String)"ENTRY");
        if (this.m_type == 18 || this.m_type == 13) {
            Trace.out((String)("location: '" + this.m_location + "' is an ASM location"));
            if (!this.m_stInfo.getPath().contentEquals(this.m_location)) {
                String trcTxt = "ERROR GETTING DISKGROUP info for location " + this.m_location + " of type " + this.m_type;
                Trace.out((String)trcTxt);
                result.addTraceInfo(trcTxt);
                result.addErrorInfo(s_msgBundle.getMessage("5131", true));
                result.setStatus(2);
                return false;
            }
            st = this.m_stInfo;
            Trace.out((String)("Using Storage Info object: \n" + st));
        } else {
            try {
                this.remCmd = this.m_signature != null ? (VerificationCommand)s_commandHandler.genInfoCmd(this.m_node, this.m_type, this.m_signature) : (VerificationCommand)s_commandHandler.genInfoCmd(this.m_node, this.m_type, this.m_location, this.m_realpath, result);
            }
            catch (StorageException e) {
                Trace.out((String)("STORAGEEXCEPTION: \n" + e.getMessage()));
                String trcTxt = "StorageException generating info cmd for " + (this.m_signature != null ? this.m_signature : this.m_location) + " of type " + this.m_type + "\n" + e.getMessage();
                Trace.out((String)trcTxt);
                result.addTraceInfo(trcTxt);
                result.addErrorInfo(trcTxt);
                result.setStatus(2);
                return false;
            }
            boolean bResult = this.remCmd.execute();
            if (!bResult) {
                String trcTxt = "GetSpaceCommand: '" + this.remCmd.getExecCommand() + "' failed!";
                VerificationLogData.logError(trcTxt);
                Trace.out((String)trcTxt);
                result.addTraceInfo(trcTxt);
                result.addErrorInfo("Getting exectask storage info failed");
                result.setStatus(2);
                return false;
            }
            String[] resultString = this.remCmd.getCommandResult().getResultString();
            String exectaskFmtdStr = VerificationUtil.strArr2List(resultString, "\n");
            if (0 != this.remCmd.getVfyCode() || !VerificationUtil.fetchExecResult(exectaskFmtdStr)) {
                String trcTxt = "Exectask result shows failure...";
                Trace.out((String)trcTxt);
                result.addTraceInfo(trcTxt);
                Trace.out((String)"getting storage info failed");
                result.addErrorInfo("getting exectask storage info failed");
                result.setStatus(2);
                return false;
            }
            try {
                st = s_commandHandler.parseInfoResult(this.remCmd, this.m_type, this.m_location);
                if (st == null) {
                    errString = new String("ERROR:GetSpaceCommand:: " + this.commandResult.getResultString());
                }
            }
            catch (StorageException e) {
                Trace.out((String)("STORAGEEXCEPTION: " + e.getMessage()));
                String trcTxt = "StorageException parsing info cmd output for location " + this.m_location + " of type " + this.m_type;
                Trace.out((String)trcTxt);
                result.addTraceInfo(trcTxt);
                result.addErrorInfo("Parsing Info command output for storage failed");
                result.setStatus(2);
                return false;
            }
        }
        if (st != null) {
            if (Trace.isTraceEnabled()) {
                Trace.out((String)("The free space at " + this.m_location + " on node " + this.m_node + " is : " + st.getFree()));
            }
            result.addTraceInfo("The free space at " + this.m_location + " on node " + this.m_node + " is : " + st.getFree());
            result.addResultInfo((long)st.getFree().sizeIn(StorageUnit.BYTE));
            result.addResultInfo(st);
            result.setStatus(1);
            return true;
        }
        Trace.out((String)errString);
        result.addErrorInfo(errString);
        result.addTraceInfo(errString);
        result.setStatus(2);
        return false;
    }
}

