/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.command;

import java.io.File;
import java.util.List;
import oracle.cluster.verification.VerificationError;
import oracle.ops.mgmt.command.util.RemoteExecCommand;
import oracle.ops.mgmt.nativesystem.NativeResult;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.command.RunGenericRootCommand;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.CVUAutoUpdateManager;
import oracle.ops.verification.framework.util.RootAutomationNotConfiguredException;
import oracle.ops.verification.framework.util.RootUserCredentials;
import oracle.ops.verification.framework.util.VerificationLogData;
import oracle.ops.verification.framework.util.VerificationUtil;

public class VerificationCommand
extends RemoteExecCommand
implements VerificationConstants {
    private static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");
    protected Result m_result;
    protected Object m_key;
    private String m_output;
    private String m_cmdExecuted;
    private int m_vfyCode;
    private static String s_subDir = VerificationUtil.getCVUSubDir();
    private String m_error;
    private String m_exceptionError = null;
    private RootUserCredentials m_rootCreds = null;
    private int m_timeout = 0;
    private String m_command = null;
    protected String[] m_nodeArr = null;
    protected ResultSet m_rootResultSet = null;

    public VerificationCommand(String node) {
        super("", null, null, node, VerificationUtil.isLocalNodeOperation(), null, "", "");
        super.setSubDirAndGroup(s_subDir, null);
        if (node != null && (node.equals("localnode") || VerificationUtil.isLocalNode(node))) {
            super.setLocalExecution(true);
        }
        this.m_key = node;
        this.m_result = new Result(node);
    }

    public VerificationCommand(String node, String[] args, String[] env) {
        super(VerificationUtil.getDestLoc() + s_subDir + File.separator + VerificationUtil.getCmd4RemExec(), args, env, node, VerificationUtil.isLocalNodeOperation(), CVUAutoUpdateManager.getCmdFiles4RemExec(), CVUAutoUpdateManager.getFiles4RemExecServer(), VerificationUtil.getDestLoc());
        super.setSubDirAndGroup(s_subDir, null);
        if (node != null && (node.equals("localnode") || VerificationUtil.isLocalNode(node))) {
            super.setLocalExecution(true);
        }
        this.m_key = node;
        this.m_result = new Result(node);
    }

    public VerificationCommand(String node, String[] args, String[] env, NativeResult nativeResult) {
        super(VerificationUtil.getDestLoc() + s_subDir + File.separator + VerificationUtil.getCmd4RemExec(), args, env, node, CVUAutoUpdateManager.getCmdFiles4RemExec(), CVUAutoUpdateManager.getFiles4RemExecServer(), VerificationUtil.getDestLoc(), nativeResult);
        super.setSubDirAndGroup(s_subDir, null);
        if (node != null && (node.equals("localnode") || VerificationUtil.isLocalNode(node))) {
            super.setLocalExecution(true);
        }
        this.m_key = node;
        this.m_result = new Result(node);
    }

    public VerificationCommand(String node, String[] args, String[] env, Result result) {
        super(VerificationUtil.getDestLoc() + s_subDir + File.separator + VerificationUtil.getCmd4RemExec(), args, env, node, VerificationUtil.isLocalNodeOperation(), CVUAutoUpdateManager.getCmdFiles4RemExec(), CVUAutoUpdateManager.getFiles4RemExecServer(), VerificationUtil.getDestLoc());
        super.setSubDirAndGroup(s_subDir, null);
        if (node != null && (node.equals("localnode") || VerificationUtil.isLocalNode(node))) {
            super.setLocalExecution(true);
        }
        this.m_key = node;
        this.m_result = result != null ? result : new Result(node);
    }

    public VerificationCommand(String cmd, String[] args, String[] env, String node, String[] cmdFiles, String srcLoc, String destLoc) {
        super(cmd, args, env, node, VerificationUtil.isLocalNodeOperation(), cmdFiles, srcLoc, destLoc);
        super.setSubDirAndGroup(s_subDir, null);
        if (node != null && (node.equals("localnode") || VerificationUtil.isLocalNode(node))) {
            super.setLocalExecution(true);
        }
        this.m_key = node;
        this.m_result = new Result(node);
    }

    public VerificationCommand(String[] nodeArr, String command, RootUserCredentials rootCreds, int timeout, ResultSet resultSet) throws RootAutomationNotConfiguredException {
        super("", null, null, nodeArr[0], false, null, "", "");
        this.m_nodeArr = nodeArr;
        this.m_rootCreds = rootCreds;
        this.m_timeout = timeout;
        this.m_command = command;
        this.m_rootResultSet = resultSet;
    }

    public String getErrorString() {
        return super.getErrorString();
    }

    public boolean execute() {
        String command;
        boolean commandSucc = true;
        boolean execSucc = true;
        String fmtdResult = "";
        String vfyCodeStr = null;
        StringBuffer buf = new StringBuffer();
        Trace.out((String)":: Inside execute() [Thread:");
        this.m_result.addTraceInfo("::Inside execute() ");
        commandSucc = super.execute();
        if (commandSucc) {
            String[] resultStrings = this.commandResult.getResultString();
            if (resultStrings == null || resultStrings.length == 0) {
                commandSucc = false;
            } else {
                fmtdResult = VerificationUtil.strArr2List(resultStrings, System.getProperty("line.separator"));
                command = this.getExecCommand();
                if (command != null) {
                    buf.append("Command: '" + command + "'");
                }
                if (fmtdResult != null) {
                    buf.append(VerificationConstants.LSEP + "Output: '" + fmtdResult + "'");
                }
                VerificationLogData.logFine(buf.toString());
                this.m_output = VerificationUtil.fetchVerificationValue(fmtdResult);
                Trace.out((String)("Formatted exectask output is:\n " + fmtdResult));
                this.m_error = VerificationUtil.fetchError(fmtdResult);
                vfyCodeStr = VerificationUtil.fetchVerificationResult(fmtdResult);
                if (vfyCodeStr == null) {
                    this.m_vfyCode = 1;
                    Trace.out((String)"VRES value was NULL, VfyCode is set to 1. ");
                } else {
                    this.m_vfyCode = Integer.parseInt(vfyCodeStr);
                    Trace.out((String)("VfyCode is: " + this.m_vfyCode));
                }
                this.m_cmdExecuted = VerificationUtil.fetchCommandValue(fmtdResult);
            }
        }
        if (commandSucc && VerificationUtil.fetchExecResult(fmtdResult)) {
            execSucc = true;
            this.m_result.setStatus(1);
        } else {
            execSucc = false;
            if (VerificationUtil.isStringGood(this.commandResult.getErrorString())) {
                Trace.out((String)("commandResult.getErrorString()=" + this.commandResult.getErrorString()));
                VerificationLogData.logError(this.commandResult.getErrorString());
                this.m_result.addErrorInfo(this.commandResult.getErrorString());
            }
            String commandOut = VerificationUtil.fetchVerificationValue(fmtdResult);
            command = this.getExecCommand();
            if (command != null) {
                buf.append("Command: '" + command + "'");
            }
            if (commandOut != null) {
                buf.append(VerificationConstants.LSEP + "Output: '" + commandOut + "'");
            } else {
                buf.append(VerificationConstants.LSEP + "Output: is EMPTY");
            }
            buf.append(VerificationConstants.LSEP + "Errors: '" + this.getErrorString() + "'");
            VerificationLogData.logError(buf.toString());
            if (commandOut == null) {
                commandOut = this.getErrorString();
            }
            this.m_result.setStatus(2);
            if (command != null && commandOut != null) {
                String errMsg = s_msgBundle.getMessage("7508", false) + VerificationConstants.LSEP + s_msgBundle.getMessage("0050", false, (Object[])new String[]{command, commandOut});
                Trace.out((String)errMsg);
                ErrorDescription errDesc = new ErrorDescription(errMsg);
                this.m_result.addErrorDescription(errDesc);
            }
        }
        return execSucc;
    }

    public boolean runCmdAsRoot() throws RootAutomationNotConfiguredException {
        boolean status = true;
        Trace.out((String)("running " + this.m_command + " as root"));
        RunGenericRootCommand runRootCommand = new RunGenericRootCommand(this.m_nodeArr, this.m_command, this.m_env, this.m_args, this.m_rootCreds, this.m_timeout, this.m_rootResultSet);
        runRootCommand.execute();
        if (this.m_rootResultSet.getStatus() != 1) {
            StringBuilder sb = new StringBuilder();
            Trace.out((String)"root command execution failed");
            for (int i = 0; i < this.m_nodeArr.length; ++i) {
                List<VerificationError> errList = this.m_rootResultSet.getResult(this.m_nodeArr[i]).getErrors();
                for (VerificationError vfyErr : errList) {
                    sb.append(vfyErr.getErrorMessage());
                }
            }
            ErrorDescription errDesc = new ErrorDescription(sb.toString());
            this.m_rootResultSet.addErrorDescription(errDesc);
            ReportUtil.sureprintln(sb.toString());
            return false;
        }
        return status;
    }

    public Result getResult() {
        return this.m_result;
    }

    public String getNodeName() {
        return this.m_node;
    }

    public void setKey(Object key) {
        this.m_key = key;
    }

    public Object getKey() {
        return this.m_key;
    }

    public String getOutput() {
        return this.m_output;
    }

    public String getError() {
        return this.m_error;
    }

    public void setExceptionError(String exceptionError) {
        this.m_exceptionError = exceptionError;
    }

    public String getExceptionError() {
        return this.m_exceptionError;
    }

    public int getVfyCode() {
        return this.m_vfyCode;
    }

    public String getExecCommand() {
        return this.m_cmdExecuted;
    }
}

