/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.config;

import java.util.Enumeration;
import java.util.Hashtable;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.config.Constraint;
import oracle.ops.verification.framework.config.InvalidConstraintDataException;
import oracle.ops.verification.framework.config.PeerCompatible;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.report.ReportUtil;

public class UserConstraint
extends Constraint
implements PeerCompatible {
    private static String CONSTRAINT_NAME = s_msgBundle.getMessage("1059", false);
    private String m_reqUser;
    private int m_refStatus = 2;

    public UserConstraint(String quali, String fbaction, String val) {
        super("USER", quali, fbaction);
        this.m_reqUser = val;
        this.setValid(false);
    }

    public UserConstraint(Hashtable ht) throws InvalidConstraintDataException {
        super("USER");
        this.validate(ht);
        this.m_qualifier = (String)ht.get("Qualifier");
        this.m_fbAction = (String)ht.get("FallbackAction");
        this.m_reqUser = (String)ht.get("KeyData");
        this.setValid(true);
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getName());
        sb.append("[Qualifier: " + this.m_qualifier);
        sb.append(", FallbackAction: " + this.m_fbAction);
        sb.append(", User : " + this.m_reqUser + "]");
        return sb.toString();
    }

    @Override
    public void validate(Hashtable ht) throws InvalidConstraintDataException {
        super.validate(ht);
        if (!((String)ht.get("Type")).equals("USER")) {
            throw new InvalidConstraintDataException("Constraint type does not match");
        }
        String quali = (String)ht.get("Qualifier");
        if (!quali.equals("EXIST") && !quali.equals("COMPARE")) {
            throw new InvalidConstraintDataException("Qualifier '" + quali + "' is not supported for " + this.getClass().getName());
        }
        if (!ht.containsKey("KeyData")) {
            throw new InvalidConstraintDataException("Missing KeyData");
        }
        int dsetlen = 4;
        if (ht.size() != dsetlen) {
            String errtxt = "Invalid data set for " + this.getClass().getName() + ". EXPECTED: " + dsetlen + ", FOUND: " + ht.size();
            throw new InvalidConstraintDataException(errtxt);
        }
    }

    @Override
    public boolean applyConstraint(String[] nodeList, ResultSet rset) throws InvalidConstraintDataException {
        if (!this.isValid()) {
            throw new InvalidConstraintDataException("Can not apply invalid constraint");
        }
        GlobalExecution globalExec = new GlobalExecution();
        return globalExec.checkUser(nodeList, this.m_reqUser, rset);
    }

    @Override
    public boolean checkCompatibility(String[] nodeList, String refNode, ResultSet resultSet) throws InvalidConstraintDataException {
        Trace.out((String)("Checking compatibility:" + this));
        if (!this.isValid()) {
            throw new InvalidConstraintDataException("Invalid constraint. Compatibility check can not proceed");
        }
        GlobalExecution globalExec = new GlobalExecution();
        boolean cmdStatus = globalExec.checkUser(nodeList, this.m_reqUser, resultSet);
        if (refNode == null || refNode.trim().length() == 0) {
            return cmdStatus;
        }
        Hashtable ht = resultSet.getResultTable();
        if (!ht.containsKey(refNode)) {
            Trace.out((String)"==== ERROR: refnode data missing");
            resultSet.addResult(nodeList, 2);
            resultSet.setStatus();
            return false;
        }
        Result refResult = (Result)ht.get(refNode);
        if (refResult.getStatus() == 2) {
            Trace.out((String)"==== ERROR: execution error at refnode");
            resultSet.addResult(nodeList, 2);
            resultSet.setStatus();
            return false;
        }
        this.m_refStatus = refResult.getStatus();
        Trace.out((String)("==== Reference data: " + refResult.getStatus()));
        Enumeration e = ht.keys();
        while (e.hasMoreElements()) {
            boolean compStatus;
            String node = (String)e.nextElement();
            Result result = (Result)ht.get(node);
            if (node.equals(refNode)) {
                result.setStatus(1);
                continue;
            }
            if (result.getStatus() == 2) continue;
            Trace.out((String)("==== Refdata:" + refResult.getStatus() + "Nodedata: " + result.getStatus()));
            boolean bl = compStatus = refResult.getStatus() == result.getStatus();
            if (compStatus) {
                result.setStatus(1);
                Trace.out((String)"==== Result status reset to op_successful");
                continue;
            }
            result.setStatus(3);
            Trace.out((String)"==== Result status reset to vf_failed");
        }
        resultSet.setStatus();
        return cmdStatus;
    }

    @Override
    public void report(ResultSet rsltSet) {
        ReportUtil.blankln();
        ReportUtil.println(s_msgBundle.getMessage("1012", false, (Object[])new String[]{CONSTRAINT_NAME, this.m_reqUser}));
        ReportUtil.writeColHeaders(ReportUtil.NODENAME, ReportUtil.STATUS, ReportUtil.COMMENT);
        Hashtable ht = rsltSet.getResultTable();
        Enumeration e = ht.keys();
        while (e.hasMoreElements()) {
            String comment;
            String usrStatus;
            String node = (String)e.nextElement();
            Result result = (Result)ht.get(node);
            if (result.getStatus() == 1) {
                usrStatus = ReportUtil.EXIST;
                comment = ReportUtil.PASSED;
            } else if (result.getStatus() == 3) {
                usrStatus = ReportUtil.NOTEXIST;
                comment = ReportUtil.FAILED;
            } else {
                usrStatus = ReportUtil.UNKNOWN;
                comment = ReportUtil.UNKNOWN;
            }
            ReportUtil.writeRecord(node, usrStatus, comment);
        }
        if (rsltSet.getStatus() == 1) {
            ReportUtil.printResult(s_msgBundle.getMessage("1002", false, (Object[])new String[]{CONSTRAINT_NAME, this.m_reqUser}));
        } else {
            ReportUtil.printResult(s_msgBundle.getMessage("1004", false, (Object[])new String[]{CONSTRAINT_NAME, this.m_reqUser}));
            ReportUtil.printErrorNodes(rsltSet);
        }
    }

    @Override
    public void reportCompatibility(ResultSet resultSet) {
        ReportUtil.sureblankln();
        ReportUtil.sureprintln(s_msgBundle.getMessage("1006", false, (Object[])new String[]{CONSTRAINT_NAME, this.m_reqUser}));
        ReportUtil.surewriteColHeaders(ReportUtil.NODENAME, ReportUtil.STATUS);
        Hashtable t = resultSet.getResultTable();
        Enumeration e = t.keys();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            Result result = (Result)t.get(node);
            String extStatus = result.getStatus() == 1 ? ReportUtil.EXIST : (result.getStatus() == 3 ? ReportUtil.NOTEXIST : ReportUtil.UNKNOWN);
            ReportUtil.surewriteRecord(node, extStatus);
        }
        if (t.size() > 1) {
            ReportUtil.sureprintln(s_msgBundle.getMessage("1008", false, (Object[])new String[]{CONSTRAINT_NAME, this.m_reqUser}));
        }
    }

    @Override
    public void reportCompatibility(String refNode, ResultSet resultSet) {
        String oppRefStat;
        String refStatus;
        ReportUtil.sureblankln();
        ReportUtil.sureprintln(s_msgBundle.getMessage("1010", false, (Object[])new String[]{CONSTRAINT_NAME, this.m_reqUser, refNode}));
        ReportUtil.surewriteColHeaders(ReportUtil.NODENAME, ReportUtil.STATUS, ReportUtil.REF_STATUS, ReportUtil.COMMENT);
        Hashtable ht = resultSet.getResultTable();
        if (this.m_refStatus == 1) {
            refStatus = ReportUtil.EXIST;
            oppRefStat = ReportUtil.NOTEXIST;
        } else if (this.m_refStatus == 3) {
            refStatus = ReportUtil.NOTEXIST;
            oppRefStat = ReportUtil.EXIST;
        } else {
            refStatus = ReportUtil.UNKNOWN;
            oppRefStat = ReportUtil.UNKNOWN;
        }
        Enumeration e = ht.keys();
        while (e.hasMoreElements()) {
            String comment;
            String cnStatus;
            String node = (String)e.nextElement();
            if (node.equals(refNode)) continue;
            Result result = (Result)ht.get(node);
            if (result.getStatus() == 1) {
                cnStatus = refStatus;
                comment = ReportUtil.MATCHED;
            } else if (result.getStatus() == 3) {
                cnStatus = oppRefStat;
                comment = ReportUtil.MISMATCHED;
            } else {
                cnStatus = ReportUtil.UNKNOWN;
                comment = ReportUtil.MISMATCHED;
            }
            ReportUtil.surewriteRecord(node, cnStatus, refStatus, comment);
        }
        if (resultSet.getStatus() == 1) {
            ReportUtil.sureprintln(s_msgBundle.getMessage("1001", false, (Object[])new String[]{CONSTRAINT_NAME}));
        } else {
            ReportUtil.sureprintln(s_msgBundle.getMessage("1003", false, (Object[])new String[]{CONSTRAINT_NAME}));
        }
    }
}

