/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine;

import oracle.cluster.util.ConsoleUtilException;
import oracle.cluster.verification.FixupException;
import oracle.cluster.verification.fixup.FixupCommandline;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.engine.component.Component;
import oracle.ops.verification.framework.engine.component.ComponentFactory;
import oracle.ops.verification.framework.engine.component.ComponentInitException;
import oracle.ops.verification.framework.engine.component.InvalidComponentException;
import oracle.ops.verification.framework.engine.stage.InvalidStageException;
import oracle.ops.verification.framework.engine.stage.Stage;
import oracle.ops.verification.framework.engine.stage.StageFactory;
import oracle.ops.verification.framework.engine.stage.StageInitException;
import oracle.ops.verification.framework.param.ParamManager;
import oracle.ops.verification.framework.param.UninitializedParamManagerException;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.InvalidEnvironmentException;
import oracle.ops.verification.framework.util.VerificationLogData;
import oracle.ops.verification.framework.util.VerificationUtil;

public class ClusterVerifier
implements VerificationConstants {
    private static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");
    private static MessageBundle s_gMsgBundle = VerificationUtil.getMessageBundle("Prvg");

    public ClusterVerifier() throws InvalidEnvironmentException {
        Trace.out((String)"Inside ClusterVerifier() constructor...");
        try {
            VerificationUtil.getExecutionEnvironment();
        }
        catch (InvalidEnvironmentException iee) {
            ReportUtil.printError(iee.getMessage() + LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
            throw iee;
        }
    }

    public boolean verifyComponent(String componentID) throws InvalidComponentException, ComponentInitException {
        ReportUtil.printReportHeader();
        Component comp = ComponentFactory.createComponent(componentID);
        boolean retval = comp.verify();
        this.wrapup();
        ReportUtil.printReportFooter(comp.getResultSet());
        return retval;
    }

    public boolean verifyStage(String stageID, int mode) throws InvalidStageException, StageInitException {
        ReportUtil.printReportHeader();
        Stage stage = StageFactory.createStage(stageID, mode);
        boolean retval = stage.verify();
        this.wrapup();
        ReportUtil.printReportFooter(stage.getResultSet());
        return retval;
    }

    private void wrapup() {
        block6: {
            Trace.out((int)5, (String)"Wrapping up the stage/component");
            ParamManager pm = null;
            try {
                pm = ParamManager.getInstance();
            }
            catch (UninitializedParamManagerException e2) {
                return;
            }
            if (pm.checkArgFixup() || pm.checkArgFixupNoExecute()) {
                try {
                    FixupCommandline.getInstance().performFixups(pm.checkArgFixupNoExecute());
                }
                catch (ConsoleUtilException cue) {
                    VerificationLogData.logError("ConsoleUtilException -" + cue.getMessage());
                    Trace.out((String)("Failed to read user input from standard in error is " + cue.getMessage()));
                    ReportUtil.printError(s_gMsgBundle.getMessage("9001", true));
                    return;
                }
                catch (FixupException fe) {
                    VerificationLogData.logError("FixupException -" + fe.getMessage());
                    Trace.out((String)("Caught FixupException while performing fixups with error " + fe.getMessage()));
                    Trace.out((Exception)fe);
                    if (!VerificationUtil.isStringGood(fe.getMessage())) break block6;
                    ReportUtil.printError(fe.getMessage());
                }
            }
        }
    }
}

