/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.component;

import oracle.cluster.verification.common.CVUException;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.component.Component;
import oracle.ops.verification.framework.engine.component.ComponentInitException;
import oracle.ops.verification.framework.engine.task.TaskACFSIntegrity;
import oracle.ops.verification.framework.engine.task.TaskASMIntegrity;
import oracle.ops.verification.framework.engine.task.TaskUSMUdevChecks;
import oracle.ops.verification.framework.param.Argument;
import oracle.ops.verification.framework.util.VerificationUtil;

public class ACFSComponent
extends Component {
    private String m_release;
    private String m_fileSystem;

    ACFSComponent(int verificationType) throws ComponentInitException {
        super(verificationType);
        this.init();
    }

    @Override
    public void init() throws ComponentInitException {
        super.init();
        this.m_fileSystem = this.m_paramMgr.getSinglePartArgVal(Argument.ARG_FILESYSTEM);
        Trace.out((String)("==== ParamManager reports File System is: " + this.m_fileSystem));
    }

    @Override
    public boolean verify() {
        Trace.out((int)5, (String)"Commencing ACFS Integrity verify()...");
        boolean retval = this.checkSetup();
        String[] validNodeArr = this.getValidNodeList();
        if (null == validNodeArr) {
            return false;
        }
        String[] crsNodes = VerificationUtil.getNodesWithCRSInstall(validNodeArr, this.m_resultSet);
        if (null == crsNodes) {
            return false;
        }
        switch (this.m_verificationType) {
            case 17: {
                if (!VerificationUtil.isACFSSupported(true)) {
                    this.m_resultSet.addResult(crsNodes, 2);
                    return false;
                }
                this.m_release = this.m_paramMgr.getSinglePartArgVal(Argument.ARG_RELEASE);
                if ("10gR1".equalsIgnoreCase(this.m_release)) {
                    this.m_release = "10.1";
                } else if ("10gR2".equalsIgnoreCase(this.m_release)) {
                    this.m_release = "10.2";
                } else if ("11gR1".equalsIgnoreCase(this.m_release)) {
                    this.m_release = "11.1";
                } else if ("11gR2".equalsIgnoreCase(this.m_release)) {
                    this.m_release = "11.2";
                }
                TaskASMIntegrity taskASM = new TaskASMIntegrity(crsNodes);
                try {
                    taskASM.setNetworkInfoFromOifcfg();
                }
                catch (CVUException cvuEx) {
                    Trace.out((String)("Exception occured while setting network info from oifcfg. msg=" + cvuEx.getMessage()));
                    this.m_resultSet.addResult(crsNodes, 2);
                    return false;
                }
                taskASM.perform();
                Trace.out((int)5, (String)"\n>>>> ACFSComponent: Upload taskASM >>>>>\n");
                this.m_resultSet.uploadResultSet(taskASM.getResultSet());
                TaskACFSIntegrity taskACFS = new TaskACFSIntegrity(crsNodes);
                taskACFS.setFileSystem(this.m_fileSystem);
                retval = taskACFS.perform();
                Trace.out((int)5, (String)"\n>>>> ACFSComponent: Upload taskACFS >>>>>\n");
                this.m_resultSet.uploadResultSet(taskACFS.getResultSet());
                NativeSystem nativeSystem = new SystemFactory().CreateSystem();
                if (VerificationUtil.isUDEVSupported()) {
                    TaskUSMUdevChecks taskUSMdev = new TaskUSMUdevChecks(this.getNodeList());
                    retval = taskUSMdev.perform();
                    Trace.out((int)5, (String)"\n>>>> USMComponent: Upload taskUSMdev>>>>>\n");
                    this.m_resultSet.uploadResultSet(taskUSMdev.getResultSet());
                }
                return !this.m_resultSet.anyFailure();
            }
        }
        Trace.out((int)15, (String)"ERROR: Invalid Verification Type!");
        return false;
    }

    @Override
    public String getComponentName() {
        return "ACFS";
    }

    @Override
    public String getComponentDisplayName() {
        return s_msgBundle.getMessage("9969", false);
    }
}

