/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.component;

import oracle.cluster.verification.common.CVUException;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.component.Component;
import oracle.ops.verification.framework.engine.component.ComponentInitException;
import oracle.ops.verification.framework.engine.task.TaskASMIntegrity;
import oracle.ops.verification.framework.param.Argument;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

public class ASMComponent
extends Component {
    private String m_release;

    ASMComponent(int verificationType) throws ComponentInitException {
        super(verificationType);
        this.init();
    }

    @Override
    public void init() throws ComponentInitException {
        super.init();
    }

    @Override
    public boolean verify() {
        boolean preCRSInst = false;
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)"Commencing ASM Integrity verify()...");
        }
        boolean retval = this.checkSetup();
        String[] validNodeArr = this.getValidNodeList();
        if (null == validNodeArr) {
            return false;
        }
        String[] crsNodes = VerificationUtil.getNodesWithCRSInstall(validNodeArr, this.m_resultSet);
        if (null == crsNodes) {
            return false;
        }
        switch (this.m_verificationType) {
            case 23: {
                this.m_release = this.m_paramMgr.getSinglePartArgVal(Argument.ARG_RELEASE);
                if ("10gR1".equalsIgnoreCase(this.m_release)) {
                    this.m_release = "10.1";
                } else if ("10gR2".equalsIgnoreCase(this.m_release)) {
                    this.m_release = "10.2";
                } else if ("11gR1".equalsIgnoreCase(this.m_release)) {
                    this.m_release = "11.1";
                } else if ("11gR2".equalsIgnoreCase(this.m_release)) {
                    this.m_release = "11.2";
                }
                TaskASMIntegrity taskASM = new TaskASMIntegrity(crsNodes);
                try {
                    taskASM.setNetworkInfoFromOifcfg();
                }
                catch (CVUException cvuEx) {
                    Trace.out((String)("Exception occured while setting network info from oifcfg. msg=" + cvuEx.getMessage()));
                    ReportUtil.sureprintln(cvuEx.getMessage());
                    this.m_resultSet.addResult(crsNodes, 2);
                    return false;
                }
                taskASM.setPreCheck(preCRSInst);
                retval = taskASM.perform();
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)"\n>>>> ASMComponent: Upload taskASM >>>>>\n");
                }
                this.m_resultSet.uploadResultSet(taskASM.getResultSet());
                return !this.m_resultSet.anyFailure();
            }
        }
        if (Trace.isLevelEnabled((int)15)) {
            Trace.out((String)"ERROR: Invalid Verification Type!");
        }
        return false;
    }

    @Override
    public String getComponentName() {
        return "ASM";
    }

    @Override
    public String getComponentDisplayName() {
        return s_msgBundle.getMessage("9950", false);
    }
}

