/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.component;

import java.net.UnknownHostException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import oracle.cluster.deployment.ClusterwareInfo;
import oracle.cluster.install.InstallException;
import oracle.cluster.sql.DBConnectionException;
import oracle.cluster.sql.SQLFactory;
import oracle.cluster.util.ConsoleUtil;
import oracle.cluster.util.ConsoleUtilException;
import oracle.cluster.verification.ParamPreReqCRSInst;
import oracle.cluster.verification.ParamPreReqDBConfig;
import oracle.cluster.verification.SubtasksNotCompleteException;
import oracle.cluster.verification.SubtasksUnavailableException;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.VerificationTask;
import oracle.cluster.verification.common.CVUException;
import oracle.cluster.verification.database.DatabaseConnectInfo;
import oracle.cluster.verification.util.DBUtils;
import oracle.cluster.verification.util.DBUtilsException;
import oracle.cluster.verification.util.DatabaseInfo;
import oracle.cluster.verification.util.VerificationType;
import oracle.cluster.verification.util.XmlFilePathException;
import oracle.jdbc.driver.OracleConnection;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.component.Component;
import oracle.ops.verification.framework.engine.component.ComponentInitException;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.TaskFactory;
import oracle.ops.verification.framework.engine.task.TaskFactoryException;
import oracle.ops.verification.framework.engine.task.TaskSoftwareDistribution;
import oracle.ops.verification.framework.param.Argument;
import oracle.ops.verification.framework.param.CLSyntax;
import oracle.ops.verification.framework.report.ReportToolException;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.report.ReportUtilConstants;
import oracle.ops.verification.framework.report.htmlreport.HtmlBrowserException;
import oracle.ops.verification.framework.report.htmlreport.HtmlConstants;
import oracle.ops.verification.framework.report.xmlreport.BaselineReportGenerator;
import oracle.ops.verification.framework.report.xmlreport.XmlReportTool;
import oracle.ops.verification.framework.report.xmlreport.XmlReportToolException;
import oracle.ops.verification.framework.util.HeavyWeightVerificationUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

public class BaselineComponent
extends Component {
    private String[] m_validNodeArr = null;
    DBUtils m_dbUtils = null;
    private static final String DB_CREDENTIAL_OERR = "ORA-01017";
    private String m_collectionType = null;
    private boolean m_rootScript = false;
    private boolean m_resource = false;
    private String m_dbName = null;
    private String m_dbHome = null;
    private boolean m_saveToAllNodes = false;
    private List<String> databaseHomeSoftwareVerifiedList = new ArrayList<String>();

    BaselineComponent(int verificationType) throws ComponentInitException {
        super(verificationType);
        this.init();
    }

    @Override
    public void init() throws ComponentInitException {
        super.init();
        this.m_nodeList = this.getNodeList();
        this.m_collectionType = VerificationUtil.getVariableValue("BASELINE_COLLECT");
        if (VerificationUtil.isStringGood(this.m_collectionType)) {
            this.m_rootScript = "true".equalsIgnoreCase(VerificationUtil.getVariableValue("BASELINE_ROOTSCRIPT"));
            this.m_resource = "true".equalsIgnoreCase(VerificationUtil.getVariableValue("BASELINE_RESOURCE"));
            this.m_saveToAllNodes = "true".equalsIgnoreCase(VerificationUtil.getVariableValue("SAVE_TO_ALL_NODES"));
            this.m_dbName = VerificationUtil.getVariableValue("BASELINE_DB");
            this.m_dbHome = VerificationUtil.getVariableValue("BASELINE_DBHOME");
            if (VerificationUtil.isCRSConfigured()) {
                ResultSet rs = new ResultSet();
                String[] nodesWithCRS = VerificationUtil.getNodesWithCRSInstall(this.m_nodeList, rs, true);
                if (nodesWithCRS == null) {
                    ReportUtil.printError(s_msgBundle.getMessage("9004", true));
                } else if (nodesWithCRS.length != this.m_nodeList.length) {
                    ReportUtil.printWarning(s_msgBundle.getMessage("4038", true));
                    ArrayList<String> failedNodes = new ArrayList<String>();
                    failedNodes.addAll(Arrays.asList(this.m_nodeList));
                    failedNodes.removeAll(Arrays.asList(nodesWithCRS));
                    ReportUtil.sureprintNodelist(failedNodes);
                    ReportUtil.sureprintln(s_msgBundle.getMessage("0008", false));
                    ReportUtil.sureprintNodelist(nodesWithCRS);
                    this.m_nodeList = nodesWithCRS;
                }
            } else if (VerificationUtil.isHAConfigured() && this.m_nodeList.length > 1) {
                throw new ComponentInitException(s_prvgMsgBundle.getMessage("5741", true));
            }
            Trace.out((String)("==== nodelist for component is : " + VerificationUtil.strArr2List(this.m_nodeList)));
            this.initNodeManager();
        }
    }

    @Override
    public boolean verify() {
        if (!VerificationUtil.isStringGood(this.m_collectionType)) {
            return this.compareBaselines();
        }
        return this.collectBaseline();
    }

    public boolean compareBaselines() {
        boolean retval = true;
        String errorMsg = null;
        String xmlFileListString = VerificationUtil.getVariableValue("COMPARE");
        BaselineReportGenerator generator = null;
        try {
            String saveDirectory = this.m_paramMgr.getSinglePartArgVal(Argument.ARG_SAVEDIR);
            if (!VerificationUtil.isStringGood(saveDirectory)) {
                try {
                    saveDirectory = this.m_rootScript ? ReportUtilConstants.getCvuBaselineXmlReportDefaultDirPathForRootScript() : (this.m_resource ? ReportUtilConstants.getCvuBaselineXmlReportDefaultDirPathForCVUResource() : ReportUtilConstants.getCvuBaselineXmlReportDefaultDirPathForUsers());
                }
                catch (ClusterException e) {
                    Trace.out((String)("Error retrieving default save directory: " + ((Object)((Object)e)).getClass() + " : " + e.getMessage()));
                    saveDirectory = System.getProperty("user.dir");
                }
            }
            generator = new BaselineReportGenerator(xmlFileListString);
            ReportUtil.quietblankln();
            ReportUtil.quietprintln(s_prvgMsgBundle.getMessage("11611", false));
            ReportUtil.quietblankln();
            ReportUtil.quietprintln(s_prvgMsgBundle.getMessage("11612", false));
            generator.xmlToHtml(s_prvgMsgBundle.getMessage("11610", false), s_prvgMsgBundle.getMessage("0212", false), this.m_paramMgr.checkArgDeviations(), HtmlConstants.Colors.WhiteSmoke, ReportUtilConstants.ReportContext.BEST_PRACTICE, true, VerificationUtil.getConfiguredValue("CV_DEFAULT_BROWSER_LOCATION", true), true, saveDirectory);
            this.m_resultSet.setStatus(1);
            ReportUtil.quietblankln();
            ReportUtil.quietprintln(s_prvgMsgBundle.getMessage("11613", false));
        }
        catch (XmlFilePathException e) {
            errorMsg = e.getMessage();
            Trace.out((String)("Caught Exception:" + e.getClass() + ":" + errorMsg));
            this.printError(errorMsg);
            this.printError(s_msgBundle.getMessage("0007", false) + LSEP);
            retval = false;
        }
        catch (ReportToolException e) {
            errorMsg = e.getMessage();
            Trace.out((String)("Caught Exception:" + e.getClass() + ":" + errorMsg));
            this.printError(errorMsg);
            this.printError(s_msgBundle.getMessage("0007", false) + LSEP);
            retval = false;
        }
        catch (HtmlBrowserException e) {
            errorMsg = e.getMessage();
            Trace.out((String)("Caught Exception:" + e.getClass() + ":" + errorMsg));
            this.printError(errorMsg);
            this.printError(s_msgBundle.getMessage("0007", false) + LSEP);
            retval = false;
        }
        catch (XmlReportToolException e) {
            errorMsg = e.getMessage();
            Trace.out((String)("Caught Exception:" + e.getClass() + ":" + errorMsg));
            this.printError(errorMsg);
            this.printError(s_msgBundle.getMessage("0007", false) + LSEP);
            retval = false;
        }
        if (retval) {
            ReportUtil.quietblankln();
            ReportUtil.quietprintln(s_prvgMsgBundle.getMessage("11614", false));
            ReportUtil.quietblankln();
        } else {
            ReportUtil.quietblankln();
            ReportUtil.quietprintln(s_prvgMsgBundle.getMessage("11615", false));
            ReportUtil.quietblankln();
        }
        if (retval && generator != null) {
            boolean bl = retval = generator.getMismatchesFound().size() == 0;
            if ("TRUE".equalsIgnoreCase(VerificationUtil.getVariableValue("BASELINE_PRINT_MISMATCH")) && generator.getMismatchesFound().size() > 0) {
                String msg = s_prvgMsgBundle.getMessage("11636", false);
                ReportUtil.quietprintln(msg);
                ReportUtil.quietblankln();
                for (String collectionName : generator.getMismatchesFound()) {
                    ReportUtil.quietprintln(collectionName);
                }
            }
        }
        return retval;
    }

    public boolean collectBaseline() {
        boolean retval = true;
        if (this.m_nodeList.length > 1) {
            VerificationUtil.setLocalNodeOperation(false);
        }
        retval = this.checkSetup();
        this.m_validNodeArr = this.getValidNodeList();
        if (null == this.m_validNodeArr) {
            return false;
        }
        ReportUtil.setMode(false);
        String errorMsg = null;
        XmlReportTool xmlReportTool = null;
        ReportUtilConstants.BasicClusterWareDetails details = new ReportUtilConstants.BasicClusterWareDetails();
        retval = this.performDiscovery(details);
        if (!retval) {
            ReportUtil.quietprintln(LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
        }
        VerificationUtil.setVariableValue("SRC_CRS_HOME_VERSION", details.getClusterwareVersion());
        boolean saveReport = this.m_paramMgr.checkArgSave();
        String saveDirectory = this.m_paramMgr.getSinglePartArgVal(Argument.ARG_SAVEDIR);
        Vector<ReportUtilConstants.DatabaseDetails> failedDatabase = new Vector<ReportUtilConstants.DatabaseDetails>();
        try {
            xmlReportTool = new XmlReportTool();
            xmlReportTool.startDocument(saveDirectory);
            xmlReportTool.addHeader(details);
            String product = this.m_paramMgr.getSinglePartArgVal(Argument.ARG_COLLECT);
            if (product.contains("all") || product.contains("cluster")) {
                retval &= this.collectOSChecks(details.getClusterwareVersion(), xmlReportTool);
            }
            if ((product.contains("all") || product.contains("cluster")) && VerificationUtil.isStringGood(details.getClusterwareVersion())) {
                retval &= this.collectClusterwareChecks(details.getClusterwareVersion(), xmlReportTool);
            }
            if (product.contains("all") || product.contains("database")) {
                Vector<ReportUtilConstants.DatabaseDetails> databaseList = details.getDatabases();
                boolean databaseResult = true;
                for (ReportUtilConstants.DatabaseDetails databaseDtails : databaseList) {
                    if (VerificationUtil.isStringGood(this.m_dbHome) && !this.m_dbHome.equalsIgnoreCase(databaseDtails.getDatabaseHome()) || VerificationUtil.isStringGood(this.m_dbName) && !this.m_dbName.equalsIgnoreCase(databaseDtails.getDatabaseName())) continue;
                    databaseResult = this.collectDatabaseChecks(databaseDtails, xmlReportTool);
                    if (!databaseResult) {
                        failedDatabase.add(databaseDtails);
                    }
                    retval &= databaseResult;
                }
                details.getDatabases().removeAll(failedDatabase);
            }
            xmlReportTool.endDocument();
        }
        catch (ParserConfigurationException pce) {
            errorMsg = pce.getMessage();
            Trace.out((String)("Caught ParserConfigurationException Error:" + errorMsg));
            retval = false;
        }
        catch (XmlFilePathException xpe) {
            errorMsg = xpe.getMessage();
            Trace.out((String)("Caught XmlFilePathException Error:" + errorMsg));
            retval = false;
        }
        catch (XmlReportToolException e) {
            errorMsg = e.getMessage();
            Trace.out((String)("Caught TransformerException Error:" + errorMsg));
            retval = false;
        }
        catch (ReportToolException e) {
            errorMsg = e.getMessage();
            Trace.out((String)("Caught TransformerException Error:" + errorMsg));
            retval = false;
        }
        if (!retval && VerificationUtil.isStringGood(errorMsg)) {
            this.reportFailure(errorMsg + LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
        }
        String statusMsg = null;
        if (VerificationUtil.isStringGood(xmlReportTool.getXMLFilePath())) {
            if (retval && !this.m_resultSet.anyFailure()) {
                statusMsg = s_prvgMsgBundle.getMessage("11637", false);
            } else {
                statusMsg = s_prvgMsgBundle.getMessage("11641", false);
                if (this.m_resultSet.anyFailure()) {
                    statusMsg = statusMsg + " " + s_prvgMsgBundle.getMessage("11642", false, (Object[])new String[]{VerificationUtil.strArr2List(this.m_resultSet.getFailureNodes())});
                }
                if (failedDatabase.size() > 0) {
                    statusMsg = statusMsg + " " + s_prvgMsgBundle.getMessage("11643", false, (Object[])new String[]{VerificationUtil.strCollection2String(failedDatabase)});
                }
            }
            if (this.m_saveToAllNodes) {
                try {
                    ArrayList<String> m_nodeListWithoutLocalNode = new ArrayList<String>();
                    m_nodeListWithoutLocalNode.addAll(Arrays.asList(this.m_nodeList));
                    m_nodeListWithoutLocalNode.remove(VerificationUtil.getLocalHostName());
                    new ClusterCmd().copyFileToNodes(xmlReportTool.getXMLFilePath(), m_nodeListWithoutLocalNode.toArray(new String[0]));
                }
                catch (ClusterException e) {
                    this.printWarning(s_prvgMsgBundle.getMessage("11644", false, (Object[])new String[]{e.getMessage()}) + LSEP);
                }
            }
            statusMsg = statusMsg + " " + s_prvgMsgBundle.getMessage("11638", false, (Object[])new String[]{xmlReportTool.getXMLFilePath()});
        } else {
            statusMsg = s_prvgMsgBundle.getMessage("11639", false);
        }
        ReportUtil.quietprintln(statusMsg + LSEP);
        return retval;
    }

    private boolean collectFromTasks(List<Task> taskList) {
        boolean retval = true;
        try {
            for (Task task : taskList) {
                if (task.hasSubtasks()) {
                    List<VerificationTask> subTaskList = task.getSubtasks();
                    for (VerificationTask subTask : subTaskList) {
                        this.verifyTask((Task)subTask);
                    }
                    continue;
                }
                this.verifyTask(task);
            }
            ReportUtil.quietblankln();
        }
        catch (SubtasksUnavailableException e) {
            Trace.out((Exception)e);
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(e.getMessage()));
            this.printError(e.getMessage());
            return false;
        }
        catch (SubtasksNotCompleteException e) {
            Trace.out((Exception)e);
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(e.getMessage()));
            this.printError(e.getMessage());
            return false;
        }
        catch (VerificationException e) {
            Trace.out((Exception)e);
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(e.getMessage()));
            this.printError(e.getMessage());
            return false;
        }
        return retval;
    }

    private void verifyTask(Task task) throws SubtasksNotCompleteException, VerificationException {
        String msg = s_prvgMsgBundle.getMessage("0207", false, (Object[])new String[]{task.getElementName()});
        ReportUtil.quietprint(msg);
        try {
            task.verify();
            if (Trace.isLevelEnabled((int)1)) {
                Trace.out((String)("\n>>>> SystemComponent:: Upload Task=" + task.getElementName() + "results >>>>>\n"));
            }
            this.m_resultSet.uploadResultSet(task.getResultSet());
            this.printTaskSummary(task);
        }
        catch (Exception e) {
            Trace.out((int)5, (String)"Exception caught while executing %s: %s", (Object[])new Object[]{task.getElementName(), e.getMessage()});
            Trace.out((Exception)e);
            String overAllStatusText = s_prveMsgBundle.getMessage("10031", false);
            ReportUtil.quietprintln(overAllStatusText.toLowerCase());
        }
    }

    private void printTaskSummary(Task task) {
        if (this.m_paramMgr.checkArgDeviations() && task.getResultSet().allSuccess()) {
            return;
        }
        String overAllStatusText = s_prveMsgBundle.getMessage("10127", false);
        ReportUtil.quietprintln(overAllStatusText.toLowerCase());
    }

    private boolean performDiscovery(ReportUtilConstants.BasicClusterWareDetails details) {
        String gridHome = null;
        boolean retval = true;
        String clusterwareVersion = null;
        Version clusterwareVersionObject = null;
        try {
            details.setOsPlatform(VerificationUtil.getOperatingSystemName());
            String localHost = VerificationUtil.getLocalHost();
            boolean haConfigured = VerificationUtil.isHAConfigured();
            if (haConfigured) {
                gridHome = VerificationUtil.getHAHome();
                clusterwareVersion = VerificationUtil.getSIHAReleaseVersion();
                clusterwareVersionObject = VerificationUtil.getSIHAReleaseVersionObj();
            } else {
                gridHome = VerificationUtil.getCRSHome();
                clusterwareVersion = VerificationUtil.getCRSSoftwareVersion(localHost);
                clusterwareVersionObject = VerificationUtil.getCRSSoftwareVersionObj();
            }
            if (gridHome == null) {
                return true;
            }
            if (clusterwareVersion == null) {
                return true;
            }
            this.m_dbUtils = new DBUtils(clusterwareVersionObject);
            Result result = new Result(localHost);
            String crsUser = VerificationUtil.getCRSUser(result, haConfigured);
            if (crsUser != null) {
                details.setCrsUserName(crsUser);
            }
        }
        catch (UnknownHostException e1) {
            Trace.out((Exception)e1);
            this.printError(e1.getMessage());
            ReportUtil.quietprintln(LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
            return false;
        }
        ClusterwareInfo clusterwareInfo = new ClusterwareInfo();
        details.setClusterwareVersion(clusterwareVersion);
        details.setCrsHome(gridHome);
        try {
            String clusterName = clusterwareInfo.getClusterName(gridHome, clusterwareVersionObject);
            if (clusterName != null) {
                details.setClusterName(clusterName);
            }
            if (!CLSyntax.STR_CLUSTER.equals(this.m_paramMgr.getSinglePartArgVal(Argument.ARG_COLLECT))) {
                String dbName = this.m_paramMgr.getSinglePartArgVal(Argument.ARG_DBNAME);
                if (dbName != null) {
                    this.performDatabaseDiscovery(dbName, details);
                } else {
                    String[] dbNameList;
                    for (String dbNameStr : dbNameList = this.m_dbUtils.getDatabases()) {
                        this.performDatabaseDiscovery(dbNameStr, details);
                    }
                }
            }
        }
        catch (InstallException e) {
            Trace.out((Exception)((Object)e));
            this.printError(e.getMessage());
            this.printError(LSEP + s_prvgMsgBundle.getMessage("0213", true) + LSEP);
        }
        catch (Exception e) {
            Trace.out((Exception)e);
            this.printError(e.getMessage());
            this.printError(LSEP + s_prvgMsgBundle.getMessage("0213", true) + LSEP);
        }
        return retval;
    }

    private boolean performDatabaseDiscovery(String dbName, ReportUtilConstants.BasicClusterWareDetails details) {
        try {
            DatabaseInfo database = this.m_dbUtils.getDatabaseInfo(dbName);
            String dbHome = database.getHome();
            Version dbVersion = database.getVersion();
            details.addDatabaseDetails(dbName, dbHome, dbVersion.toString());
        }
        catch (DBUtilsException e) {
            Trace.out((Exception)e);
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            String msg = e.getMessage();
            if (VerificationUtil.isStringGood(msg)) {
                this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(msg));
                this.printError(msg + LSEP);
            }
            return false;
        }
        return true;
    }

    private boolean collectClusterwareChecks(String version, XmlReportTool xmlReportTool) {
        ParamPreReqCRSInst m_paramPreReq = new ParamPreReqCRSInst();
        m_paramPreReq.setORAINVgroup(VerificationUtil.getOraInventoryGroup());
        String[] versionComponents = version.split(Pattern.quote("."));
        String majorNumber = versionComponents[0];
        String minorNumber = "0".equals(versionComponents[1]) ? "1" : versionComponents[1];
        String release = majorNumber + "." + minorNumber;
        m_paramPreReq.setRelease(release);
        VerificationUtil.setVariableValue("CRS_HOME", VerificationUtil.getCRSHome());
        boolean retval = true;
        if (!this.m_paramMgr.checkArgBestPractice()) {
            retval &= this.collectClusterwareMandatoryChecks(version, m_paramPreReq, xmlReportTool);
        }
        if (!this.m_paramMgr.checkArgMandatory()) {
            retval &= this.collectClusterwareBestPractice(version, m_paramPreReq, xmlReportTool);
        }
        return retval;
    }

    private boolean collectClusterwareMandatoryChecks(String version, ParamPreReqCRSInst m_paramPreReq, XmlReportTool xmlReportTool) {
        boolean retval = true;
        VerificationType vfyType = null;
        vfyType = VerificationUtil.isCRSConfigured() ? VerificationType.POSTREQ_CRS_INST : VerificationType.POSTREQ_SI_HA_CONFIG;
        try {
            String contextMsg = s_prvgMsgBundle.getMessage("0255", false);
            ReportUtil.quietblankln();
            ReportUtil.quietprintln(contextMsg);
            ReportUtil.quietblankln();
            List<Task> taskList = TaskFactory.getInstance().getTaskList(vfyType, this.m_validNodeArr, m_paramPreReq);
            if (taskList.size() <= 0) {
                ReportUtil.quietprintln(s_prveMsgBundle.getMessage("3133", false, (Object[])new String[]{version}));
            } else if (!(retval &= this.collectFromTasks(taskList))) {
                this.printError(LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
                return false;
            }
            xmlReportTool.addTarget(vfyType, taskList, null, null);
        }
        catch (TaskFactoryException e) {
            Trace.out((Exception)e);
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(e.getCompleteMessage()));
            this.printError(e.getCompleteMessage() + LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
            return false;
        }
        catch (VerificationException e) {
            Trace.out((Exception)e);
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            String msg = e.getMessage();
            if (VerificationUtil.isStringGood(msg)) {
                this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(msg));
                this.printError(msg + LSEP);
            }
            this.printError(s_msgBundle.getMessage("0007", false) + LSEP);
            return false;
        }
        catch (TransformerException e) {
            Trace.out((Exception)e);
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            String msg = e.getMessage();
            if (VerificationUtil.isStringGood(msg)) {
                this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(msg));
                this.printError(msg + LSEP);
            }
            this.printError(s_msgBundle.getMessage("0007", false) + LSEP);
            return false;
        }
        catch (XmlReportToolException e) {
            Trace.out((Exception)e);
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            String msg = e.getMessage();
            if (VerificationUtil.isStringGood(msg)) {
                this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(msg));
                this.printError(msg + LSEP);
            }
            this.printError(s_msgBundle.getMessage("0007", false) + LSEP);
            return false;
        }
        return retval;
    }

    private boolean collectClusterwareBestPractice(String version, ParamPreReqCRSInst m_paramPreReq, XmlReportTool xmlReportTool) {
        boolean retval = true;
        VerificationType vfyType = null;
        vfyType = VerificationUtil.isCRSConfigured() ? VerificationType.BESTPRACTICE_POSTREQ_CRS_INST : VerificationType.BESTPRACTICE_POSTREQ_SI_HA_CONFIG;
        m_paramPreReq.setORAINVgroup(VerificationUtil.getOraInventoryGroup());
        String[] versionComponents = version.split(Pattern.quote("."));
        String majorNumber = versionComponents[0];
        String minorNumber = "0".equals(versionComponents[1]) ? "1" : versionComponents[1];
        String release = majorNumber + "." + minorNumber;
        m_paramPreReq.setRelease(release);
        try {
            String contextMsg = s_prvgMsgBundle.getMessage("0252", false);
            ReportUtil.quietblankln();
            ReportUtil.quietprintln(contextMsg);
            ReportUtil.quietblankln();
            List<Task> taskList = TaskFactory.getInstance().getTaskList(vfyType, this.m_validNodeArr, m_paramPreReq);
            if (taskList.size() <= 0) {
                ReportUtil.quietprintln(s_prveMsgBundle.getMessage("3134", false, (Object[])new String[]{version}));
            } else if (!(retval &= this.collectFromTasks(taskList))) {
                this.printError(LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
                return false;
            }
            xmlReportTool.addTarget(vfyType, taskList, null, null);
        }
        catch (TaskFactoryException e) {
            Trace.out((Exception)e);
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(e.getCompleteMessage()));
            this.printError(e.getCompleteMessage() + LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
            return false;
        }
        catch (VerificationException e) {
            Trace.out((Exception)e);
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            String msg = e.getMessage();
            if (VerificationUtil.isStringGood(msg)) {
                this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(msg));
                this.printError(msg + LSEP);
            }
            this.printError(s_msgBundle.getMessage("0007", false) + LSEP);
            return false;
        }
        catch (TransformerException e) {
            Trace.out((Exception)e);
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            String msg = e.getMessage();
            if (VerificationUtil.isStringGood(msg)) {
                this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(msg));
                this.printError(msg + LSEP);
            }
            this.printError(s_msgBundle.getMessage("0007", false) + LSEP);
            return false;
        }
        catch (XmlReportToolException e) {
            Trace.out((Exception)e);
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            String msg = e.getMessage();
            if (VerificationUtil.isStringGood(msg)) {
                this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(msg));
                this.printError(msg + LSEP);
            }
            this.printError(s_msgBundle.getMessage("0007", false) + LSEP);
            return false;
        }
        return retval;
    }

    private boolean collectDatabaseChecks(ReportUtilConstants.DatabaseDetails databaseDtails, XmlReportTool xmlReportTool) {
        String dbHome = databaseDtails.getDatabaseHome();
        String dbVersion = databaseDtails.getDatabaseVersion();
        ParamPreReqDBConfig m_paramPreReq = new ParamPreReqDBConfig(dbHome);
        m_paramPreReq.setOraInv(VerificationUtil.getOraInventoryGroup());
        String[] versionComponents = dbVersion.split(Pattern.quote("."));
        String majorNumber = versionComponents[0];
        String minorNumber = "0".equals(versionComponents[1]) ? "1" : versionComponents[1];
        String release = majorNumber + "." + minorNumber;
        m_paramPreReq.setRelease(release);
        String database = databaseDtails.getDatabaseName();
        String userName = "DBSNMP";
        String password = null;
        String portStr = null;
        int port = 1521;
        String dbConnectDescr = null;
        try {
            boolean bPortReq = this.m_dbUtils.isPortRequiredForConnect(database);
            DatabaseConnectInfo dbConnInfo = null;
            if (VerificationUtil.isOTN()) {
                ConsoleUtil consoleUtil = new ConsoleUtil();
                String userNamePrompt = s_prvgMsgBundle.getMessage("11152", false, (Object[])new String[]{database, userName});
                if ((userName = consoleUtil.read(userNamePrompt)) == null || userName.length() == 0) {
                    userName = "DBSNMP";
                }
                String passwordPrompt = s_prvgMsgBundle.getMessage("11150", false, (Object[])new String[]{userName, database});
                password = new String(consoleUtil.readPassword(passwordPrompt));
                if (bPortReq) {
                    String portPrompt = s_prvgMsgBundle.getMessage("11151", false, (Object[])new String[]{database});
                    portStr = consoleUtil.read(portPrompt);
                    try {
                        if (portStr == null || portStr.length() == 0) {
                            port = 1521;
                        }
                        port = Integer.parseInt(portStr);
                    }
                    catch (NumberFormatException e) {
                        Trace.out((String)("Invalid port. " + portStr + ". NumberFormatException occured. msg: " + e.getMessage()));
                        Trace.out((String)"using dafault port 1521");
                        port = 1521;
                    }
                }
            } else {
                password = HeavyWeightVerificationUtil.getDBPassword(database, userName);
            }
            if (bPortReq) {
                dbConnectDescr = this.m_dbUtils.getConnectDescriptor(databaseDtails.getDatabaseName(), port);
                dbConnInfo = new DatabaseConnectInfo(database, userName, password, port);
            } else {
                dbConnectDescr = this.m_dbUtils.getConnectDescriptor(database);
                dbConnInfo = new DatabaseConnectInfo(database, userName, password);
            }
            DatabaseConnectInfo.addDBConnectInfo(dbConnInfo);
            this.testCreds(dbConnectDescr, userName, password);
        }
        catch (ConsoleUtilException e) {
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            String msg = e.getMessage();
            if (VerificationUtil.isStringGood(msg)) {
                this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(msg));
                this.printError(msg + LSEP);
            }
            return false;
        }
        catch (DBConnectionException e) {
            String msg = e.getMessage();
            if (msg.contains(DB_CREDENTIAL_OERR)) {
                this.m_resultSet.addResult(this.m_validNodeArr, 4);
                this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(msg));
                String errorMessage = s_prvgMsgBundle.getMessage("0219", true, (Object[])new String[]{databaseDtails.getDatabaseName(), userName});
                this.printWarning(errorMessage);
                return true;
            }
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(msg));
            String errorMessage = s_prvgMsgBundle.getMessage("0222", true, (Object[])new String[]{databaseDtails.getDatabaseName(), userName});
            this.printError(errorMessage + LSEP + msg + LSEP);
            return false;
        }
        catch (DBUtilsException e) {
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            String msg = e.getMessage();
            if (VerificationUtil.isStringGood(msg)) {
                this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(msg));
                this.printError(msg + LSEP);
            }
            this.printError(s_msgBundle.getMessage("0007", false) + LSEP);
            return false;
        }
        catch (CVUException cvuEx) {
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            String msg = cvuEx.getMessage();
            Trace.out((String)("CVUException occured: msg" + msg));
            if (VerificationUtil.isStringGood(msg)) {
                this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(msg));
                this.printError(msg + LSEP);
            }
            this.printError(s_msgBundle.getMessage("0007", false) + LSEP);
            return false;
        }
        VerificationUtil.setVariableValue("ORACLE_HOME", dbHome);
        VerificationUtil.setVariableValue("SRC_RAC_HOME_VERSION", dbVersion);
        boolean retval = true;
        if (!this.m_paramMgr.checkArgBestPractice()) {
            retval &= this.collectDatabaseMandatoryChecks(databaseDtails, m_paramPreReq, xmlReportTool);
        }
        if (!this.m_paramMgr.checkArgMandatory()) {
            retval &= this.collectDatabaseBestPractice(databaseDtails, m_paramPreReq, xmlReportTool);
        }
        return retval;
    }

    private boolean collectDatabaseMandatoryChecks(ReportUtilConstants.DatabaseDetails databaseDtails, ParamPreReqDBConfig m_paramPreReq, XmlReportTool xmlReportTool) {
        boolean retval = true;
        VerificationType vfyType = VerificationType.POSTREQ_DB_CONFIG;
        try {
            String contextMsg = s_prvgMsgBundle.getMessage("0256", false, (Object[])new String[]{databaseDtails.getDatabaseName()});
            ReportUtil.quietblankln();
            ReportUtil.quietprintln(contextMsg);
            ReportUtil.quietblankln();
            List<Task> taskList = TaskFactory.getInstance().getTaskList(vfyType, this.m_validNodeArr, m_paramPreReq);
            if (taskList.size() <= 0) {
                ReportUtil.quietprintln(s_prveMsgBundle.getMessage("3131", false));
            } else {
                for (Task taskItem : taskList) {
                    if (!(taskItem instanceof TaskSoftwareDistribution)) continue;
                    String home = ((TaskSoftwareDistribution)taskItem).getSoftwareComponentHome();
                    if (this.databaseHomeSoftwareVerifiedList.contains(home)) {
                        Trace.out((int)5, (String)"Home %s already verified, skipping software check", (Object[])new Object[]{home});
                        taskList.remove(taskItem);
                        break;
                    }
                    this.databaseHomeSoftwareVerifiedList.add(home);
                    break;
                }
                if (!(retval &= this.collectFromTasks(taskList))) {
                    this.printError(LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
                    return false;
                }
            }
            xmlReportTool.addTarget(vfyType, taskList, null, databaseDtails.getDatabaseName());
        }
        catch (TaskFactoryException e) {
            Trace.out((Exception)e);
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(e.getCompleteMessage()));
            this.printError(e.getCompleteMessage() + LSEP);
            return false;
        }
        catch (VerificationException e) {
            Trace.out((Exception)e);
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            String msg = e.getMessage();
            if (VerificationUtil.isStringGood(msg)) {
                this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(msg));
                this.printError(msg + LSEP);
            }
            return false;
        }
        catch (TransformerException e) {
            Trace.out((Exception)e);
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            String msg = e.getMessage();
            if (VerificationUtil.isStringGood(msg)) {
                this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(msg));
                this.printError(msg + LSEP);
            }
            return false;
        }
        catch (XmlReportToolException e) {
            Trace.out((Exception)e);
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            String msg = e.getMessage();
            if (VerificationUtil.isStringGood(msg)) {
                this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(msg));
                this.printError(msg + LSEP);
            }
            return false;
        }
        return retval;
    }

    private boolean collectDatabaseBestPractice(ReportUtilConstants.DatabaseDetails databaseDtails, ParamPreReqDBConfig m_paramPreReq, XmlReportTool xmlReportTool) {
        boolean retval = true;
        VerificationType vfyType = VerificationType.BESTPRACTICE_POSTREQ_DB_CONFIG;
        try {
            String contextMsg = s_prvgMsgBundle.getMessage("0253", false, (Object[])new String[]{databaseDtails.getDatabaseName()});
            ReportUtil.quietblankln();
            ReportUtil.quietprintln(contextMsg);
            ReportUtil.quietblankln();
            List<Task> taskList = TaskFactory.getInstance().getTaskList(vfyType, this.m_validNodeArr, m_paramPreReq);
            if (taskList.size() <= 0) {
                ReportUtil.quietprintln(s_prveMsgBundle.getMessage("3132", false));
            } else if (!(retval &= this.collectFromTasks(taskList))) {
                this.printError(LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
                return false;
            }
            xmlReportTool.addTarget(vfyType, taskList, null, databaseDtails.getDatabaseName());
        }
        catch (TaskFactoryException e) {
            Trace.out((Exception)e);
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(e.getCompleteMessage()));
            this.printError(e.getCompleteMessage() + LSEP);
            return false;
        }
        catch (VerificationException e) {
            Trace.out((Exception)e);
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            String msg = e.getMessage();
            if (VerificationUtil.isStringGood(msg)) {
                this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(msg));
                this.printError(msg + LSEP);
            }
            return false;
        }
        catch (TransformerException e) {
            Trace.out((Exception)e);
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            String msg = e.getMessage();
            if (VerificationUtil.isStringGood(msg)) {
                this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(msg));
                this.printError(msg + LSEP);
            }
            return false;
        }
        catch (XmlReportToolException e) {
            Trace.out((Exception)e);
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            String msg = e.getMessage();
            if (VerificationUtil.isStringGood(msg)) {
                this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(msg));
                this.printError(msg + LSEP);
            }
            return false;
        }
        return retval;
    }

    private boolean collectOSChecks(String version, XmlReportTool xmlReportTool) {
        ParamPreReqCRSInst m_paramPreReq = new ParamPreReqCRSInst();
        m_paramPreReq.setORAINVgroup(VerificationUtil.getOraInventoryGroup());
        if (!VerificationUtil.isStringGood(version)) {
            version = "12.1";
        }
        String[] versionComponents = version.split(Pattern.quote("."));
        String majorNumber = versionComponents[0];
        String minorNumber = "0".equals(versionComponents[1]) ? "1" : versionComponents[1];
        String release = majorNumber + "." + minorNumber;
        m_paramPreReq.setRelease(release);
        boolean retval = true;
        if (!this.m_paramMgr.checkArgBestPractice()) {
            retval &= this.collectOSMandatoryChecks(version, m_paramPreReq, xmlReportTool);
        }
        if (!this.m_paramMgr.checkArgMandatory()) {
            retval &= this.collectOSBestPractice(version, m_paramPreReq, xmlReportTool);
        }
        return retval;
    }

    private boolean collectOSMandatoryChecks(String version, ParamPreReqCRSInst m_paramPreReq, XmlReportTool xmlReportTool) {
        boolean retval = true;
        VerificationType vfyType = VerificationType.PREREQ_CRS_INST;
        try {
            String contextMsg = s_prvgMsgBundle.getMessage("0254", false);
            ReportUtil.quietblankln();
            ReportUtil.quietprintln(contextMsg);
            ReportUtil.quietblankln();
            List<Task> taskList = TaskFactory.getInstance().getTaskList(vfyType, this.m_validNodeArr, m_paramPreReq);
            if (VerificationUtil.isCRSConfigured() || VerificationUtil.isHAConfigured()) {
                for (Task taskItem : taskList) {
                    String taskName = taskItem.getClass().getName();
                    if (!taskName.contains("TaskNodeConnectivity")) continue;
                    Trace.out((String)"Removing 'TaskNodeConnectivity' from task list.");
                    taskList.remove(taskItem);
                    break;
                }
            }
            if (taskList.size() <= 0) {
                ReportUtil.quietprintln(s_prveMsgBundle.getMessage("3135", false, (Object[])new String[]{version}));
            } else if (!(retval &= this.collectFromTasks(taskList))) {
                this.printError(LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
                return false;
            }
            xmlReportTool.addTarget(vfyType, taskList, null, null);
        }
        catch (TaskFactoryException e) {
            Trace.out((Exception)e);
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(e.getCompleteMessage()));
            this.printError(e.getCompleteMessage() + LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
            return false;
        }
        catch (VerificationException e) {
            Trace.out((Exception)e);
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            String msg = e.getMessage();
            if (VerificationUtil.isStringGood(msg)) {
                this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(msg));
                this.printError(msg + LSEP);
            }
            this.printError(s_msgBundle.getMessage("0007", false) + LSEP);
            return false;
        }
        catch (TransformerException e) {
            Trace.out((Exception)e);
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            String msg = e.getMessage();
            if (VerificationUtil.isStringGood(msg)) {
                this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(msg));
                this.printError(msg + LSEP);
            }
            this.printError(s_msgBundle.getMessage("0007", false) + LSEP);
            return false;
        }
        catch (XmlReportToolException e) {
            Trace.out((Exception)e);
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            String msg = e.getMessage();
            if (VerificationUtil.isStringGood(msg)) {
                this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(msg));
                this.printError(msg + LSEP);
            }
            this.printError(s_msgBundle.getMessage("0007", false) + LSEP);
            return false;
        }
        return retval;
    }

    private boolean collectOSBestPractice(String version, ParamPreReqCRSInst m_paramPreReq, XmlReportTool xmlReportTool) {
        boolean retval = true;
        VerificationType vfyType = VerificationType.BESTPRACTICE_PRE_CRS_INST;
        try {
            String contextMsg = s_prvgMsgBundle.getMessage("0251", false);
            ReportUtil.quietblankln();
            ReportUtil.quietprintln(contextMsg);
            ReportUtil.quietblankln();
            List<Task> taskList = TaskFactory.getInstance().getTaskList(vfyType, this.m_validNodeArr, m_paramPreReq);
            if (taskList.size() <= 0) {
                ReportUtil.quietprintln(s_prveMsgBundle.getMessage("3136", false, (Object[])new String[]{version}));
            } else if (!(retval &= this.collectFromTasks(taskList))) {
                this.printError(LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
                return false;
            }
            xmlReportTool.addTarget(vfyType, taskList, null, null);
        }
        catch (TaskFactoryException e) {
            Trace.out((Exception)e);
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(e.getCompleteMessage()));
            this.printError(e.getCompleteMessage() + LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
            return false;
        }
        catch (VerificationException e) {
            Trace.out((Exception)e);
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            String msg = e.getMessage();
            if (VerificationUtil.isStringGood(msg)) {
                this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(msg));
                this.printError(msg + LSEP);
            }
            this.printError(s_msgBundle.getMessage("0007", false) + LSEP);
            return false;
        }
        catch (TransformerException e) {
            Trace.out((Exception)e);
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            String msg = e.getMessage();
            if (VerificationUtil.isStringGood(msg)) {
                this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(msg));
                this.printError(msg + LSEP);
            }
            this.printError(s_msgBundle.getMessage("0007", false) + LSEP);
            return false;
        }
        catch (XmlReportToolException e) {
            Trace.out((Exception)e);
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            String msg = e.getMessage();
            if (VerificationUtil.isStringGood(msg)) {
                this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(msg));
                this.printError(msg + LSEP);
            }
            this.printError(s_msgBundle.getMessage("0007", false) + LSEP);
            return false;
        }
        return retval;
    }

    private void reportFailure(String message) {
        this.printError(message);
    }

    private void testCreds(String dbName, String dbUser, String dbPwd) throws DBConnectionException {
        OracleConnection oracleConnection = SQLFactory.getDBConnection((String)dbName, (String)dbUser, (String)dbPwd);
        try {
            oracleConnection.close();
        }
        catch (SQLException sqlEx) {
            Trace.out((String)("SQLException while closing the connection. Mesg:" + sqlEx.getMessage()));
        }
    }

    private void printError(String message) {
        ReportUtil.quietprintln(VerificationConstants.LSEP + ReportUtil.ERROR + VerificationConstants.LSEP + message);
    }

    private void printWarning(String message) {
        ReportUtil.quietprintln(VerificationConstants.LSEP + ReportUtil.WARNING + VerificationConstants.LSEP + message);
    }

    @Override
    public String getComponentName() {
        return "BASELINE";
    }

    @Override
    public String getComponentDisplayName() {
        return "Baseline";
    }
}

