/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.component;

import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.component.Component;
import oracle.ops.verification.framework.engine.component.ComponentInitException;
import oracle.ops.verification.framework.engine.task.TaskCTSSIntegrity;

public class CTSSComponent
extends Component {
    CTSSComponent(int verificationType) throws ComponentInitException {
        super(verificationType);
        this.init();
    }

    @Override
    public boolean verify() {
        boolean retval = this.checkSetup();
        String[] validNodeArr = this.getValidNodeList();
        if (null == validNodeArr) {
            return false;
        }
        retval = this.validateEnvironment();
        if (!retval) {
            return false;
        }
        switch (this.m_verificationType) {
            case 24: {
                TaskCTSSIntegrity taskCTSSI = new TaskCTSSIntegrity(validNodeArr);
                Trace.out((String)"\n>>>> CTSSComponent:: Upload taskCTSSI >>>>>\n");
                this.m_resultSet.uploadResultSet(taskCTSSI.getResultSet());
                return retval &= taskCTSSI.perform();
            }
        }
        Trace.out((String)"ERROR: Invalid Verification Type!");
        return false;
    }

    @Override
    public String getComponentName() {
        return "CTSS";
    }

    @Override
    public String getComponentDisplayName() {
        return s_msgBundle.getMessage("9955", false);
    }
}

