/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.component;

import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.component.Component;
import oracle.ops.verification.framework.engine.component.ComponentInitException;
import oracle.ops.verification.framework.engine.task.TaskClusterMgrIntegrity;

public class ClusterMgrComponent
extends Component {
    ClusterMgrComponent(int verificationType) throws ComponentInitException {
        super(verificationType);
        this.init();
    }

    @Override
    public void init() throws ComponentInitException {
        super.init();
    }

    @Override
    public boolean verify() {
        boolean retval = this.checkSetup();
        String[] validNodeArr = this.getValidNodeList();
        if (null == validNodeArr) {
            return false;
        }
        retval = this.validateEnvironment();
        if (!retval) {
            return false;
        }
        switch (this.m_verificationType) {
            case 6: {
                TaskClusterMgrIntegrity taskCMI = new TaskClusterMgrIntegrity(validNodeArr);
                Trace.out((String)"\n>>>> ClusterMgrComponent:: Upload taskCMI >>>>>\n");
                this.m_resultSet.uploadResultSet(taskCMI.getResultSet());
                return retval &= taskCMI.perform();
            }
        }
        Trace.out((String)"ERROR: Invalid Verification Type!");
        return false;
    }

    @Override
    public String getComponentName() {
        return "CLUSTER_MANAGER";
    }

    @Override
    public String getComponentDisplayName() {
        return s_msgBundle.getMessage("9953", false);
    }
}

