/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.component;

import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.component.Component;
import oracle.ops.verification.framework.engine.component.ComponentInitException;
import oracle.ops.verification.framework.engine.task.TaskDNSChecks;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.RootAutomationUtility;
import oracle.ops.verification.framework.util.VerificationUtil;

public class DNSComponent
extends Component {
    DNSComponent(int verificationType) throws ComponentInitException {
        super(verificationType);
        this.init();
    }

    @Override
    public void init() throws ComponentInitException {
        super.init();
    }

    @Override
    public boolean verify() {
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        if (nativeSystem.isUnixSystem() && !Boolean.getBoolean("CV_ROOTUSERCHECK") && !RootAutomationUtility.isRootExecutionConfigured()) {
            String errMsg = s_msgBundle.getMessage("0055", true, (Object[])new String[]{System.getProperty("user.name")});
            this.m_resultSet.addResult(this.m_nodeList, 2);
            ErrorDescription errDesc = new ErrorDescription(errMsg);
            this.m_resultSet.addErrorDescription(this.m_nodeList, errDesc);
            ReportUtil.sureprintln(errMsg);
            return false;
        }
        boolean retval = this.checkSetup();
        String[] validNodeArr = this.getValidNodeList();
        if (null == validNodeArr) {
            return false;
        }
        String[] crsNodes = VerificationUtil.getNodesWithCRSInstall(validNodeArr, this.m_resultSet);
        if (null == crsNodes) {
            return false;
        }
        switch (this.m_verificationType) {
            case 27: {
                TaskDNSChecks taskDNSI = new TaskDNSChecks(crsNodes);
                Trace.out((String)"\n>>>> DNSComponent:: Upload taskDNSI >>>>>\n");
                this.m_resultSet.uploadResultSet(taskDNSI.getResultSet());
                return retval &= taskDNSI.perform();
            }
        }
        Trace.out((String)"ERROR: Invalid Verification Type!");
        return false;
    }

    @Override
    public String getComponentName() {
        return "DNS";
    }

    @Override
    public String getComponentDisplayName() {
        return s_msgBundle.getMessage("9984", false);
    }
}

