/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.component;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import oracle.cluster.verification.StorageSize;
import oracle.cluster.verification.StorageUnit;
import oracle.cluster.verification.VerificationError;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.config.VDMUtil;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.component.Component;
import oracle.ops.verification.framework.engine.component.ComponentInitException;
import oracle.ops.verification.framework.engine.task.sTaskFreeSpace;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

public class FreeSpaceComponent
extends Component {
    private String m_location;
    private StorageSize m_requiredSize;
    private Double m_requiredPercentSizeAsDbl;

    FreeSpaceComponent(int VerificationType2) throws ComponentInitException {
        super(VerificationType2);
        this.m_verificationType = VerificationType2;
        this.init();
    }

    @Override
    public void init() throws ComponentInitException {
        super.init();
        this.initializeReqdValues();
        Result result = new Result(this.m_nodeList[0]);
        String crsHome = VerificationUtil.getCRSHome(this.m_nodeList[0], result);
        if (crsHome == null) {
            Trace.out((String)"Cannot get CRS Home");
            String errMsg = s_msgBundle.getMessage("5301", true);
            ErrorDescription erD = new ErrorDescription(errMsg);
            this.m_resultSet.addErrorDescription(erD);
            this.m_resultSet.addResult(this.m_nodeList, 2);
            throw new ComponentInitException(errMsg);
        }
        this.m_location = crsHome;
    }

    @Override
    public boolean verify() {
        ResultSet freeSpaceRS = new ResultSet();
        sTaskFreeSpace tfs = new sTaskFreeSpace();
        String uCmd = tfs.getCommand(this.m_location);
        GlobalExecution globalExec = new GlobalExecution();
        boolean retval = this.checkSetup();
        String[] validNodeArr = this.getValidNodeList();
        if (null == validNodeArr) {
            return false;
        }
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        retval = nativeSystem.isUnixSystem() ? globalExec.runGenericCmd(validNodeArr, uCmd, freeSpaceRS) : globalExec.getSpaceCmd(validNodeArr, this.m_location, freeSpaceRS);
        Hashtable t = freeSpaceRS.getResultTable();
        Enumeration e = t.keys();
        this.m_resultSet.uploadResultSet(freeSpaceRS);
        if (!freeSpaceRS.anySuccess()) {
            String msg = s_prvgMsgBundle.getMessage("11101", true, (Object[])new String[]{this.m_location, VerificationUtil.strArr2String(validNodeArr, ",")});
            this.m_resultSet.addErrorDescription(new ErrorDescription(msg));
            List<VerificationError> errList = freeSpaceRS.getErrors();
            for (VerificationError err : errList) {
                msg = msg + LSEP + err.getErrorMessage();
            }
            this.m_resultSet.addResult(this.m_nodeList, 2);
            ReportUtil.sureprintln(msg);
            return false;
        }
        for (int i = 0; i < validNodeArr.length; ++i) {
            String node = validNodeArr[i];
            Result result = (Result)t.get(node);
            if (result.getStatus() == 2) {
                Trace.out((String)("Free Space Monitoring for " + this.m_location + " failed for node " + node));
                String errMsg = s_prvgMsgBundle.getMessage("11101", true, (Object[])new String[]{this.m_location, node});
                ErrorDescription ed = new ErrorDescription(errMsg);
                this.m_resultSet.addErrorDescription(node, ed);
                ReportUtil.sureprintln(errMsg);
                continue;
            }
            String cmdOut = VerificationUtil.strArr2List((String[])result.getResultInfoSet().get(1), LSEP);
            String sizeFreeTxt = tfs.getData(cmdOut, 4);
            String sizeTotalTxt = tfs.getData(cmdOut, 2);
            String sizeUsedTxt = tfs.getData(cmdOut, 3);
            Trace.out((String)("Total size is " + sizeTotalTxt + " free size is " + sizeFreeTxt + " size used is " + sizeUsedTxt));
            Double freeSpace = new Double(sizeFreeTxt);
            Double totalSpace = new Double(sizeTotalTxt);
            Double usedSpace = new Double(sizeUsedTxt);
            Double valFromTotalSpace = this.m_requiredPercentSizeAsDbl * totalSpace;
            StorageSize requiredPercentSize = new StorageSize(valFromTotalSpace, StorageUnit.MBYTE);
            StorageSize minReqSize = this.m_requiredSize.compareTo(requiredPercentSize) > 1 ? this.m_requiredSize : requiredPercentSize;
            Trace.out((String)("minimum required size is " + minReqSize.toString()));
            FreeSpaceValueType fsValType = this.m_requiredSize.compareTo(requiredPercentSize) > 1 ? FreeSpaceValueType.ABSOLUTE : FreeSpaceValueType.PERCENT;
            StorageSize avlSize = new StorageSize(freeSpace, StorageUnit.MBYTE);
            StorageSize totalSize = new StorageSize(totalSpace, StorageUnit.MBYTE);
            if (avlSize.compareTo(minReqSize) < 0) {
                String errMsg;
                Trace.out((String)"free space less than minimum required");
                this.m_resultSet.addResult(node, 3);
                if (fsValType == FreeSpaceValueType.ABSOLUTE) {
                    errMsg = s_prvgMsgBundle.getMessage("11105", true, (Object[])new String[]{this.m_location, node, this.m_requiredSize.toString(), avlSize.toString()});
                } else {
                    double displayReqPercent = this.m_requiredPercentSizeAsDbl * 100.0;
                    errMsg = s_prvgMsgBundle.getMessage("11104", true, (Object[])new String[]{this.m_location, node, Double.toString(displayReqPercent), requiredPercentSize.toString(), avlSize.toString(), totalSize.toString()});
                }
                ErrorDescription errDesc = new ErrorDescription(errMsg);
                this.m_resultSet.addErrorDescription(node, errDesc);
                ReportUtil.sureprintln(errMsg);
                continue;
            }
            Trace.out((String)("Free Space in the filesystem of " + this.m_location + " found on node " + node + " was sufficient"));
            this.m_resultSet.addResult(node, 1);
        }
        if (this.m_resultSet.allSuccess()) {
            ReportUtil.sureprintln(s_prvgMsgBundle.getMessage("11106", false, (Object[])new String[]{this.m_location}));
            retval = true;
        }
        return retval;
    }

    @Override
    public String getComponentName() {
        return "FREESPACE";
    }

    @Override
    public String getComponentDisplayName() {
        return s_prvgMsgBundle.getMessage("11100", false);
    }

    private void initializeReqdValues() {
        this.m_requiredSize = new StorageSize(new Double(VDMUtil.getCRSHomeDefMinSpaceAlertLog(VDMUtil.FreeSpaceValueType.ABSOLUTE)), StorageUnit.MBYTE);
        this.m_requiredPercentSizeAsDbl = new Double(VDMUtil.getCRSHomeDefMinSpaceAlertLog(VDMUtil.FreeSpaceValueType.PERCENT));
    }

    public static enum FreeSpaceValueType {
        ABSOLUTE,
        PERCENT;

    }
}

