/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.component;

import oracle.cluster.verification.common.CVUException;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.component.Component;
import oracle.ops.verification.framework.engine.component.ComponentInitException;
import oracle.ops.verification.framework.engine.task.TaskGNSIntegrity;
import oracle.ops.verification.framework.network.ClusterNetworkInfo;
import oracle.ops.verification.framework.param.Argument;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.CVUHelperUtil;
import oracle.ops.verification.framework.util.NodelistNotFoundException;
import oracle.ops.verification.framework.util.VerificationUtil;

public class GNSComponent
extends Component {
    GNSComponent(int verificationType) throws ComponentInitException {
        super(verificationType);
        this.init();
    }

    @Override
    public void init() throws ComponentInitException {
        super.init();
    }

    @Override
    public boolean verify() {
        String[] crsNodes;
        String[] validNodeArr;
        boolean preCRSInst = false;
        preCRSInst = this.m_paramMgr.checkArgGnsPreCrsinst();
        if (!preCRSInst) {
            try {
                validNodeArr = VerificationUtil.getStaticNodelist();
            }
            catch (NodelistNotFoundException e) {
                this.m_resultSet.addResult(this.m_nodeList, 2);
                ReportUtil.printError(e.getMessage());
                return false;
            }
            Trace.out((String)"adding all cluster nodes to operation");
            this.setNodeList(validNodeArr);
            if (validNodeArr.length > 1) {
                VerificationUtil.setLocalNodeOperation(false);
            }
        }
        boolean retval = this.checkSetup();
        validNodeArr = this.getValidNodeList();
        if (null == validNodeArr) {
            return false;
        }
        if (!preCRSInst) {
            crsNodes = VerificationUtil.getNodesWithCRSInstall(validNodeArr, this.m_resultSet);
            if (null == crsNodes) {
                return false;
            }
            String currentUser = System.getProperty("user.name");
            NativeSystem nativeSystem = new SystemFactory().CreateSystem();
            String crsUser = CVUHelperUtil.getCRSUser();
            if (nativeSystem.isUnixSystem() && crsUser != null && !crsUser.equals(currentUser)) {
                String errMsg = s_msgBundle.getMessage("0056", true, (Object[])new String[]{currentUser});
                this.m_resultSet.addResult(validNodeArr, 2);
                ErrorDescription errDesc = new ErrorDescription(errMsg);
                this.m_resultSet.addErrorDescription(validNodeArr, errDesc);
                ReportUtil.sureprintln(errMsg);
                return false;
            }
        } else {
            crsNodes = validNodeArr;
            if (this.m_paramMgr.hasArgument(Argument.ARG_NETWORKLIST)) {
                Argument netArg = this.m_paramMgr.getArgument(Argument.ARG_NETWORKLIST);
                try {
                    ClusterNetworkInfo netInfo = ClusterNetworkInfo.getNetworkInfoFromPMArg(netArg, validNodeArr[0]);
                    VerificationUtil.setVariableValue("INTERCONNECT_LIST", netInfo.getInterConnectList());
                }
                catch (CVUException cvuEx) {
                    String errMsg = cvuEx.getMessage();
                    ReportUtil.printError(errMsg);
                    Trace.out((String)("CVUException occured. mesg= " + errMsg));
                    this.m_resultSet.addResult(validNodeArr[0], 2);
                    this.m_resultSet.addErrorDescription(new ErrorDescription(errMsg));
                    return false;
                }
            }
        }
        if (!preCRSInst && !(retval = this.validateEnvironment())) {
            return false;
        }
        switch (this.m_verificationType) {
            case 20: {
                TaskGNSIntegrity taskGNSI = new TaskGNSIntegrity(crsNodes);
                taskGNSI.setPreCheck(preCRSInst);
                if (this.m_paramMgr.isGNSDomainSpecified()) {
                    VerificationUtil.setVariableValue("AUTO_CONFIGURE_CLUSTER_NODE_VIP", "TRUE");
                } else {
                    VerificationUtil.setVariableValue("AUTO_CONFIGURE_CLUSTER_NODE_VIP", "FALSE");
                }
                Trace.out((String)"\n>>>> GNSComponent:: Upload taskGNSI >>>>>\n");
                this.m_resultSet.uploadResultSet(taskGNSI.getResultSet());
                return retval &= taskGNSI.perform();
            }
        }
        Trace.out((String)"ERROR: Invalid Verification Type!");
        return false;
    }

    @Override
    public String getComponentName() {
        return "GNS";
    }

    @Override
    public String getComponentDisplayName() {
        return s_msgBundle.getMessage("9956", false);
    }
}

