/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.component;

import java.net.UnknownHostException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import oracle.cluster.cvu.CVU;
import oracle.cluster.cvu.CVUFactory;
import oracle.cluster.deployment.ClusterwareInfo;
import oracle.cluster.install.InstallException;
import oracle.cluster.sql.DBConnectionException;
import oracle.cluster.sql.SQLFactory;
import oracle.cluster.util.ConsoleUtil;
import oracle.cluster.util.ConsoleUtilException;
import oracle.cluster.util.NotExistsException;
import oracle.cluster.verification.ParamPreReqCRSInst;
import oracle.cluster.verification.ParamPreReqDBConfig;
import oracle.cluster.verification.SeverityType;
import oracle.cluster.verification.SubtasksNotCompleteException;
import oracle.cluster.verification.SubtasksUnavailableException;
import oracle.cluster.verification.VerificationError;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.VerificationResultSet;
import oracle.cluster.verification.VerificationTask;
import oracle.cluster.verification.common.CVUException;
import oracle.cluster.verification.database.DatabaseConnectInfo;
import oracle.cluster.verification.util.DBUtils;
import oracle.cluster.verification.util.DBUtilsException;
import oracle.cluster.verification.util.DatabaseInfo;
import oracle.cluster.verification.util.VerificationType;
import oracle.cluster.verification.util.XmlFilePathException;
import oracle.jdbc.driver.OracleConnection;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.component.Component;
import oracle.ops.verification.framework.engine.component.ComponentInitException;
import oracle.ops.verification.framework.engine.component.FreeSpaceComponent;
import oracle.ops.verification.framework.engine.component.UpdateCVUAttribute;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.TaskFactory;
import oracle.ops.verification.framework.engine.task.TaskFactoryException;
import oracle.ops.verification.framework.engine.task.TaskSoftwareDistribution;
import oracle.ops.verification.framework.param.Argument;
import oracle.ops.verification.framework.param.CLSyntax;
import oracle.ops.verification.framework.report.ReportToolException;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.report.ReportUtilConstants;
import oracle.ops.verification.framework.report.htmlreport.HtmlBrowserException;
import oracle.ops.verification.framework.report.htmlreport.HtmlConstants;
import oracle.ops.verification.framework.report.htmlreport.HtmlReportToolException;
import oracle.ops.verification.framework.report.xmlreport.XmlReportTool;
import oracle.ops.verification.framework.report.xmlreport.XmlReportToolException;
import oracle.ops.verification.framework.util.HeavyWeightVerificationUtil;
import oracle.ops.verification.framework.util.NodelistNotFoundException;
import oracle.ops.verification.framework.util.VerificationUtil;

public class HealthCheckComponent
extends Component {
    private String[] m_validNodeArr = null;
    DBUtils m_dbUtils = null;
    private String m_reportName = null;
    private boolean m_isSpaceAlert = false;
    private String[] m_spaceAlertMsgArr = null;
    private static final String DB_CREDENTIAL_OERR = "ORA-01017";
    private static final int DB_PASSWORD_ATTMPTS = 3;
    private List<String> databaseHomeSoftwareVerifiedList = new ArrayList<String>();

    HealthCheckComponent(int verificationType) throws ComponentInitException {
        super(verificationType);
        this.init();
    }

    @Override
    public void init() throws ComponentInitException {
        Trace.out((String)"==== Skipping nodelist initialization.");
        super.init(false);
        try {
            this.m_nodeList = VerificationUtil.getStaticNodelist();
            Trace.out((String)("==== nodelist for component is : " + VerificationUtil.strArr2List(this.m_nodeList)));
            this.m_reportName = VerificationUtil.getVariableValue("HEALTH_CHECK_REPORT_NAME");
        }
        catch (NodelistNotFoundException e) {
            Trace.out((String)("==== " + e.getMessage()));
            throw new ComponentInitException(e.getMessage());
        }
        this.initNodeManager();
    }

    @Override
    public boolean verify() {
        boolean retval = true;
        if (this.m_nodeList.length > 1) {
            VerificationUtil.setLocalNodeOperation(false);
        }
        retval = this.checkSetup();
        this.m_validNodeArr = this.getValidNodeList();
        if (null == this.m_validNodeArr) {
            return false;
        }
        switch (this.m_verificationType) {
            case 29: {
                retval &= this.verifyBestPractice();
                if (VerificationUtil.isCVUResource()) {
                    retval &= this.writeErrorToGlobalAlertLog();
                }
                return retval;
            }
        }
        if (Trace.isTraceEnabled()) {
            Trace.out((String)"ERROR: Invalid Verification Type!");
        }
        return false;
    }

    private boolean verifyBestPractice() {
        boolean retval = true;
        String errorMsg = null;
        XmlReportTool xmlReportTool = null;
        ReportUtilConstants.BasicClusterWareDetails details = new ReportUtilConstants.BasicClusterWareDetails();
        retval = this.performDiscovery(details);
        if (!retval) {
            ReportUtil.quietprintln(LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
        }
        VerificationUtil.setVariableValue("SRC_CRS_HOME_VERSION", details.getClusterwareVersion());
        boolean saveReport = this.m_paramMgr.checkArgSave();
        String saveDirectory = this.m_paramMgr.getSinglePartArgVal(Argument.ARG_SAVEDIR);
        if (VerificationUtil.isCVUResource()) {
            saveReport = true;
            if (!VerificationUtil.isStringGood(saveDirectory)) {
                try {
                    saveDirectory = ReportUtilConstants.getCvuBaselineXmlReportDefaultDirPathForCVUResource();
                }
                catch (ClusterException e) {
                    Trace.out((String)("Save directory for CVU resource could not be retrieved or created: " + e.getMessage()));
                    saveDirectory = null;
                }
            }
        }
        try {
            xmlReportTool = new XmlReportTool();
            xmlReportTool.startDocument(saveDirectory);
            xmlReportTool.addHeader(details);
            String product = this.m_paramMgr.getSinglePartArgVal(Argument.ARG_COLLECT);
            if (!CLSyntax.STR_DATABASE.equals(product) && (retval &= this.verifyOSChecks(details.getClusterwareVersion(), xmlReportTool))) {
                retval &= this.verifyClusterwareChecks(details.getClusterwareVersion(), xmlReportTool);
            }
            if (retval && !CLSyntax.STR_CLUSTER.equals(product)) {
                Vector<ReportUtilConstants.DatabaseDetails> databaseList = details.getDatabases();
                Vector<ReportUtilConstants.DatabaseDetails> failedDatabase = new Vector<ReportUtilConstants.DatabaseDetails>();
                boolean databaseResult = true;
                for (ReportUtilConstants.DatabaseDetails databaseDtails : databaseList) {
                    databaseResult = this.verifyDatabaseChecks(databaseDtails, xmlReportTool);
                    if (!databaseResult) {
                        failedDatabase.add(databaseDtails);
                    }
                    retval &= databaseResult;
                }
                details.getDatabases().removeAll(failedDatabase);
            }
            xmlReportTool.endDocument();
            retval &= this.verifyCRSHomeFreeSpace(details);
            boolean displayHTML = this.m_paramMgr.checkArgHTML();
            if (displayHTML && !VerificationUtil.isDisplayEnabled()) {
                String msg = s_prvgMsgBundle.getMessage("0221", false);
                this.printError(msg);
                ReportUtil.quietblankln();
                displayHTML = false;
                saveReport = true;
            }
            if (this.m_paramMgr.checkArgHTML()) {
                xmlReportTool.xmlToHtml(s_prvgMsgBundle.getMessage("0211", false), s_prvgMsgBundle.getMessage("0212", false), this.m_paramMgr.checkArgDeviations(), HtmlConstants.Colors.WhiteSmoke, ReportUtilConstants.ReportContext.BEST_PRACTICE, displayHTML, VerificationUtil.getConfiguredValue("CV_DEFAULT_BROWSER_LOCATION", true), saveReport, saveDirectory);
            } else {
                xmlReportTool.xmlToText(ReportUtilConstants.ReportContext.BEST_PRACTICE, this.m_paramMgr.checkArgDeviations(), saveReport, saveDirectory, !this.m_paramMgr.checkArgHTML());
            }
        }
        catch (XmlReportToolException e) {
            errorMsg = e.getMessage();
            Trace.out((String)("Caught Exception:" + e.getClass() + ":" + errorMsg));
            retval = false;
        }
        catch (ParserConfigurationException e) {
            errorMsg = e.getMessage();
            Trace.out((String)("Caught Exception:" + e.getClass() + ":" + errorMsg));
            retval = false;
        }
        catch (HtmlReportToolException e) {
            errorMsg = e.getMessage();
            Trace.out((String)("Caught Exception:" + e.getClass() + ":" + errorMsg));
            retval = false;
        }
        catch (XmlFilePathException e) {
            errorMsg = e.getMessage();
            Trace.out((String)("Caught Exception:" + e.getClass() + ":" + errorMsg));
            retval = false;
        }
        catch (HtmlBrowserException e) {
            errorMsg = e.getMessage();
            Trace.out((String)("Caught Exception:" + e.getClass() + ":" + errorMsg));
            retval = false;
        }
        catch (ReportToolException e) {
            errorMsg = e.getMessage();
            Trace.out((String)("Caught Exception:" + e.getClass() + ":" + errorMsg));
            retval = false;
        }
        if (VerificationUtil.isCVUResource()) {
            try {
                ArrayList<String> m_nodeListWithoutLocalNode = new ArrayList<String>();
                m_nodeListWithoutLocalNode.addAll(Arrays.asList(this.m_nodeList));
                m_nodeListWithoutLocalNode.remove(VerificationUtil.getLocalHostName());
                new ClusterCmd().copyFileToNodes(xmlReportTool.getXMLFilePath(), m_nodeListWithoutLocalNode.toArray(new String[0]));
            }
            catch (ClusterException e) {
                this.printWarning(s_prvgMsgBundle.getMessage("11644", false, (Object[])new String[]{e.getMessage()}) + LSEP);
            }
        }
        if (!retval && VerificationUtil.isStringGood(errorMsg)) {
            this.reportFailure(errorMsg + LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
        }
        return retval;
    }

    private boolean verifyTaskList(List<Task> taskList) {
        boolean retval = true;
        try {
            for (Task task : taskList) {
                if (task.hasSubtasks()) {
                    List<VerificationTask> subTaskList = task.getSubtasks();
                    for (VerificationTask subTask : subTaskList) {
                        VerificationResultSet vrset = subTask.verify();
                        ((ResultSet)vrset).allSuccess();
                        if (Trace.isLevelEnabled((int)1)) {
                            Trace.out((String)("\n>>>> SystemComponent:: Upload SubTask=" + subTask.getElementName() + "results >>>>>\n"));
                        }
                        this.m_resultSet.uploadResultSet((ResultSet)vrset);
                        this.printTaskSummary((Task)subTask);
                    }
                    continue;
                }
                task.verify();
                if (Trace.isLevelEnabled((int)1)) {
                    Trace.out((String)("\n>>>> SystemComponent:: Upload Task=" + task.getElementName() + "results >>>>>\n"));
                }
                this.m_resultSet.uploadResultSet(task.getResultSet());
                this.printTaskSummary(task);
            }
            ReportUtil.quietblankln();
        }
        catch (SubtasksUnavailableException e) {
            Trace.out((Exception)e);
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(e.getMessage()));
            this.printError(e.getMessage());
            return false;
        }
        catch (SubtasksNotCompleteException e) {
            Trace.out((Exception)e);
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(e.getMessage()));
            this.printError(e.getMessage());
            return false;
        }
        catch (VerificationException e) {
            Trace.out((Exception)e);
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(e.getMessage()));
            this.printError(e.getMessage());
            return false;
        }
        return retval;
    }

    private void printTaskSummary(Task task) {
        if (this.m_paramMgr.checkArgDeviations() && task.getResultSet().allSuccess()) {
            return;
        }
        String msg = s_prvgMsgBundle.getMessage("0207", false, (Object[])new String[]{task.getElementName()});
        String overAllStatus = task.getResultSet().getOverallStatus().name();
        String overAllStatusText = null;
        boolean isTaskMandatory = !task.isBestPractice();
        boolean showFailuresOnly = this.m_paramMgr.checkArgDeviations();
        boolean isTaskCritical = SeverityType.CRITICAL.equals((Object)task.getSeverity());
        overAllStatusText = VerificationUtil.isStringGood(overAllStatus) && overAllStatus.toLowerCase().contains("success") ? s_prveMsgBundle.getMessage("10030", false) : (VerificationUtil.isStringGood(overAllStatus) && overAllStatus.toLowerCase().contains("warning") ? s_prveMsgBundle.getMessage("10032", false) : (VerificationUtil.isStringGood(overAllStatus) && overAllStatus.toLowerCase().contains("failed") ? (isTaskCritical ? s_prveMsgBundle.getMessage("10031", false) : s_prveMsgBundle.getMessage("10032", false)) : s_prveMsgBundle.getMessage("10033", false)));
        ReportUtil.quietprintln(msg + overAllStatusText.toLowerCase());
    }

    private boolean performDiscovery(ReportUtilConstants.BasicClusterWareDetails details) {
        String gridHome = null;
        boolean retval = true;
        String clusterwareVersion = null;
        Version clusterwareVersionObject = null;
        try {
            details.setOsPlatform(VerificationUtil.getOperatingSystemName());
            String localHost = VerificationUtil.getLocalHost();
            boolean haConfigured = VerificationUtil.isHAConfigured();
            if (haConfigured) {
                gridHome = VerificationUtil.getHAHome();
                clusterwareVersion = VerificationUtil.getSIHAReleaseVersion();
                clusterwareVersionObject = VerificationUtil.getSIHAReleaseVersionObj();
            } else {
                gridHome = VerificationUtil.getCRSHome();
                clusterwareVersion = VerificationUtil.getCRSSoftwareVersion(localHost);
                clusterwareVersionObject = VerificationUtil.getCRSSoftwareVersionObj();
            }
            if (gridHome == null) {
                String cause = s_msgBundle.getMessage("5301", false);
                ReportUtil.quietprintln(VerificationConstants.LSEP + ReportUtil.ERROR + VerificationConstants.LSEP + cause);
                ReportUtil.quietprintln(LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
                return false;
            }
            if (clusterwareVersion == null) {
                String cause = s_msgBundle.getMessage("5434", true);
                ReportUtil.quietprintln(VerificationConstants.LSEP + ReportUtil.ERROR + VerificationConstants.LSEP + cause);
                ReportUtil.quietprintln(LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
                return false;
            }
            this.m_dbUtils = new DBUtils(clusterwareVersionObject);
            Result result = new Result(localHost);
            String crsUser = VerificationUtil.getCRSUser(result, haConfigured);
            if (crsUser != null) {
                details.setCrsUserName(crsUser);
            }
        }
        catch (UnknownHostException e1) {
            Trace.out((Exception)e1);
            this.printError(e1.getMessage());
            ReportUtil.quietprintln(LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
            return false;
        }
        ClusterwareInfo clusterwareInfo = new ClusterwareInfo();
        details.setClusterwareVersion(clusterwareVersion);
        details.setCrsHome(gridHome);
        try {
            String clusterName = clusterwareInfo.getClusterName(gridHome, clusterwareVersionObject);
            if (clusterName != null) {
                details.setClusterName(clusterName);
            }
            if (!CLSyntax.STR_CLUSTER.equals(this.m_paramMgr.getSinglePartArgVal(Argument.ARG_COLLECT))) {
                String dbName = this.m_paramMgr.getSinglePartArgVal(Argument.ARG_DBNAME);
                if (dbName != null) {
                    this.performDatabaseDiscovery(dbName, details);
                } else {
                    String[] dbNameList;
                    for (String dbNameStr : dbNameList = this.m_dbUtils.getDatabases()) {
                        this.performDatabaseDiscovery(dbNameStr, details);
                    }
                }
            }
        }
        catch (InstallException e) {
            Trace.out((Exception)((Object)e));
            this.printError(e.getMessage());
            this.printError(LSEP + s_prvgMsgBundle.getMessage("0213", true) + LSEP);
        }
        catch (Exception e) {
            Trace.out((Exception)e);
            this.printError(e.getMessage());
            this.printError(LSEP + s_prvgMsgBundle.getMessage("0213", true) + LSEP);
        }
        return retval;
    }

    private boolean performDatabaseDiscovery(String dbName, ReportUtilConstants.BasicClusterWareDetails details) {
        try {
            DatabaseInfo database = this.m_dbUtils.getDatabaseInfo(dbName);
            String dbHome = database.getHome();
            Version dbVersion = database.getVersion();
            details.addDatabaseDetails(dbName, dbHome, dbVersion.toString());
        }
        catch (DBUtilsException e) {
            Trace.out((Exception)e);
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            String msg = e.getMessage();
            if (VerificationUtil.isStringGood(msg)) {
                this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(msg));
                this.printError(msg + LSEP);
            }
            return false;
        }
        return true;
    }

    private boolean verifyClusterwareChecks(String version, XmlReportTool xmlReportTool) {
        ParamPreReqCRSInst m_paramPreReq = new ParamPreReqCRSInst();
        m_paramPreReq.setORAINVgroup(VerificationUtil.getOraInventoryGroup());
        String[] versionComponents = version.split(Pattern.quote("."));
        String majorNumber = versionComponents[0];
        String minorNumber = "0".equals(versionComponents[1]) ? "1" : versionComponents[1];
        String release = majorNumber + "." + minorNumber;
        m_paramPreReq.setRelease(release);
        boolean retval = true;
        if (!this.m_paramMgr.checkArgBestPractice()) {
            retval &= this.verifyClusterwareMandatoryChecks(version, m_paramPreReq, xmlReportTool);
        }
        if (!this.m_paramMgr.checkArgMandatory()) {
            retval &= this.verifyClusterwareBestPractice(version, m_paramPreReq, xmlReportTool);
        }
        return retval;
    }

    private boolean verifyCRSHomeFreeSpace(ReportUtilConstants.BasicClusterWareDetails details) {
        boolean retval = false;
        try {
            Trace.out((String)"checking free space of crshome file system");
            String msg = s_prvgMsgBundle.getMessage("11107", false, (Object[])new String[]{details.getCrsHome()});
            FreeSpaceComponent freespaceComp = new FreeSpaceComponent(this.m_verificationType);
            retval = freespaceComp.verify();
            ResultSet freeSpaceRS = freespaceComp.getResultSet();
            String overAllStatusText = null;
            if (freeSpaceRS.allSuccess()) {
                overAllStatusText = s_prveMsgBundle.getMessage("10030", false);
                this.m_isSpaceAlert = false;
                this.m_spaceAlertMsgArr = new String[1];
                this.m_spaceAlertMsgArr[0] = s_prvgMsgBundle.getMessage("11108", false, (Object[])new String[]{details.getCrsHome()});
            } else {
                overAllStatusText = s_prveMsgBundle.getMessage("10031", false);
                this.m_isSpaceAlert = true;
                List<String> errList = this.getErrorMsgList(freeSpaceRS);
                this.m_spaceAlertMsgArr = errList.toArray(new String[0]);
            }
            ReportUtil.quietprintln(msg + overAllStatusText.toLowerCase());
            if (this.m_isSpaceAlert) {
                ReportUtil.quietprintln(VerificationUtil.strArr2List(this.m_spaceAlertMsgArr));
            }
            if (!VerificationUtil.isCVUResource()) {
                this.m_resultSet.uploadResultSet(freeSpaceRS);
            }
        }
        catch (ComponentInitException e) {
            Trace.out((String)("couldn't perform crs home free space check " + e.getMessage()));
            ErrorDescription errDesc = new ErrorDescription(e.getMessage());
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            this.m_resultSet.addErrorDescription(errDesc);
        }
        return retval;
    }

    private boolean verifyClusterwareMandatoryChecks(String version, ParamPreReqCRSInst m_paramPreReq, XmlReportTool xmlReportTool) {
        boolean retval = true;
        VerificationType vfyType = null;
        vfyType = VerificationUtil.isCRSConfigured() ? VerificationType.POSTREQ_CRS_INST : VerificationType.POSTREQ_SI_HA_CONFIG;
        try {
            String contextMsg = s_prvgMsgBundle.getMessage("0216", false);
            ReportUtil.quietblankln();
            ReportUtil.quietprintln(contextMsg);
            ReportUtil.quietblankln();
            List<Task> taskList = TaskFactory.getInstance().getTaskList(vfyType, this.m_validNodeArr, m_paramPreReq);
            if (taskList.size() <= 0) {
                ReportUtil.quietprintln(s_prveMsgBundle.getMessage("3133", false, (Object[])new String[]{version}));
            } else if (!(retval &= this.verifyTaskList(taskList))) {
                this.printError(LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
                return false;
            }
            xmlReportTool.addTarget(vfyType, taskList, null, null);
        }
        catch (TaskFactoryException e) {
            Trace.out((Exception)e);
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(e.getCompleteMessage()));
            this.printError(e.getCompleteMessage() + LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
            return false;
        }
        catch (VerificationException e) {
            Trace.out((Exception)e);
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            String msg = e.getMessage();
            if (VerificationUtil.isStringGood(msg)) {
                this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(msg));
                this.printError(msg + LSEP);
            }
            this.printError(s_msgBundle.getMessage("0007", false) + LSEP);
            return false;
        }
        catch (TransformerException e) {
            Trace.out((Exception)e);
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            String msg = e.getMessage();
            if (VerificationUtil.isStringGood(msg)) {
                this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(msg));
                this.printError(msg + LSEP);
            }
            this.printError(s_msgBundle.getMessage("0007", false) + LSEP);
            return false;
        }
        catch (XmlReportToolException e) {
            Trace.out((Exception)e);
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            String msg = e.getMessage();
            if (VerificationUtil.isStringGood(msg)) {
                this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(msg));
                this.printError(msg + LSEP);
            }
            this.printError(s_msgBundle.getMessage("0007", false) + LSEP);
            return false;
        }
        return retval;
    }

    private boolean verifyClusterwareBestPractice(String version, ParamPreReqCRSInst m_paramPreReq, XmlReportTool xmlReportTool) {
        boolean retval = true;
        VerificationType vfyType = null;
        vfyType = VerificationUtil.isCRSConfigured() ? VerificationType.BESTPRACTICE_POSTREQ_CRS_INST : VerificationType.BESTPRACTICE_POSTREQ_SI_HA_CONFIG;
        m_paramPreReq.setORAINVgroup(VerificationUtil.getOraInventoryGroup());
        String[] versionComponents = version.split(Pattern.quote("."));
        String majorNumber = versionComponents[0];
        String minorNumber = "0".equals(versionComponents[1]) ? "1" : versionComponents[1];
        String release = majorNumber + "." + minorNumber;
        m_paramPreReq.setRelease(release);
        try {
            String contextMsg = s_prvgMsgBundle.getMessage("0209", false);
            ReportUtil.quietblankln();
            ReportUtil.quietprintln(contextMsg);
            ReportUtil.quietblankln();
            List<Task> taskList = TaskFactory.getInstance().getTaskList(vfyType, this.m_validNodeArr, m_paramPreReq);
            if (taskList.size() <= 0) {
                ReportUtil.quietprintln(s_prveMsgBundle.getMessage("3134", false, (Object[])new String[]{version}));
            } else if (!(retval &= this.verifyTaskList(taskList))) {
                this.printError(LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
                return false;
            }
            xmlReportTool.addTarget(vfyType, taskList, null, null);
        }
        catch (TaskFactoryException e) {
            Trace.out((Exception)e);
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(e.getCompleteMessage()));
            this.printError(e.getCompleteMessage() + LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
            return false;
        }
        catch (VerificationException e) {
            Trace.out((Exception)e);
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            String msg = e.getMessage();
            if (VerificationUtil.isStringGood(msg)) {
                this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(msg));
                this.printError(msg + LSEP);
            }
            this.printError(s_msgBundle.getMessage("0007", false) + LSEP);
            return false;
        }
        catch (TransformerException e) {
            Trace.out((Exception)e);
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            String msg = e.getMessage();
            if (VerificationUtil.isStringGood(msg)) {
                this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(msg));
                this.printError(msg + LSEP);
            }
            this.printError(s_msgBundle.getMessage("0007", false) + LSEP);
            return false;
        }
        catch (XmlReportToolException e) {
            Trace.out((Exception)e);
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            String msg = e.getMessage();
            if (VerificationUtil.isStringGood(msg)) {
                this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(msg));
                this.printError(msg + LSEP);
            }
            this.printError(s_msgBundle.getMessage("0007", false) + LSEP);
            return false;
        }
        return retval;
    }

    private boolean verifyDatabaseChecks(ReportUtilConstants.DatabaseDetails databaseDtails, XmlReportTool xmlReportTool) {
        String dbHome = databaseDtails.getDatabaseHome();
        String dbVersion = databaseDtails.getDatabaseVersion();
        ParamPreReqDBConfig m_paramPreReq = new ParamPreReqDBConfig(dbHome);
        m_paramPreReq.setOraInv(VerificationUtil.getOraInventoryGroup());
        String[] versionComponents = dbVersion.split(Pattern.quote("."));
        String majorNumber = versionComponents[0];
        String minorNumber = "0".equals(versionComponents[1]) ? "1" : versionComponents[1];
        String release = majorNumber + "." + minorNumber;
        m_paramPreReq.setRelease(release);
        String contextMsg = s_prvgMsgBundle.getMessage("0218", false, (Object[])new String[]{databaseDtails.getDatabaseName()});
        ReportUtil.quietblankln();
        ReportUtil.quietprintln(contextMsg);
        ReportUtil.quietblankln();
        String database = databaseDtails.getDatabaseName();
        String userName = "DBSNMP";
        String password = null;
        String portStr = null;
        int port = 1521;
        String dbConnectDescr = null;
        try {
            boolean bPortReq = this.m_dbUtils.isPortRequiredForConnect(database);
            DatabaseConnectInfo dbConnInfo = null;
            if (VerificationUtil.isOTN()) {
                ConsoleUtil consoleUtil = new ConsoleUtil();
                if (bPortReq) {
                    String portPrompt = s_prvgMsgBundle.getMessage("11151", false, (Object[])new String[]{database});
                    portStr = consoleUtil.read(portPrompt);
                    try {
                        if (portStr == null || portStr.length() == 0) {
                            port = 1521;
                        }
                        port = Integer.parseInt(portStr);
                    }
                    catch (NumberFormatException e) {
                        Trace.out((String)("Invalid port. " + portStr + ". NumberFormatException occured. msg: " + e.getMessage()));
                        Trace.out((String)"using dafault port 1521");
                        port = 1521;
                    }
                    dbConnectDescr = this.m_dbUtils.getConnectDescriptor(database, port);
                } else {
                    dbConnectDescr = this.m_dbUtils.getConnectDescriptor(database);
                }
                String userNamePrompt = s_prvgMsgBundle.getMessage("11152", false, (Object[])new String[]{database, userName});
                userName = consoleUtil.read(userNamePrompt);
                if (userName == null || userName.length() == 0) {
                    userName = "DBSNMP";
                }
                String passwordPrompt = s_prvgMsgBundle.getMessage("11150", false, (Object[])new String[]{userName, database});
                for (int nPasswdAtmts = 0; nPasswdAtmts < 3; ++nPasswdAtmts) {
                    try {
                        password = new String(consoleUtil.readPassword(passwordPrompt));
                        this.testCreds(dbConnectDescr, userName, password);
                        break;
                    }
                    catch (DBConnectionException e) {
                        String errMsg = e.getMessage();
                        Trace.out((String)("got DBConnectionException. mesg: " + errMsg));
                        if (!errMsg.contains(DB_CREDENTIAL_OERR)) {
                            throw e;
                        }
                        passwordPrompt = s_prvgMsgBundle.getMessage("11153", false, (Object[])new String[]{userName, database});
                        continue;
                    }
                }
            } else {
                password = HeavyWeightVerificationUtil.getDBPassword(database, userName);
            }
            if (bPortReq) {
                dbConnectDescr = this.m_dbUtils.getConnectDescriptor(databaseDtails.getDatabaseName(), port);
                dbConnInfo = new DatabaseConnectInfo(database, userName, password, port);
            } else {
                dbConnectDescr = this.m_dbUtils.getConnectDescriptor(database);
                dbConnInfo = new DatabaseConnectInfo(database, userName, password);
            }
            DatabaseConnectInfo.addDBConnectInfo(dbConnInfo);
            this.testCreds(dbConnectDescr, userName, password);
        }
        catch (ConsoleUtilException e) {
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            String msg = e.getMessage();
            if (VerificationUtil.isStringGood(msg)) {
                this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(msg));
                this.printError(msg + LSEP);
            }
            return false;
        }
        catch (DBConnectionException e) {
            String msg = e.getMessage();
            if (msg.contains(DB_CREDENTIAL_OERR)) {
                this.m_resultSet.addResult(this.m_validNodeArr, 4);
                this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(msg));
                String errorMessage = s_prvgMsgBundle.getMessage("0219", true, (Object[])new String[]{databaseDtails.getDatabaseName(), userName});
                this.printWarning(errorMessage);
                return true;
            }
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(msg));
            String errorMessage = s_prvgMsgBundle.getMessage("0222", true, (Object[])new String[]{databaseDtails.getDatabaseName(), userName});
            this.printError(errorMessage + LSEP + msg + LSEP);
            return false;
        }
        catch (DBUtilsException e) {
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            String msg = e.getMessage();
            if (VerificationUtil.isStringGood(msg)) {
                this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(msg));
                this.printError(msg + LSEP);
            }
            this.printError(s_msgBundle.getMessage("0007", false) + LSEP);
            return false;
        }
        catch (CVUException cvuEx) {
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            String msg = cvuEx.getMessage();
            Trace.out((String)("CVUException occured: msg" + msg));
            if (VerificationUtil.isStringGood(msg)) {
                this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(msg));
                this.printError(msg + LSEP);
            }
            this.printError(s_msgBundle.getMessage("0007", false) + LSEP);
            return false;
        }
        VerificationUtil.setVariableValue("ORACLE_HOME", dbHome);
        VerificationUtil.setVariableValue("SRC_RAC_HOME_VERSION", dbVersion);
        VerificationUtil.setVariableValue("DB_NAME", database);
        boolean retval = true;
        if (!this.m_paramMgr.checkArgBestPractice()) {
            retval &= this.verifyDatabaseMandatoryChecks(databaseDtails, m_paramPreReq, xmlReportTool);
        }
        if (!this.m_paramMgr.checkArgMandatory()) {
            retval &= this.verifyDatabaseBestPractice(databaseDtails, m_paramPreReq, xmlReportTool);
        }
        return retval;
    }

    private boolean verifyDatabaseMandatoryChecks(ReportUtilConstants.DatabaseDetails databaseDtails, ParamPreReqDBConfig m_paramPreReq, XmlReportTool xmlReportTool) {
        boolean retval = true;
        VerificationType vfyType = VerificationType.POSTREQ_DB_CONFIG;
        try {
            String contextMsg = s_prvgMsgBundle.getMessage("0217", false, (Object[])new String[]{databaseDtails.getDatabaseName()});
            ReportUtil.quietblankln();
            ReportUtil.quietprintln(contextMsg);
            ReportUtil.quietblankln();
            List<Task> taskList = TaskFactory.getInstance().getTaskList(vfyType, this.m_validNodeArr, m_paramPreReq);
            if (taskList.size() <= 0) {
                ReportUtil.quietprintln(s_prveMsgBundle.getMessage("3131", false));
            } else {
                for (Task taskItem : taskList) {
                    if (!(taskItem instanceof TaskSoftwareDistribution)) continue;
                    String home = ((TaskSoftwareDistribution)taskItem).getSoftwareComponentHome();
                    if (this.databaseHomeSoftwareVerifiedList.contains(home)) {
                        Trace.out((int)5, (String)"Home %s already verified, skipping software check", (Object[])new Object[]{home});
                        taskList.remove(taskItem);
                        break;
                    }
                    this.databaseHomeSoftwareVerifiedList.add(home);
                    break;
                }
                if (!(retval &= this.verifyTaskList(taskList))) {
                    this.printError(LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
                    return false;
                }
            }
            xmlReportTool.addTarget(vfyType, taskList, null, databaseDtails.getDatabaseName());
        }
        catch (TaskFactoryException e) {
            Trace.out((Exception)e);
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(e.getCompleteMessage()));
            this.printError(e.getCompleteMessage() + LSEP);
            return false;
        }
        catch (VerificationException e) {
            Trace.out((Exception)e);
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            String msg = e.getMessage();
            if (VerificationUtil.isStringGood(msg)) {
                this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(msg));
                this.printError(msg + LSEP);
            }
            return false;
        }
        catch (TransformerException e) {
            Trace.out((Exception)e);
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            String msg = e.getMessage();
            if (VerificationUtil.isStringGood(msg)) {
                this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(msg));
                this.printError(msg + LSEP);
            }
            return false;
        }
        catch (XmlReportToolException e) {
            Trace.out((Exception)e);
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            String msg = e.getMessage();
            if (VerificationUtil.isStringGood(msg)) {
                this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(msg));
                this.printError(msg + LSEP);
            }
            return false;
        }
        return retval;
    }

    private boolean verifyDatabaseBestPractice(ReportUtilConstants.DatabaseDetails databaseDtails, ParamPreReqDBConfig m_paramPreReq, XmlReportTool xmlReportTool) {
        boolean retval = true;
        VerificationType vfyType = VerificationType.BESTPRACTICE_POSTREQ_DB_CONFIG;
        try {
            String contextMsg = s_prvgMsgBundle.getMessage("0210", false, (Object[])new String[]{databaseDtails.getDatabaseName()});
            ReportUtil.quietblankln();
            ReportUtil.quietprintln(contextMsg);
            ReportUtil.quietblankln();
            List<Task> taskList = TaskFactory.getInstance().getTaskList(vfyType, this.m_validNodeArr, m_paramPreReq);
            if (taskList.size() <= 0) {
                ReportUtil.quietprintln(s_prveMsgBundle.getMessage("3132", false));
            } else if (!(retval &= this.verifyTaskList(taskList))) {
                this.printError(LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
                return false;
            }
            xmlReportTool.addTarget(vfyType, taskList, null, databaseDtails.getDatabaseName());
        }
        catch (TaskFactoryException e) {
            Trace.out((Exception)e);
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(e.getCompleteMessage()));
            this.printError(e.getCompleteMessage() + LSEP);
            return false;
        }
        catch (VerificationException e) {
            Trace.out((Exception)e);
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            String msg = e.getMessage();
            if (VerificationUtil.isStringGood(msg)) {
                this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(msg));
                this.printError(msg + LSEP);
            }
            return false;
        }
        catch (TransformerException e) {
            Trace.out((Exception)e);
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            String msg = e.getMessage();
            if (VerificationUtil.isStringGood(msg)) {
                this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(msg));
                this.printError(msg + LSEP);
            }
            return false;
        }
        catch (XmlReportToolException e) {
            Trace.out((Exception)e);
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            String msg = e.getMessage();
            if (VerificationUtil.isStringGood(msg)) {
                this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(msg));
                this.printError(msg + LSEP);
            }
            return false;
        }
        return retval;
    }

    private boolean verifyOSChecks(String version, XmlReportTool xmlReportTool) {
        ParamPreReqCRSInst m_paramPreReq = new ParamPreReqCRSInst();
        m_paramPreReq.setORAINVgroup(VerificationUtil.getOraInventoryGroup());
        String[] versionComponents = version.split(Pattern.quote("."));
        String majorNumber = versionComponents[0];
        String minorNumber = "0".equals(versionComponents[1]) ? "1" : versionComponents[1];
        String release = majorNumber + "." + minorNumber;
        m_paramPreReq.setRelease(release);
        boolean retval = true;
        if (!this.m_paramMgr.checkArgBestPractice()) {
            retval &= this.verifyOSMandatoryChecks(version, m_paramPreReq, xmlReportTool);
        }
        if (!this.m_paramMgr.checkArgMandatory()) {
            retval &= this.verifyOSBestPractice(version, m_paramPreReq, xmlReportTool);
        }
        return retval;
    }

    private boolean verifyOSMandatoryChecks(String version, ParamPreReqCRSInst m_paramPreReq, XmlReportTool xmlReportTool) {
        boolean retval = true;
        VerificationType vfyType = VerificationType.PREREQ_CRS_INST;
        try {
            String contextMsg = s_prvgMsgBundle.getMessage("0215", false);
            ReportUtil.quietblankln();
            ReportUtil.quietprintln(contextMsg);
            ReportUtil.quietblankln();
            List<Task> taskList = TaskFactory.getInstance().getTaskList(vfyType, this.m_validNodeArr, m_paramPreReq);
            if (taskList.size() <= 0) {
                ReportUtil.quietprintln(s_prveMsgBundle.getMessage("3135", false, (Object[])new String[]{version}));
            } else {
                for (Task taskItem : taskList) {
                    String taskName = taskItem.getClass().getName();
                    if (!taskName.contains("TaskNodeConnectivity")) continue;
                    Trace.out((String)"Removing 'TaskNodeConnectivity' from task list.");
                    taskList.remove(taskItem);
                    break;
                }
                if (!(retval &= this.verifyTaskList(taskList))) {
                    this.printError(LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
                    return false;
                }
            }
            xmlReportTool.addTarget(vfyType, taskList, null, null);
        }
        catch (TaskFactoryException e) {
            Trace.out((Exception)e);
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(e.getCompleteMessage()));
            this.printError(e.getCompleteMessage() + LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
            return false;
        }
        catch (VerificationException e) {
            Trace.out((Exception)e);
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            String msg = e.getMessage();
            if (VerificationUtil.isStringGood(msg)) {
                this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(msg));
                this.printError(msg + LSEP);
            }
            this.printError(s_msgBundle.getMessage("0007", false) + LSEP);
            return false;
        }
        catch (TransformerException e) {
            Trace.out((Exception)e);
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            String msg = e.getMessage();
            if (VerificationUtil.isStringGood(msg)) {
                this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(msg));
                this.printError(msg + LSEP);
            }
            this.printError(s_msgBundle.getMessage("0007", false) + LSEP);
            return false;
        }
        catch (XmlReportToolException e) {
            Trace.out((Exception)e);
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            String msg = e.getMessage();
            if (VerificationUtil.isStringGood(msg)) {
                this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(msg));
                this.printError(msg + LSEP);
            }
            this.printError(s_msgBundle.getMessage("0007", false) + LSEP);
            return false;
        }
        return retval;
    }

    private boolean verifyOSBestPractice(String version, ParamPreReqCRSInst m_paramPreReq, XmlReportTool xmlReportTool) {
        boolean retval = true;
        VerificationType vfyType = VerificationType.BESTPRACTICE_PRE_CRS_INST;
        try {
            String contextMsg = s_prvgMsgBundle.getMessage("0208", false);
            ReportUtil.quietblankln();
            ReportUtil.quietprintln(contextMsg);
            ReportUtil.quietblankln();
            List<Task> taskList = TaskFactory.getInstance().getTaskList(vfyType, this.m_validNodeArr, m_paramPreReq);
            if (taskList.size() <= 0) {
                ReportUtil.quietprintln(s_prveMsgBundle.getMessage("3136", false, (Object[])new String[]{version}));
            } else if (!(retval &= this.verifyTaskList(taskList))) {
                this.printError(LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
                return false;
            }
            xmlReportTool.addTarget(vfyType, taskList, null, null);
        }
        catch (TaskFactoryException e) {
            Trace.out((Exception)e);
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(e.getCompleteMessage()));
            this.printError(e.getCompleteMessage() + LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
            return false;
        }
        catch (VerificationException e) {
            Trace.out((Exception)e);
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            String msg = e.getMessage();
            if (VerificationUtil.isStringGood(msg)) {
                this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(msg));
                this.printError(msg + LSEP);
            }
            this.printError(s_msgBundle.getMessage("0007", false) + LSEP);
            return false;
        }
        catch (TransformerException e) {
            Trace.out((Exception)e);
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            String msg = e.getMessage();
            if (VerificationUtil.isStringGood(msg)) {
                this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(msg));
                this.printError(msg + LSEP);
            }
            this.printError(s_msgBundle.getMessage("0007", false) + LSEP);
            return false;
        }
        catch (XmlReportToolException e) {
            Trace.out((Exception)e);
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            String msg = e.getMessage();
            if (VerificationUtil.isStringGood(msg)) {
                this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(msg));
                this.printError(msg + LSEP);
            }
            this.printError(s_msgBundle.getMessage("0007", false) + LSEP);
            return false;
        }
        return retval;
    }

    private void reportFailure(String message) {
        this.printError(message);
    }

    private void printError(String message) {
        ReportUtil.quietprintln(VerificationConstants.LSEP + ReportUtil.ERROR + VerificationConstants.LSEP + message);
    }

    private void printWarning(String message) {
        ReportUtil.quietprintln(VerificationConstants.LSEP + ReportUtil.WARNING + VerificationConstants.LSEP + message);
    }

    private void testCreds(String dbName, String dbUser, String dbPwd) throws DBConnectionException {
        OracleConnection oracleConnection = SQLFactory.getDBConnection((String)dbName, (String)dbUser, (String)dbPwd);
        try {
            oracleConnection.close();
        }
        catch (SQLException sqlEx) {
            Trace.out((String)("SQLException while closing the connection. Mesg:" + sqlEx.getMessage()));
        }
    }

    private boolean writeErrorToGlobalAlertLog() {
        block14: {
            try {
                CVUFactory cvuFac = null;
                CVU cvu = null;
                String previousError = null;
                CVU.SpaceAlertState previousSpaceAlertState = null;
                List<String> errorMsgList = this.getErrorMsgList(this.m_resultSet);
                String[] currentErrorArray = errorMsgList.toArray(new String[0]);
                String currentError = VerificationUtil.strArr2List(currentErrorArray, ",");
                Trace.out((String)("current error =" + currentError));
                currentError = currentError.replace(LSEP, ",");
                Trace.out((String)"Calling CVUFactory.getInstance()");
                cvuFac = CVUFactory.getInstance();
                cvu = cvuFac.getCVU();
                previousError = cvu.getCheckResults();
                previousSpaceAlertState = cvu.getSpaceAlertState();
                Trace.out((String)"got previous results and space alert state");
                if (!currentError.equalsIgnoreCase(previousError)) {
                    ReportUtil.printGlobalAlertLog(currentErrorArray);
                    Trace.out((String)"setting attribute in seperate thread");
                    try {
                        UpdateCVUAttribute chkRes = new UpdateCVUAttribute(cvu, currentError, UpdateCVUAttribute.UpdateAttributeType.CHECK_RESULT);
                        chkRes.start();
                        chkRes.join(30000L);
                        oracle.cluster.cvu.CVUException cve = chkRes.getCVUException();
                        if (cve != null) {
                            throw cve;
                        }
                    }
                    catch (InterruptedException e) {
                        Trace.out((String)"IE. shouldn't happen");
                    }
                    Trace.out((String)"done setting check result attribute");
                }
                boolean isUpdateSpaceAlert = false;
                CVU.SpaceAlertState spaceAlertState = CVU.SpaceAlertState.ON;
                if (this.m_isSpaceAlert) {
                    Trace.out((String)"write alert on clusterware home space");
                    ReportUtil.printGlobalAlertLog(this.m_spaceAlertMsgArr);
                    if (previousSpaceAlertState != CVU.SpaceAlertState.ON) {
                        isUpdateSpaceAlert = true;
                    }
                } else if (previousSpaceAlertState == CVU.SpaceAlertState.ON) {
                    Trace.out((String)"writing to alert log that space is fine");
                    ReportUtil.printGlobalAlertLog(this.m_spaceAlertMsgArr);
                    spaceAlertState = CVU.SpaceAlertState.OFF;
                    isUpdateSpaceAlert = true;
                }
                if (!isUpdateSpaceAlert) break block14;
                try {
                    UpdateCVUAttribute spaceAlrt = new UpdateCVUAttribute(cvu, spaceAlertState, UpdateCVUAttribute.UpdateAttributeType.SPACE_ALERT);
                    spaceAlrt.start();
                    spaceAlrt.join(30000L);
                    oracle.cluster.cvu.CVUException cve = spaceAlrt.getCVUException();
                    if (cve != null) {
                        throw cve;
                    }
                }
                catch (InterruptedException e) {
                    Trace.out((String)"IE. shouldn't happen");
                }
                Trace.out((String)"done setting space alert attribute");
            }
            catch (oracle.cluster.cvu.CVUException ce) {
                Trace.out((String)("CVU exception " + ce.getMessage()));
                Trace.out((String)("Nested exception: " + ((Exception)ce.getCause()).getMessage()));
                return false;
            }
            catch (NotExistsException ne) {
                Trace.out((String)("Notexists  exception " + ne.getMessage()));
                return false;
            }
        }
        return true;
    }

    private List<String> getErrorMsgList(ResultSet rs) {
        ArrayList<String> errorMsgList = new ArrayList<String>();
        List<VerificationError> globalErrors = rs.getErrors();
        for (VerificationError error : globalErrors) {
            String errMsg = error.getErrorMessage();
            Trace.out((String)("adding global error message: " + errMsg));
            errorMsgList.add(errMsg);
        }
        Hashtable resultTable = rs.getResultTable();
        for (Object node : resultTable.keySet()) {
            Result result = (Result)resultTable.get(node);
            for (VerificationError nodeErr : result.getErrors()) {
                String errMsg = nodeErr.getErrorMessage();
                Trace.out((String)("Adding node Error mesg : " + errMsg));
                errorMsgList.add(errMsg);
            }
        }
        return errorMsgList;
    }

    @Override
    public String getComponentName() {
        return "HEALTH_CHECK";
    }

    @Override
    public String getComponentDisplayName() {
        return s_prvgMsgBundle.getMessage("0206", false);
    }
}

