/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.component;

import oracle.cluster.verification.NodeRoleCapability;
import oracle.cluster.verification.nodemgr.NodeManager;
import oracle.cluster.verification.nodemgr.NodeManagerException;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.component.Component;
import oracle.ops.verification.framework.engine.component.ComponentInitException;
import oracle.ops.verification.framework.engine.task.TaskScan;
import oracle.ops.verification.framework.util.VerificationUtil;

public class ScanComponent
extends Component {
    ScanComponent(int verificationType) throws ComponentInitException {
        super(verificationType);
        this.init();
    }

    @Override
    public void init() throws ComponentInitException {
        super.init(false);
        String localHost = VerificationUtil.getLocalHostName();
        this.m_nodeList = new String[]{localHost};
        NodeManager nm = this.initNodeManager();
        try {
            this.m_nodeList = nm.getNodes(NodeRoleCapability.ALL);
        }
        catch (NodeManagerException ex) {
            Trace.out((String)("NodeManagerException occured. message: " + ex.getMessage()));
            Trace.out((Exception)ex);
            throw new ComponentInitException(ex.getMessage());
        }
        VerificationUtil.setNodelist(this.m_nodeList);
    }

    @Override
    protected boolean checkSetup() {
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"ENTRY");
        }
        if (!super.checkSetup()) {
            return false;
        }
        boolean retval = this.validateEnvironment();
        if (!retval) {
            return false;
        }
        if (this.getValidNodeList() == null) {
            return false;
        }
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"EXIT");
        }
        return true;
    }

    @Override
    public boolean verify() {
        boolean retval;
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"ENTRY");
        }
        if (!(retval = this.checkSetup())) {
            return retval;
        }
        String[] validNodeArr = this.getValidNodeList();
        if (null == validNodeArr) {
            return false;
        }
        String[] crsNodes = VerificationUtil.getNodesWithCRSInstall(validNodeArr, this.m_resultSet);
        if (null == crsNodes) {
            return false;
        }
        switch (this.m_verificationType) {
            case 21: {
                TaskScan taskScan = new TaskScan(crsNodes);
                retval &= taskScan.perform();
                if (Trace.isLevelEnabled((int)1)) {
                    Trace.out((String)"\nUpload taskScan ResultSet\n");
                }
                this.m_resultSet.uploadResultSet(taskScan.getResultSet());
                return retval;
            }
        }
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)"ERROR: Invalid Verification Type!");
        }
        return false;
    }

    @Override
    public String getComponentName() {
        return "SCAN";
    }

    @Override
    public String getComponentDisplayName() {
        return s_msgBundle.getMessage("9965", false);
    }
}

