/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.component;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import oracle.cluster.verification.OracleFileType;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.component.Component;
import oracle.ops.verification.framework.engine.component.ComponentInitException;
import oracle.ops.verification.framework.engine.task.TaskSharedStorageAccess;
import oracle.ops.verification.framework.engine.task.TaskSpaceAvail;
import oracle.ops.verification.framework.param.Argument;
import oracle.ops.verification.framework.storage.StorageUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

public class StorageComponent
extends Component {
    String m_location;
    long m_reqdSpace;
    String[] m_storageIDlist;
    String m_deviceString;
    String m_oracleFileType;
    String m_release;

    StorageComponent(int verificationType) throws ComponentInitException {
        super(verificationType);
        this.init();
    }

    @Override
    public void init() throws ComponentInitException {
        super.init();
        switch (this.m_verificationType) {
            case 1: {
                this.m_location = this.m_paramMgr.getSinglePartArgVal(Argument.ARG_STORAGELOCATION);
                Trace.out((String)("==== ParamManager reports location as " + this.m_location));
                String reqSpace = this.m_paramMgr.getSinglePartArgVal(Argument.ARG_DISKSPACE);
                this.m_reqdSpace = Long.parseLong(reqSpace);
                Trace.out((String)("==== ParamManager reports required as " + this.m_reqdSpace));
                break;
            }
            case 2: {
                this.m_storageIDlist = this.m_paramMgr.getMultiPartArgVal(Argument.ARG_STORAGEIDLIST);
                this.m_oracleFileType = this.m_paramMgr.getSinglePartArgVal(Argument.ARG_ORACLE_FILETYPE);
                this.m_release = VerificationUtil.getVariableValue("RELEASE");
                if (this.m_release == null) {
                    this.m_release = "12.1";
                }
                this.m_deviceString = VerificationUtil.getVariableValue("ASM_DISK_DISCOVERY_STRING");
                if (this.m_deviceString == null && (this.m_paramMgr.checkASM() || this.m_paramMgr.checkFlex())) {
                    this.m_deviceString = VerificationUtil.strArr2List(VerificationUtil.getDefaultDiscoveryDevice(this.m_release));
                    VerificationUtil.setVariableValue("ASM_DISK_DISCOVERY_STRING", this.m_deviceString);
                }
                if (this.m_deviceString == null) break;
                String autoNodeListStr = VerificationUtil.getVariableValue("AUTO_LIST");
                String hubNodeListStr = VerificationUtil.getVariableValue("HUB_LIST");
                String[] autoNodeList = null;
                String[] hubNodeList = null;
                if (VerificationUtil.isStringGood(autoNodeListStr)) {
                    autoNodeList = autoNodeListStr.split(",");
                }
                if (VerificationUtil.isStringGood(hubNodeListStr)) {
                    hubNodeList = hubNodeListStr.split(",");
                }
                if (autoNodeList == null && hubNodeList == null) break;
                ArrayList<String> hubAutoNodeList = new ArrayList<String>();
                if (autoNodeList != null) {
                    hubAutoNodeList.addAll(Arrays.asList(autoNodeList));
                }
                if (hubNodeList != null) {
                    hubAutoNodeList.addAll(Arrays.asList(hubNodeList));
                }
                Set<String> asmDeviceList = StorageUtil.expandDevicePaths(hubAutoNodeList.toArray(new String[0]), this.m_deviceString.split(","));
                VerificationUtil.setVariableValue("ASM_DISKGROUP_DISKS", VerificationUtil.strCollection2String(asmDeviceList));
            }
        }
    }

    @Override
    public boolean verify() {
        boolean retval = this.checkSetup();
        String[] validNodeArr = this.getValidNodeList();
        if (null == validNodeArr) {
            return false;
        }
        switch (this.m_verificationType) {
            case 1: {
                TaskSpaceAvail taskSpcAvl = new TaskSpaceAvail(validNodeArr);
                taskSpcAvl.setLocation(this.m_location);
                taskSpcAvl.setReqdSpace(this.m_reqdSpace);
                Trace.out((String)"\n>>>> StorageComponent:: Upload taskSpcAvl >>>>>\n");
                this.m_resultSet.uploadResultSet(taskSpcAvl.getResultSet());
                return retval &= taskSpcAvl.perform();
            }
            case 2: {
                TaskSharedStorageAccess taskSSA = new TaskSharedStorageAccess(validNodeArr);
                taskSSA.setStorageIDlist(this.m_storageIDlist);
                taskSSA.setOracleFileType(this.getOracleFileType(this.m_oracleFileType));
                taskSSA.setRelease(this.m_release);
                taskSSA.setConsiderASMStorage(this.m_paramMgr.checkASM());
                List<String> deviceList = null;
                if (this.m_deviceString != null) {
                    deviceList = Arrays.asList(this.m_deviceString.split(","));
                }
                taskSSA.setDiscoveryASMPaths(deviceList);
                Trace.out((String)"\n>>>> StorageComponent:: Upload taskSSA >>>>>\n");
                this.m_resultSet.uploadResultSet(taskSSA.getResultSet());
                return retval &= taskSSA.perform();
            }
        }
        Trace.out((String)"ERROR: Invalid Verification Type!");
        return false;
    }

    private OracleFileType getOracleFileType(String typeFlag) {
        if ("software".equals(typeFlag)) {
            return OracleFileType.RAC_SOFTWARE;
        }
        if ("data".equals(typeFlag)) {
            return OracleFileType.RAC_DATA_FILES;
        }
        if ("ocr_vdisk".equals(typeFlag)) {
            return OracleFileType.RAC_OCR_VDISK;
        }
        return OracleFileType.RAC_DATA_FILES;
    }

    @Override
    public String getComponentName() {
        return "STORAGE";
    }

    @Override
    public String getComponentDisplayName() {
        return s_msgBundle.getMessage("9967", false);
    }
}

