/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.stage;

import java.util.List;
import oracle.cluster.util.ConsoleUtil;
import oracle.cluster.util.ConsoleUtilException;
import oracle.cluster.verification.ParamPreReqDBInst;
import oracle.cluster.verification.PreReqNotSupportedException;
import oracle.cluster.verification.VerificationAPIConstants;
import oracle.cluster.verification.database.DatabaseConnectInfo;
import oracle.cluster.verification.util.DBUtils;
import oracle.cluster.verification.util.DBUtilsException;
import oracle.cluster.verification.util.VerificationType;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.stage.Stage;
import oracle.ops.verification.framework.engine.stage.StageInitException;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.TaskFactory;
import oracle.ops.verification.framework.engine.task.TaskFactoryException;
import oracle.ops.verification.framework.param.Argument;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.NodelistNotFoundException;
import oracle.ops.verification.framework.util.VerificationUtil;

public class RDBMSInstallStage
extends Stage
implements VerificationAPIConstants {
    private String m_oracleHome;
    private boolean m_oracleHomeOnCFS;
    private String m_osdba;
    private String m_osbackup;
    private String m_osdg;
    private String m_oskm;
    private String m_oraInv;
    private ParamPreReqDBInst m_param = null;
    private boolean m_ASMCheck;
    private boolean m_USMCheck;
    private String[] m_ASMDGList;
    private String m_release;

    @Override
    public void init() throws StageInitException {
        super.init();
        Trace.out((String)"Inside RDBMSInstallStage:init()...");
        if (this.m_verificationMode == 1) {
            this.m_oracleHome = this.m_paramMgr.getSinglePartArgVal(Argument.ARG_ORACLEHOME);
            Trace.out((String)("==== ParamManager reports Oracle Home as: " + this.m_oracleHome));
            this.m_oracleHomeOnCFS = this.m_paramMgr.checkArgCfsOh();
            Trace.out((String)("==== ParamManager reports OracleHome-On-CFS as: " + this.m_oracleHomeOnCFS));
            this.m_ASMCheck = this.m_paramMgr.checkASM();
            Trace.out((String)("==== ParamManager reports Check-ASM as " + this.m_ASMCheck));
            this.m_USMCheck = this.m_paramMgr.checkUSM();
            Trace.out((String)("==== ParamManager reports Check-USM as " + this.m_USMCheck));
            this.m_ASMDGList = this.m_paramMgr.getMultiPartArgVal(Argument.ARG_ASM_DISKGROUP);
            if (this.m_ASMDGList != null) {
                for (String dg : this.m_ASMDGList) {
                    Trace.out((int)5, (String)("==== ParamManager reports dg as " + dg));
                }
            }
            this.m_osdba = this.m_paramMgr.getSinglePartArgVal(Argument.ARG_GROUP_OSDBA);
            Trace.out((String)("==== ParamManager reports OSDBA as: " + this.m_osdba));
            this.m_osbackup = this.m_paramMgr.getSinglePartArgVal(Argument.ARG_GROUP_OSBACKUP);
            Trace.out((String)("==== ParamManager reports OSBACKUP as: " + this.m_osbackup));
            this.m_osdg = this.m_paramMgr.getSinglePartArgVal(Argument.ARG_GROUP_OSDG);
            Trace.out((String)("==== ParamManager reports OSDG as: " + this.m_osdg));
            this.m_oskm = this.m_paramMgr.getSinglePartArgVal(Argument.ARG_GROUP_OSKM);
            Trace.out((String)("==== ParamManager reports OSKM as: " + this.m_oskm));
            if (this.m_osdba == null) {
                this.m_osdba = VerificationUtil.getDefaultDbaGroup();
            }
            this.m_oraInv = VerificationUtil.getOraInventoryGroup();
            this.m_release = VerificationUtil.getRequestedRelease();
            if ("10gR1".equalsIgnoreCase(this.m_release)) {
                this.m_release = "10.1";
            } else if ("10gR2".equalsIgnoreCase(this.m_release)) {
                this.m_release = "10.2";
            } else if ("11gR1".equalsIgnoreCase(this.m_release)) {
                this.m_release = "11.1";
            } else if ("11gR2".equalsIgnoreCase(this.m_release)) {
                this.m_release = "11.2";
            }
            Trace.out((String)"Entering values into ParamPreReqDBInst...");
            this.m_param = new ParamPreReqDBInst();
            this.m_param.setOraInv(this.m_oraInv);
            this.m_param.setOSDBAgroup(this.m_osdba);
            this.m_param.setOSBACKUPgroup(this.m_osbackup);
            this.m_param.setOSDGgroup(this.m_osdg);
            this.m_param.setOSKMgroup(this.m_oskm);
            this.m_param.setOrclHomeOnOCFS(this.m_oracleHomeOnCFS);
            this.m_param.setOrclHome(this.m_oracleHome);
            this.m_param.setCRSHome(VerificationUtil.getCRSHome());
            this.m_param.setHAHome(VerificationUtil.getHAHome());
            this.m_param.setASMCheck(this.m_ASMCheck);
            this.m_param.setUSMCheck(this.m_USMCheck);
            this.m_param.setASMDGList(this.m_ASMDGList);
            this.m_param.setRelease(this.m_release);
            if (this.m_paramMgr.checkArgUpgrade()) {
                if (VerificationUtil.isVersionPre(VerificationUtil.getVariableValue("DEST_VERSION"), "11.2.0.1.0")) {
                    String msg = s_gMsgBundle.getMessage("1195", true);
                    throw new StageInitException(msg);
                }
                this.m_param.setRelease(VerificationUtil.getVariableValue("DEST_VERSION"));
                try {
                    this.m_nodeList = VerificationUtil.getStaticNodelist();
                    VerificationUtil.setLocalNodeOperation(false);
                }
                catch (NodelistNotFoundException e) {
                    this.m_resultSet.addResult(this.m_nodeList, 2);
                    throw new StageInitException(e.getMessage());
                }
                String dbVersion = null;
                String oracleHome = null;
                try {
                    oracleHome = VerificationUtil.getVariableValue("SRC_RAC_HOME");
                    Version crsActiveVersion = VerificationUtil.getCRSActiveVersionObj();
                    dbVersion = String.valueOf(new DBUtils(crsActiveVersion).getDBVersion(oracleHome));
                }
                catch (DBUtilsException e) {
                    Trace.out((String)"Could not find data base version while upgrading.");
                    throw new StageInitException(s_gMsgBundle.getMessage("0602", true, (Object[])new String[]{oracleHome}) + LSEP + e.getMessage());
                }
                if (VerificationUtil.compareVersions(VerificationUtil.getVariableValue("DEST_VERSION"), dbVersion, ".") == 0) {
                    throw new StageInitException(s_gMsgBundle.getMessage("0601", true, (Object[])new String[]{VerificationUtil.getRDBMSVersion()}));
                }
            }
        }
    }

    @Override
    protected boolean checkSetup() {
        boolean resUE = false;
        try {
            if (this.m_nodeList.length == 1 && this.m_nodeList[0].equals(VerificationUtil.getLocalNodename()) && VerificationUtil.isHAConfigured() && !VerificationUtil.isCRSConfigured()) {
                this.setExcludeUserEquiv(true);
            }
        }
        catch (NodelistNotFoundException e) {
            Trace.out((String)("Node List not found:" + e));
            String msg = e.getMessage() + LSEP + s_msgBundle.getMessage("0007", false) + LSEP;
            ReportUtil.printError(msg);
            return false;
        }
        resUE = super.checkSetup();
        if (!resUE) {
            return false;
        }
        if (this.m_validNodeList == null || this.m_validNodeList.length == 0) {
            return false;
        }
        ResultSet rs = new ResultSet();
        String[] nodesWithCRSinstall = VerificationUtil.getNodesWithCRSInstall(this.m_validNodeList, rs);
        this.setValidNodeList(nodesWithCRSinstall);
        if (!this.checkUpgradeSetup()) {
            return false;
        }
        if (nodesWithCRSinstall != null && nodesWithCRSinstall.length != 0) {
            return false;
        }
        return nodesWithCRSinstall.length == this.getNodeList().length;
    }

    private boolean checkUpgradeSetup() {
        Throwable ex = null;
        try {
            if (this.m_paramMgr.checkArgUpgrade()) {
                Trace.out((String)"setting install option to upgrade");
                VerificationUtil.setVariableValue("INSTALL_OPTION", "UPGRADE");
                DBUtils dbUtils = new DBUtils(VerificationUtil.getCRSActiveVersionObj());
                ConsoleUtil consoleUtil = new ConsoleUtil();
                String[] dbList = this.m_paramMgr.getMultiPartArgVal(Argument.ARG_DBNAME);
                if (dbList == null) {
                    dbList = dbUtils.getDatabases();
                }
                for (String db : dbList) {
                    DatabaseConnectInfo dbConnInfo = null;
                    String userPrompt = s_gMsgBundle.getMessage("11152", false, (Object[])new String[]{db, "DBSNMP"});
                    String userName = consoleUtil.read(userPrompt);
                    if (userName == null || userName.length() == 0) {
                        userName = "DBSNMP";
                        Trace.out((String)("Username is not provided. using default user" + userName + " to connect to database " + db));
                    }
                    String psswordPrompt = s_gMsgBundle.getMessage("11150", false, (Object[])new String[]{userName, db});
                    String password = new String(consoleUtil.readPassword(psswordPrompt));
                    password = password.replaceAll("\"", "\"\"");
                    if (dbUtils.isPortRequiredForConnect(db)) {
                        int port = 1521;
                        String portPrompt = s_gMsgBundle.getMessage("11151", false, (Object[])new String[]{db});
                        String portStr = consoleUtil.read(portPrompt);
                        if (portStr == null || portStr.length() == 0) {
                            try {
                                port = Integer.parseInt(portStr);
                            }
                            catch (NumberFormatException nex) {
                                Trace.out((String)("Error while parsing input " + portStr + " entered for database " + db));
                                Trace.out((String)"using default port 1521");
                                port = 1521;
                            }
                        } else {
                            port = 1521;
                        }
                        dbConnInfo = new DatabaseConnectInfo(db, userName, password, port);
                    } else {
                        dbConnInfo = new DatabaseConnectInfo(db, userName, password);
                    }
                    Trace.out((String)("Addding database coonnection info " + dbConnInfo));
                    DatabaseConnectInfo.addDBConnectInfo(dbConnInfo);
                }
            }
        }
        catch (DBUtilsException dbEx) {
            Trace.out((String)("DBUtilsException: " + dbEx.getMessage()));
            ex = dbEx;
        }
        catch (ConsoleUtilException cuEx) {
            Trace.out((String)("ConsoleUtilException: " + cuEx.getMessage()));
            ex = cuEx;
        }
        if (ex != null) {
            String msg = s_msgBundle.getMessage("0007", false) + LSEP + ex.getMessage() + LSEP;
            ReportUtil.printError(msg);
            return false;
        }
        return true;
    }

    RDBMSInstallStage(int verificationMode) throws StageInitException {
        super(verificationMode);
        this.init();
    }

    @Override
    protected void setTaskList() throws TaskFactoryException, PreReqNotSupportedException {
        if (this.m_verificationMode == 1) {
            List<Task> dbInstStageTaskList = null;
            dbInstStageTaskList = TaskFactory.getInstance().getTaskList(VerificationType.PREREQ_DB_INST, this.getValidNodeList(), this.m_param, this);
            this.addToCurrentTaskSet(dbInstStageTaskList.toArray(new Task[0]));
        }
    }

    @Override
    public void generateReport() {
    }
}

