/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.stage;

import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.engine.stage.CFSSetupStage;
import oracle.ops.verification.framework.engine.stage.ClusterSvcSetupStage;
import oracle.ops.verification.framework.engine.stage.DBConfigStage;
import oracle.ops.verification.framework.engine.stage.HAConfigStage;
import oracle.ops.verification.framework.engine.stage.HWOSSetupStage;
import oracle.ops.verification.framework.engine.stage.InvalidStageException;
import oracle.ops.verification.framework.engine.stage.NodeAddStage;
import oracle.ops.verification.framework.engine.stage.NodeDelStage;
import oracle.ops.verification.framework.engine.stage.RDBMSInstallStage;
import oracle.ops.verification.framework.engine.stage.Stage;
import oracle.ops.verification.framework.engine.stage.StageInitException;
import oracle.ops.verification.framework.engine.stage.USMConfigStage;

public class StageFactory
implements VerificationConstants {
    public static Stage createStage(String stageID, int mode) throws InvalidStageException, StageInitException {
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"Entry");
        }
        if (stageID.equalsIgnoreCase("hwos")) {
            return new HWOSSetupStage(mode);
        }
        if (stageID.equalsIgnoreCase("cfs")) {
            return new CFSSetupStage(mode);
        }
        if (stageID.equalsIgnoreCase("crsinst")) {
            return new ClusterSvcSetupStage(mode);
        }
        if (stageID.equalsIgnoreCase("hacfg")) {
            return new HAConfigStage(mode);
        }
        if (stageID.equalsIgnoreCase("dbinst")) {
            return new RDBMSInstallStage(mode);
        }
        if (stageID.equalsIgnoreCase("dbcfg")) {
            return new DBConfigStage(mode);
        }
        if (stageID.equalsIgnoreCase("nodeadd")) {
            return new NodeAddStage(mode);
        }
        if (stageID.equalsIgnoreCase("nodedel")) {
            return new NodeDelStage(mode);
        }
        if (stageID.equalsIgnoreCase("acfscfg")) {
            return new USMConfigStage(mode);
        }
        throw new InvalidStageException("Invalid Stage ID: " + stageID);
    }
}

