/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.net.InetAddress;
import java.net.UnknownHostException;
import oracle.ops.mgmt.trace.Trace;

class GetAllByNameThread
extends Thread {
    String m_lookupName;
    String m_errReportNode;
    long m_startTime = 0L;
    long m_endTime = 0L;
    InetAddress[] m_allIPs = null;
    UnknownHostException uhe = null;

    public GetAllByNameThread(String lookupName, String errReportNode) {
        this.m_lookupName = lookupName;
        this.m_errReportNode = errReportNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.m_startTime = System.currentTimeMillis();
            Trace.out((String)("starting query for :" + this.m_lookupName + "at " + this.m_startTime));
            this.m_allIPs = InetAddress.getAllByName(this.m_lookupName);
        }
        catch (UnknownHostException e) {
            this.uhe = e;
        }
        finally {
            this.m_endTime = System.currentTimeMillis();
            Trace.out((String)("name lookup ended at " + this.m_endTime));
        }
    }

    public InetAddress[] getAllIPAddress() {
        return this.m_allIPs;
    }

    public UnknownHostException getUnknownHostException() {
        return this.uhe;
    }

    public long getCheckStartTime() {
        return this.m_startTime;
    }

    public long getCheckEndTime() {
        return this.m_endTime;
    }

    public String getLookupName() {
        return this.m_lookupName;
    }

    public String getErrNodeName() {
        return this.m_errReportNode;
    }
}

