/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import oracle.cluster.impl.verification.FixupResultSetImpl;
import oracle.cluster.verification.FixupResult;
import oracle.cluster.verification.FixupResultSet;
import oracle.cluster.verification.InvalidFixupNodeException;
import oracle.cluster.verification.NodeResultsUnavailableException;
import oracle.cluster.verification.NodeRoleCapability;
import oracle.cluster.verification.SeverityType;
import oracle.cluster.verification.SubtasksNotCompleteException;
import oracle.cluster.verification.SubtasksUnavailableException;
import oracle.cluster.verification.VerificationError;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.VerificationResult;
import oracle.cluster.verification.VerificationResultSet;
import oracle.cluster.verification.VerificationTask;
import oracle.cluster.verification.fixup.FixupData;
import oracle.cluster.verification.fixup.FixupTaskListContainer;
import oracle.cluster.verification.fixup.FixupUtility;
import oracle.cluster.verification.nodemgr.NoSuchNodesException;
import oracle.cluster.verification.nodemgr.NodeManager;
import oracle.cluster.verification.nodemgr.NodeManagerException;
import oracle.cluster.verification.nodemgr.NodeManagerFactory;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.MultiTaskHandler;
import oracle.ops.verification.framework.engine.task.PluggableTask;
import oracle.ops.verification.framework.engine.task.TaskCompletionEvent;
import oracle.ops.verification.framework.engine.task.TaskCompletionEventMulticaster;
import oracle.ops.verification.framework.engine.task.TaskCompletionListener;
import oracle.ops.verification.framework.param.ParamManager;
import oracle.ops.verification.framework.param.UninitializedParamManagerException;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.CVUCheckSkipper;
import oracle.ops.verification.framework.util.RootUserCredentials;
import oracle.ops.verification.framework.util.VerificationLogData;
import oracle.ops.verification.framework.util.VerificationUtil;

public abstract class Task
implements VerificationConstants,
TaskCompletionListener,
VerificationTask {
    protected static MessageBundle s_msgBundle;
    protected static MessageBundle s_gMsgBundle;
    public static final int CONTINUE = 1;
    public static final int STOP_ON_ERROR = 2;
    public static final int ACTION_ON_ERROR = 3;
    public static final int ACTION_ON_COMPLETION = 4;
    protected String[] m_nodeList;
    private String m_defaultTaskID = null;
    private int m_actionOnCompletion;
    protected ResultSet m_resultSet = new ResultSet();
    private boolean m_fixupReqd = FixupUtility.getDefaultFixupRequirement();
    private boolean m_isFixupProcessed = false;
    private boolean m_fixupRebootRequired = false;
    private FixupData m_fixupData = null;
    protected FixupResultSetImpl m_fixupResultSet = null;
    private MultiTaskHandler m_multiTaskHandler;
    private boolean m_diagnosticMode = false;
    private Vector m_tasksWaitedFor = new Vector();
    private TaskCompletionListener m_taskCompletionListener;
    private boolean m_hasSubtasks;
    private Task[] m_subtasks;
    private boolean m_isTaskOver;
    private boolean m_runBefore = false;
    protected String m_elementName;
    protected String m_description;
    protected SeverityType m_taskSeverity = SeverityType.CRITICAL;
    protected boolean m_bestPractice = false;
    protected String m_moreDetails;
    protected List<String> m_referenceList;
    protected NodeManager m_nodeMgr = null;
    protected String[] m_ignoreNodeList = null;
    private static ParamManager pm;
    public static boolean m_isCLImode;
    public static boolean m_isAPImode;
    protected static String m_localHost;
    int m_defaultTimeout = 0;
    RootUserCredentials m_rootCreds = null;

    public Task() {
        this(null, 1);
    }

    public Task(MultiTaskHandler multiTaskHandler) {
        this(multiTaskHandler, 1);
    }

    public Task(MultiTaskHandler multiTaskHandler, int actionOnCompletion) {
        this.m_multiTaskHandler = multiTaskHandler;
        this.m_actionOnCompletion = actionOnCompletion;
        this.m_nodeMgr = this.getNodeManager();
        this.m_defaultTaskID = this.getClass().getSimpleName().toUpperCase();
    }

    public Task(String[] nodeList) {
        this(nodeList, null, 1);
    }

    public Task(String[] nodeList, String taskID) {
        this(nodeList, null, 1);
        this.m_defaultTaskID = taskID;
    }

    public Task(String[] nodeList, MultiTaskHandler multiTaskHandler) {
        this(nodeList, multiTaskHandler, 1);
    }

    public Task(String[] nodeList, MultiTaskHandler multiTaskHandler, int actionOnCompletion) {
        Trace.out((String)(this.getClass().getName() + "::nodeList='" + VerificationUtil.strArr2List(nodeList) + "'"));
        this.m_nodeList = nodeList;
        this.m_multiTaskHandler = multiTaskHandler;
        this.m_actionOnCompletion = actionOnCompletion;
        this.m_nodeMgr = this.getNodeManager();
        this.m_defaultTaskID = this.getClass().getSimpleName().toUpperCase();
    }

    public String[] getNodeList() {
        return this.m_nodeList;
    }

    public void setNodeList(String[] nodeList) {
        this.m_nodeList = nodeList;
    }

    public boolean performTask() {
        this.m_resultSet.addResult(this.m_nodeList, 1);
        return true;
    }

    public boolean performDiagnostics() {
        return true;
    }

    public void clean() {
        Trace.out((String)"Default 'clean()' method called.");
    }

    public boolean perform() {
        boolean resultVal;
        ArrayList<String> loggerDataBeforeTask = new ArrayList<String>();
        List<String> loggerData = VerificationLogData.getVerificationLogData();
        loggerDataBeforeTask.addAll(loggerData);
        String taskName = this.getClass().getName();
        if (taskName.contains(".")) {
            taskName = taskName.substring(taskName.lastIndexOf(".") + 1);
        }
        if (taskName.equals("PluggableTask")) {
            taskName = taskName + "(" + ((PluggableTask)this).getTaskID() + ")";
        }
        taskName = taskName + ":" + this.getElementName();
        taskName = taskName + "[" + this.getTaskID() + "]";
        Trace.out((String)(LSEP + taskName + ":TASK_START"));
        VerificationLogData.logFine(LSEP + taskName + ":TASK_START");
        if (this.skipThisTask()) {
            Trace.out((String)(taskName + " is marked for skipping. not performing this task"));
            resultVal = true;
        } else if (!this.setupNodesForBigCluster()) {
            Trace.out((String)"setupNodesForBigCluster() failed. ");
            resultVal = false;
        } else if (this.m_nodeList != null && this.m_nodeList.length == 0) {
            Trace.out((String)"0 size nodelist. The task does not have to execute on any nodes.");
            resultVal = true;
        } else {
            Trace.out((String)("m_nodeList='" + VerificationUtil.strArr2List(this.m_nodeList) + "'"));
            VerificationLogData.logFine(LSEP + "m_nodeList='" + VerificationUtil.strArr2List(this.m_nodeList) + "'");
            FixupTaskListContainer.addPerformedTask(this);
            resultVal = !this.performTask() ? (this.m_diagnosticMode ? this.performDiagnostics() : false) : true;
        }
        if (this.m_multiTaskHandler != null) {
            if (this.m_taskCompletionListener != null) {
                if (Trace.isLevelEnabled((int)1)) {
                    Trace.out((String)"Inside Task:perform() - sending events...");
                }
                TaskCompletionEvent completionEvent = new TaskCompletionEvent(this, 2000);
                this.m_taskCompletionListener.taskCompleted(completionEvent);
            }
            this.m_multiTaskHandler.removeFromCurrentTaskSet(this);
        }
        this.m_isTaskOver = true;
        this.processIgnoreCVUErrors();
        int taskStatus = this.m_resultSet.getStatus();
        if (taskStatus == 1) {
            Trace.out((String)(LSEP + taskName + ":TASK_SUMMARY:SUCCESSFUL"));
            VerificationLogData.setVerificationLogData(loggerDataBeforeTask);
        } else {
            StringBuilder summary = taskStatus == 4 ? new StringBuilder(taskName + ":TASK_SUMMARY:WARNING") : new StringBuilder(taskName + ":TASK_SUMMARY:FAILED");
            summary.append(":" + this.getSeverity().name());
            summary.append(":" + ResultSet.resultsetStatusString(taskStatus));
            List<VerificationError> errorList = this.m_resultSet.getErrors();
            for (VerificationError err : errorList) {
                summary.append(LSEP + "          ERRORMSG(GLOBAL): " + err.getErrorMessage());
            }
            if (this.m_resultSet.hasNodeResults()) {
                List<VerificationResult> nrList = null;
                try {
                    nrList = this.m_resultSet.getNodeResults();
                }
                catch (NodeResultsUnavailableException nre) {
                    summary.append(LSEP + "          APPLICATION_ERROR: NodeResultsUnavailableException thrown when hasNodeResults() returns true");
                }
                if (nrList != null) {
                    for (VerificationResult nres : nrList) {
                        errorList = nres.getErrors();
                        for (VerificationError err : errorList) {
                            summary.append(LSEP + "          ERRORMSG(" + nres.getNode() + "): " + err.getErrorMessage());
                        }
                    }
                }
            }
            Trace.out((String)(LSEP + summary.toString()));
            VerificationLogData.logFine(LSEP + summary.toString());
        }
        this.clean();
        return resultVal;
    }

    public void setActionOnCompletion(int actionOnCompletion) {
        this.m_actionOnCompletion = actionOnCompletion;
    }

    public int getActionOnCompletion() {
        return this.m_actionOnCompletion;
    }

    public ResultSet getResultSet() {
        return this.m_resultSet;
    }

    @Override
    public FixupResultSet getFixupResultSet() {
        return this.m_fixupResultSet;
    }

    public void updateFixupResultSet(FixupResultSetImpl fixupResultSet) {
        if (this.m_fixupResultSet == null) {
            this.m_fixupResultSet = fixupResultSet;
        } else {
            this.m_fixupResultSet.updateResultSet(fixupResultSet);
        }
    }

    public void addFixupResult(String node, FixupResult result) throws InvalidFixupNodeException {
        if (null != this.m_fixupResultSet) {
            this.m_fixupResultSet.addNodeResult(node, result);
        }
    }

    public synchronized Vector getTasksWaitedFor() {
        return this.m_tasksWaitedFor;
    }

    public synchronized boolean isEmptyTasksWaitedFor() {
        return this.m_tasksWaitedFor.isEmpty();
    }

    public synchronized void waitFor(Task task) {
        this.m_tasksWaitedFor.addElement(task);
        task.addTaskCompletionListener(this);
    }

    public synchronized void waitFor(Task[] taskArr) {
        for (int i = 0; i < taskArr.length; ++i) {
            this.m_tasksWaitedFor.addElement(taskArr[i]);
            taskArr[i].addTaskCompletionListener(this);
        }
    }

    public synchronized void removeFromTasksWaitedFor(Task task) {
        this.m_tasksWaitedFor.removeElement(task);
    }

    @Override
    public void taskCompleted(TaskCompletionEvent e) {
        if (Trace.isLevelEnabled((int)1)) {
            Trace.out((String)"Inside Task:taskCompleted()...");
        }
        this.removeFromTasksWaitedFor(e.getTask());
        if (this.isEmptyTasksWaitedFor() && this.m_multiTaskHandler != null) {
            this.m_multiTaskHandler.addToCurrentTaskSet(this);
        }
    }

    public synchronized void addTaskCompletionListener(TaskCompletionListener l) {
        if (Trace.isLevelEnabled((int)1)) {
            Trace.out((String)"Inside Task:addTaskCompletionListener()...");
        }
        this.m_taskCompletionListener = TaskCompletionEventMulticaster.add(this.m_taskCompletionListener, l);
    }

    protected void setFixup(boolean fixupReqd) {
        this.m_fixupReqd = fixupReqd;
    }

    protected boolean isFixupReqd() {
        return this.m_fixupReqd;
    }

    @Override
    public boolean isRebootRequiredForFixup() {
        return this.m_fixupRebootRequired;
    }

    protected void setRebootRequiredForFixup(boolean rebootRequired) {
        this.m_fixupRebootRequired = rebootRequired;
    }

    @Override
    public boolean isFixable() {
        return this.m_fixupData != null && this.m_fixupData.getParticipatingNodes().size() > 0;
    }

    public FixupData getFixupData() {
        return this.m_fixupData;
    }

    public void setFixupData(FixupData fixupDataObj) {
        if (null != fixupDataObj && fixupDataObj.getParticipatingNodes().size() > 0) {
            boolean addedToContainer = this.isFixupDataSet();
            this.m_fixupData = fixupDataObj;
            if (!addedToContainer) {
                FixupTaskListContainer.addFixupTask(this);
            }
        }
    }

    protected boolean isFixupDataSet() {
        return this.m_fixupData != null;
    }

    public String getTaskID() {
        return this.getDefaultTaskID();
    }

    public final String getDefaultTaskID() {
        if (!VerificationUtil.isStringGood(this.m_defaultTaskID)) {
            this.m_defaultTaskID = this.getClass().getSimpleName().toUpperCase();
        }
        return this.m_defaultTaskID;
    }

    @Override
    public String getElementName() {
        if (this.m_elementName != null) {
            return this.m_elementName;
        }
        return this.getDefaultElementName();
    }

    public abstract String getDefaultElementName();

    @Override
    public String getDescription() {
        if (this.m_description != null) {
            return this.m_description;
        }
        return this.getDefaultDescription();
    }

    public abstract String getDefaultDescription();

    @Override
    public VerificationResultSet verify() throws SubtasksNotCompleteException, VerificationException {
        return this.verify(FixupUtility.getDefaultFixupRequirement());
    }

    @Override
    public VerificationResultSet verify(boolean fixup) throws SubtasksNotCompleteException, VerificationException {
        if (this.m_runBefore) {
            this.m_resultSet = new ResultSet();
        }
        if (this.m_hasSubtasks) {
            int i;
            for (i = 0; i < this.m_subtasks.length; ++i) {
                if (this.m_subtasks[i].isTaskOver()) continue;
                throw new SubtasksNotCompleteException(s_msgBundle.getMessage("7500", false));
            }
            for (i = 0; i < this.m_subtasks.length; ++i) {
                this.m_resultSet.uploadResultSet(this.m_subtasks[i].getResultSet(), true);
            }
        } else {
            this.m_fixupReqd = fixup;
            this.perform();
        }
        this.m_runBefore = true;
        this.m_resultSet.traceResultSet("=== m_resultSet before return from verify() ===");
        return this.m_resultSet;
    }

    @Override
    public boolean hasSubtasks() {
        return this.m_hasSubtasks;
    }

    @Override
    public List<VerificationTask> getSubtasks() throws SubtasksUnavailableException {
        if (this.m_hasSubtasks) {
            return Arrays.asList(this.m_subtasks);
        }
        throw new SubtasksUnavailableException(s_msgBundle.getMessage("7504", false));
    }

    public boolean isTaskOver() {
        return this.m_isTaskOver;
    }

    public void setSubtasks(Task[] subtasks) {
        this.m_subtasks = subtasks;
    }

    public void setHasSubtasks(boolean hasSubtasks) {
        this.m_hasSubtasks = hasSubtasks;
    }

    public void setElementName(String elementName) {
        this.m_elementName = elementName;
    }

    public void setDescription(String description) {
        this.m_description = description;
    }

    public void setMultiTaskHandler(MultiTaskHandler multiTaskHandler) {
        this.m_multiTaskHandler = multiTaskHandler;
    }

    @Override
    public SeverityType getSeverity() {
        return this.m_taskSeverity;
    }

    public void setSeverity(SeverityType taskSeverity) {
        this.m_taskSeverity = taskSeverity;
    }

    protected boolean hasRunBefore() {
        return this.m_runBefore;
    }

    public boolean isBestPractice() {
        return this.m_bestPractice;
    }

    public void setMoreDetails(String moreDetails) {
        this.m_moreDetails = moreDetails;
    }

    public String getMoreDetails() {
        return this.m_moreDetails;
    }

    public void setReferences(List<String> referenceList) {
        this.m_referenceList = referenceList;
    }

    public List<String> getReferences() {
        return this.m_referenceList;
    }

    public NodeRoleCapability getApplicableNodeRoleCapability() {
        return NodeRoleCapability.ALL;
    }

    private NodeManager getNodeManager() {
        NodeManager nm = null;
        try {
            NodeManagerFactory nmFactory = NodeManagerFactory.getInstance();
            nm = nmFactory.getNodeManager();
        }
        catch (NodeManagerException nmEx) {
            Trace.out((String)("NodeManagerException occured. message: " + nmEx.getMessage()));
            Trace.out((Exception)nmEx);
            Trace.out((String)"This should not occur if upper layers have created the NodeManager");
        }
        return nm;
    }

    private boolean setupNodesForBigCluster() {
        Trace.out((String)("START: m_nodeList=" + VerificationUtil.strArr2List(this.m_nodeList)));
        if (this.m_nodeMgr == null) {
            Trace.out((String)"NodeManager is null. THIS SHOULD NOT OCCUR");
            Trace.out((String)"Returning false.");
            return false;
        }
        if (!this.m_nodeMgr.isBigCluster()) {
            return true;
        }
        NodeRoleCapability nodeType = this.getApplicableNodeRoleCapability();
        if (nodeType == NodeRoleCapability.ALL) {
            Trace.out((String)"Task will execute on all types of nodes");
            return true;
        }
        String[] appNodes = null;
        String[] newAppNodes = null;
        try {
            Trace.out((String)("trying to get nodes of type " + (Object)((Object)nodeType)));
            try {
                appNodes = this.m_nodeMgr.getNodes(this.m_nodeList, nodeType);
            }
            catch (NoSuchNodesException nsnEx) {
                Trace.out((String)("NodeSuchNodesException ccured while getting node of type " + (Object)((Object)nodeType)));
            }
            try {
                if (this.m_nodeMgr.isNewNodesAvailable()) {
                    newAppNodes = this.m_nodeMgr.getNewNodes(this.m_nodeList, nodeType);
                }
            }
            catch (NoSuchNodesException nsnEx) {
                Trace.out((String)("NodeSuchNodesException ccured while getting node of type " + (Object)((Object)nodeType)));
            }
        }
        catch (NodeManagerException nmEx) {
            String errMsg = nmEx.getMessage();
            Trace.out((String)("NodeManagerException occured while getting node of type " + (Object)((Object)nodeType)));
            Trace.out((String)("NodeManagerException message" + errMsg));
            ErrorDescription errDesc = new ErrorDescription(errMsg);
            this.m_resultSet.addErrorDescription(this.m_nodeList, errDesc);
            this.m_resultSet.addResult(this.m_nodeList, 2);
            return false;
        }
        ArrayList<String> appNodeList = new ArrayList<String>();
        if (appNodes != null) {
            appNodeList.addAll(Arrays.asList(appNodes));
        }
        if (newAppNodes != null) {
            appNodeList.addAll(Arrays.asList(newAppNodes));
        }
        ArrayList<String> notAppNodes = new ArrayList<String>();
        for (String node : this.m_nodeList) {
            if (appNodeList.contains(node)) continue;
            Trace.out((String)("adding " + node + "to not applicable nodes list"));
            notAppNodes.add(node);
        }
        this.m_ignoreNodeList = notAppNodes.toArray(new String[0]);
        this.m_resultSet.addResult(this.m_ignoreNodeList, 6);
        this.m_nodeList = appNodeList.toArray(new String[appNodeList.size()]);
        if (this.m_nodeMgr.isNewNodesAvailable()) {
            return this.setupNewNodesForBigCluster();
        }
        Trace.out((String)("END: m_nodeList=" + VerificationUtil.strArr2List(this.m_nodeList)));
        return true;
    }

    protected boolean setupNewNodesForBigCluster() {
        return true;
    }

    private boolean skipThisTask() {
        CVUCheckSkipper taskSkipper = CVUCheckSkipper.getInstance();
        if (!taskSkipper.isSkipTask(this)) {
            return false;
        }
        Trace.out((String)(this.getTaskID() + " is disabled."));
        String errMsg = s_gMsgBundle.getMessage("11640", true, (Object[])new String[]{this.getElementName()});
        ReportUtil.printWarning(errMsg);
        ErrorDescription errDesc = new ErrorDescription(errMsg);
        this.m_resultSet.addErrorDescription(this.m_nodeList, errDesc);
        this.m_resultSet.addResult(this.m_nodeList, 4);
        return true;
    }

    private void processIgnoreCVUErrors() {
        String ignoreErrors = VerificationUtil.getVariableValue("ORA_IGNORE_CVU_ERRORS");
        if (!Boolean.parseBoolean(ignoreErrors)) {
            return;
        }
        this.m_resultSet.turnAllErrorsToWarnings();
    }

    public void setFixupProcessed() {
        if (this.isFixable()) {
            this.m_isFixupProcessed = true;
        }
    }

    public boolean isFixupProcessed() {
        return this.m_isFixupProcessed;
    }

    static {
        block2: {
            s_msgBundle = VerificationUtil.getMessageBundle("Prvf");
            s_gMsgBundle = VerificationUtil.getMessageBundle("Prvg");
            pm = null;
            try {
                pm = ParamManager.getInstance();
            }
            catch (UninitializedParamManagerException e) {
                if (!Trace.isLevelEnabled((int)1)) break block2;
                Trace.out((Exception)e);
            }
        }
        m_isCLImode = pm.getMode() == ParamManager.OperationMode.MODE_CLI;
        m_isAPImode = pm.getMode() == ParamManager.OperationMode.MODE_API;
        m_localHost = VerificationUtil.getLocalHostName();
    }
}

