/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.Hashtable;
import java.util.Vector;
import oracle.cluster.verification.NodeRoleCapability;
import oracle.cluster.verification.SeverityType;
import oracle.cluster.verification.VerificationError;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.sTaskASMLibChecks;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskASMLibChecks
extends Task {
    protected boolean isASMLibInstallConsistent = false;
    protected boolean isASMLibCommandPathConsistent = false;
    protected boolean isASMLibConfigConsistent = false;
    protected boolean isASMLibDisksConsistent = false;
    protected final String m_ASMLibCommandPath = "/usr/sbin/oracleasm";

    public TaskASMLibChecks(String[] nodeList) {
        super(nodeList);
    }

    @Override
    public boolean performTask() {
        int i;
        this.setSeverity(SeverityType.IGNORABLE);
        String errMsg = null;
        Vector<String> asmLibConfigNotConsistentNodes = new Vector<String>();
        Vector<String> asmLibNotInstallNodes = new Vector<String>();
        Vector<String> asmLibDiskNotConsistentNodes = new Vector<String>();
        Vector<String> asmLibCommandPathInconsistentNodes = new Vector<String>();
        Vector<String> operationFailedNode = new Vector<String>();
        Hashtable<String, Vector<String>> nodeAbsentDisksPair = new Hashtable<String, Vector<String>>();
        this.isASMLibInstallConsistent = true;
        this.isASMLibConfigConsistent = true;
        this.isASMLibCommandPathConsistent = true;
        this.isASMLibDisksConsistent = true;
        ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("10100", false));
        ReportUtil.writeColHeaders(ReportUtil.NODENAME, ReportUtil.STATUS);
        sTaskASMLibChecks sTask = new sTaskASMLibChecks(this);
        sTask.performVerification(asmLibNotInstallNodes, asmLibConfigNotConsistentNodes, asmLibCommandPathInconsistentNodes, asmLibDiskNotConsistentNodes, operationFailedNode, nodeAbsentDisksPair);
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("TaskASMLibChecks::performTaskThe status is isASMLibInstallConsistent :" + this.isASMLibInstallConsistent + " isASMLibConfigConsistent:" + this.isASMLibConfigConsistent + " isASMLibDisksConsistent: " + this.isASMLibDisksConsistent));
        }
        String[] succNodes = this.m_resultSet.getSuccNodes();
        for (i = 0; i < succNodes.length; ++i) {
            ReportUtil.writeRecord(succNodes[i], ReportUtil.PASSED);
        }
        if (this.isASMLibInstallConsistent && this.isASMLibConfigConsistent && this.isASMLibCommandPathConsistent && this.isASMLibDisksConsistent) {
            ReportUtil.printResult(s_msgBundle.getMessage("10102", false));
            return true;
        }
        if (!this.isASMLibInstallConsistent && asmLibNotInstallNodes.size() > 0) {
            for (i = 0; i < asmLibNotInstallNodes.size(); ++i) {
                ReportUtil.writeRecord(asmLibNotInstallNodes.elementAt(i), s_msgBundle.getMessage("10115", false));
            }
            errMsg = s_msgBundle.getMessage("10105", true);
            ReportUtil.printErrorWithNodes(errMsg, asmLibNotInstallNodes);
        }
        if (!this.isASMLibConfigConsistent && asmLibConfigNotConsistentNodes.size() > 0) {
            for (i = 0; i < asmLibConfigNotConsistentNodes.size(); ++i) {
                ReportUtil.writeRecord(asmLibConfigNotConsistentNodes.elementAt(i), s_msgBundle.getMessage("10114", false));
            }
            errMsg = s_msgBundle.getMessage("10109", true);
            ReportUtil.printErrorWithNodes(errMsg, asmLibConfigNotConsistentNodes);
            String configErrorMsg = "";
            for (String node : asmLibConfigNotConsistentNodes) {
                Result nodeRes = this.m_resultSet.getResult(node);
                for (VerificationError error : nodeRes.getErrors()) {
                    if (VerificationUtil.isStringGood(configErrorMsg)) {
                        configErrorMsg = configErrorMsg + LSEP + error.getErrorMessage();
                        continue;
                    }
                    configErrorMsg = configErrorMsg + error.getErrorMessage();
                }
            }
            if (VerificationUtil.isStringGood(configErrorMsg)) {
                ReportUtil.printError(configErrorMsg);
            }
        }
        if (!this.isASMLibCommandPathConsistent && asmLibCommandPathInconsistentNodes.size() > 0) {
            for (int i2 = 0; i2 < asmLibCommandPathInconsistentNodes.size(); ++i2) {
                ReportUtil.writeRecord(asmLibCommandPathInconsistentNodes.elementAt(i2), s_gMsgBundle.getMessage("10123", false, (Object[])new String[]{"/usr/sbin/oracleasm", asmLibCommandPathInconsistentNodes.get(i2)}));
            }
            errMsg = s_gMsgBundle.getMessage("10123", true, (Object[])new String[]{"/usr/sbin/oracleasm", VerificationUtil.strCollection2String(asmLibCommandPathInconsistentNodes)});
            ReportUtil.printErrorWithNodes(errMsg, asmLibCommandPathInconsistentNodes);
        }
        if (!this.isASMLibDisksConsistent && asmLibDiskNotConsistentNodes.size() > 0) {
            Vector<String> allmissingDisks = new Vector<String>();
            for (int i3 = 0; i3 < asmLibDiskNotConsistentNodes.size(); ++i3) {
                Vector<String> missingDisksOnNode = nodeAbsentDisksPair.get(asmLibDiskNotConsistentNodes.elementAt(i3));
                for (int cnt = 0; cnt < missingDisksOnNode.size(); ++cnt) {
                    if (allmissingDisks.size() > 0 && allmissingDisks.contains(missingDisksOnNode.elementAt(cnt))) continue;
                    allmissingDisks.add(missingDisksOnNode.elementAt(cnt));
                }
                String comment = s_msgBundle.getMessage("10113", false, (Object[])new String[]{missingDisksOnNode.toString()});
                ReportUtil.writeRecord(asmLibDiskNotConsistentNodes.elementAt(i3), comment);
            }
            errMsg = s_msgBundle.getMessage("10111", true, (Object[])new String[]{allmissingDisks.toString()});
            ReportUtil.printErrorWithNodes(errMsg, asmLibDiskNotConsistentNodes);
        }
        if (operationFailedNode.size() > 0) {
            for (int i4 = 0; i4 < operationFailedNode.size(); ++i4) {
                ReportUtil.writeRecord(operationFailedNode.elementAt(i4), s_msgBundle.getMessage("10116", false));
            }
            errMsg = s_msgBundle.getMessage("10107", true);
            ReportUtil.printErrorWithNodes(errMsg, operationFailedNode);
        }
        ReportUtil.printResult(s_msgBundle.getMessage("10101", false));
        return false;
    }

    @Override
    public NodeRoleCapability getApplicableNodeRoleCapability() {
        return NodeRoleCapability.HUB_CAPABLE;
    }

    public boolean isASMLIBPath(String path) {
        if (VerificationUtil.isPlatformLinux()) {
            sTaskASMLibChecks sTask = new sTaskASMLibChecks(this);
            return sTask.isASMLIBPath(path);
        }
        return false;
    }

    @Override
    public String getDefaultElementName() {
        return s_msgBundle.getMessage("10103", false);
    }

    @Override
    public String getDefaultDescription() {
        return s_msgBundle.getMessage("10104", false);
    }
}

