/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.cluster.verification.SeverityType;
import oracle.cluster.verification.util.VerificationType;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskChkDirStructure
extends Task {
    private VerificationType m_verType;
    private String printMsg = null;
    private String m_element = null;
    private String m_desc = null;

    public TaskChkDirStructure(String[] nodeList, VerificationType vfyType) {
        super(nodeList, null, 1);
        this.m_verType = vfyType;
        this.setSeverity(SeverityType.IGNORABLE);
        switch (this.m_verType) {
            case PREREQ_CRS_INST: {
                this.printMsg = s_msgBundle.getMessage("10010", false);
                this.m_element = s_msgBundle.getMessage("10011", false);
                this.m_desc = s_msgBundle.getMessage("10012", false);
            }
        }
    }

    @Override
    public boolean performTask() {
        ResultSet resultSet = new ResultSet();
        Trace.out((String)"Starting check for directory paths.. ");
        switch (this.m_verType) {
            case PREREQ_CRS_INST: {
                Trace.out((String)"Directory path check for directory paths - PRE CRS Install. ");
                this.verifyCRSHomeOracleBasePath(resultSet);
            }
        }
        return !this.m_resultSet.anyFailure();
    }

    private void verifyCRSHomeOracleBasePath(ResultSet resultSet) {
        String errMsg = null;
        String msg = null;
        String oracleBase = VerificationUtil.getVariableValue("ORACLE_BASE");
        String oraCrsHome = VerificationUtil.getVariableValue("ORACLE_HOME");
        if (oracleBase == null || oracleBase.trim().length() == 0 || oraCrsHome == null || oraCrsHome.trim().length() == 0) {
            if (oracleBase == null || oracleBase.trim().length() == 0) {
                Trace.out((String)"Variable ORACLE_BASE is found to be NULL");
            }
            if (oraCrsHome == null || oraCrsHome.trim().length() == 0) {
                Trace.out((String)"Variable ORACLE_HOME is found to be NULL");
            }
            resultSet.addResult(this.m_nodeList, 1);
            this.m_resultSet.uploadResultSet(resultSet);
            return;
        }
        ReportUtil.sureprintln(LSEP + this.printMsg);
        this.printMsg = new String();
        Vector<String> vFailNodes = new Vector<String>();
        Vector<String> failNodes = new Vector<String>();
        String m_oraCrsHome = this.reformPath(oraCrsHome);
        String m_oracleBase = this.reformPath(oracleBase);
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        if (!nativeSystem.isUnixSystem()) {
            m_oraCrsHome = m_oraCrsHome.toLowerCase();
            m_oracleBase = m_oracleBase.toLowerCase();
        }
        GlobalExecution globalExec = new GlobalExecution();
        globalExec.checkDirStructure(this.m_nodeList, m_oracleBase, m_oraCrsHome, resultSet);
        Hashtable ht = resultSet.getResultTable();
        Enumeration e = ht.keys();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            Result result = (Result)ht.get(node);
            if (result.getStatus() == 4) {
                vFailNodes.add(node);
                errMsg = s_msgBundle.getMessage("10015", true, (Object[])new String[]{oraCrsHome, oracleBase, node});
                resultSet.addErrorDescription(node, new ErrorDescription(errMsg));
                continue;
            }
            if (result.getStatus() != 2) continue;
            failNodes.add(node);
            errMsg = s_msgBundle.getMessage("10017", true, (Object[])new String[]{node});
            resultSet.addErrorDescription(node, new ErrorDescription(errMsg));
            Vector errorMsg = result.getErrorInfoSet();
            for (int i = 0; i < errorMsg.size(); ++i) {
                Trace.out((String)(errorMsg.elementAt(i) + " on node " + node));
            }
            resultSet.addResult(node, 4);
        }
        if (resultSet.allSuccess() && !resultSet.anyWarning()) {
            msg = s_msgBundle.getMessage("10013", false);
            this.printMsg = this.printMsg != null && this.printMsg.trim().length() > 0 ? this.printMsg + LSEP + msg : msg;
        } else {
            if (vFailNodes.size() > 0) {
                msg = s_msgBundle.getMessage("10014", true, (Object[])new String[]{oraCrsHome, oracleBase, VerificationUtil.strVect2List(vFailNodes)});
                this.printMsg = this.printMsg != null && this.printMsg.trim().length() > 0 ? this.printMsg + LSEP + msg : msg;
            }
            if (failNodes.size() > 0) {
                msg = s_msgBundle.getMessage("10016", true, (Object[])new String[]{VerificationUtil.strVect2List(failNodes)});
                this.printMsg = this.printMsg != null && this.printMsg.trim().length() > 0 ? this.printMsg + LSEP + msg : msg;
            }
            resultSet.addResult(this.m_nodeList, 4);
            resultSet.addErrorDescription(new ErrorDescription(this.printMsg));
        }
        this.m_resultSet.uploadResultSet(resultSet);
        if (resultSet.getStatus() == 4) {
            ReportUtil.printWarning(this.printMsg);
        } else {
            ReportUtil.printResult(this.printMsg);
        }
    }

    private String reformPath(String pathStr) {
        if (pathStr == null || pathStr.trim().length() == 0) {
            return null;
        }
        pathStr = pathStr.trim();
        String reformPath = new String();
        boolean isFirstOcc = true;
        for (int i = 0; i < pathStr.length(); ++i) {
            if (pathStr.charAt(i) == '/' || pathStr.charAt(i) == '\\') {
                if (isFirstOcc) {
                    reformPath = reformPath + '/';
                }
                isFirstOcc = false;
                continue;
            }
            reformPath = reformPath + pathStr.charAt(i);
            isFirstOcc = true;
        }
        if (reformPath.length() > 0 && !reformPath.endsWith("/")) {
            reformPath = reformPath + '/';
        }
        return reformPath;
    }

    @Override
    public String getDefaultElementName() {
        return this.m_element;
    }

    @Override
    public String getDefaultDescription() {
        return this.m_desc;
    }
}

