/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.cluster.verification.SeverityType;
import oracle.cluster.verification.StorageSize;
import oracle.cluster.verification.StorageUnit;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.ClusterOperationException;
import oracle.ops.mgmt.cluster.NoSuchNodeException;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.TaskFreeSpace;
import oracle.ops.verification.framework.engine.task.sTaskFreeSpace;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.global.GlobalHandler;
import oracle.ops.verification.framework.param.ParamManager;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.CVUAutoUpdateManager;
import oracle.ops.verification.framework.util.VerificationLogData;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskContainerFreeSpace
extends Task {
    public String m_localNode = null;
    private static boolean m_visited = false;
    private Vector<String> m_location = null;
    private Vector<StorageSize> m_reqdSpaceSize = null;
    private Vector<StorageSize> m_reqdRimSpaceSize = null;
    private Vector<nodeMntPnt> m_nodeMntPnt;
    private Vector<SeverityType> m_severities;
    private static String CONSTRAINT_NAME = s_msgBundle.getMessage("1056", false);

    public TaskContainerFreeSpace() {
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"Constructor");
        }
    }

    public boolean setSubTasks(TaskFreeSpace[] subtaskArr) {
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"Entry");
        }
        this.setHasSubtasks(true);
        this.setSubtasks(subtaskArr);
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"Exit");
        }
        return true;
    }

    public TaskContainerFreeSpace(String location, StorageSize size, StorageSize rimSize, boolean temp, SeverityType severity) {
        Trace.out((String)("ENTRY: location: '" + location + "' size: '" + ReportUtil.unitizeSize(size, 1) + "' rimSize: '" + ReportUtil.unitizeSize(rimSize, 1) + "' severity: '" + (Object)((Object)severity) + "'"));
        this.addPathDetails(location, size, rimSize, temp, severity);
        Trace.out((String)"EXIT");
    }

    public void addPathDetails(String location, StorageSize size, StorageSize leafSize, boolean temp, SeverityType severity) {
        Trace.out((String)("ENTRY: location: '" + location + "' size: '" + ReportUtil.unitizeSize(size, 1) + "' leafSize: '" + ReportUtil.unitizeSize(leafSize, 1) + "' temp: '" + temp + "' severity: '" + (Object)((Object)severity) + "'"));
        if (temp) {
            Vector<String> failedNodes;
            ClusterCmd clusterCmd;
            block22: {
                int i;
                Trace.out((String)"checking if temp dir exists");
                clusterCmd = new ClusterCmd();
                boolean allFailed = false;
                failedNodes = null;
                try {
                    if (this.m_nodeList == null) break block22;
                    clusterCmd.dirExists(this.m_nodeList, location);
                }
                catch (ClusterException e) {
                    Trace.out((String)("temp dir doesn't exist on all nodes" + e.getMessage()));
                    failedNodes = new Vector<String>(this.m_nodeList.length);
                    for (i = 0; i < this.m_nodeList.length; ++i) {
                        failedNodes.add(this.m_nodeList[i]);
                    }
                    VerificationLogData.logError("CLUSTEREXCEPTION: " + e.getMessage() + "\n" + Trace.getStackTrace((Throwable)e));
                }
                catch (ClusterOperationException e) {
                    VerificationLogData.logError("CLUSTEROPERATIONEXCEPTION: " + e.getMessage() + "\n" + Trace.getStackTrace((Throwable)e));
                    Trace.out((String)("temp dir doesn't exist on some nodes" + e.getMessage()));
                    failedNodes = new Vector();
                    for (i = 0; i < this.m_nodeList.length; ++i) {
                        try {
                            if (e.getStatus(this.m_nodeList[i]) == 0) continue;
                            failedNodes.add(this.m_nodeList[i]);
                            continue;
                        }
                        catch (NoSuchNodeException ne) {
                            Trace.out((String)("no such node exception for node" + this.m_nodeList[i]));
                            Trace.out((Exception)((Object)ne));
                        }
                    }
                }
            }
            try {
                if (failedNodes != null && failedNodes.size() > 0) {
                    clusterCmd.createDirInNodes(failedNodes.toArray(new String[0]), location);
                }
            }
            catch (ClusterException e) {
                Trace.out((String)("error creating temp dir in failed nodes" + e.getMessage()));
                String msg = s_msgBundle.getMessage("7509", true, (Object[])new String[]{location});
                ReportUtil.sureprintln(msg);
            }
        }
        if (this.m_location == null) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)"New Vectors");
            }
            this.m_location = new Vector();
            this.m_reqdSpaceSize = new Vector();
            this.m_reqdRimSpaceSize = new Vector();
            this.m_nodeMntPnt = new Vector();
            this.m_severities = new Vector();
        }
        if (this.m_location.contains(location)) {
            int elemIdx = this.m_location.indexOf(location, 0);
            StorageSize prevSize = this.m_reqdSpaceSize.elementAt(elemIdx);
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("Increasing size for Location: " + location + " from: " + ReportUtil.unitizeSize(prevSize, 1)));
            }
            prevSize.add(size);
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)(" Size increased to: " + ReportUtil.unitizeSize(prevSize, 1)));
            }
            StorageSize prevRimSize = this.m_reqdRimSpaceSize.elementAt(elemIdx);
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("Increasing leaf size for Location: " + location + " from: " + ReportUtil.unitizeSize(prevRimSize, 1)));
            }
            prevRimSize.add(leafSize);
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)(" Rim Size increased to: " + ReportUtil.unitizeSize(prevRimSize, 1)));
            }
        } else {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)"Adding to existing Vectors");
            }
            this.m_location.add(location);
            this.m_reqdSpaceSize.add(size);
            this.m_reqdRimSpaceSize.add(leafSize);
            this.m_severities.add(severity);
        }
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("Location: " + location + " Size: " + ReportUtil.unitizeSize(size, 1) + " Rim Size: " + ReportUtil.unitizeSize(leafSize, 1)));
        }
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"EXIT");
        }
    }

    public TaskFreeSpace[] getTaskFreeSpaceList() {
        int i;
        GlobalExecution globalExec = new GlobalExecution();
        sTaskFreeSpace sTask = new sTaskFreeSpace(this);
        ResultSet rsltSet = new ResultSet();
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"Entry");
        }
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("\n    There are " + this.m_location.size() + " locations to process."));
        }
        for (i = 0; i < this.m_location.size(); ++i) {
            NativeSystem nativeSystem;
            String loc;
            StorageSize locSize = this.m_reqdSpaceSize.elementAt(i);
            StorageSize rimLocSize = this.m_reqdRimSpaceSize.elementAt(i);
            SeverityType severity = this.m_severities.elementAt(i);
            boolean found = false;
            String originalLoc = loc = this.m_location.elementAt(i);
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("\n    Processing location:[" + i + "] " + loc + "' size: '" + ReportUtil.unitizeSize(locSize, 1) + "' rimSize: '" + ReportUtil.unitizeSize(rimLocSize, 1) + "' severity: '" + (Object)((Object)severity) + "'"));
            }
            boolean foundPath = false;
            String newLoc = loc;
            String saveLoc = null;
            Vector<String> succNodes = new Vector<String>();
            Vector<String> failNodes = new Vector<String>();
            while (!foundPath) {
                if (VerificationUtil.pathExists(this.m_nodeList, newLoc, 0, succNodes, failNodes)) {
                    if (!VerificationUtil.isDirPathWritable(this.m_nodeList, newLoc, succNodes, failNodes)) break;
                    foundPath = true;
                    break;
                }
                saveLoc = newLoc;
                if (-1 != newLoc.lastIndexOf(FSEP)) {
                    newLoc = newLoc.substring(0, newLoc.lastIndexOf(FSEP));
                }
                if (newLoc.length() == 0) {
                    newLoc = new String(FSEP);
                }
                if (!saveLoc.contentEquals(newLoc)) continue;
            }
            if (!newLoc.contentEquals(loc)) {
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)("\nProcessing old location: " + loc + "\ninto new location: " + newLoc));
                }
                loc = newLoc;
            }
            StorageSize sizeReqKB = locSize;
            StorageSize rimSizeReqKB = rimLocSize;
            String cmd = sTask.getCommand(loc);
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("\n    Executing command: " + cmd + "\n    on nodeList:      " + VerificationUtil.strArr2List(this.m_nodeList)));
            }
            if ((nativeSystem = new SystemFactory().CreateSystem()).isUnixSystem()) {
                globalExec.runGenericCmd(this.m_nodeList, cmd, rsltSet);
            } else {
                globalExec.getSpaceCmd(this.m_nodeList, loc, rsltSet);
            }
            Hashtable t = rsltSet.getResultTable();
            Enumeration e = t.keys();
            while (e.hasMoreElements()) {
                nodeMntPnt newNodeMntPnt;
                String mountPoint;
                StorageSize sizeAvailKB;
                String node;
                block31: {
                    block30: {
                        node = (String)e.nextElement();
                        Result result = (Result)t.get(node);
                        Trace.out((String)("Processing node: '" + node + "'"));
                        if (result.getStatus() == 2) {
                            sizeAvailKB = new StorageSize(0.0, StorageUnit.BYTE);
                            mountPoint = "UNKNOWN";
                        } else {
                            String cmdOut = VerificationUtil.strArr2List((String[])result.getResultInfoSet().get(1), System.getProperty("line.separator"));
                            String sizeTxt = sTask.getData(cmdOut, 4);
                            mountPoint = sTask.getData(cmdOut, 6);
                            sizeAvailKB = new StorageSize(new Double(sizeTxt), StorageUnit.MBYTE);
                        }
                        if (Trace.isLevelEnabled((int)5)) {
                            Trace.out((String)("\n    Processing:  \n    Node:        " + node + "\n    Location:    " + loc + "\n    Original Location:    " + originalLoc + "\n    Mount Point: " + mountPoint));
                        }
                        if (Trace.isLevelEnabled((int)5)) {
                            Trace.out((String)("\n    Number of elements in m_nodeMntPnt vector: " + this.m_nodeMntPnt.size()));
                        }
                        if (this.m_nodeMntPnt.size() >= 1) break block30;
                        found = true;
                        newNodeMntPnt = new nodeMntPnt(originalLoc, node, mountPoint, sizeReqKB, rimSizeReqKB, sizeAvailKB, severity);
                        this.m_nodeMntPnt.add(newNodeMntPnt);
                        if (!Trace.isLevelEnabled((int)5)) break block31;
                        Trace.out((String)("\n    Created first m_nodeMntPnt for: " + newNodeMntPnt.toString()));
                        break block31;
                    }
                    if (Trace.isLevelEnabled((int)5)) {
                        Trace.out((String)("\n    Searching vector m_nodeMntPnt for node: " + node + " and mount point: " + mountPoint));
                    }
                    for (int j = 0; j < this.m_nodeMntPnt.size(); ++j) {
                        nodeMntPnt nodeMP = this.m_nodeMntPnt.elementAt(j);
                        if (!nodeMP.nmp_node.contentEquals(node) || !nodeMP.nmp_mountPoint.contentEquals(mountPoint)) continue;
                        if (Trace.isLevelEnabled((int)5)) {
                            Trace.out((String)("\n    Processing m_nodeMntPnt for node: " + nodeMP.nmp_node + " and mount point: " + nodeMP.nmp_mountPoint));
                        }
                        found = true;
                        nodeMP.addNodeMntPnt(originalLoc, sizeReqKB, rimSizeReqKB);
                        break;
                    }
                }
                if (!found) {
                    newNodeMntPnt = new nodeMntPnt(originalLoc, node, mountPoint, sizeReqKB, rimSizeReqKB, sizeAvailKB, severity);
                    this.m_nodeMntPnt.add(newNodeMntPnt);
                    if (Trace.isLevelEnabled((int)5)) {
                        Trace.out((String)("\n    Created m_nodeMntPnt for: " + newNodeMntPnt.toString()));
                    }
                }
                found = false;
            }
        }
        String bootStrapPath = null;
        String mntPnt = null;
        if (ParamManager.isRuncluvfy() && !m_visited) {
            try {
                this.m_localNode = VerificationUtil.getLocalHost();
                bootStrapPath = CVUAutoUpdateManager.getDerivedCVUHome();
                mntPnt = this.getMntPnt(bootStrapPath);
            }
            catch (UnknownHostException uhe) {
                Trace.out((String)uhe.getMessage());
            }
        }
        TaskFreeSpace[] taskFS = new TaskFreeSpace[this.m_nodeMntPnt.size()];
        for (i = 0; i < this.m_nodeMntPnt.size(); ++i) {
            nodeMntPnt nodeMP = this.m_nodeMntPnt.elementAt(i);
            if (ParamManager.isRuncluvfy() && !m_visited && this.m_localNode != null && this.m_localNode.equalsIgnoreCase(nodeMP.nmp_node) && mntPnt != null && !mntPnt.equals("UNKNOWN") && mntPnt.equals(nodeMP.nmp_mountPoint)) {
                if (Trace.isLevelEnabled((int)1)) {
                    Trace.out((String)("    Before adding bootstrap size \n" + nodeMP.toString()));
                }
                m_visited = this.ignoreBootStrapSpace(nodeMP, bootStrapPath);
                if (Trace.isLevelEnabled((int)1)) {
                    Trace.out((String)("    After adding bootstrap size \n" + nodeMP.toString()));
                }
            }
            Trace.out((String)("\n    Adding to Task List: " + nodeMP.toString()));
            VerificationLogData.logInfo("\n    Adding to Task List: " + nodeMP.toString());
            taskFS[i] = new TaskFreeSpace(nodeMP.nmp_locations, nodeMP.nmp_node, nodeMP.nmp_mountPoint, nodeMP.nmp_reqdLocSize, nodeMP.nmp_reqdMntPntSize, nodeMP.nmp_reqdRimLocSize, nodeMP.nmp_reqdRimMntPntSize, nodeMP.nmp_availMntPntSize);
            taskFS[i].setSeverity(nodeMP.nmp_severity);
        }
        return taskFS;
    }

    public String getMntPnt(String loc) {
        GlobalExecution globalExec = new GlobalExecution();
        sTaskFreeSpace sTask = new sTaskFreeSpace();
        String cmd = sTask.getCommand(loc);
        ResultSet rsltSet = new ResultSet();
        String mountPoint = "UNKNOWN";
        globalExec.runGenericCmd(new String[]{this.m_localNode}, cmd, rsltSet);
        Hashtable t = rsltSet.getResultTable();
        Result result = (Result)t.get(this.m_localNode);
        if (result.getStatus() == 1) {
            String cmdOut = VerificationUtil.strArr2List((String[])result.getResultInfoSet().get(1), System.getProperty("line.separator"));
            mountPoint = sTask.getData(cmdOut, 6);
        }
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("   Location  :" + loc + "\n" + "   Mnt Point :" + mountPoint));
        }
        return mountPoint;
    }

    public boolean ignoreBootStrapSpace(nodeMntPnt nodeMP, String bsLoc) {
        VerificationCommand cmdOP;
        Result result;
        Trace.out((String)"Inside ignoreBootStrapSpace().....");
        ResultSet rsltSet = new ResultSet();
        String[] arg = new String[]{"-getdirsize", bsLoc};
        String[] env = null;
        VerificationCommand[] cmd = new VerificationCommand[]{new VerificationCommand(this.m_localNode, arg, env)};
        boolean cmdResult = new GlobalHandler().submit((Command[])cmd, 0, rsltSet);
        if (cmdResult && (result = (Result)rsltSet.getResultTable().get(this.m_localNode)).getStatus() == 1 && (cmdOP = cmd[0]).getVfyCode() == 0) {
            String cmdOut = cmdOP.getOutput();
            if (cmdOut == null) {
                return false;
            }
            String[] op = (cmdOut = cmdOut.trim()).split("\n");
            if (op.length > 0) {
                cmdOut = op[0];
            }
            StorageSize sizeAvail = new StorageSize(new Double(cmdOut), StorageUnit.BYTE);
            nodeMP.nmp_availMntPntSize.add(sizeAvail);
            return true;
        }
        return false;
    }

    @Override
    public boolean performTask() {
        return true;
    }

    @Override
    public String getDefaultElementName() {
        return s_msgBundle.getMessage("4438", false);
    }

    @Override
    public String getDefaultDescription() {
        return s_msgBundle.getMessage("4491", false);
    }

    private class nodeMntPnt {
        private Vector<String> nmp_locations;
        private String nmp_node;
        private String nmp_mountPoint;
        private Vector<StorageSize> nmp_reqdLocSize;
        private StorageSize nmp_reqdMntPntSize = new StorageSize(0.0, StorageUnit.BYTE);
        private Vector<StorageSize> nmp_reqdRimLocSize;
        private StorageSize nmp_reqdRimMntPntSize = new StorageSize(0.0, StorageUnit.BYTE);
        private StorageSize nmp_availMntPntSize = new StorageSize(0.0, StorageUnit.BYTE);
        private SeverityType nmp_severity;

        private nodeMntPnt(String loc, String node, String mntPnt, StorageSize size, StorageSize rimSize, StorageSize availSize, SeverityType severity) {
            this.nmp_locations = new Vector();
            this.nmp_reqdLocSize = new Vector();
            this.nmp_reqdRimLocSize = new Vector();
            this.nmp_locations.add(loc);
            this.nmp_node = node;
            this.nmp_mountPoint = mntPnt;
            this.nmp_reqdLocSize.add(size);
            this.nmp_reqdMntPntSize.add(size);
            this.nmp_reqdRimLocSize.add(rimSize);
            this.nmp_reqdRimMntPntSize.add(rimSize);
            this.nmp_availMntPntSize.add(availSize);
            this.nmp_severity = severity;
            Trace.out((String)("Constructor: " + this.toString()));
        }

        private void addNodeMntPnt(String loc, StorageSize size, StorageSize rimSize) {
            Trace.out((String)("ENTRY: loc: '" + loc + "' size: '" + ReportUtil.unitizeSize(size, 1) + "' rimSize: '" + ReportUtil.unitizeSize(rimSize, 1) + "'"));
            Trace.out((String)("Before: " + this.toString()));
            this.nmp_locations.add(loc);
            this.nmp_reqdLocSize.add(size);
            this.nmp_reqdMntPntSize.add(size);
            this.nmp_reqdRimLocSize.add(rimSize);
            this.nmp_reqdRimMntPntSize.add(rimSize);
            Trace.out((String)("After: " + this.toString()));
        }

        public String toString() {
            int i;
            StringBuffer sb = new StringBuffer();
            String[] sizes = new String[this.nmp_reqdLocSize.size()];
            String[] rimSizes = new String[this.nmp_reqdRimLocSize.size()];
            for (i = 0; i < this.nmp_reqdLocSize.size(); ++i) {
                StorageSize locSize = this.nmp_reqdLocSize.elementAt(i);
                sizes[i] = ReportUtil.unitizeSize(locSize, 1);
                sb.append("\n    StorageSize obj. addr: '" + locSize.hashCode() + " size: '" + sizes[i] + "'");
            }
            for (i = 0; i < this.nmp_reqdRimLocSize.size(); ++i) {
                StorageSize rimLocSize = this.nmp_reqdRimLocSize.elementAt(i);
                rimSizes[i] = ReportUtil.unitizeSize(rimLocSize, 1);
                sb.append("\n    StorageSize obj. addr: '" + rimLocSize.hashCode() + " rimSize: '" + rimSizes[i] + "'");
            }
            sb.append("\n    Memory addr:      " + this.hashCode() + "\n    Location(s):      " + VerificationUtil.strVect2List(this.nmp_locations) + "\n    Node:             " + this.nmp_node + "\n    Mount Point:      " + this.nmp_mountPoint + "\n    Reqd Size:        " + VerificationUtil.strArr2List(sizes) + "\n    Req. Mnt Size:    " + ReportUtil.unitizeSize(this.nmp_reqdMntPntSize, 1) + "\n    Reqd Leaf Size:    " + VerificationUtil.strArr2List(rimSizes) + "\n    Req. Leaf Mnt Size: " + ReportUtil.unitizeSize(this.nmp_reqdRimMntPntSize, 1) + "\n    Avail Size:       " + ReportUtil.unitizeSize(this.nmp_availMntPntSize, 1) + "\n    Severity:         " + (Object)((Object)this.nmp_severity));
            return sb.toString();
        }
    }
}

